/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.encryption;

import java.io.File;
import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.KeyName;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.x509.XMLX509Certificate;
import org.apache.xml.security.keys.keyresolver.KeyResolver;
import org.apache.xml.security.test.TestUtils;
import org.apache.xml.security.utils.JavaUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BaltimoreEncTest
extends TestCase {
    private static String cardNumber;
    private static String rsaCertSerialNumber;
    private static String testDecryptString;
    private static int nodeCount;
    private static byte[] jebBytes;
    private static byte[] jobBytes;
    private static byte[] jedBytes;
    private static PrivateKey rsaKey;
    private boolean haveISOPadding;
    private boolean haveKeyWraps;
    static Log log;
    static /* synthetic */ Class class$org$apache$xml$security$test$encryption$BaltimoreEncTest;

    public static Test suite() throws Exception {
        return new TestSuite(class$org$apache$xml$security$test$encryption$BaltimoreEncTest == null ? (class$org$apache$xml$security$test$encryption$BaltimoreEncTest = BaltimoreEncTest.class$("org.apache.xml.security.test.encryption.BaltimoreEncTest")) : class$org$apache$xml$security$test$encryption$BaltimoreEncTest);
    }

    public BaltimoreEncTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
        String string = "data/ie/baltimore/merlin-examples/merlin-xmlenc-five/plaintext.xml";
        String string2 = System.getProperty("basedir");
        if (string2 != null && !"".equals(string2)) {
            string = string2 + "/" + string;
        }
        File file = new File(string);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new FileInputStream(file));
        cardNumber = BaltimoreEncTest.retrieveCCNumber(document);
        testDecryptString = new String("top secret message\n");
        nodeCount = BaltimoreEncTest.countNodes(document);
        jebBytes = "abcdefghijklmnopqrstuvwx".getBytes("ASCII");
        jobBytes = "abcdefghijklmnop".getBytes("ASCII");
        jedBytes = "abcdefghijklmnopqrstuvwxyz012345".getBytes("ASCII");
        rsaCertSerialNumber = new String("1014918766910");
        string = "data/ie/baltimore/merlin-examples/merlin-xmlenc-five/rsa.p8";
        if (string2 != null && !"".equals(string2)) {
            string = string2 + "/" + string;
        }
        byte[] byArray = JavaUtils.getBytesFromFile((String)string);
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        rsaKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        Init.init();
        KeyResolver.register((String)"org.apache.xml.security.test.encryption.BobKeyResolver");
        this.haveISOPadding = false;
        String string3 = JCEMapper.translateURItoJCEID((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        if (string3 != null) {
            try {
                if (Cipher.getInstance(string3) != null) {
                    this.haveISOPadding = true;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                // empty catch block
            }
        }
        this.haveKeyWraps = JCEMapper.translateURItoJCEID((String)"http://www.w3.org/2001/04/xmlenc#kw-aes128") != null;
    }

    public static String retrieveCCNumber(Document document) throws TransformerException {
        Element element = TestUtils.createDSctx(document, "x", "urn:example:po");
        Node node = XPathAPI.selectSingleNode((Node)document, (String)"//x:Number/text()", (Node)element);
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }

    private void checkDecryptedDoc(Document document, boolean bl) throws Exception {
        String string = BaltimoreEncTest.retrieveCCNumber(document);
        log.debug((Object)("Retrieved Credit Card : " + string));
        BaltimoreEncTest.assertTrue((String)string, (string != null && string.equals(cardNumber) ? 1 : 0) != 0);
        if (bl) {
            int n = BaltimoreEncTest.countNodes(document);
            BaltimoreEncTest.assertTrue((String)"Node count mismatches", (n > 0 && n == nodeCount ? 1 : 0) != 0);
        }
    }

    private void checkDecryptedData(byte[] byArray) throws Exception {
        String string = new String(byArray, "ASCII");
        Assert.assertEquals((String)testDecryptString, (String)string);
    }

    public void test_five_content_3des_cbc() throws Exception {
        if (this.haveISOPadding) {
            String string = "data/ie/baltimore/merlin-examples/merlin-xmlenc-five/encrypt-content-tripledes-cbc.xml";
            Document document = this.decryptElement(string);
            this.checkDecryptedDoc(document, true);
        } else {
            log.warn((Object)"Skipping test test_five_content_3des_cbs as necessary crypto algorithms are not available");
        }
    }

    public void test_five_content_aes256_cbc() throws Exception {
        if (this.haveISOPadding) {
            String string = "data/ie/baltimore/merlin-examples/merlin-xmlenc-five/encrypt-content-aes256-cbc-prop.xml";
            Document document = this.decryptElement(string);
            this.checkDecryptedDoc(document, true);
        } else {
            log.warn((Object)"Skipping test test_five_content_aes256_cbc as necessary crypto algorithms are not available");
        }
    }

    public void test_five_content_aes128_cbc_kw_aes192() throws Exception {
        if (this.haveISOPadding && this.haveKeyWraps) {
            String string = "data/ie/baltimore/merlin-examples/merlin-xmlenc-five/encrypt-content-aes128-cbc-kw-aes192.xml";
            Document document = this.decryptElement(string);
            this.checkDecryptedDoc(document, true);
        } else {
            log.warn((Object)"Skipping test test_five_content_aes128_cbc_kw_aes192 as necessary crypto algorithms are not available");
        }
    }

    public void test_five_content_3des_cbc_kw_aes128() throws Exception {
        if (this.haveISOPadding && this.haveKeyWraps) {
            String string = "data/ie/baltimore/merlin-examples/merlin-xmlenc-five/encrypt-element-tripledes-cbc-kw-aes128.xml";
            Document document = this.decryptElement(string);
            this.checkDecryptedDoc(document, true);
        } else {
            log.warn((Object)"Skipping test test_five_content_3des_cbc_kw_aes128 as necessary crypto algorithms are not available");
        }
    }

    public void test_five_content_aes128_cbc_rsa_15() throws Exception {
        if (this.haveISOPadding) {
            String string = "data/ie/baltimore/merlin-examples/merlin-xmlenc-five/encrypt-element-aes128-cbc-rsa-1_5.xml";
            Document document = this.decryptElement(string);
            this.checkDecryptedDoc(document, true);
        } else {
            log.warn((Object)"Skipping test test_five_content_aes128_cbc_rsa_15 as necessary crypto algorithms are not available");
        }
    }

    public void test_five_element_aes192_cbc_ref() throws Exception {
        if (this.haveISOPadding) {
            String string = "data/ie/baltimore/merlin-examples/merlin-xmlenc-five/encrypt-element-aes192-cbc-ref.xml";
            Document document = this.decryptElement(string);
            this.checkDecryptedDoc(document, false);
        } else {
            log.warn((Object)"Skipping test test_five_element_aes192_cbc_ref as necessary crypto algorithms are not available");
        }
    }

    public void test_five_data_aes128_cbc() throws Exception {
        if (this.haveISOPadding) {
            String string = "data/ie/baltimore/merlin-examples/merlin-xmlenc-five/encrypt-data-aes128-cbc.xml";
            byte[] byArray = this.decryptData(string);
            this.checkDecryptedData(byArray);
        } else {
            log.warn((Object)"Skipping test test_five_data_aes128_cbc as necessary crypto algorithms are not available");
        }
    }

    public void test_five_data_aes256_cbc_3des() throws Exception {
        if (this.haveISOPadding && this.haveKeyWraps) {
            String string = "data/ie/baltimore/merlin-examples/merlin-xmlenc-five/encrypt-data-aes256-cbc-kw-tripledes.xml";
            byte[] byArray = this.decryptData(string);
            this.checkDecryptedData(byArray);
        } else {
            log.warn((Object)"Skipping test test_five_data_aes256_cbc_3des as necessary crypto algorithms are not available");
        }
    }

    public void test_five_data_aes192_cbc_aes256() throws Exception {
        if (this.haveISOPadding && this.haveKeyWraps) {
            String string = "data/ie/baltimore/merlin-examples/merlin-xmlenc-five/encrypt-data-aes192-cbc-kw-aes256.xml";
            byte[] byArray = this.decryptData(string);
            this.checkDecryptedData(byArray);
        } else {
            log.warn((Object)"Skipping test test_five_data_aes192_cbc_aes256 as necessary crypto algorithms are not available");
        }
    }

    public void test_five_data_3des_cbc_rsa_oaep() throws Exception {
        Provider provider = Security.getProvider("BC");
        if (provider != null) {
            provider.put("Alg.Alias.Cipher.RSA/ECB/OAEPWithSHA1AndMGF1Padding", "RSA/OAEP");
        }
        if (this.haveISOPadding) {
            String string = "data/ie/baltimore/merlin-examples/merlin-xmlenc-five/encrypt-data-tripledes-cbc-rsa-oaep-mgf1p.xml";
            byte[] byArray = this.decryptData(string);
            this.checkDecryptedData(byArray);
        } else {
            log.warn((Object)"Skipping test test_five_data_3des_cbc_rsa_oaep as necessary crypto algorithms are not available");
        }
    }

    public Document decryptElement(String string) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
        String string2 = System.getProperty("basedir");
        if (string2 != null && !"".equals(string2)) {
            string = string2 + "/" + string;
        }
        File file = new File(string);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new FileInputStream(file));
        Element element = null;
        XMLCipher xMLCipher = XMLCipher.getInstance();
        element = (Element)document.getElementsByTagName("EncryptedData").item(0);
        xMLCipher.init(2, null);
        EncryptedData encryptedData = xMLCipher.loadEncryptedData(document, element);
        Key key = this.findKey(encryptedData);
        xMLCipher.init(2, key);
        Document document2 = xMLCipher.doFinal(document, element);
        return document2;
    }

    public byte[] decryptData(String string) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setAttribute("http://xml.org/sax/features/namespaces", Boolean.TRUE);
        String string2 = System.getProperty("basedir");
        if (string2 != null && !"".equals(string2)) {
            string = string2 + "/" + string;
        }
        File file = new File(string);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new FileInputStream(file));
        Element element = null;
        XMLCipher xMLCipher = XMLCipher.getInstance();
        element = (Element)document.getElementsByTagName("EncryptedData").item(0);
        xMLCipher.init(2, null);
        EncryptedData encryptedData = xMLCipher.loadEncryptedData(document, element);
        Key key = this.findKey(encryptedData);
        xMLCipher.init(2, key);
        byte[] byArray = xMLCipher.decryptToByteArray(element);
        return byArray;
    }

    public SecretKey mapKeyName(String string) throws Exception {
        if (string.equals("job")) {
            SecretKeySpec secretKeySpec = new SecretKeySpec(jobBytes, "AES");
            return secretKeySpec;
        }
        if (string.equals("jeb")) {
            SecretKeySpec secretKeySpec = new SecretKeySpec(jebBytes, "AES");
            return secretKeySpec;
        }
        if (string.equals("jed")) {
            SecretKeySpec secretKeySpec = new SecretKeySpec(jedBytes, "AES");
            return secretKeySpec;
        }
        return null;
    }

    public Key findKey(EncryptedData encryptedData) throws Exception {
        X509Data x509Data;
        KeyInfo keyInfo = encryptedData.getKeyInfo();
        Key key = null;
        Key key2 = null;
        if (keyInfo == null) {
            return null;
        }
        KeyName keyName = keyInfo.itemKeyName(0);
        if (keyName != null) {
            return this.mapKeyName(keyName.getKeyName());
        }
        EncryptedKey encryptedKey = keyInfo.itemEncryptedKey(0);
        if (encryptedKey == null) {
            return null;
        }
        KeyInfo keyInfo2 = encryptedKey.getKeyInfo();
        if (keyInfo2 == null) {
            return null;
        }
        KeyName keyName2 = keyInfo2.itemKeyName(0);
        if (keyName2 != null) {
            key2 = this.mapKeyName(keyName2.getKeyName());
        } else {
            x509Data = keyInfo2.itemX509Data(0);
            XMLX509Certificate xMLX509Certificate = x509Data.itemCertificate(0);
            X509Certificate x509Certificate = xMLX509Certificate.getX509Certificate();
            if (x509Certificate != null && x509Certificate.getSerialNumber().toString().equals(rsaCertSerialNumber)) {
                key2 = rsaKey;
            }
        }
        if (key2 != null) {
            x509Data = XMLCipher.getInstance();
            x509Data.init(4, key2);
            key = x509Data.decryptKey(encryptedKey, encryptedData.getEncryptionMethod().getAlgorithm());
        }
        return key;
    }

    private static int countNodes(Node node) {
        if (node == null) {
            return 0;
        }
        int n = 1;
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            n += BaltimoreEncTest.countNodes(node2);
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        nodeCount = 0;
        log = LogFactory.getLog((String)(class$org$apache$xml$security$test$encryption$BaltimoreEncTest == null ? (class$org$apache$xml$security$test$encryption$BaltimoreEncTest = BaltimoreEncTest.class$("org.apache.xml.security.test.encryption.BaltimoreEncTest")) : class$org$apache$xml$security$test$encryption$BaltimoreEncTest).getName());
    }
}

