/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import org.eclipse.sisu.Hidden;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.InjectorBindings;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.inject.Sources;
import org.eclipse.sisu.inject.TypeArguments;

final class ImplicitBindings {
    private final Iterable<BindingPublisher> publishers;

    ImplicitBindings(Iterable<BindingPublisher> publishers) {
        this.publishers = publishers;
    }

    public <T> Binding<T> get(TypeLiteral<T> type2) {
        Key<T> implicitKey = TypeArguments.implicitKey(type2.getRawType());
        for (BindingPublisher p : this.publishers) {
            Injector i;
            Binding<?> binding2;
            if (!(p instanceof InjectorBindings) || (binding2 = (i = ((InjectorBindings)p).getInjector()).getBindings().get(implicitKey)) == null) continue;
            Logs.trace("Using implicit binding: {} from: <>", binding2, i);
            return binding2;
        }
        Key<T> justInTimeKey = Key.get(type2);
        for (BindingPublisher p : this.publishers) {
            if (!(p instanceof InjectorBindings)) continue;
            Injector i = ((InjectorBindings)p).getInjector();
            try {
                Binding<T> binding3 = i.getBinding(justInTimeKey);
                if (Sources.getAnnotation(binding3, Hidden.class) != null) continue;
                Logs.trace("Using just-in-time binding: {} from: <>", binding3, i);
                return binding3;
            }
            catch (RuntimeException e2) {
                Logs.trace("Problem with just-in-time binding: {}", justInTimeKey, e2);
            }
            catch (LinkageError e3) {
                Logs.trace("Problem with just-in-time binding: {}", justInTimeKey, e3);
            }
        }
        return null;
    }
}

