/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.configurator.converters;

import java.lang.reflect.Array;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.eclipse.sisu.plexus.Roles;

public abstract class AbstractConfigurationConverter
implements ConfigurationConverter {
    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type2, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator) throws ComponentConfigurationException {
        return this.fromConfiguration(lookup, configuration, type2, enclosingType, loader, evaluator, null);
    }

    protected Object fromExpression(PlexusConfiguration configuration, ExpressionEvaluator evaluator) throws ComponentConfigurationException {
        String value = configuration.getValue();
        try {
            Object result = null;
            if (value != null && value.length() > 0) {
                result = evaluator.evaluate(value);
            }
            if (result == null && configuration.getChildCount() == 0 && (value = configuration.getAttribute("default-value")) != null && value.length() > 0) {
                result = evaluator.evaluate(value);
            }
            return result;
        }
        catch (ExpressionEvaluationException e2) {
            String reason = String.format("Cannot evaluate expression '%s' for configuration entry '%s'", value, configuration.getName());
            throw new ComponentConfigurationException(configuration, reason, e2);
        }
    }

    protected Object fromExpression(PlexusConfiguration configuration, ExpressionEvaluator evaluator, Class<?> type2) throws ComponentConfigurationException {
        Object result = this.fromExpression(configuration, evaluator);
        this.failIfNotTypeCompatible(result, type2, configuration);
        return result;
    }

    protected final String fromXML(String name2) {
        return Roles.camelizeName(name2);
    }

    protected final void failIfNotTypeCompatible(Object value, Class<?> type2, PlexusConfiguration configuration) throws ComponentConfigurationException {
        if (value != null && type2 != null && !type2.isInstance(value)) {
            String reason = String.format("Cannot assign configuration entry '%s' with value '%s' of type %s to property of type %s", configuration.getName(), configuration.getValue(), value.getClass().getCanonicalName(), type2.getCanonicalName());
            throw new ComponentConfigurationException(configuration, reason);
        }
    }

    protected final Class<?> getClassForImplementationHint(Class<?> type2, PlexusConfiguration configuration, ClassLoader loader) throws ComponentConfigurationException {
        String hint = configuration.getAttribute("implementation");
        if (hint == null) {
            return type2;
        }
        try {
            int dims = 0;
            while (hint.endsWith("[]")) {
                hint = hint.substring(0, hint.length() - 2);
                ++dims;
            }
            Class<?> implType = loader.loadClass(hint);
            while (dims > 0) {
                implType = Array.newInstance(implType, 0).getClass();
                --dims;
            }
            return implType;
        }
        catch (Exception e2) {
            throw new ComponentConfigurationException("Cannot load implementation hint '" + hint + "'", (Throwable)e2);
        }
        catch (LinkageError e3) {
            throw new ComponentConfigurationException("Cannot load implementation hint '" + hint + "'", (Throwable)e3);
        }
    }

    protected final Object instantiateObject(Class<?> type2) throws ComponentConfigurationException {
        try {
            return type2.newInstance();
        }
        catch (Exception e2) {
            throw new ComponentConfigurationException("Cannot create instance of " + type2, (Throwable)e2);
        }
        catch (LinkageError e3) {
            throw new ComponentConfigurationException("Cannot create instance of " + type2, (Throwable)e3);
        }
    }
}

