/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.util;

import com.android.tools.smali.dexlib2.iface.value.BooleanEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.ByteEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.CharEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.DoubleEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.EncodedValue;
import com.android.tools.smali.dexlib2.iface.value.FloatEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.IntEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.LongEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.ShortEncodedValue;

public final class EncodedValueUtils {
    public static boolean isDefaultValue(EncodedValue encodedValue) {
        switch (encodedValue.getValueType()) {
            case 31: {
                return !((BooleanEncodedValue)encodedValue).getValue();
            }
            case 0: {
                return ((ByteEncodedValue)encodedValue).getValue() == 0;
            }
            case 3: {
                return ((CharEncodedValue)encodedValue).getValue() == '\u0000';
            }
            case 17: {
                return ((DoubleEncodedValue)encodedValue).getValue() == 0.0;
            }
            case 16: {
                return ((FloatEncodedValue)encodedValue).getValue() == 0.0f;
            }
            case 4: {
                return ((IntEncodedValue)encodedValue).getValue() == 0;
            }
            case 6: {
                return ((LongEncodedValue)encodedValue).getValue() == 0L;
            }
            case 30: {
                return true;
            }
            case 2: {
                return ((ShortEncodedValue)encodedValue).getValue() == 0;
            }
        }
        return false;
    }
}

