/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.ReadChannel;
import com.google.cloud.RestorableState;
import com.google.cloud.storage.ApiaryUnbufferedReadableByteChannel;
import com.google.cloud.storage.BaseStorageReadChannel;
import com.google.cloud.storage.BufferHandle;
import com.google.cloud.storage.Conversions;
import com.google.cloud.storage.HttpDownloadSessionBuilder;
import com.google.cloud.storage.HttpRetryAlgorithmManager;
import com.google.cloud.storage.HttpStorageOptions;
import com.google.cloud.storage.LazyReadChannel;
import com.google.cloud.storage.ReadableByteChannelSession;
import com.google.cloud.storage.ResumableMedia;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import com.google.cloud.storage.spi.v1.StorageRpc;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

final class BlobReadChannelV2
extends BaseStorageReadChannel<StorageObject> {
    private final StorageObject storageObject;
    private final Map<StorageRpc.Option, ?> opts;
    private final BlobReadChannelContext blobReadChannelContext;
    private final boolean autoGzipDecompression;

    BlobReadChannelV2(StorageObject storageObject, Map<StorageRpc.Option, ?> opts, BlobReadChannelContext blobReadChannelContext) {
        super(Conversions.apiary().blobInfo());
        this.storageObject = storageObject;
        this.opts = opts;
        this.blobReadChannelContext = blobReadChannelContext;
        this.autoGzipDecompression = Boolean.FALSE.equals(opts.get((Object)StorageRpc.Option.RETURN_RAW_INPUT_STREAM));
    }

    public synchronized RestorableState<ReadChannel> capture() {
        ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest apiaryReadRequest = this.getApiaryReadRequest();
        return new BlobReadChannelV2State(apiaryReadRequest, this.blobReadChannelContext.getStorageOptions(), this.getChunkSize());
    }

    @Override
    protected LazyReadChannel<?, StorageObject> newLazyReadChannel() {
        return new LazyReadChannel(() -> {
            HttpDownloadSessionBuilder.ReadableByteChannelSessionBuilder b = ResumableMedia.http().read().byteChannel(this.blobReadChannelContext).setAutoGzipDecompression(this.autoGzipDecompression);
            BufferHandle bufferHandle = this.getBufferHandle();
            ReadableByteChannelSession session = bufferHandle.capacity() > 0 ? b.buffered(bufferHandle).setApiaryReadRequest(this.getApiaryReadRequest()).build() : b.unbuffered().setApiaryReadRequest(this.getApiaryReadRequest()).build();
            return session;
        });
    }

    private ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest getApiaryReadRequest() {
        StorageObject object = this.getResolvedObject() != null ? (StorageObject)this.getResolvedObject() : this.storageObject;
        return new ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest(object, this.opts, this.getByteRangeSpec());
    }

    static final class BlobReadChannelContext {
        private final HttpStorageOptions storageOptions;
        private final HttpRetryAlgorithmManager retryAlgorithmManager;
        private final com.google.api.services.storage.Storage apiaryClient;

        private BlobReadChannelContext(HttpStorageOptions storageOptions, com.google.api.services.storage.Storage apiaryClient, HttpRetryAlgorithmManager retryAlgorithmManager) {
            this.storageOptions = storageOptions;
            this.apiaryClient = apiaryClient;
            this.retryAlgorithmManager = retryAlgorithmManager;
        }

        public HttpStorageOptions getStorageOptions() {
            return this.storageOptions;
        }

        public HttpRetryAlgorithmManager getRetryAlgorithmManager() {
            return this.retryAlgorithmManager;
        }

        public com.google.api.services.storage.Storage getApiaryClient() {
            return this.apiaryClient;
        }

        static BlobReadChannelContext from(HttpStorageOptions options) {
            return new BlobReadChannelContext(options, options.getStorageRpcV1().getStorage(), options.getRetryAlgorithmManager());
        }

        static BlobReadChannelContext from(Storage s) {
            StorageOptions options = (StorageOptions)s.getOptions();
            if (options instanceof HttpStorageOptions) {
                HttpStorageOptions httpStorageOptions = (HttpStorageOptions)options;
                return BlobReadChannelContext.from(httpStorageOptions);
            }
            throw new IllegalArgumentException("Only HttpStorageOptions based instance supported");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BlobReadChannelContext)) {
                return false;
            }
            BlobReadChannelContext that = (BlobReadChannelContext)o;
            return Objects.equals((Object)this.storageOptions, (Object)that.storageOptions) && Objects.equals(this.retryAlgorithmManager, that.retryAlgorithmManager);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.storageOptions, this.retryAlgorithmManager});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("storageOptions", (Object)this.storageOptions).toString();
        }
    }

    static final class BlobReadChannelV2State
    implements RestorableState<ReadChannel>,
    Serializable {
        private static final long serialVersionUID = -7595661593080505431L;
        private final ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest request;
        private final HttpStorageOptions options;
        private final Integer chunkSize;

        private BlobReadChannelV2State(ApiaryUnbufferedReadableByteChannel.ApiaryReadRequest request, HttpStorageOptions options, Integer chunkSize) {
            this.request = request;
            this.options = options;
            this.chunkSize = chunkSize;
        }

        public ReadChannel restore() {
            BlobReadChannelV2 channel = new BlobReadChannelV2(this.request.getObject(), this.request.getOptions(), BlobReadChannelContext.from(this.options));
            channel.setByteRangeSpec(this.request.getByteRangeSpec());
            if (this.chunkSize != null) {
                channel.setChunkSize(this.chunkSize);
            }
            return channel;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BlobReadChannelV2State)) {
                return false;
            }
            BlobReadChannelV2State that = (BlobReadChannelV2State)o;
            return Objects.equals(this.request, that.request) && Objects.equals((Object)this.options, (Object)that.options) && Objects.equals(this.chunkSize, that.chunkSize);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.request, this.options, this.chunkSize});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("request", (Object)this.request).add("options", (Object)this.options).add("chunkSize", (Object)this.chunkSize).toString();
        }
    }
}

