'''OpenGL extension AMD.shader_explicit_vertex_parameter

This module customises the behaviour of the 
OpenGL.raw.GL.AMD.shader_explicit_vertex_parameter to provide a more 
Python-friendly API

Overview (from the spec)
	
	Unextended GLSL provides a set of fixed function interpolation modes and
	even those are limited to certain types of interpolants (for example,
	interpolation of integer and double isn't supported).
	
	This extension introduces new built-in functions allowing access to vertex
	parameters explicitly in  the fragment shader. It also exposes barycentric
	coordinates as new built-in variables, which can be used to implement
	custom interpolation algorithms using shader code.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/AMD/shader_explicit_vertex_parameter.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.AMD.shader_explicit_vertex_parameter import *
from OpenGL.raw.GL.AMD.shader_explicit_vertex_parameter import _EXTENSION_NAME

def glInitShaderExplicitVertexParameterAMD():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION