/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf;

import de.escape.quincunx.dxf.DrawAble;
import de.escape.quincunx.dxf.DrawChar;
import de.escape.quincunx.dxf.DrawLines;
import de.escape.quincunx.dxf.DrawSet;
import de.escape.quincunx.dxf.DxfColorModel;
import de.escape.quincunx.dxf.DxfFont;
import de.escape.quincunx.dxf.FontFinder;
import de.escape.quincunx.dxf.LineStyle;
import de.escape.quincunx.dxf.LineStyleManager;
import de.escape.quincunx.dxf.Unicode;
import de.escape.quincunx.dxf.reader.DxfException;
import de.escape.quincunx.dxf.reader.DxfFile;
import de.escape.quincunx.dxf.reader.DxfLAYER;
import de.escape.quincunx.dxf.reader.DxfTEXT;
import de.escape.quincunx.trafo.Matrix4D;
import de.escape.quincunx.trafo.Point3D;
import de.escape.quincunx.trafo.Vector3D;
import java.awt.Color;
import java.awt.Graphics;
import java.text.StringCharacterIterator;

public class DrawText
extends DrawSet
implements Cloneable {
    private static final boolean CREATE_CONNECTIONS = true;
    private static final char UNDERLINE = '\u0001';
    private static final char OVERLINE = '\u0002';
    private static final float UNDERLINE_Y = -0.2f;
    private static final float OVERLINE_Y = 1.1f;
    private static final char SC_PLUSMINUS = '\u00f1';
    private static final char SC_DIAMETER = '\u00ed';
    private static final char SC_DEGREE = '\u00f8';
    private Matrix4D trafo;
    private DrawChar[] drawChars;
    private DrawLines[] underlines;
    private Point3D min;
    private Point3D max;
    private int nrLines;
    private boolean hasBB;

    private DrawText() {
    }

    public DrawText(Matrix4D mat, DxfTEXT dxftext, DxfFile dxf, FontFinder fontFinder) throws DxfException {
        super(mat);
        String text = dxftext.getText();
        if (text != null && text.length() > 0) {
            StringCharacterIterator it = new StringCharacterIterator(text);
            StringBuffer out = new StringBuffer();
            int[] underline = new int[text.length()];
            int ulinings = 0;
            int olinings = 0;
            char c = it.first();
            while (c != '\uffff') {
                if (c == '%') {
                    c = it.next();
                    if (c != '%') {
                        out.append('%');
                        c = it.previous();
                    } else {
                        c = it.next();
                        switch (c) {
                            case '%': {
                                out.append('%');
                                break;
                            }
                            case 'P': 
                            case 'p': {
                                out.append('\u00f1');
                                break;
                            }
                            case 'C': 
                            case 'c': {
                                out.append('\u00ed');
                                break;
                            }
                            case 'D': 
                            case 'd': {
                                out.append('\u00f8');
                                break;
                            }
                            case 'U': 
                            case 'u': {
                                int n = out.length();
                                underline[n] = underline[n] ^ 1;
                                ++ulinings;
                                break;
                            }
                            case 'O': 
                            case 'o': {
                                int n = out.length();
                                underline[n] = underline[n] ^ 2;
                                ++olinings;
                                break;
                            }
                            default: {
                                if (c >= '0' && c <= '9') {
                                    int max_digits = 3;
                                    char letter = (char)(c - 48);
                                    c = it.next();
                                    while (c >= '0' && c <= '9' && --max_digits > 0) {
                                        letter = (char)(10 * letter + (c - 48));
                                        c = it.next();
                                    }
                                    out.append(letter);
                                }
                                c = it.previous();
                                break;
                            }
                        }
                    }
                } else if (c == '^') {
                    c = it.next();
                    if (c == ' ') {
                        out.append('^');
                    }
                } else {
                    out.append(c);
                }
                c = it.next();
            }
            DxfFont font = fontFinder.getFont(dxf.getStyle(dxftext.getStyleName()).getFontName(), dxf);
            text = Unicode.char2DOS437(out, dxf.getCodePage(), '?');
            int lining = 0;
            int pos = 0;
            it = new StringCharacterIterator(text);
            this.drawChars = new DrawChar[text.length()];
            char c2 = it.first();
            while (c2 != '\uffff') {
                this.drawChars[pos++] = font.getDrawChar(c2);
                c2 = it.next();
            }
            if (pos < this.drawChars.length) {
                DrawChar[] tmp = new DrawChar[pos];
                System.arraycopy(this.drawChars, 0, tmp, 0, pos);
                this.drawChars = tmp;
            }
            if (olinings + ulinings > 0) {
                DrawLines xline;
                this.underlines = new DrawLines[(olinings + 1) / 2 + (ulinings + 1) / 2];
                float openUnderlinePos = -3.4028235E38f;
                float openOverlinePos = -3.4028235E38f;
                float collectedAdvance = 0.0f;
                pos = 0;
                while (pos < this.drawChars.length) {
                    if ((underline[pos] & 1) != 0) {
                        if (openUnderlinePos == -3.4028235E38f) {
                            openUnderlinePos = collectedAdvance;
                        } else {
                            xline = new DrawLines(2);
                            xline.addPoint(openUnderlinePos, -0.2f, 0.0f);
                            xline.addPoint(collectedAdvance, -0.2f, 0.0f);
                            openUnderlinePos = -3.4028235E38f;
                            this.underlines[lining++] = xline;
                            xline.setLayer(this.layer);
                            xline.setColor(this.color);
                        }
                    }
                    if ((underline[pos] & 2) != 0) {
                        if (openOverlinePos == -3.4028235E38f) {
                            openOverlinePos = collectedAdvance;
                        } else {
                            xline = new DrawLines(2);
                            xline.addPoint(openOverlinePos, 1.1f, 0.0f);
                            xline.addPoint(collectedAdvance, 1.1f, 0.0f);
                            openOverlinePos = -3.4028235E38f;
                            this.underlines[lining++] = xline;
                            xline.setLayer(this.layer);
                            xline.setColor(this.color);
                        }
                    }
                    collectedAdvance += this.drawChars[pos].advance;
                    ++pos;
                }
                if (openUnderlinePos != -3.4028235E38f) {
                    xline = new DrawLines(2);
                    xline.addPoint(openUnderlinePos, -0.2f, 0.0f);
                    xline.addPoint(collectedAdvance, -0.2f, 0.0f);
                    this.underlines[lining++] = xline;
                    xline.setLayer(this.layer);
                    xline.setColor(this.color);
                }
                if (openOverlinePos != -3.4028235E38f) {
                    xline = new DrawLines(2);
                    xline.addPoint(openOverlinePos, 1.1f, 0.0f);
                    xline.addPoint(collectedAdvance, 1.1f, 0.0f);
                    this.underlines[lining++] = xline;
                    xline.setLayer(this.layer);
                    xline.setColor(this.color);
                }
                if (lining < this.underlines.length) {
                    if (lining == 0) {
                        this.underlines = null;
                    } else {
                        DrawLines[] tmp = new DrawLines[lining];
                        System.arraycopy(this.underlines, 0, tmp, 0, lining);
                        this.underlines = tmp;
                    }
                }
            }
            this.min = new Point3D(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
            this.max = new Point3D(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
            Matrix4D translate = new Matrix4D();
            pos = 0;
            while (pos < this.drawChars.length) {
                this.drawChars[pos].calcBB(this.min, this.max, translate);
                translate.translate(this.drawChars[pos].advance, 0.0f, 0.0f);
                this.nrLines += this.drawChars[pos].nrLines;
                ++pos;
            }
            boolean bl = this.hasBB = this.max.x >= this.min.x && this.max.y >= this.min.y && this.max.z >= this.min.z;
            if (this.hasBB) {
                Point3D mid = new Point3D((this.min.x + this.max.x) / 2.0f, (this.min.y + this.max.y) / 2.0f, 0.0f);
                Point3D insert = dxftext.getPosition();
                Point3D adjust = dxftext.getAdjust();
                Point3D inspos = insert;
                float transX = 0.0f;
                float transY = 0.0f;
                if (adjust != null) {
                    inspos = adjust;
                    switch (dxftext.getVAdjust()) {
                        case 1: {
                            transY = -this.min.y;
                            break;
                        }
                        case 2: {
                            transY = -this.max.y / 2.0f;
                            break;
                        }
                        case 3: {
                            transY = -this.max.y;
                            break;
                        }
                    }
                    switch (dxftext.getHAdjust()) {
                        case 1: {
                            transX = -mid.x;
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 5: {
                            transX = -this.max.x;
                            break;
                        }
                        case 4: {
                            transX = -mid.x;
                            transY = -mid.y;
                            break;
                        }
                        case 0: {
                            inspos = insert;
                            break;
                        }
                    }
                }
                float scale = dxftext.getTextHeight();
                this.trafo = new Matrix4D(scale * dxftext.getAspectRatio(), scale * dxftext.getSlant(), 0.0f, 0.0f, 0.0f, scale, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
                this.trafo.translate(transX, transY, 0.0f);
                short mirrorflags = dxftext.getMirror();
                if (mirrorflags != 0) {
                    Matrix4D mirror = new Matrix4D((mirrorflags & 2) != 0 ? -1 : 1, 0.0f, 0.0f, 0.0f, 0.0f, (mirrorflags & 4) != 0 ? -1 : 1, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
                    this.trafo.multLeftBy(mirror);
                }
                this.trafo.zrot(dxftext.getRotation());
                this.trafo.translateLeft(inspos.x, inspos.y, inspos.z);
            }
        }
    }

    public void draw(Graphics g, Matrix4D mat, DxfLAYER insLayer, DxfColorModel colorModel, short insColor, LineStyleManager lineStyles, LineStyle insLStyle) {
        this.draw(g, mat, insLayer, colorModel, insColor);
    }

    public void draw(Graphics g, Matrix4D mat, DxfLAYER insLayer, DxfColorModel colorModel, short insColor) {
        if (!this.isVisible(insLayer)) {
            return;
        }
        if (this.drawChars != null && this.drawChars.length > 0) {
            Color drawColor = colorModel.getColor(this.calcColor(insColor, insLayer));
            Matrix4D tmp = mat != null ? mat.mult(this.trafo) : new Matrix4D(this.trafo);
            if (this.underlines != null) {
                int pos = 0;
                while (pos < this.underlines.length) {
                    this.underlines[pos].draw(g, tmp, insLayer, colorModel, insColor);
                    ++pos;
                }
            }
            int c = 0;
            while (c < this.drawChars.length - 1) {
                this.drawChars[c].draw(g, tmp, drawColor);
                tmp.translate(this.drawChars[c].advance, 0.0f, 0.0f);
                ++c;
            }
            this.drawChars[c].draw(g, tmp, drawColor);
        }
    }

    public void draw(Graphics g, Matrix4D mat, DxfLAYER insLayer, DxfColorModel colorModel, short insColor, int nr, int maxNr) {
    }

    public int calcBB(Point3D min, Point3D max, Matrix4D mat, DxfLAYER insertLayer, boolean onlyVisible) {
        if (this.drawChars != null && this.hasBB) {
            Matrix4D tmp = mat == null ? this.trafo : mat.mult(this.trafo);
            Point3D[] corner = new Point3D[]{this.min, new Point3D(this.max.x, this.min.y, 0.0f), new Point3D(this.min.x, this.max.y, 0.0f), this.max};
            int c = 0;
            while (c < 4) {
                Point3D p = tmp.mult(corner[c]);
                if (p.x < min.x) {
                    min.x = p.x;
                }
                if (p.x > max.x) {
                    max.x = p.x;
                }
                if (p.y < min.y) {
                    min.y = p.y;
                }
                if (p.y > max.y) {
                    max.y = p.y;
                }
                if (p.z < min.z) {
                    min.z = p.z;
                }
                if (p.z > max.z) {
                    max.z = p.z;
                }
                ++c;
            }
        }
        return this.nrLines;
    }

    public void transformBy(Matrix4D mat) {
        if (this.trafo != null) {
            this.trafo.multLeftBy(mat);
        }
    }

    public DrawAble extrude(float dist, Vector3D up) {
        DrawText copy;
        if (dist == 0.0f) {
            return this;
        }
        DrawSet set = new DrawSet(2 + this.nrLines);
        set.setLayer(this.layer);
        set.setColor(this.color);
        try {
            copy = (DrawText)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
        Vector3D extrusion = new Vector3D(dist * up.x, dist * up.y, dist * up.z);
        copy.trafo = this.trafo == null ? new Matrix4D() : new Matrix4D(this.trafo);
        copy.trafo.translate(extrusion.x, extrusion.y, extrusion.z);
        copy.min = new Point3D(this.min.x + extrusion.x, this.min.y + extrusion.y, this.min.z + extrusion.z);
        copy.max = new Point3D(this.max.x + extrusion.x, this.max.y + extrusion.y, this.max.z + extrusion.z);
        set.addDrawable(this);
        set.addDrawable(copy);
        Matrix4D tmp = new Matrix4D(this.trafo);
        int c = 0;
        while (c < this.drawChars.length) {
            DrawChar ch = this.drawChars[c];
            if (ch.lines != null) {
                int l = ch.lines.length - 1;
                while (l >= 0) {
                    int p = ch.lines[l].length - 1;
                    while (p >= 0) {
                        Point3D point = ch.lines[l][p];
                        DrawLines line = new DrawLines(2);
                        line.addPoint(point);
                        line.addPoint(point.x + extrusion.x, point.y + extrusion.y, point.z + extrusion.z);
                        line.transformBy(tmp);
                        line.setLayer(this.layer);
                        line.setColor(this.color);
                        set.addDrawable(line);
                        --p;
                    }
                    --l;
                }
            }
            tmp.translate(this.drawChars[c].advance, 0.0f, 0.0f);
            ++c;
        }
        return set;
    }

    public void setColor(short c) {
        super.setColor(c);
        if (this.underlines != null) {
            int pos = this.underlines.length - 1;
            while (pos >= 0) {
                this.underlines[pos].setColor(c);
                --pos;
            }
        }
    }

    public void setLayer(DxfLAYER l) {
        super.setLayer(l);
        if (this.underlines != null) {
            int pos = this.underlines.length - 1;
            while (pos >= 0) {
                this.underlines[pos].setLayer(l);
                --pos;
            }
        }
    }
}

