/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.transport.DeleteAnomalyResultsAction;
import org.opensearch.ad.util.ParseUtils;
import org.opensearch.ad.util.RestHandlerUtils;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.reindex.BulkByScrollResponse;
import org.opensearch.index.reindex.DeleteByQueryAction;
import org.opensearch.index.reindex.DeleteByQueryRequest;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class DeleteAnomalyResultsTransportAction
extends HandledTransportAction<DeleteByQueryRequest, BulkByScrollResponse> {
    private final Client client;
    private volatile Boolean filterEnabled;
    private static final Logger logger = LogManager.getLogger(DeleteAnomalyResultsTransportAction.class);

    @Inject
    public DeleteAnomalyResultsTransportAction(TransportService transportService, ActionFilters actionFilters, Settings settings, ClusterService clusterService, Client client) {
        super(DeleteAnomalyResultsAction.NAME, transportService, actionFilters, DeleteByQueryRequest::new);
        this.client = client;
        this.filterEnabled = (Boolean)AnomalyDetectorSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(AnomalyDetectorSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterEnabled = it;
        });
    }

    protected void doExecute(Task task, DeleteByQueryRequest request, ActionListener<BulkByScrollResponse> actionListener) {
        ActionListener listener = RestHandlerUtils.wrapRestActionListener(actionListener, CommonErrorMessages.FAIL_TO_DELETE_AD_RESULT);
        this.delete(request, (ActionListener<BulkByScrollResponse>)listener);
    }

    public void delete(DeleteByQueryRequest request, ActionListener<BulkByScrollResponse> listener) {
        User user = ParseUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.validateRole(request, user, listener);
        }
        catch (Exception e) {
            logger.error((Object)e);
            listener.onFailure(e);
        }
    }

    private void validateRole(DeleteByQueryRequest request, User user, ActionListener<BulkByScrollResponse> listener) {
        if (user == null || !this.filterEnabled.booleanValue()) {
            this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)request, listener);
        } else {
            try {
                ParseUtils.addUserBackendRolesFilter(user, request.getSearchRequest().source());
                this.client.execute((ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)request, listener);
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }
    }
}

