/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.stats;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.stats.ActionName;
import org.opensearch.ml.stats.MLActionStats;

public class MLModelStats
implements ToXContentFragment,
Writeable {
    private Map<ActionName, MLActionStats> modelStats;

    public MLModelStats(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.modelStats = in.readMap(stream -> (ActionName)stream.readEnum(ActionName.class), MLActionStats::new);
        }
    }

    public MLModelStats(Map<ActionName, MLActionStats> modelStats) {
        this.modelStats = modelStats;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (this.modelStats != null && this.modelStats.size() > 0) {
            out.writeBoolean(true);
            out.writeMap(this.modelStats, (stream, v) -> stream.writeEnum((Enum)v), (stream, stats) -> stats.writeTo(stream));
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.modelStats != null && this.modelStats.size() > 0) {
            for (Map.Entry<ActionName, MLActionStats> entry : this.modelStats.entrySet()) {
                builder.startObject(entry.getKey().name().toLowerCase(Locale.ROOT));
                entry.getValue().toXContent(builder, params);
                builder.endObject();
            }
        }
        return builder;
    }

    public MLActionStats getActionStats(ActionName action) {
        return this.modelStats == null ? null : this.modelStats.get((Object)action);
    }
}

