/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.input.MLInput;
import org.opensearch.ml.common.transport.training.MLTrainingTaskAction;
import org.opensearch.ml.common.transport.training.MLTrainingTaskRequest;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLTrainingAction
extends BaseRestHandler {
    private static final String ML_TRAINING_ACTION = "ml_training_action";

    public String getName() {
        return ML_TRAINING_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/_train/{%s}", "/_plugins/_ml", "algorithm")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLTrainingTaskRequest mlTrainingTaskRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLTrainingTaskAction.INSTANCE, (ActionRequest)mlTrainingTaskRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLTrainingTaskRequest getRequest(RestRequest request) throws IOException {
        String algorithm = RestActionUtils.getAlgorithm(request);
        boolean async = RestActionUtils.isAsync(request);
        XContentParser parser = request.contentParser();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        MLInput mlInput = MLInput.parse((XContentParser)parser, (String)algorithm);
        return new MLTrainingTaskRequest(mlInput, async);
    }
}

