/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.upload_chunk;

import java.util.Base64;
import java.util.concurrent.Semaphore;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.client.Client;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.exception.MLResourceNotFoundException;
import org.opensearch.ml.common.model.MLModelState;
import org.opensearch.ml.common.transport.upload_chunk.MLUploadModelChunkInput;
import org.opensearch.ml.common.transport.upload_chunk.MLUploadModelChunkResponse;
import org.opensearch.ml.helper.ModelAccessControlHelper;
import org.opensearch.ml.indices.MLIndicesHandler;
import org.opensearch.ml.utils.MLExceptionUtils;
import org.opensearch.ml.utils.MLNodeUtils;
import org.opensearch.ml.utils.RestActionUtils;

public class MLModelChunkUploader {
    @Generated
    private static final Logger log = LogManager.getLogger(MLModelChunkUploader.class);
    private final MLIndicesHandler mlIndicesHandler;
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    ModelAccessControlHelper modelAccessControlHelper;

    @Inject
    public MLModelChunkUploader(MLIndicesHandler mlIndicesHandler, Client client, NamedXContentRegistry xContentRegistry, ModelAccessControlHelper modelAccessControlHelper) {
        this.mlIndicesHandler = mlIndicesHandler;
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.modelAccessControlHelper = modelAccessControlHelper;
    }

    public void uploadModelChunk(MLUploadModelChunkInput uploadModelChunkInput, ActionListener<MLUploadModelChunkResponse> listener) {
        String modelId = uploadModelChunkInput.getModelId();
        GetRequest getRequest = new GetRequest(".plugins-ml-model").id(modelId);
        User user = RestActionUtils.getUserContext(this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            ActionListener wrappedListener = ActionListener.runBefore(listener, () -> context.restore());
            this.client.get(getRequest, ActionListener.wrap(r -> {
                if (r != null && r.isExists()) {
                    try (XContentParser parser = MLNodeUtils.createXContentParserFromRegistry(this.xContentRegistry, r.getSourceAsBytesRef());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        GetResponse getResponse = r;
                        String algorithmName = getResponse.getSource().get("algorithm").toString();
                        MLModel existingModel = MLModel.parse((XContentParser)parser, (String)algorithmName);
                        this.modelAccessControlHelper.validateModelGroupAccess(user, existingModel.getModelGroupId(), this.client, (ActionListener<Boolean>)ActionListener.wrap(access -> {
                            if (!access.booleanValue()) {
                                log.error("You don't have permissions to perform this operation on this model.");
                                wrappedListener.onFailure((Exception)new IllegalArgumentException("You don't have permissions to perform this operation on this model."));
                            } else {
                                existingModel.setModelId(r.getId());
                                if (existingModel.getTotalChunks() <= uploadModelChunkInput.getChunkNumber()) {
                                    throw new Exception("Chunk number exceeds total chunks");
                                }
                                byte[] bytes = uploadModelChunkInput.getContent();
                                if (bytes == null || bytes.length == 0) {
                                    throw new Exception("Chunk size either 0 or null");
                                }
                                if (this.validateChunkSize(bytes.length)) {
                                    throw new Exception("Chunk size exceeds 10MB");
                                }
                                this.mlIndicesHandler.initModelIndexIfAbsent((ActionListener<Boolean>)ActionListener.wrap(res -> {
                                    int chunkNum = uploadModelChunkInput.getChunkNumber();
                                    MLModel mlModel = MLModel.builder().algorithm(existingModel.getAlgorithm()).modelGroupId(existingModel.getModelGroupId()).version(existingModel.getVersion()).modelId(existingModel.getModelId()).modelFormat(existingModel.getModelFormat()).totalChunks(existingModel.getTotalChunks()).algorithm(existingModel.getAlgorithm()).chunkNumber(Integer.valueOf(chunkNum)).content(Base64.getEncoder().encodeToString(bytes)).build();
                                    IndexRequest indexRequest = new IndexRequest(".plugins-ml-model");
                                    indexRequest.id(uploadModelChunkInput.getModelId() + "_" + uploadModelChunkInput.getChunkNumber());
                                    indexRequest.source(mlModel.toXContent(XContentBuilder.builder((XContent)XContentType.JSON.xContent()), ToXContent.EMPTY_PARAMS));
                                    indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                                    this.client.index(indexRequest, ActionListener.wrap(response -> {
                                        log.info("Index model successful for {} for chunk number {}", (Object)uploadModelChunkInput.getModelId(), (Object)(chunkNum + 1));
                                        if (existingModel.getTotalChunks() == uploadModelChunkInput.getChunkNumber() + 1) {
                                            Semaphore semaphore = new Semaphore(1);
                                            semaphore.acquire();
                                            MLModel mlModelMeta = MLModel.builder().name(existingModel.getName()).algorithm(existingModel.getAlgorithm()).version(existingModel.getVersion()).modelGroupId(existingModel.getModelGroupId()).modelFormat(existingModel.getModelFormat()).modelState(MLModelState.REGISTERED).modelConfig(existingModel.getModelConfig()).totalChunks(existingModel.getTotalChunks()).modelContentHash(existingModel.getModelContentHash()).modelContentSizeInBytes(existingModel.getModelContentSizeInBytes()).createdTime(existingModel.getCreatedTime()).build();
                                            IndexRequest indexReq = new IndexRequest(".plugins-ml-model");
                                            indexReq.id(modelId);
                                            indexReq.source(mlModelMeta.toXContent(XContentBuilder.builder((XContent)XContentType.JSON.xContent()), ToXContent.EMPTY_PARAMS));
                                            indexReq.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                                            this.client.index(indexReq, ActionListener.wrap(re -> {
                                                log.debug("Index model successful", (Object)existingModel.getName());
                                                semaphore.release();
                                            }, e -> {
                                                log.error("Failed to update model state", (Throwable)e);
                                                semaphore.release();
                                                wrappedListener.onFailure(e);
                                            }));
                                        }
                                        wrappedListener.onResponse((Object)new MLUploadModelChunkResponse("Uploaded"));
                                    }, e -> {
                                        log.error("Failed to upload chunk model", (Throwable)e);
                                        wrappedListener.onFailure(e);
                                    }));
                                }, ex -> {
                                    log.error("Failed to init model index", (Throwable)ex);
                                    wrappedListener.onFailure(ex);
                                }));
                            }
                        }, e -> {
                            MLExceptionUtils.logException("Failed to validate model access", e, log);
                            wrappedListener.onFailure(e);
                        }));
                    }
                    catch (Exception e2) {
                        log.error("Failed to parse ml model " + r.getId(), (Throwable)e2);
                        wrappedListener.onFailure(e2);
                    }
                } else {
                    wrappedListener.onFailure((Exception)new MLResourceNotFoundException("Failed to find model"));
                }
            }, e -> {
                if (e instanceof IndexNotFoundException) {
                    wrappedListener.onFailure((Exception)new MLResourceNotFoundException("Failed to find model"));
                } else {
                    log.error("Failed to get ML model " + modelId, (Throwable)e);
                    wrappedListener.onFailure(e);
                }
            }));
        }
        catch (Exception e2) {
            log.error("Fail to upload chunk for model " + modelId, (Throwable)e2);
            listener.onFailure(e2);
        }
    }

    public boolean validateChunkSize(long length) {
        boolean isChunkExceedsSize = false;
        if (length > 10000000L) {
            isChunkExceedsSize = true;
        }
        return isChunkExceedsSize;
    }
}

