/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.stats;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.env.Environment;
import org.opensearch.ml.action.stats.MLStatsNodeRequest;
import org.opensearch.ml.action.stats.MLStatsNodeResponse;
import org.opensearch.ml.action.stats.MLStatsNodesAction;
import org.opensearch.ml.action.stats.MLStatsNodesRequest;
import org.opensearch.ml.action.stats.MLStatsNodesResponse;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.stats.ActionName;
import org.opensearch.ml.stats.MLActionStats;
import org.opensearch.ml.stats.MLAlgoStats;
import org.opensearch.ml.stats.MLModelStats;
import org.opensearch.ml.stats.MLNodeLevelStat;
import org.opensearch.ml.stats.MLStatLevel;
import org.opensearch.ml.stats.MLStats;
import org.opensearch.ml.stats.MLStatsInput;
import org.opensearch.monitor.jvm.JvmService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class MLStatsNodesTransportAction
extends TransportNodesAction<MLStatsNodesRequest, MLStatsNodesResponse, MLStatsNodeRequest, MLStatsNodeResponse> {
    private MLStats mlStats;
    private final JvmService jvmService;

    @Inject
    public MLStatsNodesTransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, MLStats mlStats, Environment environment) {
        super(MLStatsNodesAction.NAME, threadPool, clusterService, transportService, actionFilters, MLStatsNodesRequest::new, MLStatsNodeRequest::new, "management", MLStatsNodeResponse.class);
        this.mlStats = mlStats;
        this.jvmService = new JvmService(environment.settings());
    }

    protected MLStatsNodesResponse newResponse(MLStatsNodesRequest request, List<MLStatsNodeResponse> responses, List<FailedNodeException> failures) {
        return new MLStatsNodesResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected MLStatsNodeRequest newNodeRequest(MLStatsNodesRequest request) {
        return new MLStatsNodeRequest(request);
    }

    protected MLStatsNodeResponse newNodeResponse(StreamInput in) throws IOException {
        return new MLStatsNodeResponse(in);
    }

    protected MLStatsNodeResponse nodeOperation(MLStatsNodeRequest request) {
        return this.createMLStatsNodeResponse(request.getMlStatsNodesRequest());
    }

    MLStatsNodeResponse createMLStatsNodeResponse(MLStatsNodesRequest mlStatsNodesRequest) {
        HashMap<MLNodeLevelStat, Object> statValues = new HashMap<MLNodeLevelStat, Object>();
        MLStatsInput mlStatsInput = mlStatsNodesRequest.getMlStatsInput();
        if (mlStatsInput.getTargetStatLevels().contains((Object)MLStatLevel.NODE)) {
            if (mlStatsInput.retrieveStat(MLNodeLevelStat.ML_JVM_HEAP_USAGE)) {
                long heapUsedPercent = this.jvmService.stats().getMem().getHeapUsedPercent();
                statValues.put(MLNodeLevelStat.ML_JVM_HEAP_USAGE, heapUsedPercent);
            }
            for (Enum enum_ : this.mlStats.getNodeStats().keySet()) {
                if (!mlStatsInput.retrieveStat(enum_)) continue;
                statValues.put((MLNodeLevelStat)enum_, this.mlStats.getStats().get(enum_).getValue());
            }
        }
        HashMap<FunctionName, MLAlgoStats> algorithmStats = new HashMap<FunctionName, MLAlgoStats>();
        if (mlStatsInput.includeAlgoStats()) {
            for (FunctionName algoName : this.mlStats.getAllAlgorithms()) {
                if (!mlStatsInput.retrieveStatsForAlgo(algoName)) continue;
                HashMap<ActionName, MLActionStats> actionStatsMap = new HashMap<ActionName, MLActionStats>();
                for (Map.Entry<ActionName, MLActionStats> entry : this.mlStats.getAlgorithmStats(algoName).entrySet()) {
                    if (!mlStatsInput.retrieveStatsForAction(entry.getKey())) continue;
                    actionStatsMap.put(entry.getKey(), entry.getValue());
                }
                algorithmStats.put(algoName, new MLAlgoStats(actionStatsMap));
            }
        }
        HashMap<String, MLModelStats> hashMap = new HashMap<String, MLModelStats>();
        if (mlStatsInput.includeModelStats()) {
            for (String modelId : this.mlStats.getAllModels()) {
                if (!mlStatsInput.retrieveStatsForModel(modelId)) continue;
                HashMap<ActionName, MLActionStats> actionStatsMap = new HashMap<ActionName, MLActionStats>();
                for (Map.Entry<ActionName, MLActionStats> entry : this.mlStats.getModelStats(modelId).entrySet()) {
                    if (!mlStatsInput.retrieveStatsForAction(entry.getKey())) continue;
                    actionStatsMap.put(entry.getKey(), entry.getValue());
                }
                hashMap.put(modelId, new MLModelStats(actionStatsMap));
            }
        }
        return new MLStatsNodeResponse(this.clusterService.localNode(), statValues, algorithmStats, hashMap);
    }
}

