/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.configs;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;

public class HighHeapUsageYoungGenRcaConfig {
    private static final Logger LOG = LogManager.getLogger(HighHeapUsageYoungGenRcaConfig.class);
    public static final String CONFIG_NAME = "high-heap-usage-young-gen-rca";
    private Integer promotionRateThreshold;
    private Integer youngGenGcTimeThreshold;
    private Double garbagePromotionPctThreshold;
    public static final int DEFAULT_PROMOTION_RATE_THRESHOLD_IN_MB_PER_SEC = 500;
    public static final int DEFAULT_YOUNG_GEN_GC_TIME_THRESHOLD_IN_MS_PER_SEC = 400;
    public static final double DEFAULT_GARBAGE_PROMOTION_PCT_THRESHOLD = 0.8;

    public HighHeapUsageYoungGenRcaConfig(RcaConf rcaConf) {
        this.promotionRateThreshold = rcaConf.readRcaConfig(CONFIG_NAME, "promotion-rate-mb-per-second", 500, s -> s > 0, Integer.class);
        this.youngGenGcTimeThreshold = rcaConf.readRcaConfig(CONFIG_NAME, "young-gen-gc-time-ms-per-second", 400, s -> s > 0, Integer.class);
        this.garbagePromotionPctThreshold = rcaConf.readRcaConfig(CONFIG_NAME, "garbage-promotion-pct-threshold", 0.8, s -> s >= 0.0 && s <= 1.0, Double.class);
    }

    public int getPromotionRateThreshold() {
        return this.promotionRateThreshold;
    }

    public int getYoungGenGcTimeThreshold() {
        return this.youngGenGcTimeThreshold;
    }

    public double getGarbagePromotionPctThreshold() {
        return this.garbagePromotionPctThreshold;
    }

    public static class RCA_CONF_KEY_CONSTANTS {
        public static final String PROMOTION_RATE_THRES = "promotion-rate-mb-per-second";
        public static final String YOUNG_GEN_GC_TIME_THRES = "young-gen-gc-time-ms-per-second";
        public static final String GARBAGE_PROMOTION_PCT_THRES = "garbage-promotion-pct-threshold";
    }
}

