/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.decisionmaker.deciders.configs;

import org.opensearch.performanceanalyzer.decisionmaker.deciders.configs.CachePriorityOrderConfig;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.configs.WorkLoadTypeConfig;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.configs.jvm.OldGenDecisionPolicyConfig;
import org.opensearch.performanceanalyzer.decisionmaker.deciders.configs.jvm.young_gen.JvmGenTuningPolicyConfig;
import org.opensearch.performanceanalyzer.rca.framework.core.NestedConfig;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;

public class DeciderConfig {
    private static final String CACHE_CONFIG_NAME = "cache-type";
    private static final String WORKLOAD_CONFIG_NAME = "workload-type";
    private static final String OLD_GEN_DECISION_POLICY_CONFIG_NAME = "old-gen-decision-policy-config";
    private static final String JVM_GEN_TUNING_POLICY_CONFIG_NAME = "jvm-gen-tuning-policy-config";
    private final CachePriorityOrderConfig cachePriorityOrderConfig;
    private final WorkLoadTypeConfig workLoadTypeConfig;
    private final OldGenDecisionPolicyConfig oldGenDecisionPolicyConfig;
    private final JvmGenTuningPolicyConfig jvmGenTuningPolicyConfig;

    public DeciderConfig(RcaConf rcaConf) {
        this.cachePriorityOrderConfig = new CachePriorityOrderConfig(new NestedConfig(CACHE_CONFIG_NAME, rcaConf.getDeciderConfigSettings()));
        this.workLoadTypeConfig = new WorkLoadTypeConfig(new NestedConfig(WORKLOAD_CONFIG_NAME, rcaConf.getDeciderConfigSettings()));
        this.oldGenDecisionPolicyConfig = new OldGenDecisionPolicyConfig(new NestedConfig(OLD_GEN_DECISION_POLICY_CONFIG_NAME, rcaConf.getDeciderConfigSettings()));
        this.jvmGenTuningPolicyConfig = new JvmGenTuningPolicyConfig(new NestedConfig(JVM_GEN_TUNING_POLICY_CONFIG_NAME, rcaConf.getDeciderConfigSettings()));
    }

    public CachePriorityOrderConfig getCachePriorityOrderConfig() {
        return this.cachePriorityOrderConfig;
    }

    public WorkLoadTypeConfig getWorkLoadTypeConfig() {
        return this.workLoadTypeConfig;
    }

    public OldGenDecisionPolicyConfig getOldGenDecisionPolicyConfig() {
        return this.oldGenDecisionPolicyConfig;
    }

    public JvmGenTuningPolicyConfig getJvmGenTuningPolicyConfig() {
        return this.jvmGenTuningPolicyConfig;
    }
}

