/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.decisionmaker.actions.configs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.decisionmaker.actions.configs.ThresholdConfig;
import org.opensearch.performanceanalyzer.grpc.ResourceEnum;
import org.opensearch.performanceanalyzer.rca.framework.core.Config;
import org.opensearch.performanceanalyzer.rca.framework.core.NestedConfig;
import org.opensearch.performanceanalyzer.rca.framework.core.RcaConf;

public class CacheActionConfig {
    private static final Logger LOG = LogManager.getLogger(CacheActionConfig.class);
    private NestedConfig cacheSettingsConfig;
    private FieldDataCacheConfig fieldDataCacheConfig;
    private ShardRequestCacheConfig shardRequestCacheConfig;
    private Config<Integer> totalStepCount;
    private Map<ResourceEnum, ThresholdConfig<Double>> thresholdConfigMap;
    private static final String TOTAL_STEP_COUNT_CONFIG_NAME = "total-step-count";
    public static final int DEFAULT_TOTAL_STEP_COUNT = 20;
    public static final Double DEFAULT_FIELDDATA_CACHE_UPPER_BOUND = 0.4;
    public static final Double DEFAULT_FIELDDATA_CACHE_LOWER_BOUND = 0.1;
    public static final Double DEFAULT_SHARD_REQUEST_CACHE_UPPER_BOUND = 0.05;
    public static final Double DEFAULT_SHARD_REQUEST_CACHE_LOWER_BOUND = 0.01;

    public CacheActionConfig(RcaConf conf) {
        Map<String, Object> actionConfig = conf.getActionConfigSettings();
        this.cacheSettingsConfig = new NestedConfig("cache-settings", actionConfig);
        this.fieldDataCacheConfig = new FieldDataCacheConfig(this.cacheSettingsConfig);
        this.shardRequestCacheConfig = new ShardRequestCacheConfig(this.cacheSettingsConfig);
        this.totalStepCount = new Config<Integer>(TOTAL_STEP_COUNT_CONFIG_NAME, this.cacheSettingsConfig.getValue(), 20, s -> s > 0, Integer.class);
        this.createThresholdConfigMap();
    }

    public int getTotalStepCount() {
        return this.totalStepCount.getValue();
    }

    public double getStepSize(ResourceEnum cacheType) {
        ThresholdConfig<Double> threshold = this.getThresholdConfig(cacheType);
        return (threshold.upperBound() - threshold.lowerBound()) / (double)this.getTotalStepCount();
    }

    public ThresholdConfig<Double> getThresholdConfig(ResourceEnum cacheType) {
        if (!this.thresholdConfigMap.containsKey((Object)cacheType)) {
            String msg = "Threshold config requested for unknown cache type: " + cacheType.toString();
            LOG.error(msg);
            throw new IllegalArgumentException(msg);
        }
        return this.thresholdConfigMap.get((Object)cacheType);
    }

    private void createThresholdConfigMap() {
        HashMap<ResourceEnum, ThresholdConfig<Double>> configMap = new HashMap<ResourceEnum, ThresholdConfig<Double>>();
        configMap.put(ResourceEnum.FIELD_DATA_CACHE, this.fieldDataCacheConfig);
        configMap.put(ResourceEnum.SHARD_REQUEST_CACHE, this.shardRequestCacheConfig);
        this.thresholdConfigMap = Collections.unmodifiableMap(configMap);
    }

    private static class FieldDataCacheConfig
    implements ThresholdConfig<Double> {
        private Config<Double> fieldDataCacheUpperBound;
        private Config<Double> fieldDataCacheLowerBound;

        public FieldDataCacheConfig(NestedConfig cacheSettingsConfig) {
            NestedConfig fieldDataCacheConfig = new NestedConfig("fielddata", cacheSettingsConfig.getValue());
            this.fieldDataCacheUpperBound = new Config<Double>("upper-bound", fieldDataCacheConfig.getValue(), DEFAULT_FIELDDATA_CACHE_UPPER_BOUND, s -> s > 0.0, Double.class);
            this.fieldDataCacheLowerBound = new Config<Double>("lower-bound", fieldDataCacheConfig.getValue(), DEFAULT_FIELDDATA_CACHE_LOWER_BOUND, s -> s > 0.0, Double.class);
        }

        @Override
        public Double upperBound() {
            return this.fieldDataCacheUpperBound.getValue();
        }

        @Override
        public Double lowerBound() {
            return this.fieldDataCacheLowerBound.getValue();
        }
    }

    private static class ShardRequestCacheConfig
    implements ThresholdConfig<Double> {
        private Config<Double> shardRequestCacheUpperBound;
        private Config<Double> shardRequestCacheLowerBound;

        public ShardRequestCacheConfig(NestedConfig cacheSettingsConfig) {
            NestedConfig shardRequestCacheConfig = new NestedConfig("shard-request", cacheSettingsConfig.getValue());
            this.shardRequestCacheUpperBound = new Config<Double>("upper-bound", shardRequestCacheConfig.getValue(), DEFAULT_SHARD_REQUEST_CACHE_UPPER_BOUND, s -> s > 0.0, Double.class);
            this.shardRequestCacheLowerBound = new Config<Double>("lower-bound", shardRequestCacheConfig.getValue(), DEFAULT_SHARD_REQUEST_CACHE_LOWER_BOUND, s -> s > 0.0, Double.class);
        }

        @Override
        public Double upperBound() {
            return this.shardRequestCacheUpperBound.getValue();
        }

        @Override
        public Double lowerBound() {
            return this.shardRequestCacheLowerBound.getValue();
        }
    }
}

