/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.opensearch.action.search.SearchPhaseContext;
import org.opensearch.action.search.SearchPhaseName;
import org.opensearch.action.search.SearchRequestOperationsListener;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.metrics.CounterMetric;
import org.opensearch.common.metrics.MeanMetric;

public final class SearchRequestStats
implements SearchRequestOperationsListener {
    Map<SearchPhaseName, StatsHolder> phaseStatsMap = new EnumMap<SearchPhaseName, StatsHolder>(SearchPhaseName.class);

    @Inject
    public SearchRequestStats() {
        for (SearchPhaseName searchPhaseName : SearchPhaseName.values()) {
            this.phaseStatsMap.put(searchPhaseName, new StatsHolder());
        }
    }

    public long getPhaseCurrent(SearchPhaseName searchPhaseName) {
        return this.phaseStatsMap.get((Object)((Object)searchPhaseName)).current.count();
    }

    public long getPhaseTotal(SearchPhaseName searchPhaseName) {
        return this.phaseStatsMap.get((Object)((Object)searchPhaseName)).total.count();
    }

    public long getPhaseMetric(SearchPhaseName searchPhaseName) {
        return this.phaseStatsMap.get((Object)((Object)searchPhaseName)).timing.sum();
    }

    @Override
    public void onPhaseStart(SearchPhaseContext context) {
        this.phaseStatsMap.get((Object)((Object)context.getCurrentPhase().getSearchPhaseName())).current.inc();
    }

    @Override
    public void onPhaseEnd(SearchPhaseContext context) {
        StatsHolder phaseStats = this.phaseStatsMap.get((Object)context.getCurrentPhase().getSearchPhaseName());
        phaseStats.current.dec();
        phaseStats.total.inc();
        phaseStats.timing.inc(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - context.getCurrentPhase().getStartTimeInNanos()));
    }

    @Override
    public void onPhaseFailure(SearchPhaseContext context) {
        this.phaseStatsMap.get((Object)((Object)context.getCurrentPhase().getSearchPhaseName())).current.dec();
    }

    public static final class StatsHolder {
        CounterMetric current = new CounterMetric();
        CounterMetric total = new CounterMetric();
        MeanMetric timing = new MeanMetric();
    }
}

