/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.decommission.awareness.get;

import java.io.IOException;
import org.opensearch.action.admin.cluster.decommission.awareness.get.GetDecommissionStateRequest;
import org.opensearch.action.admin.cluster.decommission.awareness.get.GetDecommissionStateResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeReadAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.decommission.DecommissionAttributeMetadata;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportGetDecommissionStateAction
extends TransportClusterManagerNodeReadAction<GetDecommissionStateRequest, GetDecommissionStateResponse> {
    @Inject
    public TransportGetDecommissionStateAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/decommission/awareness/get", transportService, clusterService, threadPool, actionFilters, GetDecommissionStateRequest::new, indexNameExpressionResolver);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected GetDecommissionStateResponse read(StreamInput in) throws IOException {
        return new GetDecommissionStateResponse(in);
    }

    @Override
    protected void clusterManagerOperation(GetDecommissionStateRequest request, ClusterState state, ActionListener<GetDecommissionStateResponse> listener) throws Exception {
        DecommissionAttributeMetadata decommissionAttributeMetadata = state.metadata().decommissionAttributeMetadata();
        if (decommissionAttributeMetadata != null && request.attributeName().equals(decommissionAttributeMetadata.decommissionAttribute().attributeName())) {
            listener.onResponse((Object)new GetDecommissionStateResponse(decommissionAttributeMetadata.decommissionAttribute().attributeValue(), decommissionAttributeMetadata.status()));
        } else {
            listener.onResponse((Object)new GetDecommissionStateResponse());
        }
    }

    @Override
    protected ClusterBlockException checkBlock(GetDecommissionStateRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

