/*
 * Decompiled with CFR 0.152.
 */
package ai.djl;

import ai.djl.engine.Engine;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Device {
    private static final Map<String, Device> CACHE = new ConcurrentHashMap<String, Device>();
    private static final Device CPU = new Device("cpu", -1);
    private static final Device GPU = Device.of("gpu", 0);
    private static final Pattern DEVICE_NAME = Pattern.compile("([a-z]+)([0-9]*)");
    private String deviceType;
    private int deviceId;

    private Device(String deviceType, int deviceId) {
        this.deviceType = deviceType;
        this.deviceId = deviceId;
    }

    public static Device of(String deviceType, int deviceId) {
        if ("cpu".equals(deviceType)) {
            return CPU;
        }
        String key = deviceType + '-' + deviceId;
        return CACHE.computeIfAbsent(key, k -> new Device(deviceType, deviceId));
    }

    public static Device fromName(String deviceName) {
        return Device.fromName(deviceName, Engine.getInstance());
    }

    public static Device fromName(String deviceName, Engine engine) {
        if (deviceName == null || deviceName.isEmpty()) {
            return engine.defaultDevice();
        }
        Matcher matcher = DEVICE_NAME.matcher(deviceName);
        if (matcher.matches()) {
            String deviceType = matcher.group(1);
            int deviceId = -1;
            if (!matcher.group(2).isEmpty()) {
                deviceId = Integer.parseInt(matcher.group(2));
            }
            return Device.of(deviceType, deviceId);
        }
        try {
            int deviceId = Integer.parseInt(deviceName);
            if (deviceId < 0) {
                return Device.cpu();
            }
            return Device.gpu(deviceId);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Failed to parse device name: " + deviceName);
        }
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public boolean isGpu() {
        return "gpu".equals(this.deviceType);
    }

    public String toString() {
        if ("cpu".equals(this.deviceType)) {
            return this.deviceType + "()";
        }
        return this.deviceType + '(' + this.deviceId + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Device device = (Device)o;
        if ("cpu".equals(this.deviceType)) {
            return Objects.equals(this.deviceType, device.deviceType);
        }
        return this.deviceId == device.deviceId && Objects.equals(this.deviceType, device.deviceType);
    }

    public int hashCode() {
        return Objects.hash(this.deviceType, this.deviceId);
    }

    public static Device cpu() {
        return CPU;
    }

    public static Device gpu() {
        return GPU;
    }

    public static Device gpu(int deviceId) {
        return Device.of("gpu", deviceId);
    }

    public static interface Type {
        public static final String CPU = "cpu";
        public static final String GPU = "gpu";
    }
}

