/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;

public enum CommitmentPolicy {
    ForbidEncryptAllowDecrypt,
    RequireEncryptAllowDecrypt,
    RequireEncryptRequireDecrypt;


    public boolean algorithmAllowedForEncrypt(CryptoAlgorithm algorithm) {
        switch (this) {
            case ForbidEncryptAllowDecrypt: {
                return !algorithm.isCommitting();
            }
            case RequireEncryptAllowDecrypt: 
            case RequireEncryptRequireDecrypt: {
                return algorithm.isCommitting();
            }
        }
        throw new UnsupportedOperationException("Support for commitment policy " + (Object)((Object)this) + " not yet built.");
    }

    public boolean algorithmAllowedForDecrypt(CryptoAlgorithm algorithm) {
        switch (this) {
            case ForbidEncryptAllowDecrypt: 
            case RequireEncryptAllowDecrypt: {
                return true;
            }
            case RequireEncryptRequireDecrypt: {
                return algorithm.isCommitting();
            }
        }
        throw new UnsupportedOperationException("Support for commitment policy " + (Object)((Object)this) + " not yet built.");
    }
}

