/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.CertificateFactory;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.X509KeyFactory;

class ProvX509
extends AsymmetricAlgorithmProvider {
    ProvX509() {
    }

    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.X.509", "org.bouncycastle.jcajce.provider.asymmetric.x509.KeyFactory", new EngineCreator(){

            public Object createInstance(Object object) {
                return new X509KeyFactory(bouncyCastleFipsProvider);
            }
        });
        bouncyCastleFipsProvider.addAlias("Alg.Alias.KeyFactory.X509", "X.509");
        bouncyCastleFipsProvider.addAlgorithmImplementation("CertificateFactory.X.509", "org.bouncycastle.jcajce.provider.asymmetric.x509.CertificateFactory", new EngineCreator(){

            public Object createInstance(Object object) {
                return new CertificateFactory(bouncyCastleFipsProvider);
            }
        });
        bouncyCastleFipsProvider.addAlias("Alg.Alias.CertificateFactory.X509", "X.509");
    }
}

