/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.oracle.parser;

import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLHint;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObjectImpl;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDisableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropColumnItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableDropConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableEnableConstraint;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableItem;
import com.alibaba.druid.sql.ast.statement.SQLAlterTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLDropSequenceStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropTriggerStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropUserStatement;
import com.alibaba.druid.sql.ast.statement.SQLDropViewStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertInto;
import com.alibaba.druid.sql.ast.statement.SQLRollbackStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSetStatement;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleErrorLoggingClause;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleParameter;
import com.alibaba.druid.sql.dialect.oracle.ast.clause.OracleReturningClause;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterIndexStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterProcedureStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterSessionStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterSynonymStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableAddConstaint;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableDropPartition;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableModify;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableMoveTablespace;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableSplitPartition;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTableTruncatePartition;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTablespaceAddDataFile;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTablespaceStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterTriggerStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleAlterViewStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleBlockStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCommitStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleConstraint;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateDatabaseDbLinkStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateIndexStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateProcedureStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleCreateSequenceStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleDeleteStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleDropDbLinkStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleExceptionStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleExitStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleExplainStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleExprStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleFetchStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleFileSpecification;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleForStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleGotoStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleIfStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleInsertStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleLabelStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleLockTableStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleLoopStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleMergeStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleMultiInsertStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OraclePLSQLCommitStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSavePointStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSelect;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleSetTransactionStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleStatement;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleCreateTableParser;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleExprParser;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleSelectParser;
import com.alibaba.druid.sql.dialect.oracle.parser.OracleUpdateParser;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import java.util.ArrayList;
import java.util.List;

public class OracleStatementParser
extends SQLStatementParser {
    public OracleStatementParser(String sql) {
        super(new OracleExprParser(sql));
    }

    public OracleStatementParser(Lexer lexer) {
        super(new OracleExprParser(lexer));
    }

    @Override
    public OracleExprParser getExprParser() {
        return (OracleExprParser)this.exprParser;
    }

    public void parseHints(List<SQLHint> hints) {
        this.getExprParser().parseHints(hints);
    }

    @Override
    public OracleCreateTableParser getSQLCreateTableParser() {
        return new OracleCreateTableParser(this.lexer);
    }

    @Override
    protected void parseInsert0_hinits(SQLInsertInto insertStatement) {
        if (insertStatement instanceof OracleInsertStatement) {
            OracleInsertStatement stmt = (OracleInsertStatement)insertStatement;
            this.getExprParser().parseHints(stmt.getHints());
        } else {
            ArrayList hints = new ArrayList(1);
            this.getExprParser().parseHints(hints);
        }
    }

    @Override
    public void parseStatementList(List<SQLStatement> statementList, int max) {
        while (true) {
            if (max != -1 && statementList.size() >= max) {
                return;
            }
            if (this.lexer.token() == Token.EOF) {
                return;
            }
            if (this.lexer.token() == Token.END) {
                return;
            }
            if (this.lexer.token() == Token.ELSE) {
                return;
            }
            if (this.lexer.token() == Token.SEMI) {
                this.lexer.nextToken();
                continue;
            }
            if (this.lexer.token() == Token.SELECT) {
                SQLSelectStatement stmt = new SQLSelectStatement(new OracleSelectParser(this.exprParser).select(), "oracle");
                statementList.add(stmt);
                continue;
            }
            if (this.lexer.token() == Token.UPDATE) {
                statementList.add(this.parseUpdateStatement());
                continue;
            }
            if (this.lexer.token() == Token.CREATE) {
                statementList.add(this.parseCreate());
                continue;
            }
            if (this.lexer.token() == Token.INSERT) {
                statementList.add(this.parseInsert());
                continue;
            }
            if (this.lexer.token() == Token.DELETE) {
                statementList.add(this.parseDeleteStatement());
                continue;
            }
            if (this.lexer.token() == Token.SLASH) {
                this.lexer.nextToken();
                statementList.add(new OraclePLSQLCommitStatement());
                continue;
            }
            if (this.lexer.token() == Token.ALTER) {
                statementList.add(this.parserAlter());
                continue;
            }
            if (this.lexer.token() == Token.WITH) {
                statementList.add(new SQLSelectStatement(new OracleSelectParser(this.exprParser).select()));
                continue;
            }
            if (this.lexer.token() == Token.LBRACE || this.identifierEquals("CALL")) {
                statementList.add(this.parseCall());
                continue;
            }
            if (this.lexer.token() == Token.MERGE) {
                statementList.add(this.parseMerge());
                continue;
            }
            if (this.lexer.token() == Token.BEGIN) {
                statementList.add(this.parseBlock());
                continue;
            }
            if (this.lexer.token() == Token.DECLARE) {
                statementList.add(this.parseBlock());
                continue;
            }
            if (this.lexer.token() == Token.LOCK) {
                statementList.add(this.parseLock());
                continue;
            }
            if (this.lexer.token() == Token.TRUNCATE) {
                statementList.add(this.parseTruncate());
                continue;
            }
            if (this.lexer.token() == Token.VARIANT) {
                SQLSetStatement stmt;
                SQLBinaryOpExpr binaryOpExpr;
                SQLExpr variant = this.exprParser.primary();
                if (variant instanceof SQLBinaryOpExpr && (binaryOpExpr = (SQLBinaryOpExpr)variant).getOperator() == SQLBinaryOperator.Assignment) {
                    stmt = new SQLSetStatement(binaryOpExpr.getLeft(), binaryOpExpr.getRight(), this.getDbType());
                    statementList.add(stmt);
                    continue;
                }
                this.accept(Token.COLONEQ);
                SQLExpr value = this.exprParser.expr();
                stmt = new SQLSetStatement(variant, value, this.getDbType());
                statementList.add(stmt);
                continue;
            }
            if (this.lexer.token() == Token.EXCEPTION) {
                statementList.add(this.parseException());
                continue;
            }
            if (this.identifierEquals("EXIT")) {
                this.lexer.nextToken();
                OracleExitStatement stmt = new OracleExitStatement();
                if (this.lexer.token() == Token.WHEN) {
                    this.lexer.nextToken();
                    stmt.setWhen(this.exprParser.expr());
                }
                statementList.add(stmt);
                continue;
            }
            if (this.identifierEquals("FETCH")) {
                this.lexer.nextToken();
                OracleFetchStatement stmt = new OracleFetchStatement();
                stmt.setCursorName(this.exprParser.name());
                this.accept(Token.INTO);
                while (true) {
                    stmt.getInto().add(this.exprParser.name());
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                statementList.add(stmt);
                continue;
            }
            if (this.identifierEquals("ROLLBACK")) {
                SQLRollbackStatement stmt = this.parseRollback();
                statementList.add(stmt);
                continue;
            }
            if (this.lexer.token() == Token.EXPLAIN) {
                statementList.add(this.parseExplain());
                continue;
            }
            if (this.lexer.token() == Token.IDENTIFIER) {
                SQLExpr expr = this.exprParser.expr();
                OracleExprStatement stmt = new OracleExprStatement(expr);
                statementList.add(stmt);
                continue;
            }
            if (this.lexer.token() == Token.LPAREN) {
                char ch = this.lexer.current();
                int bp = this.lexer.bp();
                this.lexer.nextToken();
                if (this.lexer.token() == Token.SELECT) {
                    this.lexer.reset(bp, ch, Token.LPAREN);
                    statementList.add(this.parseSelect());
                    continue;
                }
                throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
            }
            if (this.lexer.token() == Token.SET) {
                statementList.add(this.parseSet());
                continue;
            }
            if (this.lexer.token() == Token.GRANT) {
                statementList.add(this.parseGrant());
                continue;
            }
            if (this.lexer.token() == Token.REVOKE) {
                statementList.add(this.parseRevoke());
                continue;
            }
            if (this.lexer.token() == Token.COMMENT) {
                statementList.add(this.parseComment());
                continue;
            }
            if (this.lexer.token() == Token.FOR) {
                statementList.add(this.parseFor());
                continue;
            }
            if (this.lexer.token() == Token.LOOP) {
                statementList.add(this.parseLoop());
                continue;
            }
            if (this.lexer.token() == Token.IF) {
                statementList.add(this.parseIf());
                continue;
            }
            if (this.lexer.token() == Token.GOTO) {
                this.lexer.nextToken();
                SQLName label = this.exprParser.name();
                OracleGotoStatement stmt = new OracleGotoStatement(label);
                statementList.add(stmt);
                continue;
            }
            if (this.lexer.token() == Token.COMMIT) {
                this.lexer.nextToken();
                if (this.identifierEquals("WORK")) {
                    this.lexer.nextToken();
                }
                OracleCommitStatement stmt = new OracleCommitStatement();
                if (this.identifierEquals("WRITE")) {
                    stmt.setWrite(true);
                    this.lexer.nextToken();
                    while (true) {
                        if (this.lexer.token() == Token.WAIT) {
                            this.lexer.nextToken();
                            stmt.setWait(Boolean.TRUE);
                            continue;
                        }
                        if (this.lexer.token() == Token.NOWAIT) {
                            this.lexer.nextToken();
                            stmt.setWait(Boolean.FALSE);
                            continue;
                        }
                        if (this.lexer.token() == Token.IMMEDIATE) {
                            this.lexer.nextToken();
                            stmt.setImmediate(Boolean.TRUE);
                            continue;
                        }
                        if (!this.identifierEquals("BATCH")) break;
                        this.lexer.nextToken();
                        stmt.setImmediate(Boolean.FALSE);
                    }
                }
                statementList.add(stmt);
                continue;
            }
            if (this.lexer.token() == Token.SAVEPOINT) {
                this.lexer.nextToken();
                OracleSavePointStatement stmt = new OracleSavePointStatement();
                if (this.lexer.token() == Token.TO) {
                    this.lexer.nextToken();
                    stmt.setTo(this.exprParser.name());
                }
                statementList.add(stmt);
                continue;
            }
            if (this.lexer.token() == Token.LTLT) {
                this.lexer.nextToken();
                SQLName label = this.exprParser.name();
                OracleLabelStatement stmt = new OracleLabelStatement(label);
                this.accept(Token.GTGT);
                statementList.add(stmt);
                continue;
            }
            if (this.lexer.token() == Token.DROP) {
                this.lexer.nextToken();
                if (this.lexer.token() == Token.TABLE) {
                    SQLDropTableStatement stmt = this.parseDropTable(false);
                    statementList.add(stmt);
                    continue;
                }
                boolean isPublic = false;
                if (this.identifierEquals("PUBLIC")) {
                    this.lexer.nextToken();
                    isPublic = true;
                }
                if (this.lexer.token() == Token.DATABASE) {
                    this.lexer.nextToken();
                    if (this.identifierEquals("LINK")) {
                        this.lexer.nextToken();
                        OracleDropDbLinkStatement stmt = new OracleDropDbLinkStatement();
                        if (isPublic) {
                            stmt.setPublic(isPublic);
                        }
                        stmt.setName(this.exprParser.name());
                        statementList.add(stmt);
                        continue;
                    }
                }
                if (this.lexer.token() == Token.INDEX) {
                    SQLStatement stmt = this.parseDropIndex();
                    statementList.add(stmt);
                    continue;
                }
                if (this.lexer.token() == Token.VIEW) {
                    SQLDropViewStatement stmt = this.parseDropView(false);
                    statementList.add(stmt);
                    continue;
                }
                if (this.lexer.token() == Token.SEQUENCE) {
                    SQLDropSequenceStatement stmt = this.parseDropSequece(false);
                    statementList.add(stmt);
                    continue;
                }
                if (this.lexer.token() == Token.TRIGGER) {
                    SQLDropTriggerStatement stmt = this.parseDropTrigger(false);
                    statementList.add(stmt);
                    continue;
                }
                if (this.lexer.token() == Token.USER) {
                    SQLDropUserStatement stmt = this.parseDropUser();
                    statementList.add(stmt);
                    continue;
                }
                throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
            }
            if (this.lexer.token() != Token.NULL) break;
            this.lexer.nextToken();
            OracleExprStatement stmt = new OracleExprStatement(new SQLNullExpr());
            statementList.add(stmt);
        }
        throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
    }

    public SQLStatement parseIf() {
        this.accept(Token.IF);
        OracleIfStatement stmt = new OracleIfStatement();
        stmt.setCondition(this.exprParser.expr());
        this.accept(Token.THEN);
        this.parseStatementList(stmt.getStatements());
        while (this.lexer.token() == Token.ELSE) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.IF) {
                this.lexer.nextToken();
                OracleIfStatement.ElseIf elseIf = new OracleIfStatement.ElseIf();
                elseIf.setCondition(this.exprParser.expr());
                this.accept(Token.THEN);
                this.parseStatementList(elseIf.getStatements());
                stmt.getElseIfList().add(elseIf);
                continue;
            }
            OracleIfStatement.Else elseItem = new OracleIfStatement.Else();
            this.parseStatementList(elseItem.getStatements());
            stmt.setElseItem(elseItem);
            break;
        }
        this.accept(Token.END);
        this.accept(Token.IF);
        return stmt;
    }

    public OracleForStatement parseFor() {
        this.accept(Token.FOR);
        OracleForStatement stmt = new OracleForStatement();
        stmt.setIndex(this.exprParser.name());
        this.accept(Token.IN);
        stmt.setRange(this.exprParser.expr());
        this.accept(Token.LOOP);
        this.parseStatementList(stmt.getStatements());
        this.accept(Token.END);
        this.accept(Token.LOOP);
        return stmt;
    }

    public OracleLoopStatement parseLoop() {
        this.accept(Token.LOOP);
        OracleLoopStatement stmt = new OracleLoopStatement();
        this.parseStatementList(stmt.getStatements());
        this.accept(Token.END);
        this.accept(Token.LOOP);
        return stmt;
    }

    @Override
    public SQLStatement parseSet() {
        this.accept(Token.SET);
        this.acceptIdentifier("TRANSACTION");
        OracleSetTransactionStatement stmt = new OracleSetTransactionStatement();
        if (this.identifierEquals("READ")) {
            this.lexer.nextToken();
            this.acceptIdentifier("ONLY");
            stmt.setReadOnly(true);
        }
        this.acceptIdentifier("NAME");
        stmt.setName(this.exprParser.expr());
        return stmt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OracleStatement parserAlter() {
        this.accept(Token.ALTER);
        if (this.lexer.token() == Token.SESSION) {
            this.lexer.nextToken();
            OracleAlterSessionStatement stmt = new OracleAlterSessionStatement();
            if (this.lexer.token() != Token.SET) {
                throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
            }
            this.lexer.nextToken();
            this.parseAssignItems(stmt.getItems(), stmt);
            return stmt;
        }
        if (this.lexer.token() == Token.PROCEDURE) {
            this.lexer.nextToken();
            OracleAlterProcedureStatement stmt = new OracleAlterProcedureStatement();
            stmt.setName(this.exprParser.name());
            if (this.identifierEquals("COMPILE")) {
                this.lexer.nextToken();
                stmt.setCompile(true);
            }
            if (!this.identifierEquals("REUSE")) return stmt;
            this.lexer.nextToken();
            this.acceptIdentifier("SETTINGS");
            stmt.setReuseSettings(true);
            return stmt;
        }
        if (this.lexer.token() == Token.TABLE) {
            return this.parseAlterTable();
        }
        if (this.lexer.token() == Token.INDEX) {
            this.lexer.nextToken();
            OracleAlterIndexStatement stmt = new OracleAlterIndexStatement();
            stmt.setName(this.exprParser.name());
            if (this.identifierEquals("RENAME")) {
                this.lexer.nextToken();
                this.accept(Token.TO);
                stmt.setRenameTo(this.exprParser.name());
            }
            while (true) {
                if (this.identifierEquals("rebuild")) {
                    this.lexer.nextToken();
                    OracleAlterIndexStatement.Rebuild rebuild = new OracleAlterIndexStatement.Rebuild();
                    stmt.setRebuild(rebuild);
                    continue;
                }
                if (!this.identifierEquals("MONITORING")) break;
                this.lexer.nextToken();
                this.acceptIdentifier("USAGE");
                stmt.setMonitoringUsage(Boolean.TRUE);
            }
            if (!this.identifierEquals("PARALLEL")) return stmt;
            this.lexer.nextToken();
            stmt.setParallel(this.exprParser.expr());
            return stmt;
        }
        if (this.lexer.token() == Token.TRIGGER) {
            this.lexer.nextToken();
            OracleAlterTriggerStatement stmt = new OracleAlterTriggerStatement();
            stmt.setName(this.exprParser.name());
            while (true) {
                if (this.lexer.token() == Token.ENABLE) {
                    this.lexer.nextToken();
                    stmt.setEnable(Boolean.TRUE);
                    continue;
                }
                if (this.lexer.token() == Token.DISABLE) {
                    this.lexer.nextToken();
                    stmt.setEnable(Boolean.FALSE);
                    continue;
                }
                if (!this.identifierEquals("COMPILE")) return stmt;
                this.lexer.nextToken();
                stmt.setCompile(true);
            }
        }
        if (this.identifierEquals("SYNONYM")) {
            this.lexer.nextToken();
            OracleAlterSynonymStatement stmt = new OracleAlterSynonymStatement();
            stmt.setName(this.exprParser.name());
            while (true) {
                if (this.lexer.token() == Token.ENABLE) {
                    this.lexer.nextToken();
                    stmt.setEnable(Boolean.TRUE);
                    continue;
                }
                if (this.lexer.token() == Token.DISABLE) {
                    this.lexer.nextToken();
                    stmt.setEnable(Boolean.FALSE);
                    continue;
                }
                if (!this.identifierEquals("COMPILE")) return stmt;
                this.lexer.nextToken();
                stmt.setCompile(true);
            }
        }
        if (this.lexer.token() == Token.VIEW) {
            this.lexer.nextToken();
            OracleAlterViewStatement stmt = new OracleAlterViewStatement();
            stmt.setName(this.exprParser.name());
            while (true) {
                if (this.lexer.token() == Token.ENABLE) {
                    this.lexer.nextToken();
                    stmt.setEnable(Boolean.TRUE);
                    continue;
                }
                if (this.lexer.token() == Token.DISABLE) {
                    this.lexer.nextToken();
                    stmt.setEnable(Boolean.FALSE);
                    continue;
                }
                if (!this.identifierEquals("COMPILE")) return stmt;
                this.lexer.nextToken();
                stmt.setCompile(true);
            }
        }
        if (this.lexer.token() != Token.TABLESPACE) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
        this.lexer.nextToken();
        OracleAlterTablespaceStatement stmt = new OracleAlterTablespaceStatement();
        stmt.setName(this.exprParser.name());
        if (!this.identifierEquals("ADD")) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
        this.lexer.nextToken();
        if (!this.identifierEquals("DATAFILE")) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
        this.lexer.nextToken();
        OracleAlterTablespaceAddDataFile item = new OracleAlterTablespaceAddDataFile();
        while (true) {
            OracleFileSpecification file = new OracleFileSpecification();
            while (true) {
                SQLExpr fileName = this.exprParser.expr();
                file.getFileNames().add(fileName);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            if (this.identifierEquals("SIZE")) {
                this.lexer.nextToken();
                file.setSize(this.exprParser.expr());
            }
            if (this.identifierEquals("AUTOEXTEND")) {
                this.lexer.nextToken();
                if (this.identifierEquals("OFF")) {
                    this.lexer.nextToken();
                    file.setAutoExtendOff(true);
                } else {
                    if (!this.identifierEquals("ON")) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    this.lexer.nextToken();
                    file.setAutoExtendOn(this.exprParser.expr());
                }
            }
            item.getFiles().add(file);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        stmt.setItem(item);
        return stmt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private OracleStatement parseAlterTable() {
        OracleAlterTableStatement stmt;
        block15: {
            SQLObjectImpl item;
            this.lexer.nextToken();
            stmt = new OracleAlterTableStatement();
            stmt.setName(this.exprParser.name());
            while (true) {
                if (this.identifierEquals("ADD")) {
                    this.lexer.nextToken();
                    if (this.lexer.token() == Token.LPAREN) {
                        this.lexer.nextToken();
                        item = this.parseAlterTableAddColumn();
                        stmt.getItems().add((SQLAlterTableItem)((Object)item));
                        this.accept(Token.RPAREN);
                        continue;
                    }
                    if (this.lexer.token() == Token.CONSTRAINT) {
                        OracleConstraint constraint = ((OracleExprParser)this.exprParser).parseConstaint();
                        OracleAlterTableAddConstaint item2 = new OracleAlterTableAddConstaint();
                        constraint.setParent(item2);
                        item2.setParent(stmt);
                        item2.setConstraint(constraint);
                        stmt.getItems().add(item2);
                        continue;
                    }
                    if (this.lexer.token() != Token.IDENTIFIER) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    item = this.parseAlterTableAddColumn();
                    stmt.getItems().add((SQLAlterTableItem)((Object)item));
                    continue;
                }
                if (this.identifierEquals("MOVE")) {
                    this.lexer.nextToken();
                    if (this.lexer.token() != Token.TABLESPACE) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    this.lexer.nextToken();
                    item = new OracleAlterTableMoveTablespace();
                    ((OracleAlterTableMoveTablespace)item).setName(this.exprParser.name());
                    stmt.getItems().add((SQLAlterTableItem)((Object)item));
                    break block15;
                }
                if (this.identifierEquals("RENAME")) {
                    stmt.getItems().add(this.parseAlterTableRename());
                    break block15;
                }
                if (this.identifierEquals("MODIFY")) {
                    SQLColumnDefinition columnDef;
                    this.lexer.nextToken();
                    item = new OracleAlterTableModify();
                    if (this.lexer.token() == Token.LPAREN) {
                        this.lexer.nextToken();
                        while (true) {
                            columnDef = this.exprParser.parseColumn();
                            ((OracleAlterTableModify)item).getColumns().add(columnDef);
                            if (this.lexer.token() != Token.COMMA) break;
                            this.lexer.nextToken();
                        }
                        this.accept(Token.RPAREN);
                    } else {
                        columnDef = this.exprParser.parseColumn();
                        ((OracleAlterTableModify)item).getColumns().add(columnDef);
                    }
                    stmt.getItems().add((SQLAlterTableItem)((Object)item));
                    continue;
                }
                if (this.identifierEquals("SPLIT")) {
                    this.parseAlterTableSplit(stmt);
                    continue;
                }
                if (this.lexer.token() == Token.TRUNCATE) {
                    this.lexer.nextToken();
                    if (!this.identifierEquals("PARTITION")) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    this.lexer.nextToken();
                    item = new OracleAlterTableTruncatePartition();
                    ((OracleAlterTableTruncatePartition)item).setName(this.exprParser.name());
                    stmt.getItems().add((SQLAlterTableItem)((Object)item));
                    continue;
                }
                if (this.lexer.token() != Token.DROP) break;
                this.parseAlterDrop(stmt);
            }
            if (this.lexer.token() == Token.DISABLE) {
                this.lexer.nextToken();
                if (this.lexer.token() != Token.CONSTRAINT) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                this.lexer.nextToken();
                item = new SQLAlterTableEnableConstraint();
                ((SQLAlterTableEnableConstraint)item).setConstraintName(this.exprParser.name());
                stmt.getItems().add((SQLAlterTableItem)((Object)item));
            } else if (this.lexer.token() == Token.ENABLE) {
                this.lexer.nextToken();
                if (this.lexer.token() != Token.CONSTRAINT) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                this.lexer.nextToken();
                item = new SQLAlterTableDisableConstraint();
                ((SQLAlterTableDisableConstraint)item).setConstraintName(this.exprParser.name());
                stmt.getItems().add((SQLAlterTableItem)((Object)item));
            }
        }
        if (this.lexer.token() != Token.UPDATE) return stmt;
        this.lexer.nextToken();
        if (!this.identifierEquals("GLOBAL")) throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
        this.lexer.nextToken();
        this.acceptIdentifier("INDEXES");
        stmt.setUpdateGlobalIndexes(true);
        return stmt;
    }

    @Override
    public void parseAlterDrop(SQLAlterTableStatement stmt) {
        this.lexer.nextToken();
        if (this.lexer.token() == Token.CONSTRAINT) {
            this.lexer.nextToken();
            SQLAlterTableDropConstraint item = new SQLAlterTableDropConstraint();
            item.setConstraintName(this.exprParser.name());
            stmt.getItems().add(item);
        } else if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            SQLAlterTableDropColumnItem item = new SQLAlterTableDropColumnItem();
            this.exprParser.names(item.getColumns());
            stmt.getItems().add(item);
            this.accept(Token.RPAREN);
        } else if (this.lexer.token() == Token.COLUMN) {
            this.lexer.nextToken();
            SQLAlterTableDropColumnItem item = new SQLAlterTableDropColumnItem();
            this.exprParser.names(item.getColumns());
            stmt.getItems().add(item);
        } else if (this.identifierEquals("PARTITION")) {
            this.lexer.nextToken();
            OracleAlterTableDropPartition item = new OracleAlterTableDropPartition();
            item.setName(this.exprParser.name());
            stmt.getItems().add(item);
        } else {
            throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
        }
    }

    private void parseAlterTableSplit(OracleAlterTableStatement stmt) {
        OracleAlterTableSplitPartition item;
        this.lexer.nextToken();
        if (this.identifierEquals("PARTITION")) {
            this.lexer.nextToken();
            item = new OracleAlterTableSplitPartition();
            item.setName(this.exprParser.name());
            if (!this.identifierEquals("AT")) {
                throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
            }
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            this.exprParser.exprList(item.getAt(), item);
            this.accept(Token.RPAREN);
            if (this.lexer.token() == Token.INTO) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                while (true) {
                    OracleAlterTableSplitPartition.NestedTablePartitionSpec spec = new OracleAlterTableSplitPartition.NestedTablePartitionSpec();
                    this.acceptIdentifier("PARTITION");
                    spec.setPartition(this.exprParser.name());
                    while (this.lexer.token() == Token.TABLESPACE) {
                        this.lexer.nextToken();
                        SQLName tablespace = this.exprParser.name();
                        spec.getSegmentAttributeItems().add(new OracleAlterTableSplitPartition.TableSpaceItem(tablespace));
                    }
                    if (this.identifierEquals("PCTREE")) {
                        throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    }
                    if (this.identifierEquals("PCTUSED")) {
                        throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    }
                    if (this.identifierEquals("INITRANS")) {
                        throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    }
                    if (this.identifierEquals("STORAGE")) {
                        throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    }
                    if (this.identifierEquals("LOGGING")) {
                        throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    }
                    if (this.identifierEquals("NOLOGGING")) {
                        throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    }
                    if (this.identifierEquals("FILESYSTEM_LIKE_LOGGING")) {
                        throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
                    }
                    item.getInto().add(spec);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token() == Token.UPDATE) {
                this.lexer.nextToken();
                this.acceptIdentifier("INDEXES");
                OracleAlterTableSplitPartition.UpdateIndexesClause updateIndexes = new OracleAlterTableSplitPartition.UpdateIndexesClause();
                item.setUpdateIndexes(updateIndexes);
            }
        } else {
            throw new ParserException("TODO : " + (Object)((Object)this.lexer.token()) + " " + this.lexer.stringVal());
        }
        stmt.getItems().add(item);
    }

    public OracleLockTableStatement parseLock() {
        this.accept(Token.LOCK);
        this.accept(Token.TABLE);
        OracleLockTableStatement stmt = new OracleLockTableStatement();
        stmt.setTable(this.exprParser.name());
        this.accept(Token.IN);
        if (this.lexer.token() == Token.SHARE) {
            stmt.setLockMode(OracleLockTableStatement.LockMode.SHARE);
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.EXCLUSIVE) {
            stmt.setLockMode(OracleLockTableStatement.LockMode.EXCLUSIVE);
            this.lexer.nextToken();
        }
        this.accept(Token.MODE);
        if (this.lexer.token() == Token.NOWAIT) {
            this.lexer.nextToken();
        } else if (this.lexer.token() == Token.WAIT) {
            this.lexer.nextToken();
            stmt.setWait(this.exprParser.expr());
        }
        return stmt;
    }

    @Override
    public OracleBlockStatement parseBlock() {
        OracleBlockStatement block = new OracleBlockStatement();
        if (this.lexer.token() == Token.DECLARE) {
            this.lexer.nextToken();
            this.parserParameters(block.getParameters());
            for (OracleParameter param : block.getParameters()) {
                param.setParent(block);
            }
        }
        this.accept(Token.BEGIN);
        this.parseStatementList(block.getStatementList());
        this.accept(Token.END);
        return block;
    }

    private void parserParameters(List<OracleParameter> parameters) {
        do {
            OracleParameter parameter = new OracleParameter();
            if (this.lexer.token() == Token.CURSOR) {
                this.lexer.nextToken();
                parameter.setName(this.exprParser.name());
                this.accept(Token.IS);
                OracleSelect select = this.createSQLSelectParser().select();
                SQLDataTypeImpl dataType = new SQLDataTypeImpl();
                dataType.setName("CURSOR");
                parameter.setDataType(dataType);
                parameter.setDefaultValue(new SQLQueryExpr(select));
            } else {
                parameter.setName(this.exprParser.name());
                parameter.setDataType(this.exprParser.parseDataType());
                if (this.lexer.token() == Token.COLONEQ) {
                    this.lexer.nextToken();
                    parameter.setDefaultValue(this.exprParser.expr());
                }
            }
            parameters.add(parameter);
            if (this.lexer.token() != Token.COMMA && this.lexer.token() != Token.SEMI) continue;
            this.lexer.nextToken();
        } while (this.lexer.token() != Token.BEGIN && this.lexer.token() != Token.RPAREN);
    }

    @Override
    public OracleSelectParser createSQLSelectParser() {
        return new OracleSelectParser(this.exprParser);
    }

    public OracleMergeStatement parseMerge() {
        this.accept(Token.MERGE);
        OracleMergeStatement stmt = new OracleMergeStatement();
        this.parseHints(stmt.getHints());
        this.accept(Token.INTO);
        stmt.setInto(this.exprParser.name());
        stmt.setAlias(this.as());
        this.accept(Token.USING);
        SQLTableSource using = this.createSQLSelectParser().parseTableSource();
        stmt.setUsing(using);
        this.accept(Token.ON);
        stmt.setOn(this.exprParser.expr());
        boolean insertFlag = false;
        if (this.lexer.token() == Token.WHEN) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.MATCHED) {
                OracleMergeStatement.MergeUpdateClause updateClause = new OracleMergeStatement.MergeUpdateClause();
                this.lexer.nextToken();
                this.accept(Token.THEN);
                this.accept(Token.UPDATE);
                this.accept(Token.SET);
                while (true) {
                    SQLUpdateSetItem item = this.exprParser.parseUpdateSetItem();
                    updateClause.getItems().add(item);
                    item.setParent(updateClause);
                    if (this.lexer.token() != Token.COMMA) break;
                    this.lexer.nextToken();
                }
                if (this.lexer.token() == Token.WHERE) {
                    this.lexer.nextToken();
                    updateClause.setWhere(this.exprParser.expr());
                }
                if (this.lexer.token() == Token.DELETE) {
                    this.lexer.nextToken();
                    this.accept(Token.WHERE);
                    updateClause.setWhere(this.exprParser.expr());
                }
                stmt.setUpdateClause(updateClause);
            } else if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                insertFlag = true;
            }
        }
        if (!insertFlag) {
            if (this.lexer.token() == Token.WHEN) {
                this.lexer.nextToken();
            }
            if (this.lexer.token() == Token.NOT) {
                this.lexer.nextToken();
                insertFlag = true;
            }
        }
        if (insertFlag) {
            OracleMergeStatement.MergeInsertClause insertClause = new OracleMergeStatement.MergeInsertClause();
            this.accept(Token.MATCHED);
            this.accept(Token.THEN);
            this.accept(Token.INSERT);
            if (this.lexer.token() == Token.LPAREN) {
                this.accept(Token.LPAREN);
                this.exprParser.exprList(insertClause.getColumns(), insertClause);
                this.accept(Token.RPAREN);
            }
            this.accept(Token.VALUES);
            this.accept(Token.LPAREN);
            this.exprParser.exprList(insertClause.getValues(), insertClause);
            this.accept(Token.RPAREN);
            if (this.lexer.token() == Token.WHERE) {
                this.lexer.nextToken();
                insertClause.setWhere(this.exprParser.expr());
            }
            stmt.setInsertClause(insertClause);
        }
        OracleErrorLoggingClause errorClause = this.parseErrorLoggingClause();
        stmt.setErrorLoggingClause(errorClause);
        return stmt;
    }

    @Override
    public OracleStatement parseInsert() {
        if (this.lexer.token() == Token.LPAREN) {
            OracleInsertStatement stmt = new OracleInsertStatement();
            this.parseInsert0(stmt, false);
            stmt.setReturning(this.parseReturningClause());
            stmt.setErrorLogging(this.parseErrorLoggingClause());
            return stmt;
        }
        this.accept(Token.INSERT);
        ArrayList<SQLHint> hints = new ArrayList<SQLHint>();
        this.parseHints(hints);
        if (this.lexer.token() == Token.INTO) {
            OracleInsertStatement stmt = new OracleInsertStatement();
            stmt.setHints(hints);
            this.parseInsert0(stmt);
            stmt.setReturning(this.parseReturningClause());
            stmt.setErrorLogging(this.parseErrorLoggingClause());
            return stmt;
        }
        OracleMultiInsertStatement stmt = this.parseMultiInsert();
        stmt.setHints(hints);
        return stmt;
    }

    public OracleMultiInsertStatement parseMultiInsert() {
        SQLObjectImpl clause;
        OracleMultiInsertStatement stmt = new OracleMultiInsertStatement();
        if (this.lexer.token() == Token.ALL) {
            this.lexer.nextToken();
            stmt.setOption(OracleMultiInsertStatement.Option.ALL);
        } else if (this.lexer.token() == Token.FIRST) {
            this.lexer.nextToken();
            stmt.setOption(OracleMultiInsertStatement.Option.FIRST);
        }
        while (this.lexer.token() == Token.INTO) {
            clause = new OracleMultiInsertStatement.InsertIntoClause();
            this.parseInsert0((SQLInsertInto)clause);
            ((OracleMultiInsertStatement.InsertIntoClause)clause).setReturning(this.parseReturningClause());
            ((OracleMultiInsertStatement.InsertIntoClause)clause).setErrorLogging(this.parseErrorLoggingClause());
            stmt.getEntries().add((OracleMultiInsertStatement.Entry)((Object)clause));
        }
        if (this.lexer.token() == Token.WHEN) {
            clause = new OracleMultiInsertStatement.ConditionalInsertClause();
            while (this.lexer.token() == Token.WHEN) {
                this.lexer.nextToken();
                OracleMultiInsertStatement.ConditionalInsertClauseItem item = new OracleMultiInsertStatement.ConditionalInsertClauseItem();
                item.setWhen(this.exprParser.expr());
                this.accept(Token.THEN);
                OracleMultiInsertStatement.InsertIntoClause insertInto = new OracleMultiInsertStatement.InsertIntoClause();
                this.parseInsert0(insertInto);
                item.setThen(insertInto);
                ((OracleMultiInsertStatement.ConditionalInsertClause)clause).getItems().add(item);
            }
            if (this.lexer.token() == Token.ELSE) {
                this.lexer.nextToken();
                OracleMultiInsertStatement.InsertIntoClause insertInto = new OracleMultiInsertStatement.InsertIntoClause();
                this.parseInsert0(insertInto, false);
                ((OracleMultiInsertStatement.ConditionalInsertClause)clause).setElseItem(insertInto);
            }
            stmt.getEntries().add((OracleMultiInsertStatement.Entry)((Object)clause));
        }
        OracleSelect subQuery = this.createSQLSelectParser().select();
        stmt.setSubQuery(subQuery);
        return stmt;
    }

    private OracleExceptionStatement parseException() {
        this.accept(Token.EXCEPTION);
        OracleExceptionStatement stmt = new OracleExceptionStatement();
        do {
            this.accept(Token.WHEN);
            OracleExceptionStatement.Item item = new OracleExceptionStatement.Item();
            item.setWhen(this.exprParser.expr());
            this.accept(Token.THEN);
            this.parseStatementList(item.getStatements());
            stmt.getItems().add(item);
        } while (this.lexer.token() == Token.WHEN);
        return stmt;
    }

    private OracleErrorLoggingClause parseErrorLoggingClause() {
        if (this.identifierEquals("LOG")) {
            OracleErrorLoggingClause errorClause = new OracleErrorLoggingClause();
            this.lexer.nextToken();
            this.accept(Token.ERRORS);
            if (this.lexer.token() == Token.INTO) {
                this.lexer.nextToken();
                errorClause.setInto(this.exprParser.name());
            }
            if (this.lexer.token() == Token.LPAREN) {
                this.lexer.nextToken();
                errorClause.setSimpleExpression(this.exprParser.expr());
                this.accept(Token.RPAREN);
            }
            if (this.lexer.token() == Token.REJECT) {
                this.lexer.nextToken();
                this.accept(Token.LIMIT);
                errorClause.setLimit(this.exprParser.expr());
            }
            return errorClause;
        }
        return null;
    }

    public OracleReturningClause parseReturningClause() {
        OracleReturningClause clause = null;
        if (this.lexer.token() == Token.RETURNING) {
            SQLExpr item;
            this.lexer.nextToken();
            clause = new OracleReturningClause();
            while (true) {
                item = this.exprParser.expr();
                clause.getItems().add(item);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.INTO);
            while (true) {
                item = this.exprParser.expr();
                clause.getValues().add(item);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
        }
        return clause;
    }

    @Override
    public OracleExplainStatement parseExplain() {
        this.accept(Token.EXPLAIN);
        this.acceptIdentifier("PLAN");
        OracleExplainStatement stmt = new OracleExplainStatement();
        if (this.lexer.token() == Token.SET) {
            this.lexer.nextToken();
            this.acceptIdentifier("STATEMENT_ID");
            this.accept(Token.EQ);
            stmt.setStatementId((SQLCharExpr)this.exprParser.primary());
        }
        if (this.lexer.token() == Token.INTO) {
            this.lexer.nextToken();
            stmt.setInto(this.exprParser.name());
        }
        this.accept(Token.FOR);
        stmt.setStatement(this.parseStatement());
        return stmt;
    }

    @Override
    public OracleDeleteStatement parseDeleteStatement() {
        OracleDeleteStatement deleteStatement = new OracleDeleteStatement();
        if (this.lexer.token() == Token.DELETE) {
            SQLName tableName;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.COMMENT) {
                this.lexer.nextToken();
            }
            this.parseHints(deleteStatement.getHints());
            if (this.lexer.token() == Token.FROM) {
                this.lexer.nextToken();
            }
            if (this.identifierEquals("ONLY")) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                tableName = this.exprParser.name();
                deleteStatement.setTableName(tableName);
                this.accept(Token.RPAREN);
            } else {
                tableName = this.exprParser.name();
                deleteStatement.setTableName(tableName);
            }
            deleteStatement.setAlias(this.as());
        }
        if (this.lexer.token() == Token.WHERE) {
            this.lexer.nextToken();
            deleteStatement.setWhere(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.RETURNING) {
            OracleReturningClause clause = this.parseReturningClause();
            deleteStatement.setReturning(clause);
        }
        if (this.identifierEquals("RETURN") || this.identifierEquals("RETURNING")) {
            throw new ParserException("TODO");
        }
        if (this.identifierEquals("LOG")) {
            throw new ParserException("TODO");
        }
        return deleteStatement;
    }

    @Override
    public SQLStatement parseCreateDbLink() {
        this.accept(Token.CREATE);
        OracleCreateDatabaseDbLinkStatement dbLink = new OracleCreateDatabaseDbLinkStatement();
        if (this.identifierEquals("SHARED")) {
            dbLink.setShared(true);
            this.lexer.nextToken();
        }
        if (this.identifierEquals("PUBLIC")) {
            dbLink.setPublic(true);
            this.lexer.nextToken();
        }
        this.accept(Token.DATABASE);
        this.acceptIdentifier("LINK");
        dbLink.setName(this.exprParser.name());
        if (this.lexer.token() == Token.CONNECT) {
            this.lexer.nextToken();
            this.accept(Token.TO);
            dbLink.setUser(this.exprParser.name());
            if (this.lexer.token() == Token.IDENTIFIED) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                dbLink.setPassword(this.lexer.stringVal());
                this.accept(Token.IDENTIFIER);
            }
        }
        if (this.identifierEquals("AUTHENTICATED")) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            dbLink.setAuthenticatedUser(this.exprParser.name());
            this.accept(Token.IDENTIFIED);
            this.accept(Token.BY);
            dbLink.setPassword(this.lexer.stringVal());
            this.accept(Token.IDENTIFIER);
        }
        if (this.lexer.token() == Token.USING) {
            this.lexer.nextToken();
            dbLink.setUsing(this.exprParser.expr());
        }
        return dbLink;
    }

    @Override
    public OracleCreateIndexStatement parseCreateIndex(boolean acceptCreate) {
        if (acceptCreate) {
            this.accept(Token.CREATE);
        }
        OracleCreateIndexStatement stmt = new OracleCreateIndexStatement();
        if (this.lexer.token() == Token.UNIQUE) {
            stmt.setType("UNIQUE");
            this.lexer.nextToken();
        } else if (this.identifierEquals("BITMAP")) {
            stmt.setType("BITMAP");
            this.lexer.nextToken();
        }
        this.accept(Token.INDEX);
        stmt.setName(this.exprParser.name());
        this.accept(Token.ON);
        stmt.setTable(this.exprParser.name());
        this.accept(Token.LPAREN);
        while (true) {
            SQLSelectOrderByItem item = this.exprParser.parseSelectOrderByItem();
            stmt.getItems().add(item);
            if (this.lexer.token() != Token.COMMA) break;
            this.lexer.nextToken();
        }
        this.accept(Token.RPAREN);
        while (true) {
            if (this.lexer.token() == Token.TABLESPACE) {
                this.lexer.nextToken();
                stmt.setTablespace(this.exprParser.name());
                continue;
            }
            if (this.lexer.token() == Token.PCTFREE) {
                this.lexer.nextToken();
                stmt.setPtcfree(this.exprParser.expr());
                continue;
            }
            if (this.lexer.token() == Token.INITRANS) {
                this.lexer.nextToken();
                stmt.setInitrans(this.exprParser.expr());
                continue;
            }
            if (this.lexer.token() == Token.MAXTRANS) {
                this.lexer.nextToken();
                stmt.setMaxtrans(this.exprParser.expr());
                continue;
            }
            if (this.lexer.token() == Token.COMPUTE) {
                this.lexer.nextToken();
                this.acceptIdentifier("STATISTICS");
                stmt.setComputeStatistics(true);
                continue;
            }
            if (this.lexer.token() == Token.ENABLE) {
                this.lexer.nextToken();
                stmt.setEnable(true);
                continue;
            }
            if (this.lexer.token() == Token.DISABLE) {
                this.lexer.nextToken();
                stmt.setEnable(false);
                continue;
            }
            if (this.identifierEquals("ONLINE")) {
                this.lexer.nextToken();
                stmt.setOnline(true);
                continue;
            }
            if (this.identifierEquals("NOPARALLEL")) {
                this.lexer.nextToken();
                stmt.setNoParallel(true);
                continue;
            }
            if (this.identifierEquals("PARALLEL")) {
                this.lexer.nextToken();
                stmt.setParallel(this.exprParser.expr());
                continue;
            }
            if (this.lexer.token() != Token.INDEX) break;
            this.lexer.nextToken();
            this.acceptIdentifier("ONLY");
            this.acceptIdentifier("TOPLEVEL");
            stmt.setIndexOnlyTopLevel(true);
        }
        return stmt;
    }

    @Override
    public OracleCreateSequenceStatement parseCreateSequence(boolean acceptCreate) {
        if (acceptCreate) {
            this.accept(Token.CREATE);
        }
        this.accept(Token.SEQUENCE);
        OracleCreateSequenceStatement stmt = new OracleCreateSequenceStatement();
        stmt.setName(this.exprParser.name());
        while (true) {
            if (this.lexer.token() == Token.START) {
                this.lexer.nextToken();
                this.accept(Token.WITH);
                stmt.setStartWith(this.exprParser.expr());
                continue;
            }
            if (this.identifierEquals("INCREMENT")) {
                this.lexer.nextToken();
                this.accept(Token.BY);
                stmt.setIncrementBy(this.exprParser.expr());
                continue;
            }
            if (this.lexer.token() == Token.CACHE) {
                this.lexer.nextToken();
                stmt.setCache(Boolean.TRUE);
                continue;
            }
            if (this.lexer.token() == Token.NOCACHE) {
                this.lexer.nextToken();
                stmt.setCache(Boolean.FALSE);
                continue;
            }
            if (this.identifierEquals("CYCLE")) {
                this.lexer.nextToken();
                stmt.setCycle(Boolean.TRUE);
                continue;
            }
            if (this.identifierEquals("NOCYCLE")) {
                this.lexer.nextToken();
                stmt.setCycle(Boolean.FALSE);
                continue;
            }
            if (this.identifierEquals("MINVALUE")) {
                this.lexer.nextToken();
                stmt.setMinValue(this.exprParser.expr());
                continue;
            }
            if (this.identifierEquals("MAXVALUE")) {
                this.lexer.nextToken();
                stmt.setMaxValue(this.exprParser.expr());
                continue;
            }
            if (this.identifierEquals("NOMAXVALUE")) {
                this.lexer.nextToken();
                stmt.setNoMaxValue(true);
                continue;
            }
            if (!this.identifierEquals("NOMINVALUE")) break;
            this.lexer.nextToken();
            stmt.setNoMinValue(true);
        }
        return stmt;
    }

    @Override
    public OracleCreateProcedureStatement parseCreateProcedure() {
        OracleCreateProcedureStatement stmt = new OracleCreateProcedureStatement();
        this.accept(Token.CREATE);
        if (this.lexer.token() == Token.OR) {
            this.lexer.nextToken();
            this.accept(Token.REPLACE);
            stmt.setOrReplace(true);
        }
        this.accept(Token.PROCEDURE);
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            this.parserParameters(stmt.getParameters());
            this.accept(Token.RPAREN);
        }
        this.accept(Token.AS);
        OracleBlockStatement block = this.parseBlock();
        stmt.setBlock(block);
        return stmt;
    }

    @Override
    public SQLUpdateStatement parseUpdateStatement() {
        return new OracleUpdateParser(this.lexer).parseUpdateStatement();
    }
}

