/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.asyncquery.model;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import lombok.Generated;
import org.opensearch.sql.datasource.model.DataSourceMetadata;
import org.opensearch.sql.datasource.model.DataSourceType;
import org.opensearch.sql.datasources.auth.AuthenticationType;

public class SparkSubmitParameters {
    public static final String SPACE = " ";
    public static final String EQUALS = "=";
    private final String className;
    private final Map<String, String> config;
    private String extraParameters;

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" --class ");
        stringBuilder.append(this.className);
        stringBuilder.append(SPACE);
        for (String key : this.config.keySet()) {
            stringBuilder.append(" --conf ");
            stringBuilder.append(key);
            stringBuilder.append(EQUALS);
            stringBuilder.append(this.config.get(key));
            stringBuilder.append(SPACE);
        }
        if (this.extraParameters != null) {
            stringBuilder.append(this.extraParameters);
        }
        return stringBuilder.toString();
    }

    @Generated
    public SparkSubmitParameters(String className, Map<String, String> config, String extraParameters) {
        this.className = className;
        this.config = config;
        this.extraParameters = extraParameters;
    }

    @Generated
    public SparkSubmitParameters(String className, Map<String, String> config) {
        this.className = className;
        this.config = config;
    }

    public static class Builder {
        private final String className;
        private final Map<String, String> config = new LinkedHashMap<String, String>();
        private String extraParameters;

        private Builder() {
            this.className = "org.apache.spark.sql.FlintJob";
            this.config.put("spark.hadoop.fs.s3.customAWSCredentialsProvider", "com.amazonaws.emr.AssumeRoleAWSCredentialsProvider");
            this.config.put("spark.hadoop.aws.catalog.credentials.provider.factory.class", "com.amazonaws.glue.catalog.metastore.STSAssumeRoleSessionCredentialsProviderFactory");
            this.config.put("spark.jars.packages", "org.opensearch:opensearch-spark-standalone_2.12:0.1.0-SNAPSHOT,org.opensearch:opensearch-spark-sql-application_2.12:0.1.0-SNAPSHOT,org.opensearch:opensearch-spark-ppl_2.12:0.1.0-SNAPSHOT");
            this.config.put("spark.jars.repositories", "https://aws.oss.sonatype.org/content/repositories/snapshots");
            this.config.put("spark.emr-serverless.driverEnv.JAVA_HOME", "/usr/lib/jvm/java-17-amazon-corretto.x86_64/");
            this.config.put("spark.executorEnv.JAVA_HOME", "/usr/lib/jvm/java-17-amazon-corretto.x86_64/");
            this.config.put("spark.datasource.flint.host", "localhost");
            this.config.put("spark.datasource.flint.port", "9200");
            this.config.put("spark.datasource.flint.scheme", "http");
            this.config.put("spark.datasource.flint.auth", "noauth");
            this.config.put("spark.datasource.flint.customAWSCredentialsProvider", "com.amazonaws.emr.AssumeRoleAWSCredentialsProvider");
            this.config.put("spark.sql.extensions", "org.opensearch.flint.spark.FlintSparkExtensions,org.opensearch.flint.spark.FlintPPLSparkExtensions");
            this.config.put("spark.hadoop.hive.metastore.client.factory.class", "com.amazonaws.glue.catalog.metastore.AWSGlueDataCatalogHiveClientFactory");
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder dataSource(DataSourceMetadata metadata) {
            if (DataSourceType.S3GLUE.equals((Object)metadata.getConnector())) {
                String roleArn = (String)metadata.getProperties().get("glue.auth.role_arn");
                this.config.put("spark.emr-serverless.driverEnv.ASSUME_ROLE_CREDENTIALS_ROLE_ARN", roleArn);
                this.config.put("spark.executorEnv.ASSUME_ROLE_CREDENTIALS_ROLE_ARN", roleArn);
                this.config.put("spark.hive.metastore.glue.role.arn", roleArn);
                this.config.put("spark.sql.catalog." + metadata.getName(), "org.opensearch.sql.FlintDelegatingSessionCatalog");
                this.config.put("spark.flint.datasource.name", metadata.getName());
                this.setFlintIndexStoreHost(this.parseUri((String)metadata.getProperties().get("glue.indexstore.opensearch.uri"), metadata.getName()));
                this.setFlintIndexStoreAuthProperties((String)metadata.getProperties().get("glue.indexstore.opensearch.auth"), () -> (String)metadata.getProperties().get("glue.indexstore.opensearch.auth.username"), () -> (String)metadata.getProperties().get("glue.indexstore.opensearch.auth.password"), () -> (String)metadata.getProperties().get("glue.indexstore.opensearch.region"));
                this.config.put("spark.flint.datasource.name", metadata.getName());
                return this;
            }
            throw new UnsupportedOperationException(String.format("UnSupported datasource type for async queries:: %s", metadata.getConnector()));
        }

        private void setFlintIndexStoreHost(URI uri) {
            this.config.put("spark.datasource.flint.host", uri.getHost());
            this.config.put("spark.datasource.flint.port", String.valueOf(uri.getPort()));
            this.config.put("spark.datasource.flint.scheme", uri.getScheme());
        }

        private void setFlintIndexStoreAuthProperties(String authType, Supplier<String> userName, Supplier<String> password, Supplier<String> region) {
            if (AuthenticationType.get((String)authType).equals((Object)AuthenticationType.BASICAUTH)) {
                this.config.put("spark.datasource.flint.auth", authType);
                this.config.put("spark.datasource.flint.auth.username", userName.get());
                this.config.put("spark.datasource.flint.auth.password", password.get());
            } else if (AuthenticationType.get((String)authType).equals((Object)AuthenticationType.AWSSIGV4AUTH)) {
                this.config.put("spark.datasource.flint.auth", "sigv4");
                this.config.put("spark.datasource.flint.region", region.get());
            } else {
                this.config.put("spark.datasource.flint.auth", authType);
            }
        }

        private URI parseUri(String opensearchUri, String datasourceName) {
            try {
                return new URI(opensearchUri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(String.format("Bad URI in indexstore configuration of the : %s datasoure.", datasourceName));
            }
        }

        public Builder structuredStreaming(Boolean isStructuredStreaming) {
            if (isStructuredStreaming.booleanValue()) {
                this.config.put("spark.flint.job.type", "streaming");
            }
            return this;
        }

        public Builder extraParameters(String params) {
            this.extraParameters = params;
            return this;
        }

        public SparkSubmitParameters build() {
            return new SparkSubmitParameters(this.className, this.config, this.extraParameters);
        }
    }
}

