/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.util.BaseUtilities;
import org.openide.util.WeakSet;

final class FieldLNCache {
    private final Set<FileObject> knownFiles = Collections.synchronizedSet(new WeakSet());
    private final Set<FileKey> knownFileRefs = Collections.synchronizedSet(new HashSet());
    private final Map<FieldKey, Integer> fieldLines = new LinkedHashMap<FieldKey, Integer>();

    FieldLNCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putLine(String url, String className, String fieldName, FileObject fo, int lineNumber) {
        if (!this.knownFiles.contains(fo)) {
            fo.addFileChangeListener((FileChangeListener)new FileChangeListenerImpl(url));
            this.knownFileRefs.add(new FileKey(fo, url));
        }
        Map<FieldKey, Integer> map = this.fieldLines;
        synchronized (map) {
            this.fieldLines.put(new FieldKey(url, className, fieldName), lineNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Integer getLine(String url, String className, String fieldName) {
        Map<FieldKey, Integer> map = this.fieldLines;
        synchronized (map) {
            return this.fieldLines.get(new FieldKey(url, className, fieldName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFieldLines(String url) {
        Map<FieldKey, Integer> map = this.fieldLines;
        synchronized (map) {
            Iterator<FieldKey> fieldIt = this.fieldLines.keySet().iterator();
            while (fieldIt.hasNext()) {
                FieldKey field = fieldIt.next();
                if (!field.url.equals(url)) continue;
                fieldIt.remove();
            }
        }
    }

    private class FileChangeListenerImpl
    implements FileChangeListener {
        private final String url;

        FileChangeListenerImpl(String url) {
            this.url = url;
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
            FieldLNCache.this.removeFieldLines(this.url);
        }

        public void fileDeleted(FileEvent fe) {
            FieldLNCache.this.removeFieldLines(this.url);
            FieldLNCache.this.knownFiles.remove(fe.getFile());
        }

        public void fileRenamed(FileRenameEvent fe) {
            FieldLNCache.this.removeFieldLines(this.url);
            FieldLNCache.this.knownFiles.remove(fe.getFile());
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }

    private class FileKey
    extends WeakReference<FileObject>
    implements Runnable {
        private final String url;

        FileKey(FileObject fo, String url) {
            super(fo, BaseUtilities.activeReferenceQueue());
            this.url = url;
        }

        @Override
        public void run() {
            FieldLNCache.this.removeFieldLines(this.url);
            FieldLNCache.this.knownFileRefs.remove(this);
        }
    }

    private static class FieldKey {
        private final String url;
        private final String className;
        private final String fieldName;
        private final int hash;

        public FieldKey(String url, String className, String fieldName) {
            this.url = url;
            this.className = className;
            this.fieldName = fieldName;
            this.hash = Objects.hash(url, className, fieldName);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldKey other = (FieldKey)obj;
            if (!Objects.equals(this.url, other.url)) {
                return false;
            }
            if (!Objects.equals(this.className, other.className)) {
                return false;
            }
            return Objects.equals(this.fieldName, other.fieldName);
        }
    }
}

