/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ddloaders.multiview.ejb;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.sun.ddloaders.Utils;

public class EjbMetadataReader
implements MetadataModelAction<EjbJarMetadata, Map<String, Object>> {
    public static Map<String, Object> readDescriptor(EjbJar ejbJar) {
        return EjbMetadataReader.genProperties(ejbJar);
    }

    public Map<String, Object> run(EjbJarMetadata metadata) throws Exception {
        return EjbMetadataReader.genProperties(metadata.getRoot());
    }

    private static Map<String, Object> genProperties(EjbJar ejbJar) {
        EnterpriseBeans eb;
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (ejbJar != null && (eb = ejbJar.getEnterpriseBeans()) != null) {
            Entity[] entityBeans;
            MessageDriven[] messageBeans;
            Session[] sessionBeans = eb.getSession();
            if (sessionBeans != null) {
                for (Session session : sessionBeans) {
                    String ejbName = session.getEjbName();
                    if (!Utils.notEmpty(ejbName)) continue;
                    HashMap<String, String> sessionMap = new HashMap<String, String>();
                    data.put(ejbName, sessionMap);
                    sessionMap.put("Name", ejbName);
                    String sessionType = session.getSessionType();
                    if (sessionType == null || sessionType.length() <= 0) continue;
                    sessionMap.put("SessionType", sessionType);
                }
            }
            if ((messageBeans = eb.getMessageDriven()) != null) {
                for (MessageDriven message : messageBeans) {
                    String ejbName = message.getEjbName();
                    if (!Utils.notEmpty(ejbName)) continue;
                    HashMap<String, String> messageMap = new HashMap<String, String>();
                    data.put(ejbName, messageMap);
                    messageMap.put("Name", ejbName);
                }
            }
            if ((entityBeans = eb.getEntity()) != null) {
                for (Entity entity : entityBeans) {
                    String ejbName = entity.getEjbName();
                    if (!Utils.notEmpty(ejbName)) continue;
                    HashMap<String, String> entityMap = new HashMap<String, String>();
                    data.put(ejbName, entityMap);
                    entityMap.put("Name", ejbName);
                    String persistenceType = entity.getPersistenceType();
                    if (persistenceType == null || persistenceType.length() <= 0) continue;
                    entityMap.put("PersistenceType", persistenceType);
                }
            }
        }
        return data.size() > 0 ? data : null;
    }
}

