/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.navigation;

import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.jakarta.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.jakarta.web.beans.navigation.BindingsPanel;
import org.netbeans.modules.jakarta.web.beans.navigation.JavaHierarchyModel;
import org.netbeans.modules.jakarta.web.beans.navigation.ObserversPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class DecoratorsPanel
extends BindingsPanel {
    private static final long serialVersionUID = -5097678699872215262L;
    private static final String DELEGATE = "jakarta.decorator.Delegate";

    public DecoratorsPanel(Object[] subject, MetadataModel<WebBeansModel> metaModel, WebBeansModel model, JavaHierarchyModel treeModel) {
        super(subject, metaModel, model, treeModel);
        this.setVisibleScope(true);
        this.initUI();
    }

    @Override
    protected void setScope(WebBeansModel model, Element element) {
        TypeElement clazz = (TypeElement)element;
        List<VariableElement> fields = ElementFilter.fieldsIn(model.getCompilationController().getElements().getAllMembers(clazz));
        VariableElement delegate = null;
        for (VariableElement field : fields) {
            if (!this.hasDelegate(field, model.getCompilationController())) continue;
            delegate = field;
            break;
        }
        TypeMirror delegateType = delegate.asType();
        StringBuilder shortName = new StringBuilder();
        StringBuilder fqnName = new StringBuilder();
        DecoratorsPanel.fillElementType(delegateType, shortName, fqnName, model.getCompilationController());
        JEditorPane scopeComponent = this.getScopeComponent();
        if (this.showFqns()) {
            scopeComponent.setText(fqnName.toString());
        } else {
            scopeComponent.setText(shortName.toString());
        }
    }

    private boolean hasDelegate(Element element, CompilationController controller) {
        List<? extends AnnotationMirror> allAnnotationMirrors = controller.getElements().getAllAnnotationMirrors(element);
        TypeElement delegate = controller.getElements().getTypeElement(DELEGATE);
        if (delegate == null) {
            return false;
        }
        for (AnnotationMirror annotationMirror : allAnnotationMirrors) {
            Element annotation = controller.getTypes().asElement(annotationMirror.getAnnotationType());
            if (annotation == null || !annotation.equals(delegate)) continue;
            return true;
        }
        return false;
    }

    private void initUI() {
        JLabel elementLabel = this.getSubjectElementLabel();
        Mnemonics.setLocalizedText((JLabel)elementLabel, (String)NbBundle.getMessage(ObserversPanel.class, (String)"LBL_DecoratedElement"));
        elementLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ObserversPanel.class, (String)"ACSN_DecoratedElement"));
        elementLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ObserversPanel.class, (String)"ACSD_DecoratedElement"));
        JLabel qualifiers = this.getSubjectBindingsLabel();
        Mnemonics.setLocalizedText((JLabel)qualifiers, (String)NbBundle.getMessage(ObserversPanel.class, (String)"LBL_DecoratorQualifiers"));
        qualifiers.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ObserversPanel.class, (String)"ACSN_DecoratorQualifiers"));
        qualifiers.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ObserversPanel.class, (String)"ACSD_DecoratorQualifiers"));
        JLabel selectedQualifiers = this.getSelectedBindingsLabel();
        Mnemonics.setLocalizedText((JLabel)selectedQualifiers, (String)NbBundle.getMessage(ObserversPanel.class, (String)"LBL_SelectedDecoratorQualifiers"));
        selectedQualifiers.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ObserversPanel.class, (String)"ACSN_SelectedDecoratorQualifiers"));
        selectedQualifiers.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ObserversPanel.class, (String)"ACSD_SelectedDecoratorQualifiers"));
        JLabel scopeLabel = this.getScopeLabel();
        Mnemonics.setLocalizedText((JLabel)scopeLabel, (String)NbBundle.getMessage(ObserversPanel.class, (String)"LBL_SelectedDelegateType"));
        scopeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ObserversPanel.class, (String)"ACSN_SelectedDelegateType"));
        scopeLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ObserversPanel.class, (String)"ACSD_SelectedDelegateType"));
    }
}

