/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Operators;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.jvm.PoolConstant;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeTranslator;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.Iterator;

public final class TransLiterals
extends TreeTranslator {
    protected static final Context.Key<TransLiterals> transLiteralsKey = new Context.Key();
    private final Symtab syms;
    private final Resolve rs;
    private final Types types;
    private final Operators operators;
    private final Names names;
    private TreeMaker make = null;
    private Env<AttrContext> env = null;
    private Symbol.ClassSymbol currentClass = null;
    private Symbol.MethodSymbol currentMethodSym = null;

    public static TransLiterals instance(Context context) {
        TransLiterals instance = context.get(transLiteralsKey);
        if (instance == null) {
            instance = new TransLiterals(context);
        }
        return instance;
    }

    protected TransLiterals(Context context) {
        context.put(transLiteralsKey, this);
        this.syms = Symtab.instance(context);
        this.rs = Resolve.instance(context);
        this.make = TreeMaker.instance(context);
        this.types = Types.instance(context);
        this.operators = Operators.instance(context);
        this.names = Names.instance(context);
    }

    JCTree.JCExpression makeLit(Type type, Object value) {
        return this.make.Literal(type.getTag(), value).setType(type.constType(value));
    }

    JCTree.JCExpression makeString(String string) {
        return this.makeLit(this.syms.stringType, string);
    }

    List<JCTree.JCExpression> makeStringList(List<String> strings) {
        List<JCTree.JCExpression> exprs = List.nil();
        for (String string : strings) {
            exprs = exprs.append(this.makeString(string));
        }
        return exprs;
    }

    JCTree.JCBinary makeBinary(JCTree.Tag optag, JCTree.JCExpression lhs, JCTree.JCExpression rhs) {
        JCTree.JCBinary tree = this.make.Binary(optag, lhs, rhs);
        tree.operator = this.operators.resolveBinary(tree, optag, lhs.type, rhs.type);
        tree.type = tree.operator.type.getReturnType();
        return tree;
    }

    Symbol.MethodSymbol lookupMethod(JCDiagnostic.DiagnosticPosition pos, Name name, Type qual, List<Type> args) {
        return this.rs.resolveInternalMethod(pos, this.env, qual, name, args, List.nil());
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        Symbol.ClassSymbol prevCurrentClass = this.currentClass;
        try {
            this.currentClass = tree.sym;
            super.visitClassDef(tree);
        }
        finally {
            this.currentClass = prevCurrentClass;
        }
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        Symbol.MethodSymbol prevMethodSym = this.currentMethodSym;
        try {
            this.currentMethodSym = tree.sym;
            super.visitMethodDef(tree);
        }
        finally {
            this.currentMethodSym = prevMethodSym;
        }
    }

    @Override
    public void visitStringTemplate(JCTree.JCStringTemplate tree) {
        int prevPos = this.make.pos;
        try {
            tree.processor = this.translate(tree.processor);
            tree.expressions = this.translate(tree.expressions);
            TransStringTemplate transStringTemplate = new TransStringTemplate(tree);
            this.result = transStringTemplate.visit();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw ex;
        }
        finally {
            this.make.at(prevPos);
        }
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        Symbol.MethodSymbol prevMethodSym = this.currentMethodSym;
        try {
            tree.mods = this.translate(tree.mods);
            tree.vartype = this.translate(tree.vartype);
            if (this.currentMethodSym == null) {
                this.currentMethodSym = new Symbol.MethodSymbol(tree.mods.flags & 8L | 0x100000L, this.names.empty, null, this.currentClass);
            }
            if (tree.init != null) {
                tree.init = this.translate(tree.init);
            }
            this.result = tree;
        }
        finally {
            this.currentMethodSym = prevMethodSym;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCTree translateTopLevelClass(Env<AttrContext> env, JCTree cdef, TreeMaker make) {
        try {
            this.make = make;
            this.env = env;
            this.translate(cdef);
        }
        finally {
            this.make = null;
            this.env = null;
        }
        return cdef;
    }

    final class TransStringTemplate {
        final JCTree.JCStringTemplate tree;
        final JCTree.JCExpression processor;
        final List<String> fragments;
        final List<JCTree.JCExpression> expressions;
        final List<Type> expressionTypes;
        final boolean useValuesList;

        TransStringTemplate(JCTree.JCStringTemplate tree) {
            this.tree = tree;
            this.processor = tree.processor;
            this.fragments = tree.fragments;
            this.expressions = TransLiterals.this.translate(tree.expressions);
            this.expressionTypes = this.expressions.stream().map(arg -> arg.type == ((TransLiterals)TransLiterals.this).syms.botType ? ((TransLiterals)TransLiterals.this).syms.objectType : arg.type).collect(List.collector());
            int slots = this.expressionTypes.stream().mapToInt(t -> TransLiterals.this.types.isSameType((Type)t, ((TransLiterals)TransLiterals.this).syms.longType) || TransLiterals.this.types.isSameType((Type)t, ((TransLiterals)TransLiterals.this).syms.doubleType) ? 2 : 1).sum();
            this.useValuesList = 200 < slots;
        }

        JCTree.JCExpression concatExpression(List<String> fragments, List<JCTree.JCExpression> expressions) {
            JCTree.JCExpression expr = null;
            Iterator<JCTree.JCExpression> iterator = expressions.iterator();
            for (String fragment : fragments) {
                JCTree.JCExpression jCExpression = expr = expr == null ? TransLiterals.this.makeString(fragment) : TransLiterals.this.makeBinary(JCTree.Tag.PLUS, expr, TransLiterals.this.makeString(fragment));
                if (!iterator.hasNext()) continue;
                JCTree.JCExpression expression = iterator.next();
                Type expressionType = expression.type;
                expr = TransLiterals.this.makeBinary(JCTree.Tag.PLUS, expr, expression.setType(expressionType));
            }
            return expr;
        }

        JCTree.JCExpression bsmCall(Name name, Name bootstrapName, Type type, List<JCTree.JCExpression> args, List<Type> argTypes, List<PoolConstant.LoadableConstant> staticArgValues, List<Type> staticArgsTypes) {
            Symbol bsm = TransLiterals.this.rs.resolveQualifiedMethod(this.tree.pos(), TransLiterals.this.env, ((TransLiterals)TransLiterals.this).syms.templateRuntimeType, bootstrapName, staticArgsTypes, List.nil());
            Type.MethodType indyType = new Type.MethodType(argTypes, type, List.nil(), ((TransLiterals)TransLiterals.this).syms.methodClass);
            Symbol.DynamicMethodSymbol dynSym = new Symbol.DynamicMethodSymbol(name, ((TransLiterals)TransLiterals.this).syms.noSymbol, ((Symbol.MethodSymbol)bsm).asHandle(), (Type)indyType, staticArgValues.toArray(new PoolConstant.LoadableConstant[0]));
            JCTree.JCFieldAccess qualifier = TransLiterals.this.make.Select(TransLiterals.this.make.Type(((TransLiterals)TransLiterals.this).syms.processorType), dynSym.name);
            qualifier.sym = dynSym;
            qualifier.type = type;
            JCTree.JCMethodInvocation apply = TransLiterals.this.make.Apply(List.nil(), qualifier, args);
            apply.type = type;
            return apply;
        }

        JCTree.JCExpression processCall(JCTree.JCExpression stringTemplate) {
            Symbol.MethodSymbol appyMeth = TransLiterals.this.lookupMethod(this.tree.pos(), ((TransLiterals)TransLiterals.this).names.process, ((TransLiterals)TransLiterals.this).syms.processorType, List.of(((TransLiterals)TransLiterals.this).syms.stringTemplateType));
            JCTree.JCFieldAccess applySelect = TransLiterals.this.make.Select(this.processor, appyMeth);
            JCTree.JCMethodInvocation process = TransLiterals.this.make.Apply(null, applySelect, List.of(stringTemplate)).setType(((TransLiterals)TransLiterals.this).syms.objectType);
            JCTree.JCTypeCast cast = TransLiterals.this.make.TypeCast(this.tree.type, (JCTree.JCExpression)process);
            return cast;
        }

        JCTree.JCExpression newStringTemplate() {
            List<PoolConstant.LoadableConstant> staticArgValues = List.nil();
            List<Type> staticArgsTypes = List.of(((TransLiterals)TransLiterals.this).syms.methodHandleLookupType, ((TransLiterals)TransLiterals.this).syms.stringType, ((TransLiterals)TransLiterals.this).syms.methodTypeType);
            if (this.useValuesList) {
                JCTree.JCNewArray fragmentArray = TransLiterals.this.make.NewArray(TransLiterals.this.make.Type(((TransLiterals)TransLiterals.this).syms.stringType), List.nil(), TransLiterals.this.makeStringList(this.fragments));
                fragmentArray.type = new Type.ArrayType(((TransLiterals)TransLiterals.this).syms.stringType, ((TransLiterals)TransLiterals.this).syms.arrayClass);
                JCTree.JCNewArray valuesArray = TransLiterals.this.make.NewArray(TransLiterals.this.make.Type(((TransLiterals)TransLiterals.this).syms.objectType), List.nil(), this.expressions);
                valuesArray.type = new Type.ArrayType(((TransLiterals)TransLiterals.this).syms.objectType, ((TransLiterals)TransLiterals.this).syms.arrayClass);
                return this.bsmCall(((TransLiterals)TransLiterals.this).names.process, ((TransLiterals)TransLiterals.this).names.newLargeStringTemplate, ((TransLiterals)TransLiterals.this).syms.stringTemplateType, List.of(fragmentArray, valuesArray), List.of(fragmentArray.type, valuesArray.type), staticArgValues, staticArgsTypes);
            }
            for (String fragment : this.fragments) {
                staticArgValues = staticArgValues.append(PoolConstant.LoadableConstant.String(fragment));
                staticArgsTypes = staticArgsTypes.append(((TransLiterals)TransLiterals.this).syms.stringType);
            }
            return this.bsmCall(((TransLiterals)TransLiterals.this).names.process, ((TransLiterals)TransLiterals.this).names.newStringTemplate, ((TransLiterals)TransLiterals.this).syms.stringTemplateType, this.expressions, this.expressionTypes, staticArgValues, staticArgsTypes);
        }

        JCTree.JCExpression bsmProcessCall() {
            List<JCTree.JCExpression> args = this.expressions.prepend(this.processor);
            List<Type> argTypes = this.expressionTypes.prepend(this.processor.type);
            Symbol.VarSymbol processorSym = (Symbol.VarSymbol)TreeInfo.symbol(this.processor);
            List<PoolConstant.LoadableConstant> staticArgValues = List.of(processorSym.asMethodHandle(true));
            List<Type> staticArgsTypes = List.of(((TransLiterals)TransLiterals.this).syms.methodHandleLookupType, ((TransLiterals)TransLiterals.this).syms.stringType, ((TransLiterals)TransLiterals.this).syms.methodTypeType, new Type[]{((TransLiterals)TransLiterals.this).syms.methodHandleType});
            for (String fragment : this.fragments) {
                staticArgValues = staticArgValues.append((Symbol.MethodHandleSymbol)PoolConstant.LoadableConstant.String(fragment));
                staticArgsTypes = staticArgsTypes.append(((TransLiterals)TransLiterals.this).syms.stringType);
            }
            return this.bsmCall(((TransLiterals)TransLiterals.this).names.process, ((TransLiterals)TransLiterals.this).names.processStringTemplate, this.tree.type, args, argTypes, staticArgValues, staticArgsTypes);
        }

        boolean isNamedProcessor(Name name) {
            Object object = this.processor;
            if (object instanceof JCTree.JCIdent) {
                Symbol.VarSymbol varSym;
                JCTree.JCIdent ident = (JCTree.JCIdent)object;
                object = ident.sym;
                if (object instanceof Symbol.VarSymbol && (varSym = (Symbol.VarSymbol)object).flags() == 25L && varSym.name == name && TransLiterals.this.types.isSameType(varSym.owner.type, ((TransLiterals)TransLiterals.this).syms.stringTemplateType)) {
                    return true;
                }
            }
            return false;
        }

        boolean isLinkageProcessor() {
            Symbol.VarSymbol varSymbol;
            Symbol symbol;
            return this.processor != null && !this.useValuesList && TransLiterals.this.types.isSubtype(this.processor.type, ((TransLiterals)TransLiterals.this).syms.linkageType) && this.processor.type.isFinal() && (symbol = TreeInfo.symbol(this.processor)) instanceof Symbol.VarSymbol && (varSymbol = (Symbol.VarSymbol)symbol).isStatic() && varSymbol.isFinal();
        }

        JCTree.JCExpression visit() {
            TransLiterals.this.make.at(this.tree.pos);
            JCTree.JCExpression result = this.processor == null || this.isNamedProcessor(((TransLiterals)TransLiterals.this).names.RAW) ? this.newStringTemplate() : (this.isNamedProcessor(((TransLiterals)TransLiterals.this).names.STR) ? this.concatExpression(this.fragments, this.expressions) : (this.isLinkageProcessor() ? this.bsmProcessCall() : this.processCall(this.newStringTemplate())));
            return result;
        }
    }
}

