/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.messages;

import java.util.SortedSet;
import nu.validator.messages.XmlSaxEmitter;
import nu.validator.source.SourceHandler;
import nu.validator.xml.AttributesImpl;
import nu.validator.xml.CharacterUtil;
import org.xml.sax.SAXException;

public class XmlSourceHandler
implements SourceHandler {
    private final AttributesImpl attrs = new AttributesImpl();
    private static final char[] NEWLINE = new char[]{'\n'};
    private final XmlSaxEmitter emitter;

    public XmlSourceHandler(XmlSaxEmitter emitter) {
        this.emitter = emitter;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.emitter.characters(ch, start, length);
    }

    @Override
    public void endCharHilite() throws SAXException {
    }

    @Override
    public void endRange() throws SAXException {
    }

    @Override
    public void endSource() throws SAXException {
        this.emitter.endElement("source");
    }

    @Override
    public void newLine() throws SAXException {
        this.emitter.characters(NEWLINE);
    }

    @Override
    public void startCharHilite(int oneBasedLine, int oneBasedColumn) throws SAXException {
    }

    @Override
    public void startRange(int oneBasedLine, int oneBasedColumn) throws SAXException {
    }

    @Override
    public void startSource(String type, String encoding) throws SAXException {
        this.attrs.clear();
        if (type != null) {
            this.attrs.addAttribute("type", CharacterUtil.prudentlyScrubCharacterData(type));
        }
        if (encoding != null) {
            this.attrs.addAttribute("encoding", CharacterUtil.prudentlyScrubCharacterData(encoding));
        }
        this.emitter.startElement("source", this.attrs);
    }

    @Override
    public void setLineErrors(SortedSet<Integer> oneBasedLineErrors) throws SAXException {
    }
}

