/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.spi.jaxws.client;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.websvc.api.jaxws.project.CatalogUtils;
import org.netbeans.modules.websvc.api.jaxws.project.JAXWSVersionProvider;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.ClientAlreadyExistsExeption;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.WsimportOption;
import org.netbeans.modules.websvc.api.jaxws.project.config.WsimportOptions;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelerFactory;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.spi.jaxws.client.JAXWSClientSupportImpl;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public abstract class ProjectJAXWSClientSupport
implements JAXWSClientSupportImpl {
    private static final String[] DEFAULT_WSIMPORT_OPTIONS = new String[]{"extension", "verbose", "fork"};
    private static final String[] DEFAULT_WSIMPORT_VALUES = new String[]{"true", "true", "false"};
    private static final String XNOCOMPILE_OPTION = "xnocompile";
    private static final String XENDORSED_OPTION = "xendorsed";
    private static final String PACKAGE_OPTION = "package";
    private static final String WSDL_LOCATION_OPTION = "wsdlLocation";
    private static final String TARGET_OPTION = "target";
    protected static final String JAVA_EE_VERSION_NONE = "java-ee-version-none";
    protected static final String JAVA_EE_VERSION_15 = "java-ee-version-15";
    protected static final String JAVA_EE_VERSION_16 = "java-ee-version-16";
    protected static final String JAVA_EE_VERSION_17 = "java-ee-version-17";
    protected static final String JAVA_EE_VERSION_18 = "java-ee-version-18";
    protected static final String JAKARTA_EE_VERSION_8 = "jakarta-ee-version-8";
    protected static final String JAKARTA_EE_VERSION_9 = "jakarta-ee-version-9";
    protected static final String JAKARTA_EE_VERSION_91 = "jakarta-ee-version-91";
    protected static final String JAKARTA_EE_VERSION_10 = "jakarta-ee-version-10";
    Project project;
    private AntProjectHelper helper;
    private FileObject clientArtifactsFolder;

    public ProjectJAXWSClientSupport(Project project, AntProjectHelper helper) {
        this.project = project;
        this.helper = helper;
    }

    @Override
    public void removeServiceClient(String serviceName) {
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null && jaxWsModel.removeClient(serviceName)) {
            this.writeJaxWsModel(jaxWsModel);
        }
    }

    @Override
    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }

    public String getWsdlUrl(String serviceName) {
        Client client;
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null && (client = jaxWsModel.findClientByName(serviceName)) != null) {
            return client.getWsdlUrl();
        }
        return null;
    }

    @Override
    public String addServiceClient(String clientName, String wsdlUrl, String packageName, boolean isJsr109) {
        FileObject fo = WSUtils.findJaxWsFileObject((Project)this.project);
        if (fo == null) {
            try {
                WSUtils.createJaxWsFileObject((Project)this.project);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        final JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        String finalClientName = clientName;
        boolean clientAdded = false;
        if (jaxWsModel != null) {
            NotifyDescriptor.Message desc;
            String mes;
            if (!isJsr109) {
                try {
                    this.addJaxWs20Library();
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
            Client client = null;
            finalClientName = this.findProperClientName(clientName, jaxWsModel);
            FileObject xmlResourcesFo = this.getLocalWsdlFolderForClient(finalClientName, true);
            FileObject localWsdl = null;
            try {
                localWsdl = WSUtils.retrieveResource((FileObject)xmlResourcesFo, (URI)new URI(wsdlUrl));
            }
            catch (URISyntaxException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                mes = NbBundle.getMessage(ProjectJAXWSClientSupport.class, (String)"ERR_IncorrectURI", (Object)wsdlUrl);
                desc = new NotifyDescriptor.Message((Object)mes, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
            catch (UnknownHostException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                mes = NbBundle.getMessage(ProjectJAXWSClientSupport.class, (String)"ERR_UnknownHost", (Object)ex.getMessage());
                desc = new NotifyDescriptor.Message((Object)mes, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                mes = NbBundle.getMessage(ProjectJAXWSClientSupport.class, (String)"ERR_WsdlRetrieverFailure", (Object)wsdlUrl);
                desc = new NotifyDescriptor.Message((Object)mes, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            }
            if (localWsdl != null) {
                try {
                    String localWsdlUrl = FileUtil.getRelativePath((FileObject)xmlResourcesFo, (FileObject)localWsdl);
                    client = jaxWsModel.addClient(finalClientName, wsdlUrl, packageName);
                    client.setLocalWsdlFile(localWsdlUrl);
                    if (packageName == null) {
                        client.setPackageName(WSUtils.getPackageNameForWsdl((File)FileUtil.toFile((FileObject)localWsdl)));
                    }
                }
                catch (ClientAlreadyExistsExeption localWsdlUrl) {
                    // empty catch block
                }
                FileObject catalog = this.getCatalogFileObject();
                if (catalog != null) {
                    client.setCatalogFile("catalog.xml");
                }
                WsimportOptions wsimportOptions = client.getWsImportOptions();
                WsimportOption wsimportOption = null;
                if (wsimportOptions != null) {
                    int i = 0;
                    for (String option : DEFAULT_WSIMPORT_OPTIONS) {
                        wsimportOption = wsimportOptions.newWsimportOption();
                        wsimportOption.setWsimportOptionName(option);
                        wsimportOption.setWsimportOptionValue(DEFAULT_WSIMPORT_VALUES[i++]);
                        wsimportOptions.addWsimportOption(wsimportOption);
                    }
                    wsimportOption = wsimportOptions.newWsimportOption();
                    wsimportOption.setWsimportOptionName(WSDL_LOCATION_OPTION);
                    wsimportOption.setWsimportOptionValue(wsdlUrl);
                    wsimportOptions.addWsimportOption(wsimportOption);
                    if (ProjectJAXWSClientSupport.isXnocompile(this.project)) {
                        wsimportOption = wsimportOptions.newWsimportOption();
                        wsimportOption.setWsimportOptionName(XNOCOMPILE_OPTION);
                        wsimportOption.setWsimportOptionValue("true");
                        wsimportOptions.addWsimportOption(wsimportOption);
                    }
                    if (ProjectJAXWSClientSupport.isXendorsed(this.project)) {
                        wsimportOption = wsimportOptions.newWsimportOption();
                        wsimportOption.setWsimportOptionName(XENDORSED_OPTION);
                        wsimportOption.setWsimportOptionValue("true");
                        wsimportOptions.addWsimportOption(wsimportOption);
                    }
                    if (packageName != null) {
                        wsimportOption = wsimportOptions.newWsimportOption();
                        wsimportOption.setWsimportOptionName(PACKAGE_OPTION);
                        wsimportOption.setWsimportOptionValue(packageName);
                        wsimportOptions.addWsimportOption(wsimportOption);
                    }
                    if (JAVA_EE_VERSION_15.equals(this.getProjectJavaEEVersion())) {
                        wsimportOption = wsimportOptions.newWsimportOption();
                        wsimportOption.setWsimportOptionName(TARGET_OPTION);
                        wsimportOption.setWsimportOptionValue("2.1");
                        wsimportOptions.addWsimportOption(wsimportOption);
                    }
                }
                this.writeJaxWsModel(jaxWsModel);
                clientAdded = true;
                if (catalog != null) {
                    try {
                        FileObject webInfWsdl = this.getWsdlFolder(true);
                        if (webInfWsdl != null) {
                            FileObject jaxWsCatalog = webInfWsdl.getParent().getFileObject("jax-ws-catalog.xml");
                            if (jaxWsCatalog == null) {
                                jaxWsCatalog = FileUtil.copyFile((FileObject)catalog, (FileObject)webInfWsdl.getParent(), (String)"jax-ws-catalog");
                                CatalogUtils.updateCatalogEntriesForClient((FileObject)jaxWsCatalog, (String)clientName);
                            } else {
                                CatalogUtils.copyCatalogEntriesForClient((FileObject)catalog, (FileObject)jaxWsCatalog, (String)clientName);
                            }
                            WSUtils.copyFiles((FileObject)xmlResourcesFo, (FileObject)webInfWsdl);
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                final String clientName2 = finalClientName;
                final WsdlModeler modeler = WsdlModelerFactory.getDefault().getWsdlModeler(localWsdl.toURL());
                if (modeler != null) {
                    modeler.setPackageName(packageName);
                    if (catalog != null) {
                        modeler.setCatalog(catalog.toURL());
                    }
                    modeler.generateWsdlModel(new WsdlModelListener(){

                        public void modelCreated(WsdlModel model) {
                            if (model == null) {
                                RequestProcessor.getDefault().post(new Runnable(){

                                    @Override
                                    public void run() {
                                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new WsImportFailedMessage(modeler.getCreationException()));
                                    }
                                });
                            } else {
                                Client client = jaxWsModel.findClientByName(clientName2);
                                String packName = client.getPackageName();
                                if (packName == null && model.getServices().size() > 0) {
                                    WsdlService service = (WsdlService)model.getServices().get(0);
                                    String javaName = service.getJavaName();
                                    int index = javaName.lastIndexOf(".");
                                    packName = index != -1 ? javaName.substring(0, index) : javaName;
                                    client.setPackageName(packName);
                                    ProjectJAXWSClientSupport.this.writeJaxWsModel(jaxWsModel);
                                }
                                ProjectJAXWSClientSupport.this.runWsimport(clientName2);
                            }
                        }
                    });
                }
            }
            return finalClientName;
        }
        return null;
    }

    private void runWsimport(String finalClientName) {
        final FileObject buildImplFo = this.project.getProjectDirectory().getFileObject("build.xml");
        final String finalName = finalClientName;
        if (SwingUtilities.isEventDispatchThread()) {
            this.openOutputWindow();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProjectJAXWSClientSupport.this.openOutputWindow();
                }
            });
        }
        try {
            ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws IOException {
                    Properties props = WSUtils.identifyWsimport((AntProjectHelper)ProjectJAXWSClientSupport.this.helper);
                    ExecutorTask wsimportTask = ActionUtils.runTarget((FileObject)buildImplFo, (String[])new String[]{"wsimport-client-" + finalName}, (Properties)props);
                    return Boolean.TRUE;
                }
            });
        }
        catch (MutexException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private void openOutputWindow() {
        TopComponent outputTc = WindowManager.getDefault().findTopComponent("output");
        if (outputTc != null) {
            outputTc.open();
        }
    }

    private String findProperClientName(String name, JaxWsModel jaxWsModel) {
        String firstName;
        String string = firstName = name.length() == 0 ? NbBundle.getMessage(ProjectJAXWSClientSupport.class, (String)"LBL_defaultClientName") : name;
        if (jaxWsModel.findClientByName(firstName) == null) {
            return firstName;
        }
        int i = 1;
        String finalName;
        while (jaxWsModel.findClientByName(finalName = firstName + "_" + i) != null) {
            ++i;
        }
        return finalName;
    }

    private void writeJaxWsModel(JaxWsModel jaxWsModel) {
        try {
            jaxWsModel.write();
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "failed to save jax-ws.xml", ex);
        }
    }

    @Override
    public List<Client> getServiceClients() {
        ArrayList<Client> jaxWsClients = new ArrayList<Client>();
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null) {
            Client[] clients = jaxWsModel.getClients();
            for (int i = 0; i < clients.length; ++i) {
                jaxWsClients.add(clients[i]);
            }
        }
        return jaxWsClients;
    }

    @Override
    public FileObject getLocalWsdlFolderForClient(String clientName, boolean createFolder) {
        return this.getArtifactsFolder(clientName, createFolder, true);
    }

    @Override
    public FileObject getBindingsFolderForClient(String clientName, boolean createFolder) {
        return this.getArtifactsFolder(clientName, createFolder, false);
    }

    private FileObject getArtifactsFolder(String clientName, boolean createFolder, boolean forWsdl) {
        String folderName = forWsdl ? "wsdl" : "bindings";
        FileObject root = this.getXmlArtifactsRoot();
        assert (root != null);
        FileObject wsdlLocalFolder = root.getFileObject("xml-resources/web-service-references/" + clientName + "/" + folderName);
        if (wsdlLocalFolder == null && createFolder) {
            try {
                FileObject serviceLocalFolder;
                FileObject servicesLocalFolder;
                FileObject xmlLocalFolder = root.getFileObject("xml-resources");
                if (xmlLocalFolder == null) {
                    xmlLocalFolder = root.createFolder("xml-resources");
                }
                if ((servicesLocalFolder = xmlLocalFolder.getFileObject("web-service-references")) == null) {
                    servicesLocalFolder = xmlLocalFolder.createFolder("web-service-references");
                }
                if ((serviceLocalFolder = servicesLocalFolder.getFileObject(clientName)) == null) {
                    serviceLocalFolder = servicesLocalFolder.createFolder(clientName);
                }
                if ((wsdlLocalFolder = serviceLocalFolder.getFileObject(folderName)) == null) {
                    wsdlLocalFolder = serviceLocalFolder.createFolder(folderName);
                }
            }
            catch (IOException ex) {
                return null;
            }
        }
        return wsdlLocalFolder;
    }

    protected FileObject getXmlArtifactsRoot() {
        return this.project.getProjectDirectory();
    }

    private FileObject getCatalogFileObject() {
        return this.project.getProjectDirectory().getFileObject("catalog.xml");
    }

    @Override
    public URL getCatalog() {
        FileObject catalog = this.getCatalogFileObject();
        return catalog == null ? null : catalog.toURL();
    }

    protected abstract void addJaxWs20Library() throws Exception;

    @Override
    public abstract FileObject getWsdlFolder(boolean var1) throws IOException;

    @Override
    public String getServiceRefName(Node clientNode) {
        WsdlService service = (WsdlService)clientNode.getLookup().lookup(WsdlService.class);
        String serviceName = service.getName();
        return "service/" + serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileObject getWsdlFolderForClient(String name) throws IOException {
        FileObject clientWsdlFolder;
        FileObject globalWsdlFolder = this.getWsdlFolder(true);
        FileObject oldWsdlFolder = globalWsdlFolder.getFileObject("client/" + name);
        if (oldWsdlFolder != null) {
            FileLock lock = oldWsdlFolder.lock();
            try {
                oldWsdlFolder.delete(lock);
            }
            finally {
                lock.releaseLock();
            }
        }
        if ((clientWsdlFolder = globalWsdlFolder.getFileObject("client")) == null) {
            clientWsdlFolder = globalWsdlFolder.createFolder("client");
        }
        return clientWsdlFolder.createFolder(name);
    }

    private static boolean isXnocompile(Project project) {
        String version;
        JAXWSVersionProvider jvp = (JAXWSVersionProvider)project.getLookup().lookup(JAXWSVersionProvider.class);
        if (jvp != null && (version = jvp.getJAXWSVersion()) != null) {
            return ProjectJAXWSClientSupport.isVersionSatisfied(version, "2.1.3");
        }
        return true;
    }

    private static boolean isXendorsed(Project project) {
        String version;
        JAXWSVersionProvider jvp = (JAXWSVersionProvider)project.getLookup().lookup(JAXWSVersionProvider.class);
        if (jvp != null && (version = jvp.getJAXWSVersion()) != null) {
            return ProjectJAXWSClientSupport.isVersionSatisfied(version, "2.1.1");
        }
        return false;
    }

    private static boolean isVersionSatisfied(String version, String requiredVersion) {
        int len1 = version.length();
        int len2 = requiredVersion.length();
        for (int i = 0; i < Math.min(len1, len2); ++i) {
            if (version.charAt(i) < requiredVersion.charAt(i)) {
                return false;
            }
            if (version.charAt(i) <= requiredVersion.charAt(i)) continue;
            return true;
        }
        if (len1 > len2) {
            return true;
        }
        return len1 >= len2;
    }

    protected String getProjectJavaEEVersion() {
        return JAVA_EE_VERSION_NONE;
    }

    private class WsImportFailedMessage
    extends NotifyDescriptor.Message {
        public WsImportFailedMessage(Throwable ex) {
            super((Object)NbBundle.getMessage(ProjectJAXWSClientSupport.class, (String)"TXT_CannotGenerateClient", (Object)ex.getLocalizedMessage()), 0);
        }
    }
}

