/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.historystore.Storage;
import org.netbeans.modules.versioning.historystore.StorageManager;
import org.netbeans.modules.versioning.util.Utils;

public class VersionsCache {
    private static VersionsCache instance;

    private VersionsCache() {
    }

    public static synchronized VersionsCache getInstance() {
        if (instance == null) {
            instance = new VersionsCache();
        }
        return instance;
    }

    public File getFileRevision(File base, HgLogMessage.HgRevision revision) throws IOException {
        return this.getFileRevision(base, revision, true);
    }

    public File getFileRevision(File base, HgLogMessage.HgRevision revision, boolean tryHard) throws IOException {
        String revisionNumber = revision.getRevisionNumber();
        if ("-1".equals(revisionNumber)) {
            return null;
        }
        File repository = Mercurial.getInstance().getRepositoryRoot(base);
        if (HgLogMessage.HgRevision.CURRENT.equals(revision)) {
            return base;
        }
        try {
            File tempFile = new File(Utils.getTempFolder(), "nb-hg-" + base.getName());
            tempFile.deleteOnExit();
            if (HgLogMessage.HgRevision.BASE.equals(revision)) {
                HgCommand.doCat(repository, base, tempFile, null);
            } else if ("false".equals(System.getProperty("versioning.mercurial.historycache.enable", "true"))) {
                HgCommand.doCat(repository, base, tempFile, revisionNumber, null);
            } else {
                String relativePath;
                String changesetId = revision.getChangesetId();
                Storage cachedVersions = StorageManager.getInstance().getStorage(repository.getAbsolutePath());
                File cachedFile = cachedVersions.getContent(relativePath = HgUtils.getRelativePath(base), base.getName(), changesetId);
                if (cachedFile.length() == 0L) {
                    HgCommand.doCat(repository, base, tempFile, revisionNumber, null, tryHard);
                    if (tempFile.length() != 0L) {
                        cachedVersions.setContent(relativePath, changesetId, tempFile);
                    }
                } else {
                    tempFile = cachedFile;
                }
            }
            if (tempFile.length() == 0L) {
                tempFile.delete();
                return null;
            }
            return tempFile;
        }
        catch (HgException e) {
            throw new IOException(e);
        }
    }

    private static boolean isLong(String revision) {
        boolean isLong = false;
        try {
            Long.parseLong(revision);
            isLong = true;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return isLong;
    }
}

