/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.suggestions;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AnyPatternTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BindingPatternTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ConstantCaseLabelTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DeconstructionPatternTree;
import com.sun.source.tree.DefaultCaseLabelTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExportsTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.IntersectionTypeTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.OpensTree;
import com.sun.source.tree.PackageTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PatternCaseLabelTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ProvidesTree;
import com.sun.source.tree.RequiresTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StringTemplateTree;
import com.sun.source.tree.SwitchExpressionTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.UsesTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.tree.YieldTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.ReferenceType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.editor.java.Utilities;

public class ExpectedTypeResolver
implements TreeVisitor<List<? extends TypeMirror>, Object> {
    private TreePath theExpression;
    private TreePath originalExpression;
    private TreePath expectedTree;
    private CompilationInfo info;
    private TreePath casted;
    private boolean dontResetCast;
    private int typeCastDepth;
    private TypeMirror castableTo;
    private TreePath path;
    private TreePath parentExecutable;
    private int argIndex = -1;
    private TypeMirror targetArgType;
    private boolean notRedundant;
    private static final EnumSet<Tree.Kind> ARITHMETIC_OPS = EnumSet.of(Tree.Kind.PLUS, Tree.Kind.MINUS, Tree.Kind.MULTIPLY, Tree.Kind.DIVIDE, Tree.Kind.REMAINDER);
    private static final EnumSet<Tree.Kind> COMPARISON_OPS = EnumSet.of(Tree.Kind.LESS_THAN, new Tree.Kind[]{Tree.Kind.LESS_THAN_EQUAL, Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_EQUAL, Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO});
    private final EnumSet<TypeKind> NUMERIC_TYPES = EnumSet.of(TypeKind.BYTE, new TypeKind[]{TypeKind.DOUBLE, TypeKind.FLOAT, TypeKind.INT, TypeKind.LONG, TypeKind.SHORT});

    public ExpectedTypeResolver(TreePath theExpression, CompilationInfo info) {
        this.originalExpression = theExpression;
        this.info = info;
    }

    public ExpectedTypeResolver(TreePath theExpression, TreePath prevExpression, CompilationInfo info) {
        this.originalExpression = theExpression;
        this.theExpression = prevExpression;
        this.info = info;
    }

    protected TreePath getCurrentPath() {
        return this.path;
    }

    public boolean isNotRedundant() {
        return this.notRedundant;
    }

    public TypeMirror getCastableTo() {
        return this.castableTo;
    }

    public TreePath getTheExpression() {
        return this.theExpression;
    }

    public TreePath getOriginalExpression() {
        return this.originalExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends TypeMirror> scan(TreePath path, Object p) {
        ++this.typeCastDepth;
        if (!this.dontResetCast) {
            this.casted = null;
        }
        this.path = path;
        try {
            List<? extends TypeMirror> list = path.getLeaf().accept(this, p);
            return list;
        }
        finally {
            this.path = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<? extends TypeMirror> scan(Tree tree, Object p) {
        ++this.typeCastDepth;
        if (!this.dontResetCast) {
            this.casted = null;
        }
        if (tree == null) {
            return null;
        }
        TreePath prev = this.path;
        this.path = new TreePath(this.path, tree);
        try {
            List<? extends TypeMirror> list = tree.accept(this, p);
            return list;
        }
        finally {
            this.path = prev;
        }
    }

    private void initExpression(Tree node) {
        this.initExpression(new TreePath(this.getCurrentPath(), node));
    }

    private void initExpression(TreePath path) {
        if (this.theExpression != null) {
            return;
        }
        this.originalExpression = this.theExpression = path;
    }

    @Override
    public List<? extends TypeMirror> visitVariable(VariableTree node, Object p) {
        if (this.theExpression == null) {
            if (node.getInitializer() == null) {
                return null;
            }
            this.initExpression(node.getInitializer());
        }
        if (this.theExpression.getLeaf() == node.getInitializer()) {
            this.expectedTree = new TreePath(this.getCurrentPath(), node.getType());
            return Collections.singletonList(this.info.getTrees().getTypeMirror(this.getCurrentPath()));
        }
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitDoWhileLoop(DoWhileLoopTree node, Object p) {
        if (this.theExpression == null) {
            this.initExpression(node.getCondition());
        } else if (this.theExpression.getLeaf() != node.getCondition()) {
            return null;
        }
        return this.booleanType();
    }

    @Override
    public List<? extends TypeMirror> visitWhileLoop(WhileLoopTree node, Object p) {
        if (this.theExpression == null) {
            this.initExpression(node.getCondition());
        }
        return this.booleanType();
    }

    @Override
    public List<? extends TypeMirror> visitForLoop(ForLoopTree node, Object p) {
        if (this.theExpression == null) {
            return null;
        }
        if (this.theExpression.getLeaf() == node.getCondition()) {
            return this.booleanType();
        }
        if (!(node.getInitializer() != null && node.getInitializer().contains(this.theExpression.getLeaf()) || node.getUpdate() != null && node.getUpdate().contains(this.theExpression.getLeaf()))) {
            return null;
        }
        TypeElement tel = this.info.getElements().getTypeElement("java.lang.Void");
        if (tel == null) {
            return null;
        }
        return Collections.singletonList(tel.asType());
    }

    @Override
    public List<? extends TypeMirror> visitSwitch(SwitchTree node, Object p) {
        if (this.theExpression == null) {
            this.initExpression(node.getExpression());
        }
        for (CaseTree caseTree : node.getCases()) {
            if (caseTree.getExpression() == null) continue;
            TreePath casePath = new TreePath(this.getCurrentPath(), caseTree);
            TypeMirror caseType = this.info.getTrees().getTypeMirror(new TreePath(casePath, caseTree.getExpression()));
            return Collections.singletonList(caseType);
        }
        return null;
    }

    private List<? extends TypeMirror> booleanType() {
        return Collections.singletonList(this.info.getTypes().getPrimitiveType(TypeKind.BOOLEAN));
    }

    @Override
    public List<? extends TypeMirror> visitConditionalExpression(ConditionalExpressionTree node, Object p) {
        if (this.theExpression == null) {
            return null;
        }
        if (this.theExpression.getLeaf() == node.getCondition()) {
            return this.booleanType();
        }
        ExpressionTree otherExpression = this.theExpression.getLeaf() == node.getFalseExpression() ? node.getTrueExpression() : node.getFalseExpression();
        TypeMirror otherType = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), otherExpression));
        TypeMirror thisType = this.info.getTrees().getTypeMirror(this.getExpressionWithoutCasts());
        if (!org.netbeans.modules.java.hints.errors.Utilities.isValidType(otherType) || !org.netbeans.modules.java.hints.errors.Utilities.isValidType(thisType)) {
            return null;
        }
        ExpectedTypeResolver subResolver = new ExpectedTypeResolver(this.getCurrentPath(), this.getCurrentPath(), this.info);
        ++subResolver.typeCastDepth;
        List<? extends TypeMirror> pp = subResolver.scan(this.getCurrentPath().getParentPath(), null);
        if (pp == null) {
            return null;
        }
        ArrayList<? extends TypeMirror> parentTypes = new ArrayList<TypeMirror>(pp);
        Iterator it = parentTypes.iterator();
        while (it.hasNext()) {
            TypeMirror m = (TypeMirror)it.next();
            if (this.info.getTypeUtilities().isCastable(thisType, m)) continue;
            Scope s = this.info.getTrees().getScope(this.getCurrentPath());
            SourcePositions pos = this.info.getTrees().getSourcePositions();
            StringBuilder sb = new StringBuilder();
            int posFirst = (int)pos.getStartPosition(this.info.getCompilationUnit(), this.theExpression.getLeaf());
            int posSecond = (int)pos.getStartPosition(this.info.getCompilationUnit(), otherExpression);
            if (posFirst < 0 || posSecond < 0) {
                return null;
            }
            String first = this.info.getText().substring(posFirst, (int)pos.getEndPosition(this.info.getCompilationUnit(), this.theExpression.getLeaf()));
            String second = this.info.getText().substring(posSecond, (int)pos.getEndPosition(this.info.getCompilationUnit(), otherExpression));
            sb.append(first).append("+").append(second);
            ExpressionTree expr = this.info.getTreeUtilities().parseExpression(sb.toString(), new SourcePositions[1]);
            TypeMirror targetType = this.purify(this.info, this.info.getTreeUtilities().attributeTree((Tree)expr, s));
            if (targetType != null && this.info.getTypes().isAssignable(targetType, m)) continue;
            it.remove();
        }
        return parentTypes.isEmpty() ? Collections.singletonList(otherType) : parentTypes;
    }

    private TypeMirror purify(CompilationInfo info, TypeMirror targetType) {
        if (targetType != null && targetType.getKind() == TypeKind.ERROR) {
            targetType = info.getTrees().getOriginalType((ErrorType)targetType);
        }
        if (targetType == null || targetType.getKind() == TypeKind.ERROR || targetType.getKind() == TypeKind.NONE || targetType.getKind() == TypeKind.NULL) {
            return null;
        }
        return org.netbeans.modules.java.hints.errors.Utilities.resolveCapturedType(info, targetType);
    }

    @Override
    public List<? extends TypeMirror> visitIf(IfTree node, Object p) {
        if (this.theExpression == null) {
            this.initExpression(node.getCondition());
        }
        return this.booleanType();
    }

    @Override
    public List<? extends TypeMirror> visitExpressionStatement(ExpressionStatementTree node, Object p) {
        if (this.theExpression == null) {
            this.initExpression(this.getCurrentPath());
        }
        return Collections.singletonList(this.info.getTypes().getNoType(TypeKind.VOID));
    }

    @Override
    public List<? extends TypeMirror> visitReturn(ReturnTree node, Object p) {
        Tree returnTypeTree;
        TreePath parents;
        if (node.getExpression() == null) {
            return null;
        }
        if (this.theExpression == null) {
            this.initExpression(node.getExpression());
        }
        for (parents = this.getCurrentPath(); parents != null && parents.getLeaf().getKind() != Tree.Kind.METHOD; parents = parents.getParentPath()) {
        }
        if (parents != null && (returnTypeTree = ((MethodTree)parents.getLeaf()).getReturnType()) != null) {
            return Collections.singletonList(this.info.getTrees().getTypeMirror(new TreePath(parents, returnTypeTree)));
        }
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitThrow(ThrowTree node, Object p) {
        TreePath parents;
        ArrayList<TypeMirror> result = new ArrayList<TypeMirror>();
        Tree prev = null;
        for (parents = this.getCurrentPath(); parents != null && parents.getLeaf().getKind() != Tree.Kind.METHOD; parents = parents.getParentPath()) {
            Object tt;
            Tree l = parents.getLeaf();
            if (l.getKind() == Tree.Kind.TRY && prev == (tt = (TryTree)l).getBlock()) {
                for (CatchTree catchTree : tt.getCatches()) {
                    TypeMirror ex = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), catchTree.getParameter().getType()));
                    if (ex == null) continue;
                    switch (ex.getKind()) {
                        case DECLARED: {
                            if (result.contains(ex)) break;
                            result.add(ex);
                            break;
                        }
                        case UNION: {
                            for (TypeMirror typeMirror : ((UnionType)ex).getAlternatives()) {
                                if (result.contains(typeMirror)) continue;
                                result.add(typeMirror);
                            }
                            break;
                        }
                    }
                }
            }
            prev = l;
        }
        if (parents != null) {
            MethodTree mt = (MethodTree)parents.getLeaf();
            for (ExpressionTree expressionTree : mt.getThrows()) {
                TypeMirror typeMirror = this.info.getTrees().getTypeMirror(new TreePath(parents, expressionTree));
                if (typeMirror == null || result.contains(typeMirror)) continue;
                result.add(typeMirror);
            }
        }
        TypeMirror jlre = this.info.getElements().getTypeElement("java.lang.RuntimeException").asType();
        TypeMirror jler = this.info.getElements().getTypeElement("java.lang.Error").asType();
        for (TypeMirror typeMirror : result) {
            if (jlre != null && this.info.getTypes().isAssignable(jlre, typeMirror)) {
                jlre = null;
            }
            if (jler != null && this.info.getTypes().isAssignable(jler, typeMirror)) {
                jler = null;
            }
            if (jlre != null || jler != null) continue;
            break;
        }
        if (jlre != null) {
            result.add(jlre);
        }
        if (jler != null) {
            result.add(jler);
        }
        return result;
    }

    @Override
    public List<? extends TypeMirror> visitAssert(AssertTree node, Object p) {
        if (this.theExpression == null) {
            this.initExpression(node.getCondition());
        }
        return this.booleanType();
    }

    @Override
    public List<? extends TypeMirror> visitMethodInvocation(MethodInvocationTree node, Object p) {
        TypeMirror execType = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), node.getMethodSelect()));
        if (execType == null || execType.getKind() != TypeKind.EXECUTABLE) {
            return null;
        }
        return this.visitMethodOrNew(node, p, node.getArguments(), (ExecutableType)execType);
    }

    private List<? extends TypeMirror> visitMethodOrNew(Tree node, Object p, List<? extends ExpressionTree> args, ExecutableType execType) {
        ArrayList proposed = new ArrayList();
        int[] index = new int[1];
        if (this.theExpression == null) {
            List methods = Utilities.fuzzyResolveMethodInvocation((CompilationInfo)this.info, (TreePath)this.getCurrentPath(), proposed, (int[])index);
            if (methods.isEmpty()) {
                return null;
            }
            this.initExpression(args.get(index[0]));
            return proposed;
        }
        Element el = this.info.getTrees().getElement(this.getCurrentPath());
        if (el == null) {
            return null;
        }
        if (this.theExpression.getLeaf() != node && (el.getKind() == ElementKind.METHOD || el.getKind() == ElementKind.CONSTRUCTOR)) {
            TypeMirror argm;
            int argIndex = args.indexOf(this.theExpression.getLeaf());
            this.parentExecutable = this.getCurrentPath();
            ExecutableElement ee = (ExecutableElement)el;
            boolean allowEntireVararg = false;
            boolean varargPosition = false;
            if (ee.isVarArgs() && (varargPosition = argIndex >= ee.getParameters().size() - 1)) {
                allowEntireVararg = argIndex == ee.getParameters().size() - 1;
                argIndex = ee.getParameters().size() - 1;
                this.argIndex = allowEntireVararg ? ee.getParameters().size() - 1 : ee.getParameters().size();
            } else {
                this.argIndex = argIndex;
            }
            if (execType != null) {
                argm = execType.getParameterTypes().get(argIndex);
                argm = this.decapture(argm);
            } else {
                argm = ((ExecutableElement)el).getParameters().get(argIndex).asType();
            }
            if (argm == null || argm.getKind() == TypeKind.ERROR) {
                this.targetArgType = null;
                return null;
            }
            if (varargPosition && argm.getKind() == TypeKind.ARRAY) {
                TypeMirror ctype = ((ArrayType)argm).getComponentType();
                if (allowEntireVararg) {
                    this.targetArgType = argm;
                    return Arrays.asList(argm, ctype);
                }
                argm = ctype;
            }
            this.targetArgType = argm;
            return Collections.singletonList(argm);
        }
        return null;
    }

    private TypeMirror decapture(TypeMirror argm) {
        if (argm instanceof Type.CapturedType) {
            argm = ((Type.CapturedType)argm).wildcard;
        }
        if (argm.getKind() == TypeKind.WILDCARD) {
            WildcardType wctype = (WildcardType)argm;
            TypeMirror bound = wctype.getExtendsBound();
            if (bound != null) {
                return bound;
            }
            bound = wctype.getSuperBound();
            if (bound != null) {
                return bound;
            }
            return null;
        }
        return argm;
    }

    public TreePath getParentExecutable() {
        return this.parentExecutable;
    }

    public int getArgumentIndex() {
        return this.argIndex;
    }

    @Override
    public List<? extends TypeMirror> visitNewClass(NewClassTree node, Object p) {
        TypeMirror tm = this.info.getTrees().getTypeMirror(this.getCurrentPath());
        if (tm == null || tm.getKind() != TypeKind.DECLARED) {
            return null;
        }
        Element el = this.info.getTrees().getElement(this.getCurrentPath());
        if (el == null) {
            return null;
        }
        if (this.theExpression.getLeaf() != node.getEnclosingExpression()) {
            ExecutableType execType = (ExecutableType)this.info.getTypes().asMemberOf((DeclaredType)tm, el);
            return this.visitMethodOrNew(node, p, node.getArguments(), execType);
        }
        DeclaredType dt = (DeclaredType)tm;
        if (dt.getEnclosingType() == null) {
            return null;
        }
        return Collections.singletonList(dt.getEnclosingType());
    }

    @Override
    public List<? extends TypeMirror> visitNewArray(NewArrayTree node, Object p) {
        if (node.getDimensions() == null) {
            return null;
        }
        if (this.theExpression == null && node.getDimensions().size() == 1) {
            this.initExpression(node.getDimensions().get(0));
        } else if (!node.getDimensions().contains(this.theExpression.getLeaf())) {
            return null;
        }
        return Collections.singletonList(this.info.getTypes().getPrimitiveType(TypeKind.INT));
    }

    @Override
    public List<? extends TypeMirror> visitParenthesized(ParenthesizedTree node, Object p) {
        return this.scanParent();
    }

    @Override
    public List<? extends TypeMirror> visitAssignment(AssignmentTree node, Object p) {
        if (this.theExpression == null) {
            this.initExpression(new TreePath(this.getCurrentPath(), node.getExpression()));
        }
        return Collections.singletonList(this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), node.getVariable())));
    }

    @Override
    public List<? extends TypeMirror> visitCompoundAssignment(CompoundAssignmentTree node, Object p) {
        if (this.theExpression == null) {
            this.initExpression(new TreePath(this.getCurrentPath(), node.getExpression()));
        }
        return Collections.singletonList(this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), node.getVariable())));
    }

    @Override
    public List<? extends TypeMirror> visitUnary(UnaryTree node, Object p) {
        switch (node.getKind()) {
            case POSTFIX_DECREMENT: 
            case POSTFIX_INCREMENT: 
            case PREFIX_DECREMENT: 
            case PREFIX_INCREMENT: {
                return null;
            }
            case PLUS: 
            case BITWISE_COMPLEMENT: {
                this.scanParent();
                break;
            }
            case LOGICAL_COMPLEMENT: {
                return this.booleanType();
            }
        }
        return null;
    }

    private TreePath getExpressionWithoutCasts() {
        if (this.casted != null) {
            return this.casted;
        }
        return this.theExpression == null ? this.originalExpression : this.theExpression;
    }

    private static boolean isPrimitiveType(TypeKind k) {
        return k.isPrimitive();
    }

    @Override
    public List<? extends TypeMirror> visitBinary(BinaryTree node, Object p) {
        Element e;
        TypeMirror resultType = this.info.getTrees().getTypeMirror(this.getCurrentPath());
        if (node.getLeftOperand() == null || node.getRightOperand() == null) {
            return null;
        }
        TypeMirror lhsType = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), node.getLeftOperand()));
        TypeMirror rhsType = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), node.getRightOperand()));
        if (lhsType == null || rhsType == null || this.theExpression == null) {
            return null;
        }
        boolean resultIsString = false;
        if (resultType.getKind() == TypeKind.DECLARED && (e = ((DeclaredType)resultType).asElement()).getKind() == ElementKind.CLASS) {
            TypeElement tel = (TypeElement)e;
            resultIsString = tel.getQualifiedName().contentEquals("java.lang.String");
        }
        if (COMPARISON_OPS.contains((Object)node.getKind())) {
            TreePath expPath = this.getExpressionWithoutCasts();
            TypeMirror expType = this.info.getTrees().getTypeMirror(expPath);
            TypeMirror rettype = null;
            if (this.theExpression.getLeaf() == node.getLeftOperand()) {
                lhsType = expType;
            } else {
                rhsType = expType;
            }
            if (lhsType == null || rhsType == null) {
                return null;
            }
            rettype = lhsType.getKind() == TypeKind.DOUBLE ? lhsType : (rhsType.getKind() == TypeKind.DOUBLE ? rhsType : (lhsType.getKind() == TypeKind.FLOAT ? lhsType : (rhsType.getKind() == TypeKind.FLOAT ? rhsType : (lhsType.getKind() == TypeKind.LONG ? lhsType : (rhsType.getKind() == TypeKind.LONG ? rhsType : this.info.getTypes().getPrimitiveType(TypeKind.INT))))));
            if (rettype == null) {
                return null;
            }
            return Collections.singletonList(rettype);
        }
        if (ARITHMETIC_OPS.contains((Object)node.getKind())) {
            TypeMirror other;
            TypeMirror followed;
            if (node.getLeftOperand() == this.theExpression.getLeaf()) {
                followed = lhsType;
                other = rhsType;
            } else {
                followed = rhsType;
                other = lhsType;
            }
            if (ExpectedTypeResolver.isPrimitiveType(followed.getKind())) {
                if (ExpectedTypeResolver.isPrimitiveType(resultType.getKind())) {
                    TypeKind otherKind = org.netbeans.modules.java.hints.errors.Utilities.getPrimitiveKind(this.info, other);
                    if (otherKind != null && followed.getKind() != TypeKind.ERROR && followed.getKind().ordinal() > otherKind.ordinal()) {
                        this.notRedundant = true;
                        return Collections.singletonList(followed);
                    }
                } else if (resultType.getKind() == TypeKind.DECLARED && resultIsString) {
                    TreePath expPath = this.getExpressionWithoutCasts();
                    TypeMirror expType = this.info.getTrees().getTypeMirror(expPath);
                    if (expType != null && expType.getKind().isPrimitive() && expType.getKind() != followed.getKind()) {
                        if (expType.getKind() != TypeKind.CHAR && followed.getKind().ordinal() < expType.getKind().ordinal()) {
                            return null;
                        }
                        switch (expType.getKind()) {
                            case INT: 
                            case LONG: {
                                if (followed.getKind().ordinal() < TypeKind.FLOAT.ordinal()) break;
                                this.notRedundant = true;
                                return Collections.singletonList(this.info.getTypes().getPrimitiveType(TypeKind.FLOAT));
                            }
                            case CHAR: {
                                this.notRedundant = true;
                                if (followed.getKind() == TypeKind.LONG) {
                                    return Collections.singletonList(this.info.getTypes().getPrimitiveType(TypeKind.INT));
                                }
                                if (followed.getKind().ordinal() < TypeKind.FLOAT.ordinal()) {
                                    return Collections.singletonList(followed);
                                }
                                return Collections.singletonList(this.info.getTypes().getPrimitiveType(TypeKind.FLOAT));
                            }
                        }
                    }
                }
            } else if (resultIsString) {
                TreePath tp = this.getExpressionWithoutCasts();
                if (tp == null) {
                    return null;
                }
                TypeMirror m = this.info.getTrees().getTypeMirror(tp);
                if (m == null) {
                    return null;
                }
                return Collections.singletonList(m);
            }
            return Collections.singletonList(resultType);
        }
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitInstanceOf(InstanceOfTree node, Object p) {
        TypeElement tel;
        if (this.theExpression == null) {
            this.initExpression(new TreePath(this.getCurrentPath(), node.getExpression()));
        }
        if ((tel = this.info.getElements().getTypeElement("java.lang.Object")) == null) {
            return null;
        }
        return Collections.singletonList(tel.asType());
    }

    @Override
    public List<? extends TypeMirror> visitArrayAccess(ArrayAccessTree node, Object p) {
        if (this.theExpression == null) {
            return null;
        }
        if (this.theExpression == node.getExpression()) {
            return null;
        }
        return Collections.singletonList(this.info.getTypes().getPrimitiveType(TypeKind.INT));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<? extends TypeMirror> visitMemberSelect(MemberSelectTree tree, Object v) {
        Element parent;
        TypeMirror castedType;
        if (this.casted != null && (castedType = this.info.getTrees().getTypeMirror(this.casted)) != null && castedType.getKind().isPrimitive()) {
            this.notRedundant = true;
        }
        TreePath[] p = new TreePath[1];
        ExpressionTree[] e = new ExpressionTree[1];
        Tree[] l = new Tree[1];
        ArrayList tt = new ArrayList();
        Element el = this.info.getTrees().getElement(this.getCurrentPath());
        if (el == null) {
            return null;
        }
        if (el.getKind() == ElementKind.METHOD) {
            TreePath exp = this.getExpressionWithoutCasts();
            if (exp != null && exp.getLeaf().getKind() == Tree.Kind.LAMBDA_EXPRESSION) {
                return null;
            }
            TreePath methodInvocation = this.getCurrentPath().getParentPath();
            TreePath invocationParent = methodInvocation.getParentPath();
            ExpectedTypeResolver subResolver = new ExpectedTypeResolver(methodInvocation, this.info);
            subResolver.theExpression = methodInvocation;
            ++subResolver.typeCastDepth;
            List<? extends TypeMirror> parentTypes = subResolver.scan(invocationParent, v);
            TypeMirror castable = null;
            if (parentTypes == null) {
                castable = subResolver.getCastableTo();
            }
            if (parentTypes != null || castable != null) {
                List<TypeMirror> cans;
                TreePath method;
                TypeMirror exprType = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), tree.getExpression()));
                if (!(exprType instanceof DeclaredType)) {
                    return null;
                }
                ExecutableElement elem = (ExecutableElement)el;
                for (method = this.getCurrentPath(); method != null && method.getLeaf().getKind() != Tree.Kind.METHOD; method = method.getParentPath()) {
                }
                if (method == null) {
                    method = this.getCurrentPath();
                }
                if ((cans = ExpectedTypeResolver.findBaseTypes(this.info, elem, (DeclaredType)exprType, parentTypes, castable, this.info.getTrees().getScope(method))).isEmpty()) return null;
                return cans;
            }
            TypeMirror exprm = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), tree.getExpression()));
            return Collections.singletonList(exprm);
        }
        if (el.getKind() != ElementKind.FIELD || (parent = el.getEnclosingElement()).getKind() != ElementKind.CLASS && parent.getKind() != ElementKind.INTERFACE && parent.getKind() != ElementKind.ENUM && parent.getKind() != ElementKind.RECORD) return null;
        return Collections.singletonList(parent.asType());
    }

    @Override
    public List<? extends TypeMirror> visitOther(Tree node, Object p) {
        return null;
    }

    private List<? extends TypeMirror> scanParent() {
        this.theExpression = this.getCurrentPath();
        --this.typeCastDepth;
        return this.scan(this.getCurrentPath().getParentPath(), null);
    }

    @Override
    public List<? extends TypeMirror> visitTypeCast(TypeCastTree node, Object p) {
        if (this.typeCastDepth == 1) {
            if (this.casted == null) {
                this.casted = new TreePath(this.getCurrentPath(), node.getExpression());
                while (this.casted.getLeaf().getKind() == Tree.Kind.PARENTHESIZED) {
                    this.casted = new TreePath(this.casted, ((ParenthesizedTree)this.casted.getLeaf()).getExpression());
                }
            } else if (!this.info.getTypeUtilities().isCastable(this.info.getTrees().getTypeMirror(this.casted), this.info.getTrees().getTypeMirror(this.getCurrentPath()))) {
                this.notRedundant = true;
            }
            this.dontResetCast = true;
            return this.scanParent();
        }
        this.castableTo = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), node.getType()));
        return null;
    }

    static List<TypeMirror> findBaseTypes(CompilationInfo info, ExecutableElement method, DeclaredType startFrom, Collection<? extends TypeMirror> expectedReturnType, TypeMirror castableToType, Scope accessor) {
        HashSet<TypeMirror> seenTypes = new HashSet<TypeMirror>();
        ArrayList<TypeMirror> collected = new ArrayList<TypeMirror>();
        ExpectedTypeResolver.collectMethods(info, accessor, method, expectedReturnType, castableToType, startFrom, collected, seenTypes);
        return collected;
    }

    private static boolean assignableToSomeType(CompilationInfo info, TypeMirror theValue, Collection<? extends TypeMirror> alternatives) {
        for (TypeMirror typeMirror : alternatives) {
            if (typeMirror.getKind() == TypeKind.VOID) {
                return true;
            }
            if (!info.getTypes().isAssignable(theValue, typeMirror)) continue;
            return true;
        }
        return false;
    }

    private static void collectMethods(CompilationInfo info, Scope accessor, ExecutableElement method, Collection<? extends TypeMirror> expectedReturnType, TypeMirror castableToType, DeclaredType dcc, List<TypeMirror> collected, Set<TypeMirror> seenTypes) {
        TypeElement c = (TypeElement)dcc.asElement();
        boolean tooAbstract = false;
        ExecutableElement found = null;
        if (!seenTypes.add(c.asType())) {
            return;
        }
        if (accessor == null || info.getTrees().isAccessible(accessor, c)) {
            for (ExecutableElement m : ElementFilter.methodsIn(c.getEnclosedElements())) {
                if (!m.getSimpleName().contentEquals(method.getSimpleName()) || accessor != null && !info.getTrees().isAccessible(accessor, m, dcc) || m != method && !info.getElements().overrides(method, m, c)) continue;
                if (expectedReturnType != null) {
                    if (ExpectedTypeResolver.assignableToSomeType(info, m.getReturnType(), expectedReturnType)) {
                        found = m;
                        break;
                    }
                    tooAbstract = true;
                    break;
                }
                if (castableToType != null) {
                    if (!info.getTypeUtilities().isCastable(m.getReturnType(), castableToType)) break;
                    found = m;
                    break;
                }
                found = m;
                break;
            }
        }
        if (!tooAbstract) {
            List<? extends TypeMirror> supertypes = info.getTypes().directSupertypes(dcc);
            for (TypeMirror typeMirror : supertypes) {
                if (!(typeMirror instanceof DeclaredType)) continue;
                ExpectedTypeResolver.collectMethods(info, accessor, method, expectedReturnType, castableToType, (DeclaredType)typeMirror, collected, seenTypes);
            }
        }
        if (found != null) {
            ExpectedTypeResolver.addTypeAndReplaceMoreSpecific(info, collected, dcc);
        }
    }

    private static void addTypeAndReplaceMoreSpecific(CompilationInfo info, Collection<TypeMirror> collected, TypeMirror nue) {
        Iterator<TypeMirror> it = collected.iterator();
        while (it.hasNext()) {
            TypeMirror m = it.next();
            if (info.getTypes().isAssignable(nue, m)) {
                return;
            }
            if (!info.getTypes().isAssignable(m, nue)) continue;
            it.remove();
        }
        collected.add(nue);
    }

    @Override
    public List<? extends TypeMirror> visitEnhancedForLoop(EnhancedForLoopTree node, Object p) {
        TypeMirror varType = this.info.getTrees().getTypeMirror(new TreePath(this.getCurrentPath(), node.getVariable()));
        if (!org.netbeans.modules.java.hints.errors.Utilities.isValidType(varType)) {
            return null;
        }
        ArrayType arrayType = this.info.getTypes().getArrayType(varType);
        TypeElement iterableEl = this.info.getElements().getTypeElement("java.lang.Iterable");
        if (iterableEl == null || iterableEl.getKind() != ElementKind.INTERFACE) {
            return null;
        }
        DeclaredType iterableForVar = ExpectedTypeResolver.isPrimitiveType(varType.getKind()) ? this.info.getTypes().getDeclaredType(iterableEl, this.info.getTypes().getWildcardType(this.info.getTypes().boxedClass((PrimitiveType)varType).asType(), null)) : this.info.getTypes().getDeclaredType(iterableEl, this.info.getTypes().getWildcardType(varType, null));
        ArrayList<ReferenceType> result = new ArrayList<ReferenceType>(2);
        result.add(arrayType);
        result.add(iterableForVar);
        return result;
    }

    @Override
    public List<? extends TypeMirror> visitAnnotatedType(AnnotatedTypeTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitAnnotation(AnnotationTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitBlock(BlockTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitBreak(BreakTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitCase(CaseTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitCatch(CatchTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitClass(ClassTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitContinue(ContinueTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitErroneous(ErroneousTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitIdentifier(IdentifierTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitImport(ImportTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitLabeledStatement(LabeledStatementTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitLiteral(LiteralTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitMethod(MethodTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitModifiers(ModifiersTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitLambdaExpression(LambdaExpressionTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitMemberReference(MemberReferenceTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitEmptyStatement(EmptyStatementTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitSynchronized(SynchronizedTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitCompilationUnit(CompilationUnitTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitPackage(PackageTree pt, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitTry(TryTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitParameterizedType(ParameterizedTypeTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitUnionType(UnionTypeTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitIntersectionType(IntersectionTypeTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitArrayType(ArrayTypeTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitPrimitiveType(PrimitiveTypeTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitTypeParameter(TypeParameterTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitWildcard(WildcardTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitModule(ModuleTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitExports(ExportsTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitOpens(OpensTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitProvides(ProvidesTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitRequires(RequiresTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitUses(UsesTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitBindingPattern(BindingPatternTree bpt, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitSwitchExpression(SwitchExpressionTree set, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitYield(YieldTree yt, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitDefaultCaseLabel(DefaultCaseLabelTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitConstantCaseLabel(ConstantCaseLabelTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitPatternCaseLabel(PatternCaseLabelTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitDeconstructionPattern(DeconstructionPatternTree node, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitStringTemplate(StringTemplateTree stt, Object p) {
        return null;
    }

    @Override
    public List<? extends TypeMirror> visitAnyPattern(AnyPatternTree apt, Object p) {
        return null;
    }
}

