/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.php.project.ui.wizards.PhpFrameworksPanel;
import org.netbeans.modules.php.spi.framework.PhpFrameworkProvider;
import org.netbeans.modules.php.spi.framework.PhpModuleExtender;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class PhpFrameworksPanelVisual
extends JPanel
implements HelpCtx.Provider,
TableModelListener,
ListSelectionListener,
ChangeListener {
    private static final int STEP_INDEX = 2;
    private static final long serialVersionUID = 158602680330133653L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final FrameworksTableModel model;
    private final Map<PhpFrameworkProvider, PhpModuleExtender> extenders;
    private PhpModuleExtender actualExtender;
    private JPanel configPanel;
    private JLabel descriptionLabel;
    private JScrollPane frameworksScrollPane;
    private JTable frameworksTable;
    private JSeparator separator;

    public PhpFrameworksPanelVisual(PhpFrameworksPanel wizardPanel, Map<PhpFrameworkProvider, PhpModuleExtender> extenders) {
        assert (extenders != null);
        this.extenders = extenders;
        this.setName(wizardPanel.getSteps()[2]);
        this.putClientProperty("WizardPanel_contentSelectedIndex", 2);
        this.putClientProperty("WizardPanel_contentData", wizardPanel.getSteps());
        this.initComponents();
        this.model = new FrameworksTableModel();
        this.frameworksTable.setModel(this.model);
        this.frameworksTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "none");
        this.createFrameworksList();
        FrameworksTableCellRenderer renderer = new FrameworksTableCellRenderer(this.model);
        renderer.setBooleanRenderer(this.frameworksTable.getDefaultRenderer(Boolean.class));
        this.frameworksTable.setDefaultRenderer(PhpFrameworkProvider.class, renderer);
        this.frameworksTable.setDefaultRenderer(Boolean.class, renderer);
        this.initTableVisualProperties();
        this.changeDescriptionAndPanel();
    }

    public void addPhpFrameworksListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removePhpFrameworksListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public Map<PhpFrameworkProvider, PhpModuleExtender> getSelectedExtenders() {
        LinkedHashMap<PhpFrameworkProvider, PhpModuleExtender> selectedExtenders = new LinkedHashMap<PhpFrameworkProvider, PhpModuleExtender>();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            FrameworkModelItem item = this.model.getItem(i);
            if (!item.isSelected().booleanValue()) continue;
            PhpFrameworkProvider framework = item.getFramework();
            assert (framework != null);
            PhpModuleExtender extender = this.extenders.get(framework);
            selectedExtenders.put(framework, extender);
        }
        return selectedExtenders;
    }

    public PhpModuleExtender getSelectedVisibleExtender() {
        int selectedRow = this.frameworksTable.getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        FrameworkModelItem item = this.model.getItem(selectedRow);
        assert (item != null);
        if (item.isSelected().booleanValue()) {
            return this.extenders.get(item.getFramework());
        }
        return null;
    }

    public void markInvalidFrameworks(Set<PhpFrameworkProvider> invalidFrameworks) {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            FrameworkModelItem item;
            item.setValid(!invalidFrameworks.contains((item = this.model.getItem(i)).getFramework()));
        }
    }

    public HelpCtx getHelpCtx() {
        for (Component component : this.configPanel.getComponents()) {
            HelpCtx helpCtx;
            if (!(component instanceof HelpCtx.Provider) || (helpCtx = ((HelpCtx.Provider)component).getHelpCtx()) == null) continue;
            return helpCtx;
        }
        return null;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.changeDescriptionAndPanel();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.changeDescriptionAndPanel();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireChange();
    }

    private void fireChange() {
        this.changeSupport.fireChange();
    }

    private void createFrameworksList() {
        for (PhpFrameworkProvider provider : this.extenders.keySet()) {
            this.model.addItem(new FrameworkModelItem(provider));
        }
    }

    private void initTableVisualProperties() {
        this.frameworksTable.getModel().addTableModelListener(this);
        this.frameworksTable.getSelectionModel().addListSelectionListener(this);
        this.frameworksTable.setRowHeight(this.frameworksTable.getRowHeight() + 4);
        this.frameworksTable.setIntercellSpacing(new Dimension(0, 0));
        this.frameworksTable.getParent().setBackground(this.frameworksTable.getBackground());
        this.frameworksTable.getColumnModel().getColumn(0).setMaxWidth(30);
    }

    private void changeDescriptionAndPanel() {
        if (this.actualExtender != null) {
            this.actualExtender.removeChangeListener((ChangeListener)this);
        }
        if (this.frameworksTable.getSelectedRow() == -1) {
            this.descriptionLabel.setText(" ");
            this.configPanel.removeAll();
            this.configPanel.repaint();
            this.configPanel.revalidate();
        } else {
            FrameworkModelItem item = this.model.getItem(this.frameworksTable.getSelectedRow());
            this.descriptionLabel.setText(item.getFramework().getDescription());
            this.descriptionLabel.setEnabled(item.isSelected());
            this.configPanel.removeAll();
            this.actualExtender = this.extenders.get(item.getFramework());
            this.actualExtender.addChangeListener((ChangeListener)this);
            JComponent component = this.actualExtender.getComponent();
            if (component != null) {
                this.configPanel.add((Component)component, "Center");
                this.enableComponents(component, item.isSelected());
            }
            this.configPanel.revalidate();
            this.configPanel.repaint();
        }
        this.fireChange();
    }

    private void enableComponents(Container root, boolean enabled) {
        root.setEnabled(enabled);
        for (Component child : root.getComponents()) {
            if (child instanceof Container) {
                this.enableComponents((Container)child, enabled);
                continue;
            }
            child.setEnabled(enabled);
        }
    }

    private void initComponents() {
        this.frameworksScrollPane = new JScrollPane();
        this.frameworksTable = new JTable();
        this.descriptionLabel = new JLabel();
        this.separator = new JSeparator();
        this.configPanel = new JPanel();
        this.setFocusTraversalPolicy(null);
        this.frameworksTable.setSelectionMode(0);
        this.frameworksTable.setShowHorizontalLines(false);
        this.frameworksTable.setShowVerticalLines(false);
        this.frameworksTable.setTableHeader(null);
        this.frameworksScrollPane.setViewportView(this.frameworksTable);
        this.frameworksTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpFrameworksPanelVisual.class, (String)"PhpFrameworksPanelVisual.frameworksTable.AccessibleContext.accessibleName"));
        this.frameworksTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpFrameworksPanelVisual.class, (String)"PhpFrameworksPanelVisual.frameworksTable.AccessibleContext.accessibleDescription"));
        this.descriptionLabel.setText("DUMMY");
        this.configPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.separator, -1, 64, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.descriptionLabel).addContainerGap()).addComponent(this.configPanel, -1, 64, Short.MAX_VALUE).addComponent(this.frameworksScrollPane, -1, 64, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.frameworksScrollPane, -2, 90, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separator, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.descriptionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configPanel, -1, 169, Short.MAX_VALUE)));
        this.frameworksScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpFrameworksPanelVisual.class, (String)"PhpFrameworksPanelVisual.frameworksScrollPane.AccessibleContext.accessibleName"));
        this.frameworksScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpFrameworksPanelVisual.class, (String)"PhpFrameworksPanelVisual.frameworksScrollPane.AccessibleContext.accessibleDescription"));
        this.descriptionLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpFrameworksPanelVisual.class, (String)"PhpFrameworksPanelVisual.descriptionLabel.AccessibleContext.accessibleName"));
        this.configPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpFrameworksPanelVisual.class, (String)"PhpFrameworksPanelVisual.configPanel.AccessibleContext.accessibleName"));
        this.configPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpFrameworksPanelVisual.class, (String)"PhpFrameworksPanelVisual.configPanel.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PhpFrameworksPanelVisual.class, (String)"PhpFrameworksPanelVisual.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PhpFrameworksPanelVisual.class, (String)"PhpFrameworksPanelVisual.AccessibleContext.accessibleDescription"));
    }

    private static final class FrameworkModelItem {
        private final PhpFrameworkProvider framework;
        private Boolean selected;
        private boolean valid = true;

        public FrameworkModelItem(PhpFrameworkProvider framework) {
            assert (framework != null);
            this.framework = framework;
            this.setSelected(Boolean.FALSE);
        }

        public PhpFrameworkProvider getFramework() {
            return this.framework;
        }

        public Boolean isSelected() {
            return this.selected;
        }

        public void setSelected(Boolean selected) {
            this.selected = selected;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setValid(boolean valid) {
            this.valid = valid;
        }
    }

    private static final class FrameworksTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 8082636013224696L;
        private final DefaultListModel<FrameworkModelItem> model = new DefaultListModel();

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.model.size();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return PhpFrameworkProvider.class;
                }
            }
            assert (false) : "Unknown column index: " + columnIndex;
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public Object getValueAt(int row, int column) {
            FrameworkModelItem item = this.getItem(row);
            switch (column) {
                case 0: {
                    return item.isSelected();
                }
                case 1: {
                    return item.getFramework();
                }
            }
            assert (false) : "Unknown column index: " + column;
            return "";
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            FrameworkModelItem item = this.getItem(row);
            switch (column) {
                case 0: {
                    item.setSelected((Boolean)value);
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    assert (false) : "Unknown column index: " + column;
                    break;
                }
            }
            this.fireTableCellUpdated(row, column);
        }

        FrameworkModelItem getItem(int index) {
            return this.model.get(index);
        }

        void addItem(FrameworkModelItem item) {
            this.model.addElement(item);
        }
    }

    private static final class FrameworksTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 22495101047716943L;
        private static final Color ERROR_COLOR = UIManager.getColor("nb.errorForeground");
        private static final Color NORMAL_COLOR = new JLabel().getForeground();
        private final FrameworksTableModel model;
        private TableCellRenderer booleanRenderer;

        private FrameworksTableCellRenderer(FrameworksTableModel model) {
            this.model = model;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof PhpFrameworkProvider) {
                FrameworkModelItem item = this.model.getItem(row);
                Component defaultRenderer = super.getTableCellRendererComponent(table, item.getFramework().getName(), isSelected, false, row, column);
                if (item.isValid()) {
                    defaultRenderer.setForeground(NORMAL_COLOR);
                } else {
                    defaultRenderer.setForeground(ERROR_COLOR);
                }
                return defaultRenderer;
            }
            if (value instanceof Boolean && this.booleanRenderer != null) {
                return this.booleanRenderer.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        }

        public void setBooleanRenderer(TableCellRenderer booleanRenderer) {
            this.booleanRenderer = booleanRenderer;
        }
    }
}

