/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.converter;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.converter.AbstractMessageConverter;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;

public class MappingJackson2MessageConverter
extends AbstractMessageConverter {
    private ObjectMapper objectMapper;
    private Boolean prettyPrint;

    public MappingJackson2MessageConverter() {
        super(new MimeType("application", "json", Charset.forName("UTF-8")));
        this.initObjectMapper();
    }

    public MappingJackson2MessageConverter(MimeType ... supportedMimeTypes) {
        super(Arrays.asList(supportedMimeTypes));
        this.initObjectMapper();
    }

    private void initObjectMapper() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(MapperFeature.DEFAULT_VIEW_INCLUSION, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"ObjectMapper must not be null");
        this.objectMapper = objectMapper;
        this.configurePrettyPrint();
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        this.configurePrettyPrint();
    }

    private void configurePrettyPrint() {
        if (this.prettyPrint != null) {
            this.objectMapper.configure(SerializationFeature.INDENT_OUTPUT, this.prettyPrint.booleanValue());
        }
    }

    @Override
    protected boolean canConvertFrom(Message<?> message, Class<?> targetClass) {
        AtomicReference causeRef;
        if (targetClass == null || !this.supportsMimeType(message.getHeaders())) {
            return false;
        }
        JavaType javaType = this.objectMapper.constructType(targetClass);
        if (this.objectMapper.canDeserialize(javaType, causeRef = new AtomicReference())) {
            return true;
        }
        this.logWarningIfNecessary((Type)javaType, (Throwable)causeRef.get());
        return false;
    }

    @Override
    protected boolean canConvertTo(Object payload, MessageHeaders headers) {
        if (payload == null || !this.supportsMimeType(headers)) {
            return false;
        }
        AtomicReference causeRef = new AtomicReference();
        if (this.objectMapper.canSerialize(payload.getClass(), causeRef)) {
            return true;
        }
        this.logWarningIfNecessary(payload.getClass(), (Throwable)causeRef.get());
        return false;
    }

    protected void logWarningIfNecessary(Type type, Throwable cause) {
        boolean debugLevel;
        if (cause == null) {
            return;
        }
        boolean bl = debugLevel = cause instanceof JsonMappingException && (cause.getMessage().startsWith("Can not find") || cause.getMessage().startsWith("Cannot find"));
        if (debugLevel ? this.logger.isDebugEnabled() : this.logger.isWarnEnabled()) {
            String msg = "Failed to evaluate Jackson " + (type instanceof JavaType ? "de" : "") + "serialization for type [" + type + "]";
            if (debugLevel) {
                this.logger.debug((Object)msg, cause);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.warn((Object)msg, cause);
            } else {
                this.logger.warn((Object)(msg + ": " + cause));
            }
        }
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        JavaType javaType = this.getJavaType(targetClass, conversionHint);
        Object payload = message.getPayload();
        Class<?> view = this.getSerializationView(conversionHint);
        try {
            if (payload instanceof byte[]) {
                if (view != null) {
                    return this.objectMapper.readerWithView(view).forType(javaType).readValue((byte[])payload);
                }
                return this.objectMapper.readValue((byte[])payload, javaType);
            }
            if (view != null) {
                return this.objectMapper.readerWithView(view).forType(javaType).readValue(payload.toString());
            }
            return this.objectMapper.readValue(payload.toString(), javaType);
        }
        catch (IOException ex) {
            throw new MessageConversionException(message, "Could not read JSON: " + ex.getMessage(), ex);
        }
    }

    private JavaType getJavaType(Class<?> targetClass, Object conversionHint) {
        if (conversionHint instanceof MethodParameter) {
            MethodParameter param = (MethodParameter)conversionHint;
            if (Message.class.isAssignableFrom((param = param.nestedIfOptional()).getParameterType())) {
                param = param.nested();
            }
            Type genericParameterType = param.getNestedGenericParameterType();
            Class contextClass = param.getContainingClass();
            JavaType type = this.getJavaType(genericParameterType, contextClass);
            return this.objectMapper.getTypeFactory().constructType((Type)type);
        }
        return this.objectMapper.constructType(targetClass);
    }

    private JavaType getJavaType(Type type, Class<?> contextClass) {
        TypeFactory typeFactory = this.objectMapper.getTypeFactory();
        if (contextClass != null) {
            ResolvableType resolvedType = ResolvableType.forType((Type)type);
            if (type instanceof TypeVariable) {
                ResolvableType resolvedTypeVariable = this.resolveVariable((TypeVariable)type, ResolvableType.forClass(contextClass));
                if (resolvedTypeVariable != ResolvableType.NONE) {
                    return typeFactory.constructType((Type)resolvedTypeVariable.resolve());
                }
            } else if (type instanceof ParameterizedType && resolvedType.hasUnresolvableGenerics()) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class[] generics = new Class[parameterizedType.getActualTypeArguments().length];
                Type[] typeArguments = parameterizedType.getActualTypeArguments();
                for (int i = 0; i < typeArguments.length; ++i) {
                    Type typeArgument = typeArguments[i];
                    if (typeArgument instanceof TypeVariable) {
                        ResolvableType resolvedTypeArgument = this.resolveVariable((TypeVariable)typeArgument, ResolvableType.forClass(contextClass));
                        if (resolvedTypeArgument != ResolvableType.NONE) {
                            generics[i] = resolvedTypeArgument.resolve();
                            continue;
                        }
                        generics[i] = ResolvableType.forType((Type)typeArgument).resolve();
                        continue;
                    }
                    generics[i] = ResolvableType.forType((Type)typeArgument).resolve();
                }
                return typeFactory.constructType(ResolvableType.forClassWithGenerics((Class)resolvedType.getRawClass(), (Class[])generics).getType());
            }
        }
        return typeFactory.constructType(type);
    }

    private ResolvableType resolveVariable(TypeVariable<?> typeVariable, ResolvableType contextType) {
        ResolvableType resolvedType;
        if (contextType.hasGenerics() && (resolvedType = ResolvableType.forType(typeVariable, (ResolvableType)contextType)).resolve() != null) {
            return resolvedType;
        }
        ResolvableType superType = contextType.getSuperType();
        if (superType != ResolvableType.NONE && (resolvedType = this.resolveVariable(typeVariable, superType)).resolve() != null) {
            return resolvedType;
        }
        for (ResolvableType ifc : contextType.getInterfaces()) {
            resolvedType = this.resolveVariable(typeVariable, ifc);
            if (resolvedType.resolve() == null) continue;
            return resolvedType;
        }
        return ResolvableType.NONE;
    }

    @Override
    protected Object convertToInternal(Object payload, MessageHeaders headers, Object conversionHint) {
        try {
            Class<?> view = this.getSerializationView(conversionHint);
            if (byte[].class == this.getSerializedPayloadClass()) {
                ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                JsonEncoding encoding = this.getJsonEncoding(this.getMimeType(headers));
                JsonGenerator generator = this.objectMapper.getFactory().createGenerator((OutputStream)out, encoding);
                if (view != null) {
                    this.objectMapper.writerWithView(view).writeValue(generator, payload);
                } else {
                    this.objectMapper.writeValue(generator, payload);
                }
                payload = out.toByteArray();
            } else {
                StringWriter writer = new StringWriter();
                if (view != null) {
                    this.objectMapper.writerWithView(view).writeValue((Writer)writer, payload);
                } else {
                    this.objectMapper.writeValue((Writer)writer, payload);
                }
                payload = ((Object)writer).toString();
            }
        }
        catch (IOException ex) {
            throw new MessageConversionException("Could not write JSON: " + ex.getMessage(), (Throwable)ex);
        }
        return payload;
    }

    protected Class<?> getSerializationView(Object conversionHint) {
        if (conversionHint instanceof MethodParameter) {
            JsonView annotation;
            MethodParameter param = (MethodParameter)conversionHint;
            JsonView jsonView = annotation = param.getParameterIndex() >= 0 ? (JsonView)param.getParameterAnnotation(JsonView.class) : (JsonView)param.getMethodAnnotation(JsonView.class);
            if (annotation != null) {
                return this.extractViewClass(annotation, conversionHint);
            }
        } else {
            if (conversionHint instanceof JsonView) {
                return this.extractViewClass((JsonView)conversionHint, conversionHint);
            }
            if (conversionHint instanceof Class) {
                return (Class)conversionHint;
            }
        }
        return null;
    }

    private Class<?> extractViewClass(JsonView annotation, Object conversionHint) {
        Class[] classes = annotation.value();
        if (classes.length != 1) {
            throw new IllegalArgumentException("@JsonView only supported for handler methods with exactly 1 class argument: " + conversionHint);
        }
        return classes[0];
    }

    protected JsonEncoding getJsonEncoding(MimeType contentType) {
        if (contentType != null && contentType.getCharset() != null) {
            Charset charset = contentType.getCharset();
            for (JsonEncoding encoding : JsonEncoding.values()) {
                if (!charset.name().equals(encoding.getJavaName())) continue;
                return encoding;
            }
        }
        return JsonEncoding.UTF8;
    }
}

