/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.classpath;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.classpath.AbstractProjectClassPathImpl;
import org.netbeans.spi.java.classpath.FlaggedClassPathImplementation;
import org.openide.util.Utilities;

class CompileClassPathImpl
extends AbstractProjectClassPathImpl
implements FlaggedClassPathImplementation {
    private volatile boolean incomplete;
    private final boolean addOutputDir;

    public CompileClassPathImpl(NbMavenProjectImpl proj, boolean addOutputDir) {
        super(proj);
        this.addOutputDir = addOutputDir;
    }

    @Override
    URI[] createPath() {
        ArrayList<URI> lst = new ArrayList<URI>();
        boolean broken = CompileClassPathImpl.getCompileArtifacts(this.getMavenProject().getOriginalMavenProject(), lst);
        if (this.addOutputDir) {
            lst.add(Utilities.toURI((File)this.getProject().getProjectWatcher().getOutputDirectory(false)));
        }
        if (this.incomplete != broken) {
            this.incomplete = broken;
            this.firePropertyChange("flags", null, null);
        }
        URI[] uris = new URI[lst.size()];
        uris = lst.toArray(uris);
        return uris;
    }

    static boolean getCompileArtifacts(MavenProject mavenProject, List<URI> lst) {
        List arts = mavenProject.getCompileArtifacts();
        boolean broken = false;
        for (Artifact art : arts) {
            File f = CompileClassPathImpl.getFile(art);
            if (f != null) {
                lst.add(Utilities.toURI((File)f));
                broken |= !f.exists();
                continue;
            }
            broken = true;
        }
        return broken;
    }

    public Set<ClassPath.Flag> getFlags() {
        return this.incomplete ? EnumSet.of(ClassPath.Flag.INCOMPLETE) : Collections.emptySet();
    }
}

