/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.awt.EventQueue;
import java.awt.Image;
import java.io.File;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClientFactory;
import org.netbeans.modules.subversion.options.AnnotationColorProvider;
import org.netbeans.modules.subversion.ui.blame.BlameAction;
import org.netbeans.modules.subversion.ui.commit.CommitAction;
import org.netbeans.modules.subversion.ui.history.SearchHistoryAction;
import org.netbeans.modules.subversion.ui.lock.LockAction;
import org.netbeans.modules.subversion.ui.lock.UnlockAction;
import org.netbeans.modules.subversion.ui.menu.CopyMenu;
import org.netbeans.modules.subversion.ui.menu.DiffMenu;
import org.netbeans.modules.subversion.ui.menu.IgnoreMenu;
import org.netbeans.modules.subversion.ui.menu.PatchesMenu;
import org.netbeans.modules.subversion.ui.menu.UpdateMenu;
import org.netbeans.modules.subversion.ui.menu.WorkingCopyMenu;
import org.netbeans.modules.subversion.ui.properties.SvnPropertiesAction;
import org.netbeans.modules.subversion.ui.properties.VersioningInfoAction;
import org.netbeans.modules.subversion.ui.status.StatusAction;
import org.netbeans.modules.subversion.ui.update.ResolveConflictsAction;
import org.netbeans.modules.subversion.ui.update.RevertModificationsAction;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.SystemActionBridge;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.awt.Actions;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class Annotator {
    private static final String badgeModified = "org/netbeans/modules/subversion/resources/icons/modified-badge.png";
    private static final String badgeConflicts = "org/netbeans/modules/subversion/resources/icons/conflicts-badge.png";
    private static final String toolTipModified = "<img src=\"" + Annotator.class.getClassLoader().getResource("org/netbeans/modules/subversion/resources/icons/modified-badge.png") + "\">&nbsp;" + NbBundle.getMessage(Annotator.class, (String)"MSG_Contains_Modified_Locally");
    private static final String toolTipConflict = "<img src=\"" + Annotator.class.getClassLoader().getResource("org/netbeans/modules/subversion/resources/icons/conflicts-badge.png") + "\">&nbsp;" + NbBundle.getMessage(Annotator.class, (String)"MSG_Contains_Conflicts");
    private static final int STATUS_TEXT_ANNOTABLE = 88414;
    private static final Pattern lessThan = Pattern.compile("<");
    public static final String ANNOTATION_REVISION = "revision";
    public static final String ANNOTATION_STATUS = "status";
    public static final String ANNOTATION_LOCK = "lock";
    public static final String ANNOTATION_FOLDER = "folder";
    public static final String ANNOTATION_MIME_TYPE = "mime_type";
    public static final String ANNOTATION_COMMIT_REVISION = "commit_revision";
    public static final String ANNOTATION_COMMIT_DATE = "date";
    public static final String ANNOTATION_COMMIT_AUTHOR = "author";
    public static final String[] LABELS = new String[]{"revision", "status", "lock", "folder", "mime_type", "commit_revision", "date", "author"};
    public static final String ACTIONS_PATH_PREFIX = "Actions/Subversion/";
    private final FileStatusCache cache;
    private MessageFormat format;
    private String emptyFormat;
    private boolean mimeTypeFlag;
    private boolean clientInitStarted;

    Annotator(Subversion svn) {
        this.cache = svn.getStatusCache();
        this.initDefaults();
    }

    private void initDefaults() {
        this.refresh();
    }

    public void refresh() {
        String string = SvnModuleConfig.getDefault().getAnnotationFormat();
        if (string != null && !string.trim().equals("")) {
            this.mimeTypeFlag = string.indexOf("{mime_type}") > -1;
            if (!SvnUtils.isAnnotationFormatValid(string = SvnUtils.createAnnotationFormat(string))) {
                Subversion.LOG.log(Level.WARNING, "Bad annotation format, switching to defaults");
                string = NbBundle.getMessage(Annotator.class, (String)"Annotator.defaultFormat");
                this.mimeTypeFlag = string.contains("{4}");
            }
            this.format = new MessageFormat(string);
            this.emptyFormat = this.format.format(new String[]{"", "", "", "", "", "", "", "", ""}, new StringBuffer(), (FieldPosition)null).toString().trim();
        }
        this.cache.getLabelsCache().setMimeTypeFlag(this.mimeTypeFlag);
    }

    public String annotateNameHtml(String name, FileInformation info, File file) {
        String textAnnotation;
        File[] fileArray;
        if (file == null) {
            fileArray = new File[]{};
        } else {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = file;
        }
        if (!this.checkClientAvailable("annotateNameHtml", fileArray)) {
            return name;
        }
        name = this.htmlEncode(name);
        int status = info.getStatus();
        boolean annotationsVisible = VersioningSupport.isTextAnnotationVisible();
        if (annotationsVisible && file != null && (status & 0x1595E) != 0) {
            if (this.format != null) {
                textAnnotation = this.formatAnnotation(info, file);
            } else {
                String statusText;
                String lockString = this.getLockString(info.getStatus());
                String lockStringAnnPart = lockString.isEmpty() ? "" : lockString + "; ";
                String sticky = this.cache.getLabelsCache().getLabelInfo(file, false).getStickyString();
                textAnnotation = status == 8 && "".equals(sticky) ? lockString : (status == 8 ? " [" + lockStringAnnPart + sticky + "]" : ("".equals(sticky) ? (!(statusText = info.getShortStatusText()).equals("") ? " [" + lockStringAnnPart + info.getShortStatusText() + "]" : lockString) : " [" + info.getShortStatusText() + "; " + lockStringAnnPart + sticky + "]"));
            }
        } else {
            textAnnotation = "";
        }
        if (textAnnotation.length() > 0) {
            textAnnotation = this.getAnnotationProvider().TEXT_ANNOTATION.getFormat().format(new Object[]{textAnnotation});
        }
        if (0 != (status & 0x4000)) {
            return this.getAnnotationProvider().TREECONFLICT_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x4040)) {
            return this.getAnnotationProvider().CONFLICT_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x80)) {
            return this.getAnnotationProvider().MERGEABLE_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x800)) {
            return this.getAnnotationProvider().DELETED_LOCALLY_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x100)) {
            return this.getAnnotationProvider().REMOVED_LOCALLY_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 4)) {
            return this.getAnnotationProvider().NEW_LOCALLY_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x1000)) {
            return this.getAnnotationProvider().ADDED_LOCALLY_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x10010)) {
            return this.getAnnotationProvider().MODIFIED_LOCALLY_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x400)) {
            return this.getAnnotationProvider().REMOVED_IN_REPOSITORY_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x200)) {
            return this.getAnnotationProvider().NEW_IN_REPOSITORY_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 0x20)) {
            return this.getAnnotationProvider().MODIFIED_IN_REPOSITORY_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 8)) {
            return this.getAnnotationProvider().UP_TO_DATE_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 2)) {
            return this.getAnnotationProvider().EXCLUDED_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (0 != (status & 1)) {
            return name;
        }
        if (status == 0) {
            return name;
        }
        throw new IllegalArgumentException("Unknown status: " + status);
    }

    private String formatAnnotation(FileInformation info, File file) {
        String statusString = "";
        int status = info.getStatus();
        if (status != 8) {
            statusString = info.getShortStatusText();
        }
        String lockString = this.getLockString(status);
        FileStatusCache.FileLabelCache.FileLabelInfo labelInfo = this.cache.getLabelsCache().getLabelInfo(file, this.mimeTypeFlag);
        String revisionString = labelInfo.getRevisionString();
        String binaryString = labelInfo.getBinaryString();
        String stickyString = labelInfo.getStickyString();
        String lastRev = labelInfo.getLastRevisionString();
        String lastDate = labelInfo.getLastDateString();
        String lastAuthor = labelInfo.getLastAuthorString();
        Object[] arguments = new Object[]{revisionString, statusString, stickyString, lockString, binaryString, lastRev, lastDate, lastAuthor};
        String annotation = this.format.format(arguments, new StringBuffer(), (FieldPosition)null).toString().trim();
        if (annotation.equals(this.emptyFormat)) {
            return "";
        }
        return " " + annotation;
    }

    private String annotateFolderNameHtml(String name, FileInformation info, File file) {
        String textAnnotation;
        name = this.htmlEncode(name);
        int status = info.getStatus();
        boolean annotationsVisible = VersioningSupport.isTextAnnotationVisible();
        if (annotationsVisible && file != null && (status & 0xFFFFFFFE) != 0) {
            if (this.format != null) {
                textAnnotation = this.formatAnnotation(info, file);
            } else {
                String statusText;
                String sticky = this.cache.getLabelsCache().getLabelInfo(file, false).getStickyString();
                textAnnotation = status == 8 && "".equals(sticky) ? "" : (status == 8 ? " [" + sticky + "]" : ("".equals(sticky) ? (!(statusText = info.getShortStatusText()).equals("") ? " [" + info.getShortStatusText() + "]" : "") : " [" + info.getShortStatusText() + "; " + sticky + "]"));
            }
        } else {
            textAnnotation = "";
        }
        if (textAnnotation.length() > 0) {
            textAnnotation = this.getAnnotationProvider().TEXT_ANNOTATION.getFormat().format(new Object[]{textAnnotation});
        }
        if (status == 0) {
            return name;
        }
        if (Annotator.match(status, 256)) {
            return name;
        }
        if (Annotator.match(status, 4)) {
            return this.getAnnotationProvider().UP_TO_DATE_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (Annotator.match(status, 4096)) {
            return this.getAnnotationProvider().UP_TO_DATE_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (Annotator.match(status, 8)) {
            return this.getAnnotationProvider().UP_TO_DATE_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (Annotator.match(status, 2)) {
            return this.getAnnotationProvider().EXCLUDED_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (Annotator.match(status, 2048)) {
            return name;
        }
        if (Annotator.match(status, 512)) {
            return name;
        }
        if (Annotator.match(status, 32)) {
            return name;
        }
        if (Annotator.match(status, 1024)) {
            return name;
        }
        if (Annotator.match(status, 1)) {
            return name;
        }
        if (Annotator.match(status, 128)) {
            return name;
        }
        if (Annotator.match(status, 65552)) {
            return this.getAnnotationProvider().UP_TO_DATE_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (Annotator.match(status, 16448)) {
            return name;
        }
        throw new IllegalArgumentException("Unknown status: " + status);
    }

    private static boolean match(int status, int mask) {
        return (status & mask) != 0;
    }

    private String htmlEncode(String name) {
        if (name.indexOf(60) == -1) {
            return name;
        }
        return lessThan.matcher(name).replaceAll("&lt;");
    }

    public String annotateNameHtml(File file, FileInformation info) {
        return this.annotateNameHtml(file.getName(), info, file);
    }

    public String annotateNameHtml(String name, VCSContext context, int includeStatus) {
        if (!this.checkClientAvailable("annotateNameHtml", context.getRootFiles().toArray(new File[context.getRootFiles().size()]))) {
            return name;
        }
        FileInformation mostImportantInfo = null;
        File mostImportantFile = null;
        boolean folderAnnotation = false;
        for (File file : context.getRootFiles()) {
            int status;
            if (SvnUtils.isPartOfSubversionMetadata(file)) continue;
            FileInformation info = this.cache.getCachedStatus(file);
            if (info == null) {
                File parentFile = file.getParentFile();
                Subversion.LOG.log(Level.FINE, "null cached status for: {0} in {1}", new Object[]{file, parentFile});
                this.cache.refreshAsync(file);
                info = new FileInformation(8, false);
            }
            if (((status = info.getStatus()) & includeStatus) == 0 || !this.isMoreImportant(info, mostImportantInfo)) continue;
            mostImportantInfo = info;
            mostImportantFile = file;
            folderAnnotation = file.isDirectory();
        }
        if (!folderAnnotation && context.getRootFiles().size() > 1) {
            boolean bl = folderAnnotation = !Utils.isFromMultiFileDataObject((VCSContext)context);
        }
        if (mostImportantInfo == null) {
            return null;
        }
        return folderAnnotation ? this.annotateFolderNameHtml(name, mostImportantInfo, mostImportantFile) : this.annotateNameHtml(name, mostImportantInfo, mostImportantFile);
    }

    private boolean isMoreImportant(FileInformation a, FileInformation b) {
        if (b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return SvnUtils.getComparableStatus(a.getStatus()) < SvnUtils.getComparableStatus(b.getStatus());
    }

    String annotateName(String name, Set files) {
        return null;
    }

    public static Action[] getActions(VCSContext ctx, VCSAnnotator.ActionDestination destination) {
        boolean noneVersioned;
        ArrayList<Action> actions = new ArrayList<Action>(20);
        File[] files = ctx.getRootFiles().toArray(new File[ctx.getRootFiles().size()]);
        if (EventQueue.isDispatchThread() && !Subversion.getInstance().getStatusCache().ready()) {
            noneVersioned = true;
            Subversion.LOG.log(Level.INFO, "Cache not yet initialized, showing default actions");
        } else {
            noneVersioned = Annotator.isNothingVersioned(files);
        }
        if (destination == VCSAnnotator.ActionDestination.MainMenu) {
            if (noneVersioned) {
                Action a = Utils.getAcceleratedAction((String)"Actions/Subversion/org-netbeans-modules-subversion-ui-checkout-CheckoutAction.instance");
                if (a != null) {
                    actions.add(a);
                }
                if ((a = Utils.getAcceleratedAction((String)"Actions/Subversion/org-netbeans-modules-subversion-ui-project-ImportAction.instance")) instanceof ContextAwareAction) {
                    a = ((ContextAwareAction)a).createContextAwareInstance(Lookups.fixed((Object[])files));
                }
                if (a != null) {
                    actions.add(a);
                }
            } else {
                actions.add((Action)SystemAction.get(StatusAction.class));
                actions.add(new DiffMenu(destination, null));
                actions.add((Action)SystemAction.get(CommitAction.class));
                actions.add(new UpdateMenu(destination, null));
                actions.add((Action)SystemAction.get(RevertModificationsAction.class));
                actions.add((Action)SystemAction.get(BlameAction.class));
                actions.add((Action)SystemAction.get(SearchHistoryAction.class));
                actions.add((Action)SystemAction.get(ResolveConflictsAction.class));
                actions.add(null);
                actions.add(new IgnoreMenu(null, null));
                actions.add(new PatchesMenu(destination, null));
                actions.add(null);
                actions.add(new CopyMenu(destination, null));
                Action a = Utils.getAcceleratedAction((String)"Actions/Subversion/org-netbeans-modules-subversion-ui-checkout-CheckoutAction.instance");
                if (a != null) {
                    actions.add(a);
                }
                actions.add(null);
                SystemAction unlockAction = SystemAction.get(UnlockAction.class);
                if (unlockAction.isEnabled()) {
                    actions.add((Action)unlockAction);
                } else {
                    actions.add((Action)SystemAction.get(LockAction.class));
                }
                actions.add(new WorkingCopyMenu(destination, null));
                actions.add((Action)SystemAction.get(VersioningInfoAction.class));
                actions.add((Action)SystemAction.get(SvnPropertiesAction.class));
            }
            Utils.setAcceleratorBindings((String)ACTIONS_PATH_PREFIX, (Action[])actions.toArray(new Action[actions.size()]));
        } else {
            ResourceBundle loc = NbBundle.getBundle(Annotator.class);
            Lookup context = ctx.getElements();
            if (noneVersioned) {
                Action a = Actions.forID((String)"Subversion", (String)"org.netbeans.modules.subversion.ui.project.ImportAction");
                if (a instanceof ContextAwareAction) {
                    a = ((ContextAwareAction)a).createContextAwareInstance(Lookups.fixed((Object[])files));
                }
                if (a != null) {
                    actions.add(a);
                }
            } else {
                Node[] nodes = ctx.getElements().lookupAll(Node.class).toArray(new Node[0]);
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(StatusAction.class), (String)loc.getString("CTL_PopupMenuItem_Status"), (Lookup)context));
                actions.add(new DiffMenu(destination, context));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(CommitAction.class), (String)loc.getString("CTL_PopupMenuItem_Commit"), (Lookup)context));
                actions.add(new UpdateMenu(destination, context));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(RevertModificationsAction.class), (String)loc.getString("CTL_PopupMenuItem_GetClean"), (Lookup)context));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(BlameAction.class), (String)(((BlameAction)SystemAction.get(BlameAction.class)).visible(nodes) ? loc.getString("CTL_PopupMenuItem_HideAnnotations") : loc.getString("CTL_PopupMenuItem_ShowAnnotations")), (Lookup)context));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(SearchHistoryAction.class), (String)loc.getString("CTL_PopupMenuItem_SearchHistory"), (Lookup)context));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(ResolveConflictsAction.class), (String)loc.getString("CTL_PopupMenuItem_ResolveConflicts"), (Lookup)context));
                actions.add(null);
                actions.add(new IgnoreMenu(context, nodes));
                actions.add(new PatchesMenu(destination, context));
                actions.add(null);
                actions.add(new CopyMenu(destination, context));
                Action a = Actions.forID((String)"Subversion", (String)"org.netbeans.modules.subversion.ui.checkout.CheckoutAction");
                if (a != null) {
                    actions.add(a);
                }
                actions.add(null);
                SystemActionBridge unlockAction = SystemActionBridge.createAction((Action)SystemAction.get(UnlockAction.class), (String)loc.getString("CTL_PopupMenuItem_Unlock"), (Lookup)context);
                if (unlockAction.isEnabled()) {
                    actions.add((Action)unlockAction);
                } else {
                    actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(LockAction.class), (String)loc.getString("CTL_PopupMenuItem_Lock"), (Lookup)context));
                }
                actions.add(new WorkingCopyMenu(destination, context));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(VersioningInfoAction.class), (String)loc.getString("CTL_PopupMenuItem_VersioningInfo"), (Lookup)context));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(SvnPropertiesAction.class), (String)loc.getString("CTL_PopupMenuItem_Properties"), (Lookup)context));
            }
        }
        return actions.toArray(new Action[actions.size()]);
    }

    private static boolean isNothingVersioned(File[] files) {
        for (File file : files) {
            if (!SvnUtils.isManaged(file)) continue;
            return false;
        }
        return true;
    }

    public Image annotateIcon(Image icon, VCSContext context, int includeStatus) {
        if (!this.checkClientAvailable("annotateIcon", context.getRootFiles().toArray(new File[context.getRootFiles().size()]))) {
            return null;
        }
        boolean folderAnnotation = false;
        for (File file : context.getRootFiles()) {
            if (!file.isDirectory()) continue;
            folderAnnotation = true;
            break;
        }
        if (!folderAnnotation && context.getRootFiles().size() > 1) {
            boolean bl = folderAnnotation = !Utils.isFromMultiFileDataObject((VCSContext)context);
        }
        if (!folderAnnotation) {
            return this.annotateFileIcon(context, icon, includeStatus);
        }
        return this.annotateFolderIcon(context, icon);
    }

    private Image annotateFileIcon(VCSContext context, Image icon, int includeStatus) {
        FileInformation mostImportantInfo = null;
        LinkedList<File> filesToRefresh = new LinkedList<File>();
        for (File file : context.getRootFiles()) {
            int status;
            FileInformation info = this.cache.getCachedStatus(file);
            if (info == null) {
                File parentFile = file.getParentFile();
                Subversion.LOG.log(Level.FINE, "null cached status for: {0} in {1}", new Object[]{file, parentFile});
                filesToRefresh.add(file);
                info = new FileInformation(8, false);
            }
            if (((status = info.getStatus()) & includeStatus) == 0 || !this.isMoreImportant(info, mostImportantInfo)) continue;
            mostImportantInfo = info;
        }
        this.cache.refreshAsync(filesToRefresh);
        if (mostImportantInfo == null) {
            return null;
        }
        String statusText = null;
        int status = mostImportantInfo.getStatus();
        if (0 != (status & 0x4000)) {
            statusText = this.getAnnotationProvider().TREECONFLICT_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 0x4040)) {
            statusText = this.getAnnotationProvider().CONFLICT_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 0x80)) {
            statusText = this.getAnnotationProvider().MERGEABLE_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 0x800)) {
            statusText = this.getAnnotationProvider().DELETED_LOCALLY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 0x100)) {
            statusText = this.getAnnotationProvider().REMOVED_LOCALLY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 4)) {
            statusText = this.getAnnotationProvider().NEW_LOCALLY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 0x1000)) {
            statusText = this.getAnnotationProvider().ADDED_LOCALLY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 0x10010)) {
            statusText = this.getAnnotationProvider().MODIFIED_LOCALLY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 0x400)) {
            statusText = this.getAnnotationProvider().REMOVED_IN_REPOSITORY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 0x200)) {
            statusText = this.getAnnotationProvider().NEW_IN_REPOSITORY_FILE.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 0x20)) {
            statusText = this.getAnnotationProvider().MODIFIED_IN_REPOSITORY_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 8)) {
            statusText = null;
        } else if (0 != (status & 2)) {
            statusText = this.getAnnotationProvider().EXCLUDED_FILE_TOOLTIP.getFormat().format(new Object[]{mostImportantInfo.getStatusText()});
        } else if (0 != (status & 1)) {
            statusText = null;
        } else if (status == 0) {
            statusText = null;
        } else {
            throw new IllegalArgumentException("Unknown status: " + status);
        }
        return statusText != null ? ImageUtilities.addToolTipToImage((Image)icon, (String)statusText) : null;
    }

    private Image annotateFolderIcon(VCSContext context, Image icon) {
        LinkedList<File> filesToRefresh = new LinkedList<File>();
        for (File file : context.getRootFiles()) {
            FileInformation info = this.cache.getCachedStatus(file);
            if (info == null) {
                filesToRefresh.add(file);
            }
            if (!file.isDirectory()) continue;
            Utils.addFolderToLog((File)file);
        }
        this.cache.refreshAsync(filesToRefresh);
        if (this.cache.ready()) {
            if (this.cache.containsFiles(context.getRootFiles(), 16448, false)) {
                return this.getBadge(badgeConflicts, icon, toolTipConflict);
            }
            if (this.cache.containsFiles(context.getRootFiles(), 88532, false)) {
                return this.getBadge(badgeModified, icon, toolTipModified);
            }
        }
        return icon;
    }

    private Image getBadge(String badgePath, Image origIcon, String toolTip) {
        Image ret = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)badgePath, (boolean)true), (String)toolTip);
        ret = ImageUtilities.mergeImages((Image)origIcon, (Image)ret, (int)16, (int)9);
        return ret;
    }

    private boolean checkClientAvailable(String methodName, File[] files) {
        boolean available = true;
        if (!SvnClientFactory.isInitialized() && EventQueue.isDispatchThread()) {
            if (!this.clientInitStarted) {
                this.clientInitStarted = true;
                Subversion.getInstance().getRequestProcessor().post(new Runnable(){

                    @Override
                    public void run() {
                        SvnClientFactory.init();
                        Subversion.getInstance().refreshAllAnnotations();
                    }
                });
            }
            Subversion.LOG.log(Level.FINE, " skipping {0} due to not yet initialized client", methodName);
            available = false;
        } else if (!SvnClientFactory.isClientAvailable()) {
            Subversion.LOG.log(Level.FINE, " skipping {0} due to missing client", methodName);
            available = false;
        }
        return available;
    }

    private AnnotationColorProvider getAnnotationProvider() {
        return AnnotationColorProvider.getInstance();
    }

    private String getLockString(int status) {
        String lockString = "";
        if ((status & 0x2000) != 0) {
            lockString = "K";
        } else if ((status & 0x8000) != 0) {
            lockString = "O";
        }
        return lockString;
    }
}

