/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.target.iterator.api;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.target.iterator.api.BrowseFolders;
import org.netbeans.modules.target.iterator.api.TargetChooserPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.NbBundle;

public final class TargetChooserPanelGUI<T>
extends JPanel
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = -1977566644151991912L;
    private JButton browseButton;
    private JPanel customPanel;
    private JTextField documentNameTextField;
    private JTextField fileTextField;
    private JPanel fillerPanel;
    private JLabel folderLabel;
    private JTextField folderTextField;
    private JComboBox locationCB;
    private JLabel locationLabel;
    private JLabel nameLabel;
    private JLabel pathLabel;
    private JLabel projectLabel;
    private JTextField projectTextField;
    private JSeparator targetSeparator;
    private TargetChooserPanel<T> myWizardPanel;

    public TargetChooserPanelGUI(TargetChooserPanel<T> wizardPanel) {
        this.myWizardPanel = wizardPanel;
        this.initComponents();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_TargetPanel", (Object)wizardPanel.getProvider().getUIManager().getAccessibleDescription()));
        wizardPanel.getProvider().getUIManager().initComponents(this.customPanel, wizardPanel, this);
        this.browseButton.addActionListener(this);
        this.documentNameTextField.getDocument().addDocumentListener(this);
        this.folderTextField.getDocument().addDocumentListener(this);
        this.setName(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"TITLE_name_location"));
    }

    public String getDocumentName() {
        return this.documentNameTextField.getText().trim();
    }

    public String getFolder() {
        return this.folderTextField.getText();
    }

    public void setFile(String text) {
        this.fileTextField.setText(text);
    }

    public String getFile() {
        return this.fileTextField.getText();
    }

    public void setNameLabel(String name) {
        this.nameLabel.setText(name);
    }

    public void addLocationListener(ActionListener listener) {
        this.locationCB.addActionListener(listener);
    }

    public String getSelectedFolder() {
        return this.getLocationRoot().getName();
    }

    public void initValues() {
        FileObject folder;
        String documentName;
        this.getPanel().getProvider().getUIManager().initValues(this.getPanel(), this);
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.getPanel().getProject()).getDisplayName());
        if (this.getPanel().getSourceGroups() != null && this.getPanel().getSourceGroups().length > 0) {
            this.locationCB.setModel(new DefaultComboBoxModel<Object>(this.getLocations(this.getPanel().getSourceGroups())));
        } else {
            this.locationCB.setModel(new DefaultComboBoxModel<Object>(new Object[]{new LocationItem(this.getPanel().getProject().getProjectDirectory())}));
        }
        String target = null;
        FileObject preselectedFolder = Templates.getTargetFolder((WizardDescriptor)this.getPanel().getTemplateWizard());
        if (preselectedFolder != null) {
            for (int item = 0; target == null && item < this.locationCB.getModel().getSize(); ++item) {
                FileObject docBase = ((LocationItem)this.locationCB.getModel().getElementAt(item)).getFileObject();
                if (!preselectedFolder.equals(docBase) && !FileUtil.isParentOf((FileObject)docBase, (FileObject)preselectedFolder)) continue;
                target = FileUtil.getRelativePath((FileObject)docBase, (FileObject)preselectedFolder);
                this.locationCB.getModel().setSelectedItem(this.locationCB.getModel().getElementAt(item));
                break;
            }
        }
        this.getPanel().getProvider().getUIManager().initFolderValue(this.getPanel(), target, this.folderTextField);
        String newDocumentName = documentName = this.getPanel().getProvider().getNewFileName();
        File targetFolder = this.getFileCreationRoot();
        if (targetFolder != null && (folder = FileUtil.toFileObject((File)targetFolder)) != null) {
            FileObject _tmp;
            int index = 0;
            while ((_tmp = folder.getFileObject(documentName, this.getPanel().getProvider().getExpectedExtension(this.getPanel()))) != null) {
                documentName = newDocumentName + ++index;
            }
        }
        this.documentNameTextField.setText(documentName);
    }

    private Object[] getLocations(SourceGroup[] folders) {
        Object[] loc = new Object[folders.length];
        for (int i = 0; i < folders.length; ++i) {
            loc[i] = new LocationItem(folders[i]);
        }
        return loc;
    }

    private String getRelativeSourcesFolder() {
        FileObject sourcesBase = ((LocationItem)this.locationCB.getModel().getSelectedItem()).getFileObject();
        String sourceDir = this.getPanel().getProvider().getRelativeSourcesFolder(this.getPanel(), sourcesBase);
        if (sourceDir == null) {
            sourceDir = "";
        }
        return sourceDir.length() == 0 ? "" : sourceDir + '/';
    }

    public String getRelativeTargetFolder() {
        return this.getRelativeSourcesFolder() + this.getNormalizedFolder();
    }

    public String getNormalizedFolder() {
        int i;
        String norm = this.folderTextField.getText().trim();
        if (norm.length() == 0) {
            return "";
        }
        norm = norm.replace('\\', '/');
        for (i = 0; i < norm.length() && norm.charAt(i) == '/'; ++i) {
        }
        if (i == norm.length()) {
            return "";
        }
        norm = norm.substring(i);
        StringTokenizer tokens = new StringTokenizer(norm, "/");
        StringBuilder buf = new StringBuilder(tokens.nextToken());
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.length() <= 0) continue;
            buf.append('/');
            buf.append(token);
        }
        return buf.toString();
    }

    public String getTargetFolder() {
        return this.getTargetFile().getPath();
    }

    public File getTargetFile() {
        String text = this.getRelativeTargetFolder();
        return this.getPanel().getProvider().getTargetFile(this.getPanel(), this.getLocationRoot(), text);
    }

    public String getTargetName() {
        String text = this.documentNameTextField.getText().trim();
        if (text.length() == 0) {
            return null;
        }
        return text;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.browseButton == e.getSource()) {
            FileObject fo = null;
            if (this.getPanel().getSourceGroups() != null) {
                fo = BrowseFolders.showDialog(this.getPanel().getSourceGroups(), DataFolder.class, this.folderTextField.getText().replace(File.separatorChar, '/'));
            } else {
                Sources sources = ProjectUtils.getSources((Project)this.getPanel().getProject());
                fo = BrowseFolders.showDialog(sources.getSourceGroups("generic"), DataFolder.class, this.folderTextField.getText().replace(File.separatorChar, '/'));
            }
            if (fo != null && fo.isFolder()) {
                FileObject root = ((LocationItem)this.locationCB.getSelectedItem()).getFileObject();
                this.folderTextField.setText(FileUtil.getRelativePath((FileObject)root, (FileObject)fo));
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        File rootDirFile = FileUtil.toFile((FileObject)((LocationItem)this.locationCB.getSelectedItem()).getFileObject());
        if (rootDirFile != null) {
            String documentName = this.documentNameTextField.getText().trim();
            if (documentName.length() == 0) {
                this.fileTextField.setText("");
            } else {
                StringBuilder name = new StringBuilder(documentName);
                String ext = this.getPanel().getProvider().getResultExtension(this.getPanel());
                if (ext != null && ext.length() > 0) {
                    name.append('.');
                    name.append(ext);
                }
                File newFile = new File(new File(rootDirFile, this.folderTextField.getText().replace('/', File.separatorChar)), name.toString());
                this.fileTextField.setText(newFile.getAbsolutePath());
            }
        } else {
            this.fileTextField.setText("");
        }
        this.getPanel().getProvider().getUIManager().changeUpdate(e, this.getPanel());
        this.myWizardPanel.fireChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    String getErrorMessage() {
        return this.getPanel().getProvider().getUIManager().getErrorMessage(this.getPanel());
    }

    boolean isPanelValid() {
        return this.getPanel().getProvider().getUIManager().isPanelValid();
    }

    FileObject getLocationRoot() {
        return ((LocationItem)this.locationCB.getModel().getSelectedItem()).getFileObject();
    }

    String getCreatedFilePath() {
        return this.fileTextField.getText();
    }

    private File getFileCreationRoot() {
        File rootDirFile = FileUtil.toFile((FileObject)((LocationItem)this.locationCB.getSelectedItem()).getFileObject());
        if (rootDirFile != null) {
            return new File(rootDirFile, this.folderTextField.getText().replace('/', File.separatorChar));
        }
        return null;
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.documentNameTextField = new JTextField();
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationCB = new JComboBox();
        this.folderLabel = new JLabel();
        this.folderTextField = new JTextField();
        this.browseButton = new JButton();
        this.pathLabel = new JLabel();
        this.fileTextField = new JTextField();
        this.targetSeparator = new JSeparator();
        this.customPanel = new JPanel();
        this.fillerPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.nameLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_FileName_mnem").charAt(0));
        this.nameLabel.setLabelFor(this.documentNameTextField);
        this.nameLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_JspName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.add((Component)this.documentNameTextField, gridBagConstraints);
        this.documentNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_FileName"));
        this.projectLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_Project_mnem").charAt(0));
        this.projectLabel.setLabelFor(this.projectTextField);
        this.projectLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Project"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.projectLabel, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_Project"));
        this.locationLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_Location_mnem").charAt(0));
        this.locationLabel.setLabelFor(this.locationCB);
        this.locationLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.locationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.locationCB, gridBagConstraints);
        this.locationCB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_Location"));
        this.folderLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_Folder_mnem").charAt(0));
        this.folderLabel.setLabelFor(this.folderTextField);
        this.folderLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Folder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.folderLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.folderTextField, gridBagConstraints);
        this.folderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_Folder"));
        this.browseButton.setMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Browse_Mnemonic").charAt(0));
        this.browseButton.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_Browse"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"ACSD_Browse"));
        this.pathLabel.setDisplayedMnemonic(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_CreatedFile_mnem").charAt(0));
        this.pathLabel.setLabelFor(this.fileTextField);
        this.pathLabel.setText(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"LBL_CreatedFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.pathLabel, gridBagConstraints);
        this.fileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.fileTextField, gridBagConstraints);
        this.fileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TargetChooserPanelGUI.class, (String)"A11Y_DESC_CreatedFile"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.customPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.customPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.fillerPanel, gridBagConstraints);
    }

    private TargetChooserPanel<T> getPanel() {
        return this.myWizardPanel;
    }

    public static class LocationItem {
        FileObject myFileObject;
        SourceGroup myGroup;

        public LocationItem(FileObject fo) {
            this.myFileObject = fo;
        }

        public LocationItem(SourceGroup group) {
            this.myFileObject = group.getRootFolder();
            this.myGroup = group;
        }

        public FileObject getFileObject() {
            return this.myFileObject;
        }

        public String toString() {
            return this.myGroup == null ? this.myFileObject.getName() : this.myGroup.getDisplayName();
        }
    }
}

