/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.lsp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.lsp.StructureElement;
import org.netbeans.modules.lsp.StructureElementAccessor;
import org.openide.filesystems.FileObject;

public interface StructureProvider {
    @NonNull
    public List<StructureElement> getStructure(@NonNull Document var1);

    public static Builder newBuilder(@NonNull String name, @NonNull StructureElement.Kind kind) {
        return new Builder(name, kind);
    }

    public static Builder copy(@NonNull StructureElement from) {
        Builder builder = new Builder(from.getName(), from.getKind());
        builder.detail(from.getDetail()).children(from.getChildren());
        builder.selectionStartOffset(from.getSelectionStartOffset()).selectionEndOffset(from.getSelectionEndOffset());
        builder.expandedStartOffset(from.getExpandedStartOffset()).expandedEndOffset(from.getExpandedEndOffset());
        builder.tags(from.getTags());
        return builder;
    }

    public static final class Builder {
        private String name;
        private String detail;
        private int selectionStartOffset;
        private int selectionEndOffset;
        private int expandedStartOffset;
        private int expandedEndOffset;
        private StructureElement.Kind kind;
        private Set<StructureElement.Tag> tags;
        private List<StructureElement> children;
        private FileObject file;

        private Builder(@NonNull String name, @NonNull StructureElement.Kind kind) {
            this.name = name;
            this.kind = kind;
        }

        @NonNull
        public Builder name(@NonNull String name) {
            this.name = name;
            return this;
        }

        @NonNull
        public Builder kind(@NonNull StructureElement.Kind name) {
            this.kind = this.kind;
            return this;
        }

        @NonNull
        public Builder detail(@NonNull String detail) {
            this.detail = detail;
            return this;
        }

        @NonNull
        public Builder selectionStartOffset(int selectionStartOffset) {
            this.selectionStartOffset = selectionStartOffset;
            return this;
        }

        @NonNull
        public Builder selectionEndOffset(int selectionEndOffset) {
            this.selectionEndOffset = selectionEndOffset;
            return this;
        }

        @NonNull
        public Builder expandedStartOffset(int expandedStartOffset) {
            this.expandedStartOffset = expandedStartOffset;
            return this;
        }

        @NonNull
        public Builder expandedEndOffset(int expandedEndOffset) {
            this.expandedEndOffset = expandedEndOffset;
            return this;
        }

        @NonNull
        public Builder addTag(@NonNull StructureElement.Tag tag) {
            if (this.tags == null) {
                this.tags = new HashSet<StructureElement.Tag>();
            }
            this.tags.add(tag);
            return this;
        }

        @NonNull
        public Builder tags(@NonNull Set<StructureElement.Tag> tags) {
            this.tags = tags;
            return this;
        }

        @NonNull
        public Builder children(StructureElement ... children) {
            if (this.children == null) {
                this.children = new ArrayList<StructureElement>();
            }
            for (StructureElement structureElement : children) {
                this.children.add(structureElement);
            }
            return this;
        }

        @NonNull
        public Builder children(@NonNull List<StructureElement> children) {
            if (this.children == null) {
                this.children = new ArrayList<StructureElement>();
            }
            this.children.addAll(children);
            return this;
        }

        public Builder file(FileObject f) {
            this.file = f;
            return this;
        }

        @NonNull
        public StructureElement build() {
            return StructureElementAccessor.getDefault().createStructureElement(this.file, this.name, this.detail, this.selectionStartOffset, this.selectionEndOffset, this.expandedStartOffset, this.expandedEndOffset, this.kind, this.tags, this.children);
        }
    }
}

