/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSNumber;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObject;

@ExportLibrary(value=InteropLibrary.class)
public final class JSNumberObject
extends JSNonProxyObject {
    private final Number number;

    protected JSNumberObject(Shape shape, Number number) {
        super(shape);
        this.number = number;
    }

    public Number getNumber() {
        return this.number;
    }

    @Override
    public String getClassName() {
        return "Number";
    }

    public static DynamicObject create(Shape shape, Number value) {
        return new JSNumberObject(shape, value);
    }

    public static DynamicObject create(JSRealm realm, JSObjectFactory factory, Number value) {
        return factory.initProto(new JSNumberObject(factory.getShape(realm), value), realm);
    }

    @ExportMessage
    public boolean isNumber() {
        return true;
    }

    @ExportMessage
    public boolean fitsInByte(@Cached.Shared(value="numberLib") @CachedLibrary(limit="1") InteropLibrary numberLib) {
        return numberLib.fitsInByte((Object)JSNumber.valueOf(this));
    }

    @ExportMessage
    public boolean fitsInShort(@Cached.Shared(value="numberLib") @CachedLibrary(limit="1") InteropLibrary numberLib) {
        return numberLib.fitsInShort((Object)JSNumber.valueOf(this));
    }

    @ExportMessage
    public boolean fitsInInt(@Cached.Shared(value="numberLib") @CachedLibrary(limit="1") InteropLibrary numberLib) {
        return numberLib.fitsInInt((Object)JSNumber.valueOf(this));
    }

    @ExportMessage
    public boolean fitsInLong(@Cached.Shared(value="numberLib") @CachedLibrary(limit="1") InteropLibrary numberLib) {
        return numberLib.fitsInLong((Object)JSNumber.valueOf(this));
    }

    @ExportMessage
    public boolean fitsInFloat(@Cached.Shared(value="numberLib") @CachedLibrary(limit="1") InteropLibrary numberLib) {
        return numberLib.fitsInFloat((Object)JSNumber.valueOf(this));
    }

    @ExportMessage
    public boolean fitsInDouble(@Cached.Shared(value="numberLib") @CachedLibrary(limit="1") InteropLibrary numberLib) {
        return numberLib.fitsInDouble((Object)JSNumber.valueOf(this));
    }

    @ExportMessage
    public byte asByte(@Cached.Shared(value="numberLib") @CachedLibrary(limit="1") InteropLibrary numberLib) throws UnsupportedMessageException {
        if (this.fitsInByte(numberLib)) {
            return numberLib.asByte((Object)JSNumber.valueOf(this));
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public short asShort(@Cached.Shared(value="numberLib") @CachedLibrary(limit="1") InteropLibrary numberLib) throws UnsupportedMessageException {
        if (this.fitsInShort(numberLib)) {
            return numberLib.asShort((Object)JSNumber.valueOf(this));
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public int asInt(@Cached.Shared(value="numberLib") @CachedLibrary(limit="1") InteropLibrary numberLib) throws UnsupportedMessageException {
        if (this.fitsInInt(numberLib)) {
            return numberLib.asInt((Object)JSNumber.valueOf(this));
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public long asLong(@Cached.Shared(value="numberLib") @CachedLibrary(limit="1") InteropLibrary numberLib) throws UnsupportedMessageException {
        if (this.fitsInLong(numberLib)) {
            return numberLib.asLong((Object)JSNumber.valueOf(this));
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public float asFloat(@Cached.Shared(value="numberLib") @CachedLibrary(limit="1") InteropLibrary numberLib) throws UnsupportedMessageException {
        if (this.fitsInFloat(numberLib)) {
            return numberLib.asFloat((Object)JSNumber.valueOf(this));
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public double asDouble(@Cached.Shared(value="numberLib") @CachedLibrary(limit="1") InteropLibrary numberLib) throws UnsupportedMessageException {
        if (this.fitsInDouble(numberLib)) {
            return numberLib.asDouble((Object)JSNumber.valueOf(this));
        }
        throw UnsupportedMessageException.create();
    }
}

