/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.ErrorStackTraceLimitNodeGen;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsIntNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSErrorType;

public abstract class ErrorStackTraceLimitNode
extends JavaScriptBaseNode {
    private final JSContext context;
    @Node.Child
    private PropertyGetNode getStackTraceLimit;
    @Node.Child
    private JSToIntegerAsIntNode toInteger;

    protected ErrorStackTraceLimitNode(JSContext context) {
        this.context = context;
        this.getStackTraceLimit = PropertyGetNode.create("stackTraceLimit", false, context);
        this.toInteger = JSToIntegerAsIntNode.create();
    }

    public static ErrorStackTraceLimitNode create(JSContext context) {
        return ErrorStackTraceLimitNodeGen.create(context);
    }

    @Specialization
    public int doInt() {
        DynamicObject errorConstructor = this.context.getRealm().getErrorConstructor(JSErrorType.Error);
        return Math.max(0, this.toInteger.executeInt(this.getStackTraceLimit.getValue(errorConstructor)));
    }

    public abstract int executeInt();
}

