/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.image;

import java.beans.PropertyVetoException;
import java.util.Enumeration;
import javax.swing.SwingUtilities;
import org.netbeans.modules.image.ImageDataObject;
import org.netbeans.modules.image.ImageViewer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.OpenSupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;

public class ImageOpenSupport
extends OpenSupport
implements OpenCookie,
CloseCookie {
    private long lastSaveTime;
    private FileChangeListener fileChangeL;
    private RequestProcessor.Task reloadTask;

    public ImageOpenSupport(MultiDataObject.Entry entry) {
        super(entry, (OpenSupport.Env)new Environment((DataObject)entry.getDataObject()));
    }

    public CloneableTopComponent createCloneableTopComponent() {
        this.prepareViewer();
        return new ImageViewer((ImageDataObject)this.entry.getDataObject());
    }

    void prepareViewer() {
        if (this.fileChangeL == null) {
            this.fileChangeL = new FileChangeAdapter(){

                public void fileChanged(FileEvent evt) {
                    if (ImageOpenSupport.this.allEditors.isEmpty()) {
                        return;
                    }
                    if (evt.getFile().isVirtual()) {
                        ImageOpenSupport.this.entry.getFile().removeFileChangeListener((FileChangeListener)this);
                        ((Environment)ImageOpenSupport.this.env).fileRemoved();
                        ImageOpenSupport.this.entry.getFile().addFileChangeListener((FileChangeListener)this);
                        return;
                    }
                    if (evt.getTime() > ImageOpenSupport.this.lastSaveTime) {
                        ImageOpenSupport.this.lastSaveTime = System.currentTimeMillis();
                        if (ImageOpenSupport.this.reloadTask == null || ImageOpenSupport.this.reloadTask.isFinished()) {
                            ImageOpenSupport.this.reloadTask = RequestProcessor.getDefault().post(() -> ImageOpenSupport.this.reload());
                        }
                    }
                }
            };
        }
        this.entry.getFile().addFileChangeListener(this.fileChangeL);
        this.lastSaveTime = System.currentTimeMillis();
    }

    void lastClosed() {
        if (this.fileChangeL != null) {
            this.entry.getFile().removeFileChangeListener(this.fileChangeL);
            this.fileChangeL = null;
        }
    }

    private void reload() {
        String msg = NbBundle.getMessage(ImageOpenSupport.class, (String)"MSG_ExternalChange", (Object)this.entry.getFile());
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, 0);
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        if (NotifyDescriptor.YES_OPTION.equals(ret)) {
            ImageDataObject imageObj = (ImageDataObject)this.entry.getDataObject();
            CloneableTopComponent.Ref editors = this.allEditors;
            Enumeration e = editors.getComponents();
            while (e.hasMoreElements()) {
                Object pane = e.nextElement();
                SwingUtilities.invokeLater(() -> ((ImageViewer)((Object)((Object)pane))).updateView(imageObj));
            }
        }
    }

    private static class Environment
    extends OpenSupport.Env {
        static final long serialVersionUID = -1934890789745432254L;

        public Environment(DataObject dataObject) {
            super(dataObject);
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getCookie(OpenCookie.class);
        }

        private void fileRemoved() {
            try {
                this.fireVetoableChange("valid", Boolean.TRUE, Boolean.FALSE);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.firePropertyChange("valid", Boolean.TRUE, Boolean.FALSE);
        }
    }
}

