/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;
import org.netbeans.modules.form.layoutdesign.VisualMapper;

public class LayoutUtils
implements LayoutConstants {
    private LayoutUtils() {
    }

    public static LayoutInterval getAdjacentEmptySpace(LayoutComponent comp, int dimension, int direction) {
        LayoutInterval gapNeighbor;
        LayoutInterval interval = comp.getLayoutInterval(dimension);
        LayoutInterval gap = LayoutInterval.getNeighbor(interval, direction, false, true, false);
        if (gap != null && gap.isEmptySpace() && ((gapNeighbor = LayoutInterval.getDirectNeighbor(gap, direction ^ 1, true)) == interval || LayoutInterval.isPlacedAtBorder(interval, gapNeighbor, dimension, direction))) {
            return gap;
        }
        return null;
    }

    public static boolean hasAdjacentComponent(LayoutComponent comp, int dimension, int direction) {
        return LayoutInterval.getNeighbor(comp.getLayoutInterval(dimension), direction, true, true, false) != null;
    }

    static LayoutInterval getOutermostComponent(LayoutInterval interval, int dimension, int alignment) {
        if (interval.isComponent()) {
            return interval;
        }
        assert (alignment == 0 || alignment == 1);
        if (interval.isSequential()) {
            int i;
            int d = alignment == 0 ? 1 : -1;
            int n = i = alignment == 0 ? 0 : interval.getSubIntervalCount() - 1;
            while (i >= 0 && i < interval.getSubIntervalCount()) {
                LayoutInterval li = interval.getSubInterval(i);
                if (li.isEmptySpace()) {
                    i += d;
                    continue;
                }
                return LayoutUtils.getOutermostComponent(li, dimension, alignment);
            }
        } else if (interval.isParallel()) {
            LayoutInterval best = null;
            int pos = Integer.MAX_VALUE;
            int n = interval.getSubIntervalCount();
            for (int i = 0; i < n; ++i) {
                LayoutInterval li = interval.getSubInterval(i);
                if ((li = LayoutUtils.getOutermostComponent(li, dimension, alignment)) == null) continue;
                if (LayoutInterval.isAlignedAtBorder(li, interval, alignment)) {
                    return li;
                }
                int p = li.getCurrentSpace().positions[dimension][alignment] * (alignment == 0 ? 1 : -1);
                if (p >= pos) continue;
                best = li;
                pos = p;
            }
            return best;
        }
        return null;
    }

    static boolean anythingAtGroupEdge(LayoutInterval group, LayoutInterval exclude, int dimension, int alignment) {
        LinkedList<LayoutInterval> list = new LinkedList<LayoutInterval>();
        list.add(group);
        while (!list.isEmpty()) {
            LayoutInterval interval = (LayoutInterval)list.remove(0);
            if (interval.isParallel()) {
                Iterator<LayoutInterval> it = interval.getSubIntervals();
                while (it.hasNext()) {
                    LayoutInterval li = it.next();
                    if (li == exclude || !LayoutInterval.isAlignedAtBorder(li, interval, alignment) && !LayoutInterval.isPlacedAtBorder(li, interval, dimension, alignment)) continue;
                    if (li.isComponent()) {
                        return true;
                    }
                    if (!li.isGroup()) continue;
                    list.add(li);
                }
                continue;
            }
            if (!interval.isSequential()) continue;
            LayoutInterval li = interval.getSubInterval(alignment == 0 ? 0 : interval.getSubIntervalCount() - 1);
            if (li.isComponent() || li.isEmptySpace() && li.getPreferredSize() == -1 && !LayoutInterval.canResize(li)) {
                return true;
            }
            if (!li.isParallel()) continue;
            list.add(li);
        }
        return false;
    }

    static int getRemainingCount(LayoutInterval group, List<LayoutInterval> componentsToRemove, boolean nonEmpty) {
        int remainingCount = LayoutInterval.getCount(group, Integer.MAX_VALUE, nonEmpty);
        Iterator<LayoutInterval> it = group.getSubIntervals();
        while (it.hasNext()) {
            LayoutInterval sub = it.next();
            boolean allToRemove = false;
            Iterator<LayoutInterval> it2 = LayoutUtils.getComponentIterator(sub);
            while (it2.hasNext() && (allToRemove = componentsToRemove.contains(it2.next()))) {
            }
            if (!allToRemove) continue;
            --remainingCount;
        }
        return remainingCount;
    }

    static int getPositionWithoutGap(Collection<LayoutInterval> intervals, int dimension, int alignment) {
        assert (alignment == 0 || alignment == 1);
        int outermostPos = Integer.MIN_VALUE;
        for (LayoutInterval li : intervals) {
            int pos;
            assert (!li.isEmptySpace());
            LayoutInterval interval = null;
            if (li.isSequential()) {
                int idx;
                int n = idx = alignment == 0 ? 0 : li.getSubIntervalCount() - 1;
                while (idx >= 0 && idx < li.getSubIntervalCount() && (interval = li.getSubInterval(idx)).isEmptySpace()) {
                    interval = null;
                    idx += alignment == 0 ? 1 : -1;
                }
            } else {
                interval = li;
            }
            if (interval == null || !LayoutRegion.isValidCoordinate(pos = interval.getCurrentSpace().positions[dimension][alignment]) || outermostPos != Integer.MIN_VALUE && (alignment != 0 || pos >= outermostPos) && (alignment != 1 || pos <= outermostPos)) continue;
            outermostPos = pos;
        }
        return outermostPos;
    }

    static int getSizeOfDefaultGap(LayoutInterval gap, VisualMapper visualMapper) {
        LayoutConstants.PaddingType gapType = gap.getPaddingType() != null ? gap.getPaddingType() : LayoutConstants.PaddingType.RELATED;
        int[] pads = LayoutUtils.getSizesOfDefaultGap(gap, gapType, visualMapper);
        return pads != null && pads.length > 0 ? pads[0] : 0;
    }

    static int[] getSizesOfDefaultGap(LayoutInterval gap, VisualMapper visualMapper) {
        return LayoutUtils.getSizesOfDefaultGap(gap, null, visualMapper);
    }

    private static int[] getSizesOfDefaultGap(LayoutInterval interval, LayoutConstants.PaddingType gapType, VisualMapper visualMapper) {
        assert (interval.isEmptySpace());
        LayoutInterval parent = interval.getParent();
        if (parent.isParallel()) {
            return new int[]{interval.getPreferredSize()};
        }
        LayoutInterval candidate = interval;
        LayoutInterval srcInt = null;
        LayoutInterval targetInt = null;
        while (parent != null && (srcInt == null || targetInt == null)) {
            int index = parent.indexOf(candidate);
            if (srcInt == null && index > 0) {
                srcInt = parent.getSubInterval(index - 1);
            }
            if (targetInt == null && index < parent.getSubIntervalCount() - 1) {
                targetInt = parent.getSubInterval(index + 1);
            }
            if (srcInt != null && targetInt != null) continue;
            do {
                candidate = parent;
            } while ((parent = parent.getParent()) != null && parent.isParallel());
        }
        List<LayoutInterval> sources = LayoutUtils.getSideComponents(srcInt, 1, true, false);
        List<LayoutInterval> targets = LayoutUtils.getSideComponents(targetInt, 0, true, false);
        return LayoutUtils.getSizesOfDefaultGap(sources, targets, gapType, visualMapper, null, Collections.emptyMap());
    }

    static int[] getSizesOfDefaultGap(List sources, List targets, LayoutConstants.PaddingType gapType, VisualMapper visualMapper, String contId, Map<String, LayoutRegion> boundsMap) {
        int[] sizes;
        LayoutRegion region;
        if (sources != null && sources.isEmpty() || targets != null && targets.isEmpty()) {
            return null;
        }
        sources = sources == null ? Collections.EMPTY_LIST : sources;
        targets = targets == null ? Collections.EMPTY_LIST : targets;
        boolean containerGap = false;
        int containerGapAlignment = -1;
        LayoutInterval temp = null;
        if (sources.isEmpty()) {
            if (targets.isEmpty()) {
                return new int[]{0};
            }
            containerGap = true;
            containerGapAlignment = 0;
            temp = (LayoutInterval)targets.get(0);
        } else {
            temp = (LayoutInterval)sources.get(0);
            if (targets.isEmpty()) {
                containerGap = true;
                containerGapAlignment = 1;
            }
        }
        int dimension = temp == temp.getComponent().getLayoutInterval(0) ? 0 : 1;
        int max = Short.MIN_VALUE;
        int min = Short.MAX_VALUE;
        boolean positionsNotUpdated = false;
        for (LayoutInterval source : sources) {
            region = LayoutUtils.sizeOfEmptySpaceHelper(source, boundsMap);
            int trailing = region.positions[dimension][1];
            if (trailing == Integer.MIN_VALUE) {
                positionsNotUpdated = true;
                break;
            }
            max = Math.max(max, trailing);
        }
        Iterator iter = targets.iterator();
        while (iter.hasNext()) {
            LayoutInterval target = (LayoutInterval)iter.next();
            region = LayoutUtils.sizeOfEmptySpaceHelper(target, boundsMap);
            int leading = region.positions[dimension][0];
            if (leading == Integer.MIN_VALUE) {
                positionsNotUpdated = true;
                break;
            }
            min = Math.min(min, leading);
        }
        if (containerGap) {
            sizes = new int[1];
            Iterator iterator = iter = sources.isEmpty() ? targets.iterator() : sources.iterator();
            while (iter.hasNext()) {
                int delta;
                LayoutInterval interval = (LayoutInterval)iter.next();
                LayoutComponent component = interval.getComponent();
                LayoutRegion region2 = LayoutUtils.sizeOfEmptySpaceHelper(interval, boundsMap);
                String parentId = contId == null ? component.getParent().getId() : contId;
                int padding = visualMapper.getPreferredPaddingInParent(parentId, component.getId(), dimension, containerGapAlignment);
                int position = region2.positions[dimension][containerGapAlignment];
                int n = delta = containerGapAlignment == 0 ? position - min : max - position;
                if (!positionsNotUpdated) {
                    padding -= delta;
                }
                sizes[0] = Math.max(sizes[0], padding);
            }
        } else {
            LayoutConstants.PaddingType[] paddingTypeArray;
            if (gapType != null) {
                LayoutConstants.PaddingType[] paddingTypeArray2 = new LayoutConstants.PaddingType[1];
                paddingTypeArray = paddingTypeArray2;
                paddingTypeArray2[0] = gapType;
            } else {
                paddingTypeArray = PADDINGS;
            }
            LayoutConstants.PaddingType[] paddingTypes = paddingTypeArray;
            sizes = new int[paddingTypes.length];
            for (LayoutInterval srcCandidate : sources) {
                String srcId = srcCandidate.getComponent().getId();
                LayoutRegion srcRegion = LayoutUtils.sizeOfEmptySpaceHelper(srcCandidate, boundsMap);
                int srcDelta = max - srcRegion.positions[dimension][1];
                for (LayoutInterval targetCandidate : targets) {
                    String targetId = targetCandidate.getComponent().getId();
                    LayoutRegion targetRegion = LayoutUtils.sizeOfEmptySpaceHelper(targetCandidate, boundsMap);
                    int targetDelta = targetRegion.positions[dimension][0] - min;
                    for (int i = 0; i < paddingTypes.length; ++i) {
                        LayoutConstants.PaddingType type = paddingTypes[i];
                        int padding = visualMapper.getPreferredPadding(srcId, targetId, dimension, 0, type);
                        if (!positionsNotUpdated) {
                            padding -= srcDelta + targetDelta;
                        }
                        sizes[i] = Math.max(sizes[i], padding);
                    }
                }
            }
        }
        return sizes;
    }

    private static LayoutRegion sizeOfEmptySpaceHelper(LayoutInterval interval, Map<String, LayoutRegion> boundsMap) {
        LayoutComponent component = interval.getComponent();
        String compId = component.getId();
        if (boundsMap.containsKey(compId)) {
            return boundsMap.get(compId);
        }
        return interval.getCurrentSpace();
    }

    static int getVisualPosition(LayoutInterval interval, int dimension, int alignment) {
        if (interval.isEmptySpace()) {
            assert (alignment == 0 || alignment == 1);
            LayoutInterval neighbor = LayoutInterval.getDirectNeighbor(interval, alignment, false);
            if (neighbor != null) {
                interval = neighbor;
                alignment ^= 1;
            } else {
                interval = LayoutInterval.getFirstParent(interval, 103);
            }
        }
        return interval.getCurrentSpace().positions[dimension][alignment];
    }

    static int determineDimension(LayoutInterval interval) {
        Iterator<LayoutInterval> it = LayoutUtils.getComponentIterator(interval);
        if (it.hasNext()) {
            LayoutInterval comp = it.next();
            return comp == comp.getComponent().getLayoutInterval(0) ? 0 : 1;
        }
        return -1;
    }

    static List<LayoutInterval> edgeSubComponents(LayoutInterval root, int edge, boolean aligned) {
        return LayoutUtils.getSideSubIntervals(root, edge, true, false, true, aligned, false);
    }

    static List<LayoutInterval> getSideSubIntervals(LayoutInterval interval, int edge, boolean components, boolean gaps, boolean mustBeLast, boolean aligned) {
        return LayoutUtils.getSideSubIntervals(interval, edge, components, gaps, mustBeLast, aligned, false);
    }

    private static List<LayoutInterval> getSideSubIntervals(LayoutInterval interval, int edge, boolean components, boolean gaps, boolean mustBeLast, boolean aligned, boolean justFirst) {
        int d;
        if (edge != 0 && edge != 1) {
            throw new IllegalArgumentException();
        }
        LinkedList<LayoutInterval> intervals = null;
        LinkedList<LayoutInterval> candidates = new LinkedList<LayoutInterval>();
        if (interval != null) {
            intervals = new LinkedList<LayoutInterval>();
            candidates.add(interval);
        }
        int n = d = edge == 0 ? -1 : 1;
        while (!(candidates.isEmpty() || justFirst && !intervals.isEmpty())) {
            LayoutInterval candidate = (LayoutInterval)candidates.remove(0);
            if (candidate.isGroup()) {
                if (candidate.isSequential() && candidate.getSubIntervalCount() > 0) {
                    int index = edge == 0 ? 0 : candidate.getSubIntervalCount() - 1;
                    LayoutInterval sub = candidate.getSubInterval(index);
                    candidates.add(sub);
                    if (mustBeLast || !sub.isSingle() || (index -= d) < 0 || index >= candidate.getSubIntervalCount() || aligned && LayoutInterval.canResize(sub)) continue;
                    candidates.add(candidate.getSubInterval(index));
                    continue;
                }
                Iterator<LayoutInterval> subs = candidate.getSubIntervals();
                while (subs.hasNext()) {
                    LayoutInterval li = subs.next();
                    if (aligned && !LayoutInterval.isAlignedAtBorder(li, edge)) continue;
                    candidates.add(li);
                }
                continue;
            }
            if ((!components || !candidate.isComponent()) && (!gaps || !candidate.isEmptySpace())) continue;
            intervals.add(candidate);
        }
        return intervals;
    }

    static List<LayoutInterval> getSideComponents(LayoutInterval interval, int edge, boolean mustBeLast, boolean aligned) {
        return LayoutUtils.getSideSubIntervals(interval, edge, true, false, mustBeLast, aligned, false);
    }

    static boolean hasSideComponents(LayoutInterval interval, int edge, boolean mustBeLast, boolean aligned) {
        return !LayoutUtils.getSideSubIntervals(interval, edge, true, false, mustBeLast, aligned, true).isEmpty();
    }

    static List<LayoutInterval> getSideGaps(LayoutInterval interval, int edge, boolean aligned) {
        return LayoutUtils.getSideSubIntervals(interval, edge, false, true, true, aligned, false);
    }

    static boolean hasSideGaps(LayoutInterval interval, int edge, boolean aligned) {
        return !LayoutUtils.getSideSubIntervals(interval, edge, false, true, true, aligned, true).isEmpty();
    }

    static boolean alignedIntervals(LayoutInterval interval1, LayoutInterval interval2, int alignment) {
        LayoutInterval parent = LayoutInterval.getCommonParent(interval1, interval2);
        return parent != null && parent.isParallel() && LayoutInterval.isAlignedAtBorder(interval1, parent, alignment) && LayoutInterval.isAlignedAtBorder(interval2, parent, alignment);
    }

    static boolean isDefaultGapValidForNeighbor(LayoutInterval neighbor, int neighborEdge) {
        return LayoutUtils.hasSideComponents(neighbor, neighborEdge, true, false) && (LayoutUtils.hasSideComponents(neighbor, neighborEdge, true, true) || !LayoutUtils.hasSideGaps(neighbor, neighborEdge, true));
    }

    static boolean contentOverlap(LayoutRegion space, LayoutInterval interval, int dimension) {
        return LayoutUtils.contentOverlap(space, interval, -1, -1, dimension);
    }

    static boolean contentOverlap(LayoutRegion space, LayoutInterval interval, int fromIndex, int toIndex, int dimension) {
        boolean overlap;
        LayoutRegion examinedSpace = interval.getCurrentSpace();
        if (!interval.isGroup()) {
            return LayoutRegion.overlap(space, examinedSpace, dimension, 0);
        }
        boolean bl = overlap = !examinedSpace.isSet(dimension) || LayoutRegion.overlap(space, examinedSpace, dimension, 0);
        if (overlap) {
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            if (toIndex < 0) {
                toIndex = interval.getSubIntervalCount() - 1;
            }
            assert (fromIndex <= toIndex);
            overlap = false;
            for (int i = fromIndex; i <= toIndex; ++i) {
                LayoutInterval li = interval.getSubInterval(i);
                if (li.isEmptySpace() || !LayoutUtils.contentOverlap(space, li, dimension)) continue;
                overlap = true;
                break;
            }
        }
        return overlap;
    }

    static boolean contentOverlap(LayoutInterval interval1, LayoutInterval interval2, int dimension) {
        return LayoutUtils.contentOverlap(interval1, interval2, 0, interval2.getSubIntervalCount() - 1, dimension);
    }

    static boolean contentOverlap(LayoutInterval interval1, LayoutInterval interval2, int fromIndex, int toIndex, int dimension) {
        if (!interval2.isGroup()) {
            if (!interval1.isGroup()) {
                return LayoutRegion.overlap(interval1.getCurrentSpace(), interval2.getCurrentSpace(), dimension, 0);
            }
            LayoutInterval temp = interval1;
            interval1 = interval2;
            interval2 = temp;
        }
        LinkedList<LayoutInterval> int2list = null;
        LinkedList<LayoutInterval> addList = null;
        Iterator<LayoutInterval> it1 = LayoutUtils.getComponentIterator(interval1);
        while (it1.hasNext()) {
            Iterator it2;
            LayoutRegion space1 = it1.next().getCurrentSpace();
            Iterator<Object> iterator = it2 = int2list != null ? int2list.iterator() : LayoutUtils.getComponentIterator(interval2, fromIndex, toIndex);
            if (int2list == null && it1.hasNext()) {
                addList = int2list = new LinkedList<LayoutInterval>();
            }
            while (it2.hasNext()) {
                LayoutInterval li2 = (LayoutInterval)it2.next();
                if (LayoutRegion.overlap(space1, li2.getCurrentSpace(), dimension, 0)) {
                    return true;
                }
                if (addList == null) continue;
                addList.add(li2);
            }
            addList = null;
        }
        return false;
    }

    static boolean contentOverlap(LayoutRegion space, LayoutInterval interval) {
        Iterator<LayoutInterval> it = LayoutUtils.getComponentIterator(interval);
        while (it.hasNext()) {
            LayoutRegion compSpace = it.next().getCurrentSpace();
            if (!LayoutRegion.overlap(space, compSpace, 0, 0) || !LayoutRegion.overlap(space, compSpace, 1, 0)) continue;
            return true;
        }
        return false;
    }

    static boolean isOverlapPreventedInOtherDimension(LayoutInterval addingInterval, LayoutInterval existingInterval, int dimension) {
        int otherDim = dimension ^ 1;
        Iterator<LayoutInterval> addIt = LayoutUtils.getComponentIterator(addingInterval);
        do {
            LayoutInterval otherDimAdd = addIt.next().getComponent().getLayoutInterval(otherDim);
            Iterator<LayoutInterval> exIt = LayoutUtils.getComponentIterator(existingInterval);
            do {
                LayoutInterval otherDimEx;
                LayoutInterval parent;
                if ((parent = LayoutInterval.getCommonParent(otherDimAdd, otherDimEx = exIt.next().getComponent().getLayoutInterval(otherDim))) != null && !parent.isParallel()) continue;
                return false;
            } while (exIt.hasNext());
        } while (addIt.hasNext());
        return true;
    }

    static Iterator<LayoutInterval> getComponentIterator(LayoutInterval interval) {
        return new ComponentIterator(interval, 0, interval.getSubIntervalCount() - 1);
    }

    static Iterator<LayoutInterval> getComponentIterator(LayoutInterval interval, int startIndex, int endIndex) {
        return new ComponentIterator(interval, startIndex, endIndex);
    }

    private static class ComponentIterator
    implements Iterator {
        private LayoutInterval root;
        private int startIndex;
        private int endIndex;
        private boolean initialized;
        private int index;
        private LayoutInterval next;

        ComponentIterator(LayoutInterval interval, int startIndex, int endIndex) {
            this.root = interval;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.findNext();
            this.initialized = true;
        }

        private void findNext() {
            int idx;
            LayoutInterval parent;
            if (this.next == null) {
                if (this.initialized) {
                    return;
                }
                if (!this.root.isGroup()) {
                    if (this.root.isComponent()) {
                        this.next = this.root;
                    }
                    return;
                }
                parent = this.root;
                idx = this.startIndex;
            } else if (this.next != this.root) {
                parent = this.next.getParent();
                idx = this.index + 1;
            } else {
                this.next = null;
                return;
            }
            this.next = null;
            while (true) {
                if (idx < parent.getSubIntervalCount()) {
                    if (parent == this.root && idx > this.endIndex) {
                        return;
                    }
                    LayoutInterval sub = parent.getSubInterval(idx);
                    if (sub.isComponent()) {
                        this.next = sub;
                        this.index = idx;
                        return;
                    }
                    if (sub.isGroup()) {
                        parent = sub;
                        idx = 0;
                        continue;
                    }
                    ++idx;
                    continue;
                }
                if (parent == this.root) break;
                idx = parent.getParent().indexOf(parent) + 1;
                parent = parent.getParent();
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            LayoutInterval ret = this.next;
            this.findNext();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

