/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.action;

import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.TransformEdit;
import org.jhotdraw.draw.TranslationDirection;
import org.jhotdraw.draw.action.AbstractSelectedAction;

public abstract class MoveConstrainedAction
extends AbstractSelectedAction {
    private TranslationDirection dir;

    public MoveConstrainedAction(DrawingEditor drawingEditor, TranslationDirection translationDirection) {
        super(drawingEditor);
        this.dir = translationDirection;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.getView().getSelectionCount() > 0) {
            Rectangle2D.Double double_ = null;
            for (Figure cloneable2 : this.getView().getSelectedFigures()) {
                if (double_ == null) {
                    double_ = cloneable2.getBounds();
                    continue;
                }
                double_.add(cloneable2.getBounds());
            }
            Point2D.Double double_2 = new Point2D.Double(double_.x, double_.y);
            if (this.getView().getConstrainer() != null) {
                this.getView().getConstrainer().translateRectangle(double_, this.dir);
            } else {
                switch (this.dir) {
                    case NORTH: {
                        double_.y -= 1.0;
                        break;
                    }
                    case SOUTH: {
                        double_.y += 1.0;
                        break;
                    }
                    case WEST: {
                        double_.x -= 1.0;
                        break;
                    }
                    case EAST: {
                        double_.x += 1.0;
                    }
                }
            }
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(double_.x - double_2.x, double_.y - double_2.y);
            for (Figure figure : this.getView().getSelectedFigures()) {
                if (!figure.isTransformable()) continue;
                figure.willChange();
                figure.transform(affineTransform);
                figure.changed();
            }
            this.fireUndoableEditHappened(new TransformEdit(this.getView().getSelectedFigures(), affineTransform));
        }
    }

    public static class East
    extends MoveConstrainedAction {
        public static final String ID = "edit.moveConstrainedEast";

        public East(DrawingEditor drawingEditor) {
            super(drawingEditor, TranslationDirection.EAST);
            this.labels.configureAction(this, ID);
        }
    }

    public static class North
    extends MoveConstrainedAction {
        public static final String ID = "edit.moveConstrainedNorth";

        public North(DrawingEditor drawingEditor) {
            super(drawingEditor, TranslationDirection.NORTH);
            this.labels.configureAction(this, ID);
        }
    }

    public static class South
    extends MoveConstrainedAction {
        public static final String ID = "edit.moveConstrainedSouth";

        public South(DrawingEditor drawingEditor) {
            super(drawingEditor, TranslationDirection.SOUTH);
            this.labels.configureAction(this, ID);
        }
    }

    public static class West
    extends MoveConstrainedAction {
        public static final String ID = "edit.moveConstrainedWest";

        public West(DrawingEditor drawingEditor) {
            super(drawingEditor, TranslationDirection.WEST);
            this.labels.configureAction(this, ID);
        }
    }
}

