/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.beans.AbstractBean;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingEditorProxy;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.draw.ToolEvent;
import org.jhotdraw.draw.ToolListener;

public abstract class AbstractTool
extends AbstractBean
implements Tool {
    private boolean isActive;
    protected boolean isWorking;
    protected DrawingEditor editor;
    protected Point anchor = new Point();
    protected EventListenerList listenerList = new EventListenerList();
    private DrawingEditorProxy editorProxy = new DrawingEditorProxy();
    private InputMap inputMap;
    private ActionMap actionMap;

    public AbstractTool() {
        this.setInputMap(this.createInputMap());
        this.setActionMap(this.createActionMap());
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listenerList.add(UndoableEditListener.class, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.listenerList.remove(UndoableEditListener.class, undoableEditListener);
    }

    @Override
    public void activate(DrawingEditor drawingEditor) {
        this.editor = drawingEditor;
        this.editorProxy.setTarget(drawingEditor);
        this.isActive = true;
        for (DrawingView drawingView : drawingEditor.getDrawingViews()) {
            drawingView.repaintHandles();
        }
    }

    @Override
    public void deactivate(DrawingEditor drawingEditor) {
        this.editor = drawingEditor;
        this.editorProxy.setTarget(null);
        this.isActive = false;
    }

    public boolean isActive() {
        return this.isActive;
    }

    protected DrawingView getView() {
        return this.editor.getActiveView();
    }

    protected DrawingEditor getEditor() {
        return this.editor;
    }

    protected Drawing getDrawing() {
        return this.getView().getDrawing();
    }

    protected Point2D.Double viewToDrawing(Point point) {
        return this.constrainPoint(this.getView().viewToDrawing(point));
    }

    protected Point2D.Double constrainPoint(Point point) {
        return this.constrainPoint(this.getView().viewToDrawing(point));
    }

    protected Point2D.Double constrainPoint(Point2D.Double double_) {
        return this.getView().getConstrainer().constrainPoint(double_);
    }

    public void setInputMap(InputMap inputMap) {
        this.inputMap = inputMap;
    }

    public InputMap getInputMap() {
        return this.inputMap;
    }

    public void setActionMap(ActionMap actionMap) {
        this.actionMap = actionMap;
    }

    public ActionMap getActionMap() {
        return this.actionMap;
    }

    @Override
    public void editDelete() {
        this.getView().getDrawing().removeAll(this.getView().getSelectedFigures());
    }

    @Override
    public void editCut() {
    }

    @Override
    public void editCopy() {
    }

    @Override
    public void editDuplicate() {
    }

    @Override
    public void editPaste() {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.fireToolDone();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (!keyEvent.isConsumed()) {
            Object object;
            if (keyEvent.getSource() instanceof Container) {
                this.editor.setActiveView(this.editor.findView((Container)keyEvent.getSource()));
            }
            Object object2 = null;
            if (this.inputMap != null) {
                object2 = this.inputMap.get(KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers(), false));
            }
            if (object2 == null && (object = this.editor.getInputMap()) != null) {
                object2 = ((InputMap)object).get(KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers(), false));
            }
            object = null;
            if (object2 instanceof ActionListener) {
                object = (ActionListener)object2;
            } else if (object2 != null) {
                if (this.actionMap != null) {
                    object = this.actionMap.get(object2);
                }
                if (object == null) {
                    object = this.editor.getActionMap().get(object2);
                }
            }
            if (object != null) {
                keyEvent.consume();
                object.actionPerformed(new ActionEvent(this, 1001, "tool", keyEvent.getWhen(), keyEvent.getModifiers()));
                this.fireToolDone();
            }
        }
    }

    protected InputMap createInputMap() {
        return null;
    }

    protected ActionMap createActionMap() {
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        DrawingView drawingView = this.editor.findView((Container)mouseEvent.getSource());
        drawingView.requestFocus();
        this.anchor = new Point(mouseEvent.getX(), mouseEvent.getY());
        this.isWorking = true;
        this.fireToolStarted(drawingView);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.isWorking = false;
    }

    @Override
    public void addToolListener(ToolListener toolListener) {
        this.listenerList.add(ToolListener.class, toolListener);
    }

    @Override
    public void removeToolListener(ToolListener toolListener) {
        this.listenerList.remove(ToolListener.class, toolListener);
    }

    protected void fireToolStarted(DrawingView drawingView) {
        ToolEvent toolEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ToolListener.class) continue;
            if (toolEvent == null) {
                toolEvent = new ToolEvent(this, drawingView, new Rectangle(0, 0, -1, -1));
            }
            ((ToolListener)objectArray[i + 1]).toolStarted(toolEvent);
        }
    }

    protected void fireToolDone() {
        ToolEvent toolEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ToolListener.class) continue;
            if (toolEvent == null) {
                toolEvent = new ToolEvent(this, this.getView(), new Rectangle(0, 0, -1, -1));
            }
            ((ToolListener)objectArray[i + 1]).toolDone(toolEvent);
        }
    }

    protected void fireAreaInvalidated(Rectangle2D.Double double_) {
        Point point = this.getView().drawingToView(new Point2D.Double(double_.x, double_.y));
        Point point2 = this.getView().drawingToView(new Point2D.Double(double_.x + double_.width, double_.y + double_.height));
        this.fireAreaInvalidated(new Rectangle(point.x, point.y, point2.x - point.x, point2.y - point.y));
    }

    protected void fireAreaInvalidated(Rectangle rectangle) {
        ToolEvent toolEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ToolListener.class) continue;
            if (toolEvent == null) {
                toolEvent = new ToolEvent(this, this.getView(), rectangle);
            }
            ((ToolListener)objectArray[i + 1]).areaInvalidated(toolEvent);
        }
    }

    @Override
    public void draw(Graphics2D graphics2D) {
    }

    public void updateCursor(DrawingView drawingView, Point point) {
        if (drawingView.isEnabled()) {
            Handle handle = drawingView.findHandle(point);
            if (handle != null) {
                drawingView.setCursor(handle.getCursor());
            } else {
                Figure figure = drawingView.findFigure(point);
                Point2D.Double double_ = drawingView.viewToDrawing(point);
                Drawing drawing = drawingView.getDrawing();
                while (figure != null && !figure.isSelectable()) {
                    figure = drawing.findFigureBehind(double_, figure);
                }
                if (figure != null) {
                    drawingView.setCursor(figure.getCursor(drawingView.viewToDrawing(point)));
                } else {
                    drawingView.setCursor(Cursor.getDefaultCursor());
                }
            }
        } else {
            drawingView.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    @Override
    public String getToolTipText(DrawingView drawingView, MouseEvent mouseEvent) {
        return null;
    }

    @Override
    public boolean supportsHandleInteraction() {
        return false;
    }
}

