/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import org.postgresql.core.ParameterList;
import org.postgresql.core.v3.CompositeParameterList;
import org.postgresql.core.v3.SimpleParameterList;
import org.postgresql.core.v3.SimpleQuery;
import org.postgresql.core.v3.V3Query;

class CompositeQuery
implements V3Query {
    private final SimpleQuery[] subqueries;
    private final int[] offsets;

    CompositeQuery(SimpleQuery[] subqueries, int[] offsets) {
        this.subqueries = subqueries;
        this.offsets = offsets;
    }

    public ParameterList createParameterList() {
        SimpleParameterList[] subparams = new SimpleParameterList[this.subqueries.length];
        for (int i2 = 0; i2 < this.subqueries.length; ++i2) {
            subparams[i2] = (SimpleParameterList)this.subqueries[i2].createParameterList();
        }
        return new CompositeParameterList(subparams, this.offsets);
    }

    public String toString(ParameterList parameters) {
        StringBuilder sbuf = new StringBuilder(this.subqueries[0].toString());
        for (int i2 = 1; i2 < this.subqueries.length; ++i2) {
            sbuf.append(';');
            sbuf.append(this.subqueries[i2]);
        }
        return sbuf.toString();
    }

    public String toString() {
        return this.toString(null);
    }

    public void close() {
        for (SimpleQuery subquery : this.subqueries) {
            subquery.close();
        }
    }

    public SimpleQuery[] getSubqueries() {
        return this.subqueries;
    }

    public boolean isStatementDescribed() {
        for (SimpleQuery subquery : this.subqueries) {
            if (subquery.isStatementDescribed()) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        for (SimpleQuery subquery : this.subqueries) {
            if (subquery.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

