/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.UUID;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.mariadb.jdbc.internal.util.Options;

public class MyX509TrustManager
implements X509TrustManager {
    String serverCertFile;
    public String keystoreUrl;
    public String certKeystorePassword;
    X509TrustManager trustManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public MyX509TrustManager(Options options) throws Exception {
        void var8_13;
        boolean trustServerCertificate = options.trustServerCertificate;
        if (trustServerCertificate) {
            return;
        }
        this.serverCertFile = options.serverSslCert;
        this.keystoreUrl = options.trustCertificateKeyStoreUrl;
        InputStream inStream = null;
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        if (this.keystoreUrl != null) {
            try {
                inStream = new URL(this.keystoreUrl).openStream();
                ks.load(inStream, options.trustCertificateKeyStorePassword == null ? null : options.trustCertificateKeyStorePassword.toCharArray());
            }
            finally {
                if (inStream != null) {
                    inStream.close();
                }
            }
        }
        if (this.serverCertFile.startsWith("-----BEGIN CERTIFICATE-----")) {
            inStream = new ByteArrayInputStream(this.serverCertFile.getBytes());
        } else if (this.serverCertFile.startsWith("classpath:")) {
            String classpathFile = this.serverCertFile.substring("classpath:".length());
            inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathFile);
        } else {
            inStream = new FileInputStream(this.serverCertFile);
        }
        ks = KeyStore.getInstance(KeyStore.getDefaultType());
        try {
            ks.load(null);
        }
        catch (Exception classpathFile) {
            // empty catch block
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> caList = cf.generateCertificates(inStream);
        inStream.close();
        for (Certificate certificate : caList) {
            ks.setCertificateEntry(UUID.randomUUID().toString(), certificate);
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        TrustManager[] trustManagerArray = tmf.getTrustManagers();
        int n2 = trustManagerArray.length;
        boolean bl = false;
        while (var8_13 < n2) {
            TrustManager tm = trustManagerArray[var8_13];
            if (tm instanceof X509TrustManager) {
                this.trustManager = (X509TrustManager)tm;
                break;
            }
            ++var8_13;
        }
        if (this.trustManager == null) {
            throw new RuntimeException("No X509TrustManager found");
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String string) throws CertificateException {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String string) throws CertificateException {
        if (this.trustManager == null) {
            return;
        }
        this.trustManager.checkServerTrusted(x509Certificates, string);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }
}

