/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.pt;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_pt extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "001", "Mundo" },
            { "002", "\u00c1frica" },
            { "003", "Am\u00e9rica do Norte" },
            { "005", "Am\u00e9rica do Sul" },
            { "009", "Oceania" },
            { "011", "\u00c1frica Ocidental" },
            { "013", "Am\u00e9rica Central" },
            { "014", "\u00c1frica Oriental" },
            { "015", "\u00c1frica do Norte" },
            { "017", "\u00c1frica Central" },
            { "018", "\u00c1frica Austral" },
            { "019", "Am\u00e9ricas" },
            { "021", "Am\u00e9rica Setentrional" },
            { "029", "Caribe" },
            { "030", "\u00c1sia Oriental" },
            { "034", "\u00c1sia do Sul" },
            { "035", "\u00c1sia Centro-Oriental" },
            { "039", "Europa do Sul" },
            { "053", "Austr\u00e1lia e Nova Zel\u00e2ndia" },
            { "054", "Melan\u00e9sia" },
            { "057", "Regi\u00e3o da Micron\u00e9sia" },
            { "061", "Polin\u00e9sia" },
            { "142", "\u00c1sia" },
            { "143", "\u00c1sia Central" },
            { "145", "\u00c1sia Ocidental" },
            { "150", "Europa" },
            { "151", "Europa Oriental" },
            { "154", "Europa Setentrional" },
            { "155", "Europa Ocidental" },
            { "419", "Am\u00e9rica Latina" },
            { "AC", "Ilha de Ascens\u00e3o" },
            { "AD", "Andorra" },
            { "AE", "Emirados \u00c1rabes Unidos" },
            { "AF", "Afeganist\u00e3o" },
            { "AG", "Ant\u00edgua e Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Alb\u00e2nia" },
            { "AM", "Arm\u00eania" },
            { "AN", "Antilhas Holandesas" },
            { "AO", "Angola" },
            { "AQ", "Ant\u00e1rtida" },
            { "AR", "Argentina" },
            { "AS", "Samoa Americana" },
            { "AT", "\u00c1ustria" },
            { "AU", "Austr\u00e1lia" },
            { "AW", "Aruba" },
            { "AX", "Ilhas Aland" },
            { "AZ", "Azerbaij\u00e3o" },
            { "BA", "B\u00f3snia-Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "B\u00e9lgica" },
            { "BF", "Burquina Faso" },
            { "BG", "Bulg\u00e1ria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "S\u00e3o Bartolomeu" },
            { "BM", "Bermudas" },
            { "BN", "Brunei" },
            { "BO", "Bol\u00edvia" },
            { "BR", "Brasil" },
            { "BS", "Bahamas" },
            { "BT", "But\u00e3o" },
            { "BV", "Ilha Bouvet" },
            { "BW", "Botsuana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Canad\u00e1" },
            { "CC", "Ilhas Coco" },
            { "CD", "Congo-Kinshasa" },
            { "CF", "Rep\u00fablica Centro-Africana" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Su\u00ed\u00e7a" },
            { "CI", "Costa do Marfim" },
            { "CK", "Ilhas Cook" },
            { "CL", "Chile" },
            { "CM", "Rep\u00fablica dos Camar\u00f5es" },
            { "CN", "China" },
            { "CO", "Col\u00f4mbia" },
            { "CP", "Ilha de Clipperton" },
            { "CR", "Costa Rica" },
            { "CS", "S\u00e9rvia e Montenegro" },
            { "CU", "Cuba" },
            { "CV", "Cabo Verde" },
            { "CX", "Ilhas Natal" },
            { "CY", "Chipre" },
            { "CZ", "Rep\u00fablica Tcheca" },
            { "DE", "Alemanha" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibuti" },
            { "DK", "Dinamarca" },
            { "DM", "Dominica" },
            { "DO", "Rep\u00fablica Dominicana" },
            { "DZ", "Arg\u00e9lia" },
            { "EA", "Ceuta e Melilha" },
            { "EC", "Equador" },
            { "EE", "Est\u00f4nia" },
            { "EG", "Egito" },
            { "EH", "Saara Ocidental" },
            { "ER", "Eritreia" },
            { "ES", "Espanha" },
            { "ET", "Eti\u00f3pia" },
            { "EU", "Uni\u00e3o Europeia" },
            { "FI", "Finl\u00e2ndia" },
            { "FJ", "Fiji" },
            { "FK", "Ilhas Malvinas" },
            { "FM", "Micron\u00e9sia" },
            { "FO", "Ilhas Faroe" },
            { "FR", "Fran\u00e7a" },
            { "GA", "Gab\u00e3o" },
            { "GB", "Reino Unido" },
            { "GD", "Granada" },
            { "GE", "Ge\u00f3rgia" },
            { "GF", "Guiana Francesa" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "GI", "Gibraltar" },
            { "GL", "Gro\u00eanlandia" },
            { "GM", "G\u00e2mbia" },
            { "GN", "Guin\u00e9" },
            { "GP", "Guadalupe" },
            { "GQ", "Guin\u00e9 Equatorial" },
            { "GR", "Gr\u00e9cia" },
            { "GS", "Ge\u00f3rgia do Sul e Ilhas Sandwich do Sul" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guin\u00e9 Bissau" },
            { "GY", "Guiana" },
            { "HK", "Hong Kong, Regi\u00e3o Admin. Especial da China" },
            { "HM", "Ilha Heard e Ilhas McDonald" },
            { "HN", "Honduras" },
            { "HR", "Cro\u00e1cia" },
            { "HT", "Haiti" },
            { "HU", "Hungria" },
            { "IC", "Ilhas Can\u00e1rias" },
            { "ID", "Indon\u00e9sia" },
            { "IE", "Irlanda" },
            { "IL", "Israel" },
            { "IM", "Ilha de Man" },
            { "IN", "\u00cdndia" },
            { "IO", "Territ\u00f3rio Brit\u00e2nico do Oceano \u00cdndico" },
            { "IQ", "Iraque" },
            { "IR", "Ir\u00e3" },
            { "IS", "Isl\u00e2ndia" },
            { "IT", "It\u00e1lia" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jord\u00e2nia" },
            { "JP", "Jap\u00e3o" },
            { "KE", "Qu\u00eania" },
            { "KG", "Quirguist\u00e3o" },
            { "KH", "Camboja" },
            { "KI", "Quiribati" },
            { "KM", "Comores" },
            { "KN", "S\u00e3o Cristov\u00e3o e Nevis" },
            { "KP", "Coreia do Norte" },
            { "KR", "Coreia do Sul" },
            { "KW", "Kuwait" },
            { "KY", "Ilhas Caiman" },
            { "KZ", "Casaquist\u00e3o" },
            { "LA", "Rep\u00fablica Popular Democr\u00e1tica do Laos" },
            { "LB", "L\u00edbano" },
            { "LC", "Santa L\u00facia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Lib\u00e9ria" },
            { "LS", "Lesoto" },
            { "LT", "Litu\u00e2nia" },
            { "LU", "Luxemburgo" },
            { "LV", "Let\u00f4nia" },
            { "LY", "L\u00edbia" },
            { "MA", "Marrocos" },
            { "MC", "M\u00f4naco" },
            { "MD", "Mold\u00e1via" },
            { "ME", "Montenegro" },
            { "MF", "S\u00e3o Martinho" },
            { "MG", "Madagascar" },
            { "MH", "Ilhas Marshall" },
            { "MK", "Maced\u00f4nia" },
            { "ML", "Mali" },
            { "MM", "Mianmar [Birm\u00e2nia]" },
            { "MN", "Mong\u00f3lia" },
            { "MO", "Macau, Regi\u00e3o Admin. Especial da China" },
            { "MP", "Ilhas Marianas do Norte" },
            { "MQ", "Martinica" },
            { "MR", "Maurit\u00e2nia" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Maur\u00edcio" },
            { "MV", "Maldivas" },
            { "MW", "Malawi" },
            { "MX", "M\u00e9xico" },
            { "MY", "Mal\u00e1sia" },
            { "MZ", "Mo\u00e7ambique" },
            { "NA", "Nam\u00edbia" },
            { "NC", "Nova Caled\u00f4nia" },
            { "NE", "N\u00edger" },
            { "NF", "Ilha Norfolk" },
            { "NG", "Nig\u00e9ria" },
            { "NI", "Nicar\u00e1gua" },
            { "NL", "Holanda" },
            { "NO", "Noruega" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nova Zel\u00e2ndia" },
            { "OM", "Om\u00e3" },
            { "PA", "Panam\u00e1" },
            { "PE", "Peru" },
            { "PF", "Polin\u00e9sia Francesa" },
            { "PG", "Papua-Nova Guin\u00e9" },
            { "PH", "Filipinas" },
            { "PK", "Paquist\u00e3o" },
            { "PL", "Pol\u00f4nia" },
            { "PM", "Saint Pierre e Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Porto Rico" },
            { "PS", "Territ\u00f3rios palestinos" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguai" },
            { "QA", "Catar" },
            { "QO", "Oceania Remota" },
            { "RE", "Reuni\u00e3o" },
            { "RO", "Rom\u00eania" },
            { "RS", "S\u00e9rvia" },
            { "RU", "R\u00fassia" },
            { "RW", "Ruanda" },
            { "SA", "Ar\u00e1bia Saudita" },
            { "SB", "Ilhas Salom\u00e3o" },
            { "SC", "Seychelles" },
            { "SD", "Sud\u00e3o" },
            { "SE", "Su\u00e9cia" },
            { "SG", "Cingapura" },
            { "SH", "Santa Helena" },
            { "SI", "Eslov\u00eania" },
            { "SJ", "Svalbard e Jan Mayen" },
            { "SK", "Eslov\u00e1quia" },
            { "SL", "Serra Leoa" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Som\u00e1lia" },
            { "SR", "Suriname" },
            { "ST", "S\u00e3o Tom\u00e9 e Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SY", "S\u00edria" },
            { "SZ", "Suazil\u00e2ndia" },
            { "TA", "Trist\u00e3o da Cunha" },
            { "TC", "Ilhas Turks e Caicos" },
            { "TD", "Chade" },
            { "TF", "Territ\u00f3rios Franceses do Sul" },
            { "TG", "Togo" },
            { "TH", "Tail\u00e2ndia" },
            { "TJ", "Tadjiquist\u00e3o" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turcomenist\u00e3o" },
            { "TN", "Tun\u00edsia" },
            { "TO", "Tonga" },
            { "TR", "Turquia" },
            { "TT", "Trinidad e Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanz\u00e2nia" },
            { "UA", "Ucr\u00e2nia" },
            { "UG", "Uganda" },
            { "UM", "Ilhas Menores Distantes dos Estados Unidos" },
            { "US", "Estados Unidos" },
            { "UY", "Uruguai" },
            { "UZ", "Uzbequist\u00e3o" },
            { "VA", "Vaticano" },
            { "VC", "S\u00e3o Vicente e Granadinas" },
            { "VE", "Venezuela" },
            { "VG", "Ilhas Virgens Brit\u00e2nicas" },
            { "VI", "Ilhas Virgens dos EUA" },
            { "VN", "Vietn\u00e3" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis e Futuna" },
            { "WS", "Samoa" },
            { "YE", "I\u00eamen" },
            { "YT", "Mayotte" },
            { "ZA", "\u00c1frica do Sul" },
            { "ZM", "Z\u00e2mbia" },
            { "ZW", "Zimb\u00e1bue" },
            { "ZZ", "Regi\u00e3o desconhecida ou inv\u00e1lida" },
            { "aa", "afar" },
            { "ab", "abc\u00e1zio" },
            { "ae", "av\u00e9stico" },
            { "af", "afric\u00e2ner" },
            { "ak", "akan" },
            { "am", "am\u00e1rico" },
            { "an", "aragon\u00eas" },
            { "ar", "\u00e1rabe" },
            { "as", "assam\u00eas" },
            { "av", "avaric" },
            { "ay", "aimara" },
            { "az", "azerbaijano" },
            { "ba", "bashkir" },
            { "be", "bielo-russo" },
            { "bg", "b\u00falgaro" },
            { "bh", "biari" },
            { "bi", "bislam\u00e1" },
            { "bm", "bambara" },
            { "bn", "bengali" },
            { "bo", "tibetano" },
            { "br", "bret\u00e3o" },
            { "bs", "b\u00f3snio" },
            { "ca", "catal\u00e3o" },
            { "ce", "checheno" },
            { "ch", "chamorro" },
            { "co", "c\u00f3rsico" },
            { "cr", "cree" },
            { "cs", "tcheco" },
            { "cu", "eslavo eclesi\u00e1stico" },
            { "cv", "chuvash" },
            { "cy", "gal\u00eas" },
            { "da", "dinamarqu\u00eas" },
            { "de", "alem\u00e3o" },
            { "dv", "divehi" },
            { "dz", "dzonga" },
            { "ee", "eve" },
            { "el", "grego" },
            { "en", "ingl\u00eas" },
            { "eo", "esperanto" },
            { "es", "espanhol" },
            { "et", "estoniano" },
            { "eu", "basco" },
            { "fa", "persa" },
            { "ff", "fula" },
            { "fi", "finland\u00eas" },
            { "fj", "fijiano" },
            { "fo", "fero\u00eas" },
            { "fr", "franc\u00eas" },
            { "fy", "fr\u00edsio ocidental" },
            { "ga", "irland\u00eas" },
            { "gd", "ga\u00e9lico escoc\u00eas" },
            { "gl", "galego" },
            { "gn", "guarani" },
            { "gu", "guzerate" },
            { "gv", "manx" },
            { "ha", "hau\u00e7\u00e1" },
            { "he", "hebraico" },
            { "hi", "h\u00edndi" },
            { "ho", "hiri motu" },
            { "hr", "croata" },
            { "ht", "haitiano" },
            { "hu", "h\u00fangaro" },
            { "hy", "arm\u00eanio" },
            { "hz", "herero" },
            { "ia", "interl\u00edngua" },
            { "id", "indon\u00e9sio" },
            { "ie", "interlingue" },
            { "ig", "ibo" },
            { "ii", "sichuan yi" },
            { "ik", "inupiaque" },
            { "io", "ido" },
            { "is", "island\u00eas" },
            { "it", "italiano" },
            { "iu", "inuktitut" },
            { "ja", "japon\u00eas" },
            { "jv", "javan\u00eas" },
            { "ka", "georgiano" },
            { "kg", "congol\u00eas" },
            { "ki", "quicuio" },
            { "kj", "kuanyama" },
            { "kk", "cazaque" },
            { "kl", "groenland\u00eas" },
            { "km", "cmer" },
            { "kn", "canar\u00eas" },
            { "ko", "coreano" },
            { "kr", "can\u00fari" },
            { "ks", "caxemira" },
            { "ku", "curdo" },
            { "kv", "komi" },
            { "kw", "c\u00f3rnico" },
            { "ky", "quirguiz" },
            { "la", "latim" },
            { "lb", "luxemburgu\u00eas" },
            { "lg", "luganda" },
            { "li", "limburgu\u00eas" },
            { "ln", "lingala" },
            { "lo", "laosiano" },
            { "lt", "lituano" },
            { "lu", "luba-catanga" },
            { "lv", "let\u00e3o" },
            { "mg", "malgaxe" },
            { "mh", "marshal\u00eas" },
            { "mi", "maori" },
            { "mk", "maced\u00f4nio" },
            { "ml", "malaiala" },
            { "mn", "mongol" },
            { "mo", "mold\u00e1vio" },
            { "mr", "marata" },
            { "ms", "malaio" },
            { "mt", "malt\u00eas" },
            { "my", "birman\u00eas" },
            { "na", "nauruano" },
            { "nb", "bokm\u00e5l noruegu\u00eas" },
            { "nd", "ndebele do norte" },
            { "ne", "nepali" },
            { "ng", "dongo" },
            { "nl", "holand\u00eas" },
            { "nn", "nynorsk noruegu\u00eas" },
            { "no", "noruegu\u00eas" },
            { "nr", "ndebele do sul" },
            { "nv", "navajo" },
            { "ny", "nianja" },
            { "oc", "occit\u00e2nico" },
            { "oj", "ojibwa" },
            { "om", "oromo" },
            { "or", "oriya" },
            { "os", "ossetic" },
            { "pa", "panjabi" },
            { "pi", "p\u00e1li" },
            { "pl", "polon\u00eas" },
            { "ps", "pashto" },
            { "pt", "portugu\u00eas" },
            { "qu", "qu\u00edchua" },
            { "rm", "reto-romano" },
            { "rn", "rundi" },
            { "ro", "romeno" },
            { "ru", "russo" },
            { "rw", "kinyarwanda" },
            { "sa", "s\u00e2nscrito" },
            { "sc", "sardo" },
            { "sd", "sindi" },
            { "se", "sami do norte" },
            { "sg", "sango" },
            { "sh", "servo-croata" },
            { "si", "cingal\u00eas" },
            { "sk", "eslovaco" },
            { "sl", "esloveno" },
            { "sm", "samoano" },
            { "sn", "shona" },
            { "so", "somali" },
            { "sq", "alban\u00eas" },
            { "sr", "s\u00e9rvio" },
            { "ss", "swati" },
            { "st", "soto do sul" },
            { "su", "sundan\u00eas" },
            { "sv", "sueco" },
            { "sw", "suaili" },
            { "ta", "t\u00e2mil" },
            { "te", "telugu" },
            { "tg", "tadjique" },
            { "th", "tailand\u00eas" },
            { "ti", "tigr\u00ednia" },
            { "tk", "turcomano" },
            { "tl", "tagalo" },
            { "tn", "tswana" },
            { "to", "tongan\u00eas" },
            { "tr", "turco" },
            { "ts", "tsonga" },
            { "tt", "tatar" },
            { "tw", "twi" },
            { "ty", "taitiano" },
            { "ug", "uighur" },
            { "uk", "ucraniano" },
            { "ur", "urdu" },
            { "uz", "usbeque" },
            { "ve", "venda" },
            { "vi", "vietnamita" },
            { "vo", "volapuque" },
            { "wa", "val\u00e3o" },
            { "wo", "u\u00f3lofe" },
            { "xh", "xosa" },
            { "yi", "i\u00eddiche" },
            { "yo", "ioruba" },
            { "za", "zhuang" },
            { "zh", "chin\u00eas" },
            { "zu", "zulu" },
            { "ace", "ach\u00e9m" },
            { "ach", "acoli" },
            { "ada", "adangme" },
            { "ady", "adigue" },
            { "afa", "idioma afro-asi\u00e1tico" },
            { "afh", "afrihili" },
            { "ain", "ainu" },
            { "akk", "acadiano" },
            { "ale", "ale\u00fate" },
            { "alg", "idioma algonquiano" },
            { "alt", "altai do sul" },
            { "ang", "ingl\u00eas arcaico" },
            { "anp", "angika" },
            { "apa", "idioma apache" },
            { "arc", "aramaico" },
            { "arn", "araucano" },
            { "arp", "arapaho" },
            { "art", "idioma artificial" },
            { "arw", "arauaqui" },
            { "asa", "asa" },
            { "ast", "asturiano" },
            { "ath", "idioma atabascano" },
            { "aus", "idioma australiano" },
            { "awa", "awadhi" },
            { "bad", "banda" },
            { "bai", "idioma bamileke" },
            { "bal", "bal\u00fachi" },
            { "ban", "balin\u00eas" },
            { "bas", "basa" },
            { "bat", "idioma b\u00e1ltico" },
            { "bej", "beja" },
            { "bem", "bemba" },
            { "ber", "berbere" },
            { "bho", "bhojpuri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bla", "siksika" },
            { "bnt", "banto" },
            { "bra", "braj" },
            { "brx", "bodo" },
            { "btk", "bataque" },
            { "bua", "buriat" },
            { "bug", "buguin\u00eas" },
            { "byn", "blin" },
            { "cad", "caddo" },
            { "cai", "idioma ind\u00edgena centro-americano" },
            { "car", "caribe" },
            { "cau", "idioma cauc\u00e1sico" },
            { "cch", "atsam" },
            { "ceb", "cebuano" },
            { "cel", "idioma celta" },
            { "chb", "chibcha" },
            { "chg", "chagatai" },
            { "chk", "chuukese" },
            { "chm", "mari" },
            { "chn", "chinook jargon" },
            { "cho", "choctaw" },
            { "chp", "chipewyan" },
            { "chr", "cherokee" },
            { "chy", "cheiene" },
            { "cmc", "idioma chamic" },
            { "cop", "copta" },
            { "cpe", "crioulo ou pidgin baseado no ingl\u00eas" },
            { "cpf", "crioulo ou pidgin baseado no franc\u00eas" },
            { "cpp", "crioulo ou pidgin baseado no portugu\u00eas" },
            { "crh", "turco da Crimeia" },
            { "crp", "crioulo ou pidgin" },
            { "csb", "kashubian" },
            { "cus", "idioma cuch\u00edtico" },
            { "dak", "dacota" },
            { "dar", "dargwa" },
            { "day", "dayak" },
            { "del", "delaware" },
            { "den", "slave" },
            { "dgr", "dogrib" },
            { "din", "dinka" },
            { "doi", "dogri" },
            { "dra", "idioma dravidiano" },
            { "dsb", "s\u00e9rvio baixo" },
            { "dua", "duala" },
            { "dum", "holand\u00eas m\u00e9dio" },
            { "dyu", "di\u00fala" },
            { "ebu", "embu" },
            { "efi", "efique" },
            { "egy", "eg\u00edpcio arcaico" },
            { "eka", "ekajuk" },
            { "elx", "elamite" },
            { "enm", "ingl\u00eas m\u00e9dio" },
            { "ewo", "ewondo" },
            { "fan", "fangue" },
            { "fat", "fanti" },
            { "fil", "filipino" },
            { "fiu", "idioma fino-\u00fagrico" },
            { "fon", "fom" },
            { "frm", "franc\u00eas m\u00e9dio" },
            { "fro", "franc\u00eas arcaico" },
            { "frr", "fr\u00edsio setentrional" },
            { "frs", "fris\u00e3o oriental" },
            { "fur", "friulano" },
            { "gaa", "ga" },
            { "gay", "gayo" },
            { "gba", "gbaia" },
            { "gem", "idioma germ\u00e2nico" },
            { "gez", "geez" },
            { "gil", "gilbert\u00eas" },
            { "gmh", "alem\u00e3o m\u00e9dio-alto" },
            { "goh", "alem\u00e3o arcaico alto" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", "g\u00f3tico" },
            { "grb", "grebo" },
            { "grc", "grego arcaico" },
            { "gsw", "alem\u00e3o su\u00ed\u00e7o" },
            { "gwi", "gwich\u02bcin" },
            { "hai", "haida" },
            { "haw", "havaiano" },
            { "hil", "hiligaynon" },
            { "him", "himachali" },
            { "hit", "hitita" },
            { "hmn", "hmong" },
            { "hsb", "sor\u00e1bio superior" },
            { "hup", "hupa" },
            { "iba", "iban" },
            { "ijo", "ijo" },
            { "ilo", "ilocano" },
            { "inc", "idioma \u00edndico" },
            { "ine", "idioma indo-europeu" },
            { "inh", "inguche" },
            { "ira", "iraniano" },
            { "iro", "idioma iroqu\u00eas" },
            { "jbo", "lojban" },
            { "jpr", "judaico-persa" },
            { "jrb", "judaico-ar\u00e1bico" },
            { "kaa", "kara-kalpak" },
            { "kab", "kabyle" },
            { "kac", "kachin" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kar", "karen" },
            { "kaw", "kawi" },
            { "kbd", "kabardiano" },
            { "kcg", "tyap" },
            { "kea", "kabuverdianu" },
            { "kfo", "koro" },
            { "kha", "khasi" },
            { "khi", "idioma cois\u00e3" },
            { "kho", "khotan\u00eas" },
            { "kmb", "quimbundo" },
            { "kok", "concani" },
            { "kos", "kosraean" },
            { "kpe", "kpelle" },
            { "krc", "karachay-balkar" },
            { "krl", "idioma car\u00e9lio" },
            { "kro", "kru" },
            { "kru", "kurukh" },
            { "kum", "kumyk" },
            { "kut", "kutenai" },
            { "lad", "ladino" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lezghian" },
            { "lol", "mongo" },
            { "loz", "lozi" },
            { "lua", "luba-lulua" },
            { "lui", "luiseno" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "lushai" },
            { "mad", "madur\u00eas" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", "makasar" },
            { "man", "mandinga" },
            { "map", "austron\u00e9sio" },
            { "mas", "massai" },
            { "mdf", "mocsa" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mga", "irland\u00eas m\u00e9dio" },
            { "mic", "miquemaque" },
            { "min", "minangkabau" },
            { "mis", "idiomas diversos" },
            { "mkh", "idioma mon-khmer" },
            { "mnc", "manchu" },
            { "mni", "manipuri" },
            { "mno", "idioma manobo" },
            { "moh", "mohawk" },
            { "mos", "mossi" },
            { "mul", "idiomas m\u00faltiplos" },
            { "mun", "idiomas munda" },
            { "mus", "creek" },
            { "mwl", "mirand\u00eas" },
            { "mwr", "marwari" },
            { "myn", "maia" },
            { "myv", "erzya" },
            { "nah", "n\u00e1uatle" },
            { "nai", "idioma ind\u00edgena norte-americano" },
            { "nap", "napolitano" },
            { "nds", "baixo-alem\u00e3o" },
            { "new", "newari" },
            { "nia", "nias" },
            { "nic", "idioma cordofano-nigeriano" },
            { "niu", "niueano" },
            { "nog", "nogai" },
            { "non", "n\u00f3rdico arcaico" },
            { "nqo", "n'ko" },
            { "nso", "soto setentrional" },
            { "nub", "idioma n\u00fabio" },
            { "nwc", "newari cl\u00e1ssico" },
            { "nym", "nyamwezi" },
            { "nyn", "nyankole" },
            { "nyo", "nyoro" },
            { "nzi", "nzima" },
            { "osa", "osage" },
            { "ota", "turco otomano" },
            { "oto", "idioma otomano" },
            { "paa", "idioma papuano" },
            { "pag", "pangasin\u00e3" },
            { "pal", "p\u00e1lavi" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "palauano" },
            { "peo", "persa arcaico" },
            { "phi", "idioma filipino" },
            { "phn", "fen\u00edcio" },
            { "pon", "pohnpeian" },
            { "pra", "idioma pr\u00e1crito" },
            { "pro", "proven\u00e7al arcaico" },
            { "raj", "rajastani" },
            { "rap", "rapanui" },
            { "rar", "rarotongano" },
            { "roa", "idioma rom\u00e2nico" },
            { "rof", "rombo" },
            { "rom", "romani" },
            { "rup", "aromeno" },
            { "rwk", "rwa" },
            { "sad", "sandawe" },
            { "sah", "iacuto" },
            { "sai", "idioma ind\u00edgena sul-americano" },
            { "sal", "idioma salisano" },
            { "sam", "aramaico samaritano" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "scn", "siciliano" },
            { "sco", "escoc\u00eas" },
            { "sel", "selkup" },
            { "sem", "idioma sem\u00edtico" },
            { "sga", "irland\u00eas arcaico" },
            { "sgn", "linguagem de sinais" },
            { "shn", "shan" },
            { "sid", "sidamo" },
            { "sio", "idioma sioux" },
            { "sit", "idioma sino-tibetano" },
            { "sla", "idioma eslavo" },
            { "sma", "sami do sul" },
            { "smi", "idioma sami" },
            { "smj", "lule sami" },
            { "smn", "inari sami" },
            { "sms", "skolt sami" },
            { "snk", "soninqu\u00ea" },
            { "sog", "sogdiano" },
            { "son", "songai" },
            { "srn", "idioma surinam\u00eas" },
            { "srr", "serere" },
            { "ssa", "idioma nilo-saariano" },
            { "suk", "sukuma" },
            { "sus", "sosso" },
            { "sux", "sum\u00e9rio" },
            { "swb", "comoriano" },
            { "syc", "sir\u00edaco cl\u00e1ssico" },
            { "syr", "sir\u00edaco" },
            { "tai", "idioma tailand\u00eas" },
            { "tem", "timne" },
            { "ter", "tereno" },
            { "tet", "t\u00e9tum" },
            { "tig", "tigr\u00e9" },
            { "tiv", "tiv" },
            { "tkl", "toquelauano" },
            { "tlh", "klingon" },
            { "tli", "tlinguite" },
            { "tmh", "tamaxeque" },
            { "tog", "tongan\u00eas de Nyasa" },
            { "tpi", "tok pisin" },
            { "tsi", "tsimshian" },
            { "tum", "tumbuka" },
            { "tup", "idioma tupi" },
            { "tut", "idioma altaico" },
            { "tvl", "tuvaluano" },
            { "tyv", "tuvinian" },
            { "udm", "udmurt" },
            { "uga", "ugar\u00edtico" },
            { "umb", "umbundu" },
            { "und", "idioma inv\u00e1lido ou desconhecido" },
            { "vai", "vai" },
            { "vot", "votic" },
            { "wae", "walser" },
            { "wak", "idioma wakashan" },
            { "wal", "walamo" },
            { "war", "waray" },
            { "was", "washo" },
            { "wen", "idioma sor\u00e1bio" },
            { "xal", "kalmyk" },
            { "yao", "yao" },
            { "yap", "yapese" },
            { "ypk", "idioma i\u00fapique" },
            { "yue", "canton\u00eas" },
            { "zap", "zapoteca" },
            { "zbl", "s\u00edmbolos blis" },
            { "zen", "zenaga" },
            { "znd", "zande" },
            { "zun", "zunhi" },
            { "zxx", "sem conte\u00fado lingu\u00edstico" },
            { "zza", "zaza" },
            { "Arab", "\u00e1rabe" },
            { "Armi", "armi" },
            { "Armn", "arm\u00eanio" },
            { "Avst", "av\u00e9stico" },
            { "Bali", "balin\u00eas" },
            { "Batk", "bataque" },
            { "Beng", "bengali" },
            { "Blis", "s\u00edmbolos bliss" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "braille" },
            { "Bugi", "bugin\u00eas" },
            { "Buhd", "buhid" },
            { "Cakm", "cakm" },
            { "Cans", "escrita sil\u00e1bica unificada dos abor\u00edgenes canadenses" },
            { "Cari", "cariano" },
            { "Cham", "cham" },
            { "Cher", "cherokee" },
            { "Cirt", "cirth" },
            { "Copt", "c\u00f3ptico" },
            { "Cprt", "cipriota" },
            { "Cyrl", "cir\u00edlico" },
            { "Cyrs", "cir\u00edlico eslavo eclesi\u00e1stico" },
            { "Deva", "devan\u00e1gari" },
            { "Dsrt", "deseret" },
            { "Egyd", "dem\u00f3tico eg\u00edpcio" },
            { "Egyh", "hier\u00e1tico eg\u00edpcio" },
            { "Egyp", "hier\u00f3glifos eg\u00edpcios" },
            { "Ethi", "eti\u00f3pico" },
            { "Geok", "khutsuri georgiano" },
            { "Geor", "georgiano" },
            { "Glag", "glagol\u00edtico" },
            { "Goth", "g\u00f3tico" },
            { "Grek", "grego" },
            { "Gujr", "gujerati" },
            { "Guru", "gurmuqui" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hano", "hanunoo" },
            { "Hans", "han simplificado" },
            { "Hant", "han tradicional" },
            { "Hebr", "hebraico" },
            { "Hira", "hiragana" },
            { "Hmng", "pahawh hmong" },
            { "Hrkt", "katakana ou hiragana" },
            { "Hung", "h\u00fangaro antigo" },
            { "Inds", "indo" },
            { "Ital", "it\u00e1lico antigo" },
            { "Java", "javan\u00eas" },
            { "Jpan", "japon\u00eas" },
            { "Kali", "kayah li" },
            { "Kana", "katakana" },
            { "Khar", "kharoshthi" },
            { "Khmr", "khmer" },
            { "Knda", "kannada" },
            { "Kore", "coreano" },
            { "Kthi", "kthi" },
            { "Lana", "lanna" },
            { "Laoo", "lao" },
            { "Latf", "latim fraktur" },
            { "Latg", "latim ga\u00e9lico" },
            { "Latn", "latim" },
            { "Lepc", "lepcha" },
            { "Limb", "limbu" },
            { "Lina", "A linear" },
            { "Linb", "B linear" },
            { "Lyci", "l\u00edcio" },
            { "Lydi", "l\u00eddio" },
            { "Mand", "mandaico" },
            { "Mani", "maniqueano" },
            { "Maya", "hier\u00f3glifos maias" },
            { "Mero", "mero\u00edtico" },
            { "Mlym", "malaiala" },
            { "Mong", "mongol" },
            { "Moon", "moon" },
            { "Mtei", "meitei mayek" },
            { "Mymr", "birman\u00eas" },
            { "Nkoo", "n'ko" },
            { "Ogam", "og\u00e2mico" },
            { "Olck", "ol chiki" },
            { "Orkh", "orkhon" },
            { "Orya", "oriya" },
            { "Osma", "osmania" },
            { "Perm", "p\u00e9rmico antigo" },
            { "Phag", "phags-pa" },
            { "Phli", "phli" },
            { "Phlp", "phlp" },
            { "Phlv", "pahlavi antigo" },
            { "Phnx", "fen\u00edcio" },
            { "Plrd", "fon\u00e9tico pollard" },
            { "Prti", "prti" },
            { "Rjng", "rejang" },
            { "Roro", "rongorongo" },
            { "Runr", "r\u00fanico" },
            { "Samr", "samaritano" },
            { "Sara", "sarati" },
            { "Saur", "saurashtra" },
            { "Sgnw", "signwriting" },
            { "Shaw", "shaviano" },
            { "Sinh", "cingal\u00eas" },
            { "Sund", "sundan\u00eas" },
            { "Sylo", "syloti nagri" },
            { "Syrc", "sir\u00edaco" },
            { "Syre", "sir\u00edaco estrangelo" },
            { "Syrj", "sir\u00edaco ocidental" },
            { "Syrn", "sir\u00edaco oriental" },
            { "Tagb", "tagbanwa" },
            { "Tale", "tai Le" },
            { "Talu", "novo tai lue" },
            { "Taml", "t\u00e2mil" },
            { "Tavt", "tavt" },
            { "Telu", "t\u00e9lugo" },
            { "Teng", "tengwar" },
            { "Tfng", "tifinagh" },
            { "Tglg", "tagalo" },
            { "Thaa", "thaana" },
            { "Thai", "tailand\u00eas" },
            { "Tibt", "tibetano" },
            { "Ugar", "ugar\u00edtico" },
            { "Vaii", "vai" },
            { "Visp", "visible speech" },
            { "Xpeo", "persa antigo" },
            { "Xsux", "sum\u00e9rio-acadiano cuneiforme" },
            { "Yiii", "yi" },
            { "Zinh", "herdado" },
            { "Zmth", "zmth" },
            { "Zsym", "zsym" },
            { "Zxxx", "\u00e1grafo" },
            { "Zyyy", "comum" },
            { "Zzzz", "escrita desconhecida ou inv\u00e1lida" },
            { "de_AT", "alem\u00e3o austr\u00edaco" },
            { "de_CH", "alto alem\u00e3o su\u00ed\u00e7o" },
            { "en_AU", "ingl\u00eas australiano" },
            { "en_CA", "ingl\u00eas canadense" },
            { "en_GB", "ingl\u00eas brit\u00e2nico" },
            { "en_US", "ingl\u00eas americano" },
            { "es_ES", "espanhol ib\u00e9rico" },
            { "fr_CA", "franc\u00eas canadense" },
            { "fr_CH", "franc\u00eas su\u00ed\u00e7o" },
            { "nl_BE", "flamengo" },
            { "pt_BR", "portugu\u00eas do Brasil" },
            { "pt_PT", "portugu\u00eas ib\u00e9rico" },
            { "es_419", "espanhol latino-americano" },
            { "zh_Hans", "chin\u00eas simplificado" },
            { "zh_Hant", "chin\u00eas tradicional" },
        };
        return data;
    }
}
