/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.Color;
import java.awt.Transparency;
import sun.java2d.SurfaceData;
import sun.java2d.SurfaceDataProxy;
import sun.java2d.loops.CompositeType;
import sun.java2d.xr.XRGraphicsConfig;
import sun.java2d.xr.XRSurfaceData;

public class XRSurfaceDataProxy
extends SurfaceDataProxy
implements Transparency {
    XRGraphicsConfig xrgc;
    int transparency;

    public static SurfaceDataProxy createProxy(SurfaceData surfaceData, XRGraphicsConfig xRGraphicsConfig) {
        if (surfaceData instanceof XRSurfaceData) {
            return UNCACHED;
        }
        return new XRSurfaceDataProxy(xRGraphicsConfig, surfaceData.getTransparency());
    }

    public XRSurfaceDataProxy(XRGraphicsConfig xRGraphicsConfig) {
        this.xrgc = xRGraphicsConfig;
    }

    @Override
    public SurfaceData validateSurfaceData(SurfaceData surfaceData, SurfaceData surfaceData2, int n, int n2) {
        if (surfaceData2 == null) {
            try {
                surfaceData2 = XRSurfaceData.createData(this.xrgc, n, n2, this.xrgc.getColorModel(), null, 0L, this.getTransparency());
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
        }
        return surfaceData2;
    }

    public XRSurfaceDataProxy(XRGraphicsConfig xRGraphicsConfig, int n) {
        this.xrgc = xRGraphicsConfig;
        this.transparency = n;
    }

    @Override
    public boolean isSupportedOperation(SurfaceData surfaceData, int n, CompositeType compositeType, Color color) {
        return color == null || this.transparency == 3;
    }

    @Override
    public int getTransparency() {
        return this.transparency;
    }
}

