/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.Record;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLStringizer;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.Utilities;

final class ServerNameExtension {
    static final HandshakeProducer chNetworkProducer = new CHServerNameProducer();
    static final SSLExtension.ExtensionConsumer chOnLoadConsumer = new CHServerNameConsumer();
    static final SSLStringizer chStringizer = new CHServerNamesStringizer();
    static final HandshakeProducer shNetworkProducer = new SHServerNameProducer();
    static final SSLExtension.ExtensionConsumer shOnLoadConsumer = new SHServerNameConsumer();
    static final SSLStringizer shStringizer = new SHServerNamesStringizer();
    static final HandshakeProducer eeNetworkProducer = new EEServerNameProducer();
    static final SSLExtension.ExtensionConsumer eeOnLoadConsumer = new EEServerNameConsumer();

    ServerNameExtension() {
    }

    private static final class EEServerNameConsumer
    implements SSLExtension.ExtensionConsumer {
        private EEServerNameConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            CHServerNamesSpec cHServerNamesSpec = (CHServerNamesSpec)clientHandshakeContext.handshakeExtensions.get(SSLExtension.CH_SERVER_NAME);
            if (cHServerNamesSpec == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected EncryptedExtensions server_name extension");
            }
            if (byteBuffer.remaining() != 0) {
                throw clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Invalid EncryptedExtensions server_name extension");
            }
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.EE_SERVER_NAME, SHServerNamesSpec.DEFAULT);
            clientHandshakeContext.negotiatedServerName = cHServerNamesSpec.serverNames.get(0);
        }
    }

    private static final class EEServerNameProducer
    implements HandshakeProducer {
        private EEServerNameProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            CHServerNamesSpec cHServerNamesSpec = (CHServerNamesSpec)serverHandshakeContext.handshakeExtensions.get(SSLExtension.CH_SERVER_NAME);
            if (cHServerNamesSpec == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.finest("Ignore unavailable extension: " + SSLExtension.EE_SERVER_NAME.name, new Object[0]);
                }
                return null;
            }
            if (serverHandshakeContext.isResumption || serverHandshakeContext.negotiatedServerName == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.finest("No expected server name indication response", new Object[0]);
                }
                return null;
            }
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.EE_SERVER_NAME, SHServerNamesSpec.DEFAULT);
            return new byte[0];
        }
    }

    private static final class SHServerNameConsumer
    implements SSLExtension.ExtensionConsumer {
        private SHServerNameConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            CHServerNamesSpec cHServerNamesSpec = (CHServerNamesSpec)clientHandshakeContext.handshakeExtensions.get(SSLExtension.CH_SERVER_NAME);
            if (cHServerNamesSpec == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected ServerHello server_name extension");
            }
            if (byteBuffer.remaining() != 0) {
                throw clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Invalid ServerHello server_name extension");
            }
            clientHandshakeContext.handshakeExtensions.put(SSLExtension.SH_SERVER_NAME, SHServerNamesSpec.DEFAULT);
            clientHandshakeContext.negotiatedServerName = cHServerNamesSpec.serverNames.get(0);
        }
    }

    private static final class SHServerNameProducer
    implements HandshakeProducer {
        private SHServerNameProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            CHServerNamesSpec cHServerNamesSpec = (CHServerNamesSpec)serverHandshakeContext.handshakeExtensions.get(SSLExtension.CH_SERVER_NAME);
            if (cHServerNamesSpec == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.finest("Ignore unavailable extension: " + SSLExtension.SH_SERVER_NAME.name, new Object[0]);
                }
                return null;
            }
            if (serverHandshakeContext.isResumption || serverHandshakeContext.negotiatedServerName == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.finest("No expected server name indication response", new Object[0]);
                }
                return null;
            }
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.SH_SERVER_NAME, SHServerNamesSpec.DEFAULT);
            return new byte[0];
        }
    }

    private static final class SHServerNamesStringizer
    implements SSLStringizer {
        private SHServerNamesStringizer() {
        }

        @Override
        public String toString(ByteBuffer byteBuffer) {
            try {
                return new SHServerNamesSpec(byteBuffer).toString();
            }
            catch (IOException iOException) {
                return iOException.getMessage();
            }
        }
    }

    static final class SHServerNamesSpec
    implements SSLExtension.SSLExtensionSpec {
        static final SHServerNamesSpec DEFAULT = new SHServerNamesSpec();

        private SHServerNamesSpec() {
        }

        private SHServerNamesSpec(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.remaining() != 0) {
                throw new SSLProtocolException("Invalid ServerHello server_name extension: not empty");
            }
        }

        public String toString() {
            return "<empty extension_data field>";
        }
    }

    private static final class CHServerNameConsumer
    implements SSLExtension.ExtensionConsumer {
        private CHServerNameConsumer() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void consume(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage, ByteBuffer byteBuffer) throws IOException {
            CHServerNamesSpec cHServerNamesSpec;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_SERVER_NAME)) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) return;
                SSLLogger.fine("Ignore unavailable extension: " + SSLExtension.CH_SERVER_NAME.name, new Object[0]);
                return;
            }
            try {
                cHServerNamesSpec = new CHServerNamesSpec(byteBuffer);
            }
            catch (IOException iOException) {
                throw serverHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, iOException);
            }
            serverHandshakeContext.handshakeExtensions.put(SSLExtension.CH_SERVER_NAME, cHServerNamesSpec);
            SNIServerName sNIServerName = null;
            if (!serverHandshakeContext.sslConfig.sniMatchers.isEmpty()) {
                sNIServerName = CHServerNameConsumer.chooseSni(serverHandshakeContext.sslConfig.sniMatchers, cHServerNamesSpec.serverNames);
                if (sNIServerName == null) throw serverHandshakeContext.conContext.fatal(Alert.UNRECOGNIZED_NAME, "Unrecognized server name indication");
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("server name indication (" + sNIServerName + ") is accepted", new Object[0]);
                }
            } else if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("no server name matchers, ignore server name indication", new Object[0]);
            }
            if (serverHandshakeContext.isResumption && serverHandshakeContext.resumingSession != null && !Objects.equals(sNIServerName, serverHandshakeContext.resumingSession.serverNameIndication)) {
                serverHandshakeContext.isResumption = false;
                serverHandshakeContext.resumingSession = null;
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("abort session resumption, different server name indication used", new Object[0]);
                }
            }
            serverHandshakeContext.requestedServerNames = cHServerNamesSpec.serverNames;
            serverHandshakeContext.negotiatedServerName = sNIServerName;
        }

        private static SNIServerName chooseSni(Collection<SNIMatcher> collection, List<SNIServerName> list) {
            if (list != null && !list.isEmpty()) {
                block0: for (SNIMatcher sNIMatcher : collection) {
                    int n = sNIMatcher.getType();
                    for (SNIServerName sNIServerName : list) {
                        if (sNIServerName.getType() != n) continue;
                        if (!sNIMatcher.matches(sNIServerName)) continue block0;
                        return sNIServerName;
                    }
                }
            }
            return null;
        }
    }

    private static final class CHServerNameProducer
    implements HandshakeProducer {
        private CHServerNameProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (!clientHandshakeContext.sslConfig.isAvailable(SSLExtension.CH_SERVER_NAME)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.warning("Ignore unavailable server_name extension", new Object[0]);
                }
                return null;
            }
            List<SNIServerName> list = clientHandshakeContext.isResumption && clientHandshakeContext.resumingSession != null ? clientHandshakeContext.resumingSession.getRequestedServerNames() : clientHandshakeContext.sslConfig.serverNames;
            if (list != null && !list.isEmpty()) {
                int n = 0;
                for (SNIServerName object2 : list) {
                    n += 3;
                    n += object2.getEncoded().length;
                }
                Object object3 = new byte[n + 2];
                ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])object3);
                Record.putInt16(byteBuffer, n);
                for (SNIServerName sNIServerName : list) {
                    Record.putInt8(byteBuffer, sNIServerName.getType());
                    Record.putBytes16(byteBuffer, sNIServerName.getEncoded());
                }
                clientHandshakeContext.requestedServerNames = list;
                clientHandshakeContext.handshakeExtensions.put(SSLExtension.CH_SERVER_NAME, new CHServerNamesSpec(list));
                return object3;
            }
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.warning("Unable to indicate server name", new Object[0]);
            }
            return null;
        }
    }

    private static final class CHServerNamesStringizer
    implements SSLStringizer {
        private CHServerNamesStringizer() {
        }

        @Override
        public String toString(ByteBuffer byteBuffer) {
            try {
                return new CHServerNamesSpec(byteBuffer).toString();
            }
            catch (IOException iOException) {
                return iOException.getMessage();
            }
        }
    }

    static final class CHServerNamesSpec
    implements SSLExtension.SSLExtensionSpec {
        static final int NAME_HEADER_LENGTH = 3;
        final List<SNIServerName> serverNames;

        private CHServerNamesSpec(List<SNIServerName> list) {
            this.serverNames = Collections.unmodifiableList(new ArrayList<SNIServerName>(list));
        }

        private CHServerNamesSpec(ByteBuffer byteBuffer) throws IOException {
            if (byteBuffer.remaining() < 2) {
                throw new SSLProtocolException("Invalid server_name extension: insufficient data");
            }
            int n = Record.getInt16(byteBuffer);
            if (n == 0 || n != byteBuffer.remaining()) {
                throw new SSLProtocolException("Invalid server_name extension: incomplete data");
            }
            LinkedHashMap<Integer, SNIServerName> linkedHashMap = new LinkedHashMap<Integer, SNIServerName>();
            while (byteBuffer.hasRemaining()) {
                SNIServerName sNIServerName;
                int n2 = Record.getInt8(byteBuffer);
                byte[] byArray = Record.getBytes16(byteBuffer);
                if (n2 == 0) {
                    if (byArray.length == 0) {
                        throw new SSLProtocolException("Empty HostName in server_name extension");
                    }
                    try {
                        sNIServerName = new SNIHostName(byArray);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        SSLProtocolException sSLProtocolException = new SSLProtocolException("Illegal server name, type=host_name(" + n2 + "), name=" + new String(byArray, StandardCharsets.UTF_8) + ", value={" + Utilities.toHexString(byArray) + "}");
                        throw (SSLProtocolException)sSLProtocolException.initCause(illegalArgumentException);
                    }
                }
                try {
                    sNIServerName = new UnknownServerName(n2, byArray);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    SSLProtocolException sSLProtocolException = new SSLProtocolException("Illegal server name, type=(" + n2 + "), value={" + Utilities.toHexString(byArray) + "}");
                    throw (SSLProtocolException)sSLProtocolException.initCause(illegalArgumentException);
                }
                if (linkedHashMap.put(sNIServerName.getType(), sNIServerName) == null) continue;
                throw new SSLProtocolException("Duplicated server name of type " + sNIServerName.getType());
            }
            this.serverNames = new ArrayList(linkedHashMap.values());
        }

        public String toString() {
            if (this.serverNames == null || this.serverNames.isEmpty()) {
                return "<no server name indicator specified>";
            }
            StringBuilder stringBuilder = new StringBuilder(512);
            for (SNIServerName sNIServerName : this.serverNames) {
                stringBuilder.append(sNIServerName.toString());
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }

        private static class UnknownServerName
        extends SNIServerName {
            UnknownServerName(int n, byte[] byArray) {
                super(n, byArray);
            }
        }
    }
}

