/* 
    complex - functions and definitions for complex types

    Copyright (C) 1995, Adam Fedor
*/

#ifndef _COMPLEX_INCLUDE_
#define _COMPLEX_INCLUDE_

/* GCC has types for complex, but currently it can't do @encode() on them. Also, theoretically
   you can substitute the types from vecLib here so you can use MathLib and vecLib 
   together.*/
typedef struct _complex_float_ {
    float real, imag;
} complex_float;

typedef struct _complex_double_ {
    double real, imag;
} complex_double;

extern complex_double c_f2d (complex_float f);
extern complex_float  c_d2f (complex_double d);

extern complex_double c_add (complex_double x, complex_double y);
extern complex_double c_sub (complex_double x, complex_double y);
extern complex_double c_mult (complex_double x, complex_double y);
extern complex_double c_div (complex_double x, complex_double y);

extern double c_abs (complex_double z);
extern double c_imag (complex_double z);
extern double c_real (complex_double z);
extern complex_double c_set (double real, double imag);

extern complex_double c_cos (complex_double z);
extern complex_double c_exp (complex_double z);
extern complex_double c_log (complex_double z);
extern complex_double c_log10 (complex_double z);
extern complex_double c_conj (complex_double z);
extern complex_double c_pow (complex_double x, complex_double y);
extern complex_double c_sin (complex_double z);
extern complex_double c_sqrt (complex_double z);

extern complex_double	c_acos( complex_double __x );
extern complex_double	c_asin( complex_double __x );
extern complex_double	c_atan( complex_double __x );
extern complex_double	c_atan2( complex_double __x, complex_double __y );
extern complex_double	c_cosh( complex_double __x );
extern complex_double	c_mod( complex_double __x, complex_double __y );
extern complex_double	c_sinh( complex_double __x );
extern complex_double	c_tan( complex_double __x );
extern complex_double	c_tanh( complex_double __x );

#endif /* _COMPLEX_INCLUDE_ */
