/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.xml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.xml.XmlStreamReaderException;

@Deprecated
public class XmlReader
extends Reader {
    private static final int BUFFER_SIZE = 4096;
    private static final String UTF_8 = "UTF-8";
    private static final String US_ASCII = "US-ASCII";
    private static final String UTF_16BE = "UTF-16BE";
    private static final String UTF_16LE = "UTF-16LE";
    private static final String UTF_16 = "UTF-16";
    private static final String EBCDIC = "CP1047";
    private static String _staticDefaultEncoding = null;
    private Reader _reader;
    private String _encoding;
    private String _defaultEncoding;
    private static final Pattern CHARSET_PATTERN = Pattern.compile("charset=([.[^; ]]*)");
    static final Pattern ENCODING_PATTERN = Pattern.compile("<\\?xml.*encoding[\\s]*=[\\s]*((?:\".[^\"]*\")|(?:'.[^']*'))", 8);
    private static final MessageFormat RAW_EX_1 = new MessageFormat("Invalid encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] encoding mismatch");
    private static final MessageFormat RAW_EX_2 = new MessageFormat("Invalid encoding, BOM [{0}] XML guess [{1}] XML prolog [{2}] unknown BOM");
    private static final MessageFormat HTTP_EX_1 = new MessageFormat("Invalid encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], BOM must be NULL");
    private static final MessageFormat HTTP_EX_2 = new MessageFormat("Invalid encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], encoding mismatch");
    private static final MessageFormat HTTP_EX_3 = new MessageFormat("Invalid encoding, CT-MIME [{0}] CT-Enc [{1}] BOM [{2}] XML guess [{3}] XML prolog [{4}], Invalid MIME");

    public static void setDefaultEncoding(String encoding2) {
        _staticDefaultEncoding = encoding2;
    }

    public static String getDefaultEncoding() {
        return _staticDefaultEncoding;
    }

    public XmlReader(File file2) throws IOException {
        this(Files.newInputStream(file2.toPath(), new OpenOption[0]));
    }

    public XmlReader(InputStream is2) throws IOException {
        this(is2, true);
    }

    public XmlReader(InputStream is2, boolean lenient) throws IOException, XmlStreamReaderException {
        this._defaultEncoding = _staticDefaultEncoding;
        try {
            this.doRawStream(is2, lenient);
        }
        catch (XmlStreamReaderException ex) {
            if (!lenient) {
                throw ex;
            }
            this.doLenientDetection(null, ex);
        }
    }

    public XmlReader(URL url) throws IOException {
        this(url.openConnection());
    }

    public XmlReader(URLConnection conn) throws IOException {
        this._defaultEncoding = _staticDefaultEncoding;
        boolean lenient = true;
        if (conn instanceof HttpURLConnection) {
            try {
                this.doHttpStream(conn.getInputStream(), conn.getContentType(), lenient);
            }
            catch (XmlStreamReaderException ex) {
                this.doLenientDetection(conn.getContentType(), ex);
            }
        } else if (conn.getContentType() != null) {
            try {
                this.doHttpStream(conn.getInputStream(), conn.getContentType(), lenient);
            }
            catch (XmlStreamReaderException ex) {
                this.doLenientDetection(conn.getContentType(), ex);
            }
        } else {
            try {
                this.doRawStream(conn.getInputStream(), lenient);
            }
            catch (XmlStreamReaderException ex) {
                this.doLenientDetection(null, ex);
            }
        }
    }

    public XmlReader(InputStream is2, String httpContentType) throws IOException {
        this(is2, httpContentType, true);
    }

    public XmlReader(InputStream is2, String httpContentType, boolean lenient, String defaultEncoding) throws IOException, XmlStreamReaderException {
        this._defaultEncoding = defaultEncoding == null ? _staticDefaultEncoding : defaultEncoding;
        try {
            this.doHttpStream(is2, httpContentType, lenient);
        }
        catch (XmlStreamReaderException ex) {
            if (!lenient) {
                throw ex;
            }
            this.doLenientDetection(httpContentType, ex);
        }
    }

    public XmlReader(InputStream is2, String httpContentType, boolean lenient) throws IOException, XmlStreamReaderException {
        this(is2, httpContentType, lenient, null);
    }

    private void doLenientDetection(String httpContentType, XmlStreamReaderException ex) throws IOException {
        if (httpContentType != null && httpContentType.startsWith("text/html")) {
            httpContentType = httpContentType.substring("text/html".length());
            httpContentType = "text/xml" + httpContentType;
            try {
                this.doHttpStream(ex.getInputStream(), httpContentType, true);
                ex = null;
            }
            catch (XmlStreamReaderException ex2) {
                ex = ex2;
            }
        }
        if (ex != null) {
            String encoding2 = ex.getXmlEncoding();
            if (encoding2 == null) {
                encoding2 = ex.getContentTypeEncoding();
            }
            if (encoding2 == null) {
                encoding2 = this._defaultEncoding == null ? UTF_8 : this._defaultEncoding;
            }
            this.prepareReader(ex.getInputStream(), encoding2);
        }
    }

    public String getEncoding() {
        return this._encoding;
    }

    @Override
    public int read(char[] buf, int offset, int len) throws IOException {
        return this._reader.read(buf, offset, len);
    }

    @Override
    public void close() throws IOException {
        this._reader.close();
    }

    private void doRawStream(InputStream is2, boolean lenient) throws IOException {
        BufferedInputStream pis = new BufferedInputStream(is2, 4096);
        String bomEnc = XmlReader.getBOMEncoding(pis);
        String xmlGuessEnc = XmlReader.getXMLGuessEncoding(pis);
        String xmlEnc = XmlReader.getXmlProlog(pis, xmlGuessEnc);
        String encoding2 = this.calculateRawEncoding(bomEnc, xmlGuessEnc, xmlEnc, pis);
        this.prepareReader(pis, encoding2);
    }

    private void doHttpStream(InputStream is2, String httpContentType, boolean lenient) throws IOException {
        BufferedInputStream pis = new BufferedInputStream(is2, 4096);
        String cTMime = XmlReader.getContentTypeMime(httpContentType);
        String cTEnc = XmlReader.getContentTypeEncoding(httpContentType);
        String bomEnc = XmlReader.getBOMEncoding(pis);
        String xmlGuessEnc = XmlReader.getXMLGuessEncoding(pis);
        String xmlEnc = XmlReader.getXmlProlog(pis, xmlGuessEnc);
        String encoding2 = this.calculateHttpEncoding(cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc, pis, lenient);
        this.prepareReader(pis, encoding2);
    }

    private void prepareReader(InputStream is2, String encoding2) throws IOException {
        this._reader = new InputStreamReader(is2, encoding2);
        this._encoding = encoding2;
    }

    private String calculateRawEncoding(String bomEnc, String xmlGuessEnc, String xmlEnc, InputStream is2) throws IOException {
        String encoding2;
        if (bomEnc == null) {
            encoding2 = xmlGuessEnc == null || xmlEnc == null ? (this._defaultEncoding == null ? UTF_8 : this._defaultEncoding) : (xmlEnc.equals(UTF_16) && (xmlGuessEnc.equals(UTF_16BE) || xmlGuessEnc.equals(UTF_16LE)) ? xmlGuessEnc : xmlEnc);
        } else if (bomEnc.equals(UTF_8)) {
            if (xmlGuessEnc != null && !xmlGuessEnc.equals(UTF_8)) {
                throw new XmlStreamReaderException(RAW_EX_1.format(new Object[]{bomEnc, xmlGuessEnc, xmlEnc}), bomEnc, xmlGuessEnc, xmlEnc, is2);
            }
            if (xmlEnc != null && !xmlEnc.equals(UTF_8)) {
                throw new XmlStreamReaderException(RAW_EX_1.format(new Object[]{bomEnc, xmlGuessEnc, xmlEnc}), bomEnc, xmlGuessEnc, xmlEnc, is2);
            }
            encoding2 = UTF_8;
        } else if (bomEnc.equals(UTF_16BE) || bomEnc.equals(UTF_16LE)) {
            if (xmlGuessEnc != null && !xmlGuessEnc.equals(bomEnc)) {
                throw new IOException(RAW_EX_1.format(new Object[]{bomEnc, xmlGuessEnc, xmlEnc}));
            }
            if (xmlEnc != null && !xmlEnc.equals(UTF_16) && !xmlEnc.equals(bomEnc)) {
                throw new XmlStreamReaderException(RAW_EX_1.format(new Object[]{bomEnc, xmlGuessEnc, xmlEnc}), bomEnc, xmlGuessEnc, xmlEnc, is2);
            }
            encoding2 = bomEnc;
        } else {
            throw new XmlStreamReaderException(RAW_EX_2.format(new Object[]{bomEnc, xmlGuessEnc, xmlEnc}), bomEnc, xmlGuessEnc, xmlEnc, is2);
        }
        return encoding2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String calculateHttpEncoding(String cTMime, String cTEnc, String bomEnc, String xmlGuessEnc, String xmlEnc, InputStream is2, boolean lenient) throws IOException {
        if (lenient & xmlEnc != null) {
            return xmlEnc;
        }
        boolean appXml = XmlReader.isAppXml(cTMime);
        boolean textXml = XmlReader.isTextXml(cTMime);
        if (!appXml && !textXml) throw new XmlStreamReaderException(HTTP_EX_3.format(new Object[]{cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc}), cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc, is2);
        if (cTEnc == null) {
            if (appXml) {
                return this.calculateRawEncoding(bomEnc, xmlGuessEnc, xmlEnc, is2);
            }
            if (this._defaultEncoding == null) {
                return US_ASCII;
            }
            String string2 = this._defaultEncoding;
            return string2;
        }
        if (bomEnc != null && (cTEnc.equals(UTF_16BE) || cTEnc.equals(UTF_16LE))) {
            throw new XmlStreamReaderException(HTTP_EX_1.format(new Object[]{cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc}), cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc, is2);
        }
        if (!cTEnc.equals(UTF_16)) return cTEnc;
        if (bomEnc == null || !bomEnc.startsWith(UTF_16)) throw new XmlStreamReaderException(HTTP_EX_2.format(new Object[]{cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc}), cTMime, cTEnc, bomEnc, xmlGuessEnc, xmlEnc, is2);
        return bomEnc;
    }

    private static String getContentTypeMime(String httpContentType) {
        String mime = null;
        if (httpContentType != null) {
            int i = httpContentType.indexOf(";");
            mime = (i == -1 ? httpContentType : httpContentType.substring(0, i)).trim();
        }
        return mime;
    }

    private static String getContentTypeEncoding(String httpContentType) {
        int i;
        String encoding2 = null;
        if (httpContentType != null && (i = httpContentType.indexOf(";")) > -1) {
            String postMime = httpContentType.substring(i + 1);
            Matcher m = CHARSET_PATTERN.matcher(postMime);
            encoding2 = m.find() ? m.group(1) : null;
            encoding2 = encoding2 != null ? encoding2.toUpperCase(Locale.ENGLISH) : null;
        }
        return encoding2;
    }

    private static String getBOMEncoding(BufferedInputStream is2) throws IOException {
        String encoding2 = null;
        int[] bytes2 = new int[3];
        is2.mark(3);
        bytes2[0] = is2.read();
        bytes2[1] = is2.read();
        bytes2[2] = is2.read();
        if (bytes2[0] == 254 && bytes2[1] == 255) {
            encoding2 = UTF_16BE;
            is2.reset();
            is2.read();
            is2.read();
        } else if (bytes2[0] == 255 && bytes2[1] == 254) {
            encoding2 = UTF_16LE;
            is2.reset();
            is2.read();
            is2.read();
        } else if (bytes2[0] == 239 && bytes2[1] == 187 && bytes2[2] == 191) {
            encoding2 = UTF_8;
        } else {
            is2.reset();
        }
        return encoding2;
    }

    private static String getXMLGuessEncoding(BufferedInputStream is2) throws IOException {
        String encoding2 = null;
        int[] bytes2 = new int[4];
        is2.mark(4);
        bytes2[0] = is2.read();
        bytes2[1] = is2.read();
        bytes2[2] = is2.read();
        bytes2[3] = is2.read();
        is2.reset();
        if (bytes2[0] == 0 && bytes2[1] == 60 && bytes2[2] == 0 && bytes2[3] == 63) {
            encoding2 = UTF_16BE;
        } else if (bytes2[0] == 60 && bytes2[1] == 0 && bytes2[2] == 63 && bytes2[3] == 0) {
            encoding2 = UTF_16LE;
        } else if (bytes2[0] == 60 && bytes2[1] == 63 && bytes2[2] == 120 && bytes2[3] == 109) {
            encoding2 = UTF_8;
        } else if (bytes2[0] == 76 && bytes2[1] == 111 && bytes2[2] == 167 && bytes2[3] == 148) {
            encoding2 = EBCDIC;
        }
        return encoding2;
    }

    private static String getXmlProlog(BufferedInputStream is2, String guessedEnc) throws IOException {
        String encoding2 = null;
        if (guessedEnc != null) {
            byte[] bytes2 = new byte[4096];
            is2.mark(4096);
            int offset = 0;
            int max2 = 4096;
            int c = is2.read(bytes2, offset, max2);
            int firstGT = -1;
            String xmlProlog = null;
            while (c != -1 && firstGT == -1 && offset < 4096) {
                c = is2.read(bytes2, offset += c, max2 -= c);
                xmlProlog = new String(bytes2, 0, offset, guessedEnc);
                firstGT = xmlProlog.indexOf(62);
            }
            if (firstGT == -1) {
                if (c == -1) {
                    throw new IOException("Unexpected end of XML stream");
                }
                throw new IOException("XML prolog or ROOT element not found on first " + offset + " bytes");
            }
            int bytesRead = offset;
            if (bytesRead > 0) {
                is2.reset();
                BufferedReader bReader = new BufferedReader(new StringReader(xmlProlog.substring(0, firstGT + 1)));
                StringBuilder prolog = new StringBuilder();
                String line = bReader.readLine();
                while (line != null) {
                    prolog.append(line);
                    line = bReader.readLine();
                }
                Matcher m = ENCODING_PATTERN.matcher(prolog);
                if (m.find()) {
                    encoding2 = m.group(1).toUpperCase(Locale.ENGLISH);
                    encoding2 = encoding2.substring(1, encoding2.length() - 1);
                }
            }
        }
        return encoding2;
    }

    private static boolean isAppXml(String mime) {
        return mime != null && (mime.equals("application/xml") || mime.equals("application/xml-dtd") || mime.equals("application/xml-external-parsed-entity") || mime.startsWith("application/") && mime.endsWith("+xml"));
    }

    private static boolean isTextXml(String mime) {
        return mime != null && (mime.equals("text/xml") || mime.equals("text/xml-external-parsed-entity") || mime.startsWith("text/") && mime.endsWith("+xml"));
    }
}

