// Copyright 2017-2021 Espressif Systems (Shanghai) PTE LTD
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
#ifndef _SOC_WORLD_CONTROLLER_REG_H_
#define _SOC_WORLD_CONTROLLER_REG_H_


#include "soc.h"
#ifdef __cplusplus
extern "C" {
#endif

#define WORLD_CONTROLLER_WCL_CORE_0_ENTRY_1_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x0)
/* WORLD_CONTROLLER_CORE_0_ENTRY_1_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_0 Entry 1 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_0_ENTRY_1_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_1_ADDR_M  ((WORLD_CONTROLLER_CORE_0_ENTRY_1_ADDR_V)<<(WORLD_CONTROLLER_CORE_0_ENTRY_1_ADDR_S))
#define WORLD_CONTROLLER_CORE_0_ENTRY_1_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_1_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_ENTRY_2_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x4)
/* WORLD_CONTROLLER_CORE_0_ENTRY_2_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_0 Entry 2 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_0_ENTRY_2_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_2_ADDR_M  ((WORLD_CONTROLLER_CORE_0_ENTRY_2_ADDR_V)<<(WORLD_CONTROLLER_CORE_0_ENTRY_2_ADDR_S))
#define WORLD_CONTROLLER_CORE_0_ENTRY_2_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_2_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_ENTRY_3_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x8)
/* WORLD_CONTROLLER_CORE_0_ENTRY_3_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_0 Entry 3 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_0_ENTRY_3_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_3_ADDR_M  ((WORLD_CONTROLLER_CORE_0_ENTRY_3_ADDR_V)<<(WORLD_CONTROLLER_CORE_0_ENTRY_3_ADDR_S))
#define WORLD_CONTROLLER_CORE_0_ENTRY_3_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_3_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_ENTRY_4_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0xC)
/* WORLD_CONTROLLER_CORE_0_ENTRY_4_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_0 Entry 4 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_0_ENTRY_4_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_4_ADDR_M  ((WORLD_CONTROLLER_CORE_0_ENTRY_4_ADDR_V)<<(WORLD_CONTROLLER_CORE_0_ENTRY_4_ADDR_S))
#define WORLD_CONTROLLER_CORE_0_ENTRY_4_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_4_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_ENTRY_5_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x10)
/* WORLD_CONTROLLER_CORE_0_ENTRY_5_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_0 Entry 5 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_0_ENTRY_5_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_5_ADDR_M  ((WORLD_CONTROLLER_CORE_0_ENTRY_5_ADDR_V)<<(WORLD_CONTROLLER_CORE_0_ENTRY_5_ADDR_S))
#define WORLD_CONTROLLER_CORE_0_ENTRY_5_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_5_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_ENTRY_6_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x14)
/* WORLD_CONTROLLER_CORE_0_ENTRY_6_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_0 Entry 6 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_0_ENTRY_6_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_6_ADDR_M  ((WORLD_CONTROLLER_CORE_0_ENTRY_6_ADDR_V)<<(WORLD_CONTROLLER_CORE_0_ENTRY_6_ADDR_S))
#define WORLD_CONTROLLER_CORE_0_ENTRY_6_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_6_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_ENTRY_7_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x18)
/* WORLD_CONTROLLER_CORE_0_ENTRY_7_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_0 Entry 7 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_0_ENTRY_7_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_7_ADDR_M  ((WORLD_CONTROLLER_CORE_0_ENTRY_7_ADDR_V)<<(WORLD_CONTROLLER_CORE_0_ENTRY_7_ADDR_S))
#define WORLD_CONTROLLER_CORE_0_ENTRY_7_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_7_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_ENTRY_8_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x1C)
/* WORLD_CONTROLLER_CORE_0_ENTRY_8_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_0 Entry 8 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_0_ENTRY_8_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_8_ADDR_M  ((WORLD_CONTROLLER_CORE_0_ENTRY_8_ADDR_V)<<(WORLD_CONTROLLER_CORE_0_ENTRY_8_ADDR_S))
#define WORLD_CONTROLLER_CORE_0_ENTRY_8_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_8_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_ENTRY_9_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x20)
/* WORLD_CONTROLLER_CORE_0_ENTRY_9_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_0 Entry 9 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_0_ENTRY_9_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_9_ADDR_M  ((WORLD_CONTROLLER_CORE_0_ENTRY_9_ADDR_V)<<(WORLD_CONTROLLER_CORE_0_ENTRY_9_ADDR_S))
#define WORLD_CONTROLLER_CORE_0_ENTRY_9_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_9_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_ENTRY_10_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x24)
/* WORLD_CONTROLLER_CORE_0_ENTRY_10_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_0 Entry 10 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_0_ENTRY_10_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_10_ADDR_M  ((WORLD_CONTROLLER_CORE_0_ENTRY_10_ADDR_V)<<(WORLD_CONTROLLER_CORE_0_ENTRY_10_ADDR_S))
#define WORLD_CONTROLLER_CORE_0_ENTRY_10_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_10_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_ENTRY_11_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x28)
/* WORLD_CONTROLLER_CORE_0_ENTRY_11_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_0 Entry 11 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_0_ENTRY_11_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_11_ADDR_M  ((WORLD_CONTROLLER_CORE_0_ENTRY_11_ADDR_V)<<(WORLD_CONTROLLER_CORE_0_ENTRY_11_ADDR_S))
#define WORLD_CONTROLLER_CORE_0_ENTRY_11_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_11_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_ENTRY_12_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x2C)
/* WORLD_CONTROLLER_CORE_0_ENTRY_12_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_0 Entry 12 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_0_ENTRY_12_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_12_ADDR_M  ((WORLD_CONTROLLER_CORE_0_ENTRY_12_ADDR_V)<<(WORLD_CONTROLLER_CORE_0_ENTRY_12_ADDR_S))
#define WORLD_CONTROLLER_CORE_0_ENTRY_12_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_12_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_ENTRY_13_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x30)
/* WORLD_CONTROLLER_CORE_0_ENTRY_13_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_0 Entry 13 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_0_ENTRY_13_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_13_ADDR_M  ((WORLD_CONTROLLER_CORE_0_ENTRY_13_ADDR_V)<<(WORLD_CONTROLLER_CORE_0_ENTRY_13_ADDR_S))
#define WORLD_CONTROLLER_CORE_0_ENTRY_13_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_13_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_ENTRY_CHECK_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x7C)
/* WORLD_CONTROLLER_CORE_0_ENTRY_CHECK : R/W ;bitpos:[13:1] ;default: 1'b1 ; */
/*description: This filed is used to enable entry address check .*/
#define WORLD_CONTROLLER_CORE_0_ENTRY_CHECK    0x00001FFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_CHECK_M  ((WORLD_CONTROLLER_CORE_0_ENTRY_CHECK_V)<<(WORLD_CONTROLLER_CORE_0_ENTRY_CHECK_S))
#define WORLD_CONTROLLER_CORE_0_ENTRY_CHECK_V  0x1FFF
#define WORLD_CONTROLLER_CORE_0_ENTRY_CHECK_S  1

#define WORLD_CONTROLLER_WCL_CORE_0_MESSAGE_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x100)
/* WORLD_CONTROLLER_CORE_0_MESSAGE_ADDR : R/W ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: This field is used to set address that need to write when enter WORLD0.*/
#define WORLD_CONTROLLER_CORE_0_MESSAGE_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_MESSAGE_ADDR_M  ((WORLD_CONTROLLER_CORE_0_MESSAGE_ADDR_V)<<(WORLD_CONTROLLER_CORE_0_MESSAGE_ADDR_S))
#define WORLD_CONTROLLER_CORE_0_MESSAGE_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_MESSAGE_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_MESSAGE_MAX_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x104)
/* WORLD_CONTROLLER_CORE_0_MESSAGE_MAX : R/W ;bitpos:[3:0] ;default: 4'b0 ; */
/*description: This filed is used to set the max value of clear write_buffer.*/
#define WORLD_CONTROLLER_CORE_0_MESSAGE_MAX    0x0000000F
#define WORLD_CONTROLLER_CORE_0_MESSAGE_MAX_M  ((WORLD_CONTROLLER_CORE_0_MESSAGE_MAX_V)<<(WORLD_CONTROLLER_CORE_0_MESSAGE_MAX_S))
#define WORLD_CONTROLLER_CORE_0_MESSAGE_MAX_V  0xF
#define WORLD_CONTROLLER_CORE_0_MESSAGE_MAX_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_STATUSTABLE1_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x80)
/* WORLD_CONTROLLER_CORE_0_CURRENT_1 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 1 .*/
#define WORLD_CONTROLLER_CORE_0_CURRENT_1    (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_1_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_1_V  0x1
#define WORLD_CONTROLLER_CORE_0_CURRENT_1_S  5
/* WORLD_CONTROLLER_CORE_0_FROM_ENTRY_1 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 1.*/
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_1    0x0000000F
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_1_M  ((WORLD_CONTROLLER_CORE_0_FROM_ENTRY_1_V)<<(WORLD_CONTROLLER_CORE_0_FROM_ENTRY_1_S))
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_1_V  0xF
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_1_S  1
/* WORLD_CONTROLLER_CORE_0_FROM_WORLD_1 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 1 .*/
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_1    (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_1_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_1_V  0x1
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_1_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_STATUSTABLE2_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x84)
/* WORLD_CONTROLLER_CORE_0_CURRENT_2 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 2 .*/
#define WORLD_CONTROLLER_CORE_0_CURRENT_2    (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_2_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_2_V  0x1
#define WORLD_CONTROLLER_CORE_0_CURRENT_2_S  5
/* WORLD_CONTROLLER_CORE_0_FROM_ENTRY_2 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 2.*/
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_2    0x0000000F
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_2_M  ((WORLD_CONTROLLER_CORE_0_FROM_ENTRY_2_V)<<(WORLD_CONTROLLER_CORE_0_FROM_ENTRY_2_S))
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_2_V  0xF
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_2_S  1
/* WORLD_CONTROLLER_CORE_0_FROM_WORLD_2 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 2 .*/
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_2    (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_2_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_2_V  0x1
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_2_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_STATUSTABLE3_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x88)
/* WORLD_CONTROLLER_CORE_0_CURRENT_3 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 3 .*/
#define WORLD_CONTROLLER_CORE_0_CURRENT_3    (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_3_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_3_V  0x1
#define WORLD_CONTROLLER_CORE_0_CURRENT_3_S  5
/* WORLD_CONTROLLER_CORE_0_FROM_ENTRY_3 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 3.*/
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_3    0x0000000F
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_3_M  ((WORLD_CONTROLLER_CORE_0_FROM_ENTRY_3_V)<<(WORLD_CONTROLLER_CORE_0_FROM_ENTRY_3_S))
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_3_V  0xF
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_3_S  1
/* WORLD_CONTROLLER_CORE_0_FROM_WORLD_3 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 3 .*/
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_3    (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_3_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_3_V  0x1
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_3_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_STATUSTABLE4_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x8C)
/* WORLD_CONTROLLER_CORE_0_CURRENT_4 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 4 .*/
#define WORLD_CONTROLLER_CORE_0_CURRENT_4    (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_4_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_4_V  0x1
#define WORLD_CONTROLLER_CORE_0_CURRENT_4_S  5
/* WORLD_CONTROLLER_CORE_0_FROM_ENTRY_4 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 4.*/
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_4    0x0000000F
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_4_M  ((WORLD_CONTROLLER_CORE_0_FROM_ENTRY_4_V)<<(WORLD_CONTROLLER_CORE_0_FROM_ENTRY_4_S))
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_4_V  0xF
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_4_S  1
/* WORLD_CONTROLLER_CORE_0_FROM_WORLD_4 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 4 .*/
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_4    (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_4_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_4_V  0x1
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_4_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_STATUSTABLE5_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x90)
/* WORLD_CONTROLLER_CORE_0_CURRENT_5 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 5 .*/
#define WORLD_CONTROLLER_CORE_0_CURRENT_5    (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_5_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_5_V  0x1
#define WORLD_CONTROLLER_CORE_0_CURRENT_5_S  5
/* WORLD_CONTROLLER_CORE_0_FROM_ENTRY_5 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 5.*/
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_5    0x0000000F
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_5_M  ((WORLD_CONTROLLER_CORE_0_FROM_ENTRY_5_V)<<(WORLD_CONTROLLER_CORE_0_FROM_ENTRY_5_S))
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_5_V  0xF
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_5_S  1
/* WORLD_CONTROLLER_CORE_0_FROM_WORLD_5 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 5 .*/
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_5    (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_5_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_5_V  0x1
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_5_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_STATUSTABLE6_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x94)
/* WORLD_CONTROLLER_CORE_0_CURRENT_6 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 6 .*/
#define WORLD_CONTROLLER_CORE_0_CURRENT_6    (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_6_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_6_V  0x1
#define WORLD_CONTROLLER_CORE_0_CURRENT_6_S  5
/* WORLD_CONTROLLER_CORE_0_FROM_ENTRY_6 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 6.*/
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_6    0x0000000F
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_6_M  ((WORLD_CONTROLLER_CORE_0_FROM_ENTRY_6_V)<<(WORLD_CONTROLLER_CORE_0_FROM_ENTRY_6_S))
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_6_V  0xF
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_6_S  1
/* WORLD_CONTROLLER_CORE_0_FROM_WORLD_6 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 6 .*/
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_6    (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_6_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_6_V  0x1
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_6_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_STATUSTABLE7_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x98)
/* WORLD_CONTROLLER_CORE_0_CURRENT_7 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 7 .*/
#define WORLD_CONTROLLER_CORE_0_CURRENT_7    (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_7_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_7_V  0x1
#define WORLD_CONTROLLER_CORE_0_CURRENT_7_S  5
/* WORLD_CONTROLLER_CORE_0_FROM_ENTRY_7 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 7.*/
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_7    0x0000000F
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_7_M  ((WORLD_CONTROLLER_CORE_0_FROM_ENTRY_7_V)<<(WORLD_CONTROLLER_CORE_0_FROM_ENTRY_7_S))
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_7_V  0xF
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_7_S  1
/* WORLD_CONTROLLER_CORE_0_FROM_WORLD_7 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 7 .*/
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_7    (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_7_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_7_V  0x1
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_7_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_STATUSTABLE8_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x9C)
/* WORLD_CONTROLLER_CORE_0_CURRENT_8 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 8 .*/
#define WORLD_CONTROLLER_CORE_0_CURRENT_8    (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_8_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_8_V  0x1
#define WORLD_CONTROLLER_CORE_0_CURRENT_8_S  5
/* WORLD_CONTROLLER_CORE_0_FROM_ENTRY_8 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 8.*/
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_8    0x0000000F
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_8_M  ((WORLD_CONTROLLER_CORE_0_FROM_ENTRY_8_V)<<(WORLD_CONTROLLER_CORE_0_FROM_ENTRY_8_S))
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_8_V  0xF
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_8_S  1
/* WORLD_CONTROLLER_CORE_0_FROM_WORLD_8 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 8 .*/
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_8    (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_8_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_8_V  0x1
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_8_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_STATUSTABLE9_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0xA0)
/* WORLD_CONTROLLER_CORE_0_CURRENT_9 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 9 .*/
#define WORLD_CONTROLLER_CORE_0_CURRENT_9    (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_9_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_9_V  0x1
#define WORLD_CONTROLLER_CORE_0_CURRENT_9_S  5
/* WORLD_CONTROLLER_CORE_0_FROM_ENTRY_9 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 9.*/
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_9    0x0000000F
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_9_M  ((WORLD_CONTROLLER_CORE_0_FROM_ENTRY_9_V)<<(WORLD_CONTROLLER_CORE_0_FROM_ENTRY_9_S))
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_9_V  0xF
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_9_S  1
/* WORLD_CONTROLLER_CORE_0_FROM_WORLD_9 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 9 .*/
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_9    (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_9_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_9_V  0x1
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_9_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_STATUSTABLE10_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0xA4)
/* WORLD_CONTROLLER_CORE_0_CURRENT_10 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 10 .*/
#define WORLD_CONTROLLER_CORE_0_CURRENT_10    (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_10_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_10_V  0x1
#define WORLD_CONTROLLER_CORE_0_CURRENT_10_S  5
/* WORLD_CONTROLLER_CORE_0_FROM_ENTRY_10 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 10.*/
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_10    0x0000000F
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_10_M  ((WORLD_CONTROLLER_CORE_0_FROM_ENTRY_10_V)<<(WORLD_CONTROLLER_CORE_0_FROM_ENTRY_10_S))
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_10_V  0xF
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_10_S  1
/* WORLD_CONTROLLER_CORE_0_FROM_WORLD_10 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 10 .*/
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_10    (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_10_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_10_V  0x1
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_10_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_STATUSTABLE11_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0xA8)
/* WORLD_CONTROLLER_CORE_0_CURRENT_11 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 11 .*/
#define WORLD_CONTROLLER_CORE_0_CURRENT_11    (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_11_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_11_V  0x1
#define WORLD_CONTROLLER_CORE_0_CURRENT_11_S  5
/* WORLD_CONTROLLER_CORE_0_FROM_ENTRY_11 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 11.*/
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_11    0x0000000F
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_11_M  ((WORLD_CONTROLLER_CORE_0_FROM_ENTRY_11_V)<<(WORLD_CONTROLLER_CORE_0_FROM_ENTRY_11_S))
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_11_V  0xF
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_11_S  1
/* WORLD_CONTROLLER_CORE_0_FROM_WORLD_11 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 11 .*/
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_11    (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_11_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_11_V  0x1
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_11_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_STATUSTABLE12_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0xAC)
/* WORLD_CONTROLLER_CORE_0_CURRENT_12 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 12 .*/
#define WORLD_CONTROLLER_CORE_0_CURRENT_12    (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_12_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_12_V  0x1
#define WORLD_CONTROLLER_CORE_0_CURRENT_12_S  5
/* WORLD_CONTROLLER_CORE_0_FROM_ENTRY_12 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 12.*/
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_12    0x0000000F
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_12_M  ((WORLD_CONTROLLER_CORE_0_FROM_ENTRY_12_V)<<(WORLD_CONTROLLER_CORE_0_FROM_ENTRY_12_S))
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_12_V  0xF
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_12_S  1
/* WORLD_CONTROLLER_CORE_0_FROM_WORLD_12 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 12 .*/
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_12    (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_12_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_12_V  0x1
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_12_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_STATUSTABLE13_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0xB0)
/* WORLD_CONTROLLER_CORE_0_CURRENT_13 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 13 .*/
#define WORLD_CONTROLLER_CORE_0_CURRENT_13    (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_13_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_0_CURRENT_13_V  0x1
#define WORLD_CONTROLLER_CORE_0_CURRENT_13_S  5
/* WORLD_CONTROLLER_CORE_0_FROM_ENTRY_13 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 13.*/
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_13    0x0000000F
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_13_M  ((WORLD_CONTROLLER_CORE_0_FROM_ENTRY_13_V)<<(WORLD_CONTROLLER_CORE_0_FROM_ENTRY_13_S))
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_13_V  0xF
#define WORLD_CONTROLLER_CORE_0_FROM_ENTRY_13_S  1
/* WORLD_CONTROLLER_CORE_0_FROM_WORLD_13 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 13 .*/
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_13    (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_13_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_13_V  0x1
#define WORLD_CONTROLLER_CORE_0_FROM_WORLD_13_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_STATUSTABLE_CURRENT_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0xFC)
/* WORLD_CONTROLLER_CORE_0_STATUSTABLE_CURRENT : R/W ;bitpos:[13:1] ;default: 13'b0 ; */
/*description: This field is used to quickly read and rewrite the current field of all STATUSTA
BLE registers.For example.*/
#define WORLD_CONTROLLER_CORE_0_STATUSTABLE_CURRENT    0x00001FFF
#define WORLD_CONTROLLER_CORE_0_STATUSTABLE_CURRENT_M  ((WORLD_CONTROLLER_CORE_0_STATUSTABLE_CURRENT_V)<<(WORLD_CONTROLLER_CORE_0_STATUSTABLE_CURRENT_S))
#define WORLD_CONTROLLER_CORE_0_STATUSTABLE_CURRENT_V  0x1FFF
#define WORLD_CONTROLLER_CORE_0_STATUSTABLE_CURRENT_S  1

#define WORLD_CONTROLLER_WCL_CORE_0_MESSAGE_PHASE_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x108)
/* WORLD_CONTROLLER_CORE_0_MESSAGE_ADDRESSPHASE : RO ;bitpos:[6] ;default: 1'b0 ; */
/*description: If this bit is 1.*/
#define WORLD_CONTROLLER_CORE_0_MESSAGE_ADDRESSPHASE    (BIT(6))
#define WORLD_CONTROLLER_CORE_0_MESSAGE_ADDRESSPHASE_M  (BIT(6))
#define WORLD_CONTROLLER_CORE_0_MESSAGE_ADDRESSPHASE_V  0x1
#define WORLD_CONTROLLER_CORE_0_MESSAGE_ADDRESSPHASE_S  6
/* WORLD_CONTROLLER_CORE_0_MESSAGE_DATAPHASE : RO ;bitpos:[5] ;default: 1'b0 ; */
/*description: If this bit is 1.*/
#define WORLD_CONTROLLER_CORE_0_MESSAGE_DATAPHASE    (BIT(5))
#define WORLD_CONTROLLER_CORE_0_MESSAGE_DATAPHASE_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_0_MESSAGE_DATAPHASE_V  0x1
#define WORLD_CONTROLLER_CORE_0_MESSAGE_DATAPHASE_S  5
/* WORLD_CONTROLLER_CORE_0_MESSAGE_EXPECT : RO ;bitpos:[4:1] ;default: 4'b0 ; */
/*description: This field indicates the data to be written next time.*/
#define WORLD_CONTROLLER_CORE_0_MESSAGE_EXPECT    0x0000000F
#define WORLD_CONTROLLER_CORE_0_MESSAGE_EXPECT_M  ((WORLD_CONTROLLER_CORE_0_MESSAGE_EXPECT_V)<<(WORLD_CONTROLLER_CORE_0_MESSAGE_EXPECT_S))
#define WORLD_CONTROLLER_CORE_0_MESSAGE_EXPECT_V  0xF
#define WORLD_CONTROLLER_CORE_0_MESSAGE_EXPECT_S  1
/* WORLD_CONTROLLER_CORE_0_MESSAGE_MATCH : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit indicates whether the check is successful.*/
#define WORLD_CONTROLLER_CORE_0_MESSAGE_MATCH    (BIT(0))
#define WORLD_CONTROLLER_CORE_0_MESSAGE_MATCH_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_0_MESSAGE_MATCH_V  0x1
#define WORLD_CONTROLLER_CORE_0_MESSAGE_MATCH_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_WORLD_TRIGGER_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x140)
/* WORLD_CONTROLLER_CORE_0_WORLD_TRIGGER_ADDR : RW ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: This field is used to configure the entry address from WORLD0 to WORLD1.*/
#define WORLD_CONTROLLER_CORE_0_WORLD_TRIGGER_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_WORLD_TRIGGER_ADDR_M  ((WORLD_CONTROLLER_CORE_0_WORLD_TRIGGER_ADDR_V)<<(WORLD_CONTROLLER_CORE_0_WORLD_TRIGGER_ADDR_S))
#define WORLD_CONTROLLER_CORE_0_WORLD_TRIGGER_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_WORLD_TRIGGER_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_WORLD_PREPARE_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x144)
/* WORLD_CONTROLLER_CORE_0_WORLD_PREPARE : R/W ;bitpos:[1:0] ;default: 2'h0 ; */
/*description: This field to used to set world to enter.*/
#define WORLD_CONTROLLER_CORE_0_WORLD_PREPARE    0x00000003
#define WORLD_CONTROLLER_CORE_0_WORLD_PREPARE_M  ((WORLD_CONTROLLER_CORE_0_WORLD_PREPARE_V)<<(WORLD_CONTROLLER_CORE_0_WORLD_PREPARE_S))
#define WORLD_CONTROLLER_CORE_0_WORLD_PREPARE_V  0x3
#define WORLD_CONTROLLER_CORE_0_WORLD_PREPARE_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_WORLD_UPDATE_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x148)
/* WORLD_CONTROLLER_CORE_0_UPDATE : WO ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: This field is used to update configuration completed.*/
#define WORLD_CONTROLLER_CORE_0_UPDATE    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_UPDATE_M  ((WORLD_CONTROLLER_CORE_0_UPDATE_V)<<(WORLD_CONTROLLER_CORE_0_UPDATE_S))
#define WORLD_CONTROLLER_CORE_0_UPDATE_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_UPDATE_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_WORLD_CANCEL_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x14C)
/* WORLD_CONTROLLER_CORE_0_WORLD_CANCEL : WO ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: This field is used to cancel switch world configuration.*/
#define WORLD_CONTROLLER_CORE_0_WORLD_CANCEL    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_WORLD_CANCEL_M  ((WORLD_CONTROLLER_CORE_0_WORLD_CANCEL_V)<<(WORLD_CONTROLLER_CORE_0_WORLD_CANCEL_S))
#define WORLD_CONTROLLER_CORE_0_WORLD_CANCEL_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_WORLD_CANCEL_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_WORLD_IRAM0_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x150)
/* WORLD_CONTROLLER_CORE_0_WORLD_IRAM0 : R/W ;bitpos:[1:0] ;default: 2'h0 ; */
/*description: this field is used to read current world of Iram0 bus.*/
#define WORLD_CONTROLLER_CORE_0_WORLD_IRAM0    0x00000003
#define WORLD_CONTROLLER_CORE_0_WORLD_IRAM0_M  ((WORLD_CONTROLLER_CORE_0_WORLD_IRAM0_V)<<(WORLD_CONTROLLER_CORE_0_WORLD_IRAM0_S))
#define WORLD_CONTROLLER_CORE_0_WORLD_IRAM0_V  0x3
#define WORLD_CONTROLLER_CORE_0_WORLD_IRAM0_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_WORLD_DRAM0_PIF_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x154)
/* WORLD_CONTROLLER_CORE_0_WORLD_DRAM0_PIF : R/W ;bitpos:[1:0] ;default: 2'h0 ; */
/*description: this field is used to read current world of Dram0 bus and PIF bus.*/
#define WORLD_CONTROLLER_CORE_0_WORLD_DRAM0_PIF    0x00000003
#define WORLD_CONTROLLER_CORE_0_WORLD_DRAM0_PIF_M  ((WORLD_CONTROLLER_CORE_0_WORLD_DRAM0_PIF_V)<<(WORLD_CONTROLLER_CORE_0_WORLD_DRAM0_PIF_S))
#define WORLD_CONTROLLER_CORE_0_WORLD_DRAM0_PIF_V  0x3
#define WORLD_CONTROLLER_CORE_0_WORLD_DRAM0_PIF_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_WORLD_PHASE_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x158)
/* WORLD_CONTROLLER_CORE_0_WORLD_PHASE : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit indicates whether is preparing to switch to WORLD1.*/
#define WORLD_CONTROLLER_CORE_0_WORLD_PHASE    (BIT(0))
#define WORLD_CONTROLLER_CORE_0_WORLD_PHASE_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_0_WORLD_PHASE_V  0x1
#define WORLD_CONTROLLER_CORE_0_WORLD_PHASE_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_NMI_MASK_ENABLE_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x180)
/* WORLD_CONTROLLER_CORE_0_NMI_MASK_ENABLE : WO ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: this field is used to set NMI mask.*/
#define WORLD_CONTROLLER_CORE_0_NMI_MASK_ENABLE    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_NMI_MASK_ENABLE_M  ((WORLD_CONTROLLER_CORE_0_NMI_MASK_ENABLE_V)<<(WORLD_CONTROLLER_CORE_0_NMI_MASK_ENABLE_S))
#define WORLD_CONTROLLER_CORE_0_NMI_MASK_ENABLE_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_NMI_MASK_ENABLE_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_NMI_MASK_TRIGGER_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x184)
/* WORLD_CONTROLLER_CORE_0_NMI_MASK_TRIGGER_ADDR : R/W ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: this field to used to set trigger address.*/
#define WORLD_CONTROLLER_CORE_0_NMI_MASK_TRIGGER_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_NMI_MASK_TRIGGER_ADDR_M  ((WORLD_CONTROLLER_CORE_0_NMI_MASK_TRIGGER_ADDR_V)<<(WORLD_CONTROLLER_CORE_0_NMI_MASK_TRIGGER_ADDR_S))
#define WORLD_CONTROLLER_CORE_0_NMI_MASK_TRIGGER_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_NMI_MASK_TRIGGER_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_NMI_MASK_DISABLE_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x188)
/* WORLD_CONTROLLER_CORE_0_NMI_MASK_DISABLE : WO ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: this field is used to disable NMI mask.*/
#define WORLD_CONTROLLER_CORE_0_NMI_MASK_DISABLE    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_NMI_MASK_DISABLE_M  ((WORLD_CONTROLLER_CORE_0_NMI_MASK_DISABLE_V)<<(WORLD_CONTROLLER_CORE_0_NMI_MASK_DISABLE_S))
#define WORLD_CONTROLLER_CORE_0_NMI_MASK_DISABLE_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_NMI_MASK_DISABLE_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_NMI_MASK_CANCLE_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x18C)
/* WORLD_CONTROLLER_CORE_0_NMI_MASK_CANCEL : WO ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: this field is used to cancel NMI mask disable function..*/
#define WORLD_CONTROLLER_CORE_0_NMI_MASK_CANCEL    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_NMI_MASK_CANCEL_M  ((WORLD_CONTROLLER_CORE_0_NMI_MASK_CANCEL_V)<<(WORLD_CONTROLLER_CORE_0_NMI_MASK_CANCEL_S))
#define WORLD_CONTROLLER_CORE_0_NMI_MASK_CANCEL_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_0_NMI_MASK_CANCEL_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_NMI_MASK_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x190)
/* WORLD_CONTROLLER_CORE_0_NMI_MASK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: this bit is used to mask NMI interrupt.*/
#define WORLD_CONTROLLER_CORE_0_NMI_MASK    (BIT(0))
#define WORLD_CONTROLLER_CORE_0_NMI_MASK_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_0_NMI_MASK_V  0x1
#define WORLD_CONTROLLER_CORE_0_NMI_MASK_S  0

#define WORLD_CONTROLLER_WCL_CORE_0_NMI_MASK_PHASE_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x194)
/* WORLD_CONTROLLER_CORE_0_NMI_MASK_PHASE : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: this bit is used to indicates whether the NMI interrupt is being masked.*/
#define WORLD_CONTROLLER_CORE_0_NMI_MASK_PHASE    (BIT(0))
#define WORLD_CONTROLLER_CORE_0_NMI_MASK_PHASE_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_0_NMI_MASK_PHASE_V  0x1
#define WORLD_CONTROLLER_CORE_0_NMI_MASK_PHASE_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_ENTRY_1_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x400)
/* WORLD_CONTROLLER_CORE_1_ENTRY_1_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_1 Entry 1 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_1_ENTRY_1_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_1_ADDR_M  ((WORLD_CONTROLLER_CORE_1_ENTRY_1_ADDR_V)<<(WORLD_CONTROLLER_CORE_1_ENTRY_1_ADDR_S))
#define WORLD_CONTROLLER_CORE_1_ENTRY_1_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_1_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_ENTRY_2_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x404)
/* WORLD_CONTROLLER_CORE_1_ENTRY_2_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_1 Entry 2 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_1_ENTRY_2_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_2_ADDR_M  ((WORLD_CONTROLLER_CORE_1_ENTRY_2_ADDR_V)<<(WORLD_CONTROLLER_CORE_1_ENTRY_2_ADDR_S))
#define WORLD_CONTROLLER_CORE_1_ENTRY_2_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_2_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_ENTRY_3_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x408)
/* WORLD_CONTROLLER_CORE_1_ENTRY_3_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_1 Entry 3 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_1_ENTRY_3_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_3_ADDR_M  ((WORLD_CONTROLLER_CORE_1_ENTRY_3_ADDR_V)<<(WORLD_CONTROLLER_CORE_1_ENTRY_3_ADDR_S))
#define WORLD_CONTROLLER_CORE_1_ENTRY_3_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_3_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_ENTRY_4_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x40C)
/* WORLD_CONTROLLER_CORE_1_ENTRY_4_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_1 Entry 4 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_1_ENTRY_4_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_4_ADDR_M  ((WORLD_CONTROLLER_CORE_1_ENTRY_4_ADDR_V)<<(WORLD_CONTROLLER_CORE_1_ENTRY_4_ADDR_S))
#define WORLD_CONTROLLER_CORE_1_ENTRY_4_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_4_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_ENTRY_5_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x410)
/* WORLD_CONTROLLER_CORE_1_ENTRY_5_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_1 Entry 5 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_1_ENTRY_5_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_5_ADDR_M  ((WORLD_CONTROLLER_CORE_1_ENTRY_5_ADDR_V)<<(WORLD_CONTROLLER_CORE_1_ENTRY_5_ADDR_S))
#define WORLD_CONTROLLER_CORE_1_ENTRY_5_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_5_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_ENTRY_6_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x414)
/* WORLD_CONTROLLER_CORE_1_ENTRY_6_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_1 Entry 6 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_1_ENTRY_6_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_6_ADDR_M  ((WORLD_CONTROLLER_CORE_1_ENTRY_6_ADDR_V)<<(WORLD_CONTROLLER_CORE_1_ENTRY_6_ADDR_S))
#define WORLD_CONTROLLER_CORE_1_ENTRY_6_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_6_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_ENTRY_7_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x418)
/* WORLD_CONTROLLER_CORE_1_ENTRY_7_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_1 Entry 7 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_1_ENTRY_7_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_7_ADDR_M  ((WORLD_CONTROLLER_CORE_1_ENTRY_7_ADDR_V)<<(WORLD_CONTROLLER_CORE_1_ENTRY_7_ADDR_S))
#define WORLD_CONTROLLER_CORE_1_ENTRY_7_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_7_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_ENTRY_8_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x41C)
/* WORLD_CONTROLLER_CORE_1_ENTRY_8_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_1 Entry 8 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_1_ENTRY_8_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_8_ADDR_M  ((WORLD_CONTROLLER_CORE_1_ENTRY_8_ADDR_V)<<(WORLD_CONTROLLER_CORE_1_ENTRY_8_ADDR_S))
#define WORLD_CONTROLLER_CORE_1_ENTRY_8_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_8_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_ENTRY_9_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x420)
/* WORLD_CONTROLLER_CORE_1_ENTRY_9_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_1 Entry 9 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_1_ENTRY_9_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_9_ADDR_M  ((WORLD_CONTROLLER_CORE_1_ENTRY_9_ADDR_V)<<(WORLD_CONTROLLER_CORE_1_ENTRY_9_ADDR_S))
#define WORLD_CONTROLLER_CORE_1_ENTRY_9_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_9_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_ENTRY_10_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x424)
/* WORLD_CONTROLLER_CORE_1_ENTRY_10_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_1 Entry 10 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_1_ENTRY_10_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_10_ADDR_M  ((WORLD_CONTROLLER_CORE_1_ENTRY_10_ADDR_V)<<(WORLD_CONTROLLER_CORE_1_ENTRY_10_ADDR_S))
#define WORLD_CONTROLLER_CORE_1_ENTRY_10_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_10_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_ENTRY_11_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x428)
/* WORLD_CONTROLLER_CORE_1_ENTRY_11_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_1 Entry 11 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_1_ENTRY_11_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_11_ADDR_M  ((WORLD_CONTROLLER_CORE_1_ENTRY_11_ADDR_V)<<(WORLD_CONTROLLER_CORE_1_ENTRY_11_ADDR_S))
#define WORLD_CONTROLLER_CORE_1_ENTRY_11_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_11_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_ENTRY_12_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x42C)
/* WORLD_CONTROLLER_CORE_1_ENTRY_12_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_1 Entry 12 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_1_ENTRY_12_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_12_ADDR_M  ((WORLD_CONTROLLER_CORE_1_ENTRY_12_ADDR_V)<<(WORLD_CONTROLLER_CORE_1_ENTRY_12_ADDR_S))
#define WORLD_CONTROLLER_CORE_1_ENTRY_12_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_12_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_ENTRY_13_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x430)
/* WORLD_CONTROLLER_CORE_1_ENTRY_13_ADDR : R/W ;bitpos:[31:0] ;default: 31'b0 ; */
/*description: Core_1 Entry 13 address from WORLD1 to WORLD0.*/
#define WORLD_CONTROLLER_CORE_1_ENTRY_13_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_13_ADDR_M  ((WORLD_CONTROLLER_CORE_1_ENTRY_13_ADDR_V)<<(WORLD_CONTROLLER_CORE_1_ENTRY_13_ADDR_S))
#define WORLD_CONTROLLER_CORE_1_ENTRY_13_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_13_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_ENTRY_CHECK_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x47C)
/* WORLD_CONTROLLER_CORE_1_ENTRY_CHECK : R/W ;bitpos:[13:1] ;default: 1'b1 ; */
/*description: This filed is used to enable entry address check .*/
#define WORLD_CONTROLLER_CORE_1_ENTRY_CHECK    0x00001FFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_CHECK_M  ((WORLD_CONTROLLER_CORE_1_ENTRY_CHECK_V)<<(WORLD_CONTROLLER_CORE_1_ENTRY_CHECK_S))
#define WORLD_CONTROLLER_CORE_1_ENTRY_CHECK_V  0x1FFF
#define WORLD_CONTROLLER_CORE_1_ENTRY_CHECK_S  1

#define WORLD_CONTROLLER_WCL_CORE_1_MESSAGE_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x500)
/* WORLD_CONTROLLER_CORE_1_MESSAGE_ADDR : R/W ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: This field is used to set address that need to write when enter WORLD0.*/
#define WORLD_CONTROLLER_CORE_1_MESSAGE_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_MESSAGE_ADDR_M  ((WORLD_CONTROLLER_CORE_1_MESSAGE_ADDR_V)<<(WORLD_CONTROLLER_CORE_1_MESSAGE_ADDR_S))
#define WORLD_CONTROLLER_CORE_1_MESSAGE_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_MESSAGE_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_MESSAGE_MAX_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x504)
/* WORLD_CONTROLLER_CORE_1_MESSAGE_MAX : R/W ;bitpos:[3:0] ;default: 4'b0 ; */
/*description: This filed is used to set the max value of clear write_buffer.*/
#define WORLD_CONTROLLER_CORE_1_MESSAGE_MAX    0x0000000F
#define WORLD_CONTROLLER_CORE_1_MESSAGE_MAX_M  ((WORLD_CONTROLLER_CORE_1_MESSAGE_MAX_V)<<(WORLD_CONTROLLER_CORE_1_MESSAGE_MAX_S))
#define WORLD_CONTROLLER_CORE_1_MESSAGE_MAX_V  0xF
#define WORLD_CONTROLLER_CORE_1_MESSAGE_MAX_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_STATUSTABLE1_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x480)
/* WORLD_CONTROLLER_CORE_1_CURRENT_1 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 1 .*/
#define WORLD_CONTROLLER_CORE_1_CURRENT_1    (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_1_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_1_V  0x1
#define WORLD_CONTROLLER_CORE_1_CURRENT_1_S  5
/* WORLD_CONTROLLER_CORE_1_FROM_ENTRY_1 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 1.*/
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_1    0x0000000F
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_1_M  ((WORLD_CONTROLLER_CORE_1_FROM_ENTRY_1_V)<<(WORLD_CONTROLLER_CORE_1_FROM_ENTRY_1_S))
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_1_V  0xF
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_1_S  1
/* WORLD_CONTROLLER_CORE_1_FROM_WORLD_1 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 1 .*/
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_1    (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_1_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_1_V  0x1
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_1_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_STATUSTABLE2_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x484)
/* WORLD_CONTROLLER_CORE_1_CURRENT_2 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 2 .*/
#define WORLD_CONTROLLER_CORE_1_CURRENT_2    (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_2_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_2_V  0x1
#define WORLD_CONTROLLER_CORE_1_CURRENT_2_S  5
/* WORLD_CONTROLLER_CORE_1_FROM_ENTRY_2 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 2.*/
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_2    0x0000000F
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_2_M  ((WORLD_CONTROLLER_CORE_1_FROM_ENTRY_2_V)<<(WORLD_CONTROLLER_CORE_1_FROM_ENTRY_2_S))
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_2_V  0xF
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_2_S  1
/* WORLD_CONTROLLER_CORE_1_FROM_WORLD_2 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 2 .*/
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_2    (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_2_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_2_V  0x1
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_2_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_STATUSTABLE3_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x488)
/* WORLD_CONTROLLER_CORE_1_CURRENT_3 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 3 .*/
#define WORLD_CONTROLLER_CORE_1_CURRENT_3    (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_3_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_3_V  0x1
#define WORLD_CONTROLLER_CORE_1_CURRENT_3_S  5
/* WORLD_CONTROLLER_CORE_1_FROM_ENTRY_3 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 3.*/
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_3    0x0000000F
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_3_M  ((WORLD_CONTROLLER_CORE_1_FROM_ENTRY_3_V)<<(WORLD_CONTROLLER_CORE_1_FROM_ENTRY_3_S))
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_3_V  0xF
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_3_S  1
/* WORLD_CONTROLLER_CORE_1_FROM_WORLD_3 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 3 .*/
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_3    (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_3_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_3_V  0x1
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_3_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_STATUSTABLE4_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x48C)
/* WORLD_CONTROLLER_CORE_1_CURRENT_4 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 4 .*/
#define WORLD_CONTROLLER_CORE_1_CURRENT_4    (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_4_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_4_V  0x1
#define WORLD_CONTROLLER_CORE_1_CURRENT_4_S  5
/* WORLD_CONTROLLER_CORE_1_FROM_ENTRY_4 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 4.*/
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_4    0x0000000F
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_4_M  ((WORLD_CONTROLLER_CORE_1_FROM_ENTRY_4_V)<<(WORLD_CONTROLLER_CORE_1_FROM_ENTRY_4_S))
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_4_V  0xF
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_4_S  1
/* WORLD_CONTROLLER_CORE_1_FROM_WORLD_4 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 4 .*/
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_4    (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_4_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_4_V  0x1
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_4_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_STATUSTABLE5_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x490)
/* WORLD_CONTROLLER_CORE_1_CURRENT_5 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 5 .*/
#define WORLD_CONTROLLER_CORE_1_CURRENT_5    (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_5_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_5_V  0x1
#define WORLD_CONTROLLER_CORE_1_CURRENT_5_S  5
/* WORLD_CONTROLLER_CORE_1_FROM_ENTRY_5 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 5.*/
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_5    0x0000000F
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_5_M  ((WORLD_CONTROLLER_CORE_1_FROM_ENTRY_5_V)<<(WORLD_CONTROLLER_CORE_1_FROM_ENTRY_5_S))
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_5_V  0xF
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_5_S  1
/* WORLD_CONTROLLER_CORE_1_FROM_WORLD_5 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 5 .*/
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_5    (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_5_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_5_V  0x1
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_5_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_STATUSTABLE6_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x494)
/* WORLD_CONTROLLER_CORE_1_CURRENT_6 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 6 .*/
#define WORLD_CONTROLLER_CORE_1_CURRENT_6    (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_6_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_6_V  0x1
#define WORLD_CONTROLLER_CORE_1_CURRENT_6_S  5
/* WORLD_CONTROLLER_CORE_1_FROM_ENTRY_6 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 6.*/
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_6    0x0000000F
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_6_M  ((WORLD_CONTROLLER_CORE_1_FROM_ENTRY_6_V)<<(WORLD_CONTROLLER_CORE_1_FROM_ENTRY_6_S))
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_6_V  0xF
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_6_S  1
/* WORLD_CONTROLLER_CORE_1_FROM_WORLD_6 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 6 .*/
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_6    (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_6_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_6_V  0x1
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_6_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_STATUSTABLE7_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x498)
/* WORLD_CONTROLLER_CORE_1_CURRENT_7 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 7 .*/
#define WORLD_CONTROLLER_CORE_1_CURRENT_7    (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_7_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_7_V  0x1
#define WORLD_CONTROLLER_CORE_1_CURRENT_7_S  5
/* WORLD_CONTROLLER_CORE_1_FROM_ENTRY_7 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 7.*/
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_7    0x0000000F
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_7_M  ((WORLD_CONTROLLER_CORE_1_FROM_ENTRY_7_V)<<(WORLD_CONTROLLER_CORE_1_FROM_ENTRY_7_S))
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_7_V  0xF
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_7_S  1
/* WORLD_CONTROLLER_CORE_1_FROM_WORLD_7 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 7 .*/
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_7    (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_7_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_7_V  0x1
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_7_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_STATUSTABLE8_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x49C)
/* WORLD_CONTROLLER_CORE_1_CURRENT_8 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 8 .*/
#define WORLD_CONTROLLER_CORE_1_CURRENT_8    (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_8_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_8_V  0x1
#define WORLD_CONTROLLER_CORE_1_CURRENT_8_S  5
/* WORLD_CONTROLLER_CORE_1_FROM_ENTRY_8 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 8.*/
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_8    0x0000000F
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_8_M  ((WORLD_CONTROLLER_CORE_1_FROM_ENTRY_8_V)<<(WORLD_CONTROLLER_CORE_1_FROM_ENTRY_8_S))
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_8_V  0xF
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_8_S  1
/* WORLD_CONTROLLER_CORE_1_FROM_WORLD_8 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 8 .*/
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_8    (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_8_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_8_V  0x1
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_8_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_STATUSTABLE9_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x4A0)
/* WORLD_CONTROLLER_CORE_1_CURRENT_9 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 9 .*/
#define WORLD_CONTROLLER_CORE_1_CURRENT_9    (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_9_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_9_V  0x1
#define WORLD_CONTROLLER_CORE_1_CURRENT_9_S  5
/* WORLD_CONTROLLER_CORE_1_FROM_ENTRY_9 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 9.*/
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_9    0x0000000F
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_9_M  ((WORLD_CONTROLLER_CORE_1_FROM_ENTRY_9_V)<<(WORLD_CONTROLLER_CORE_1_FROM_ENTRY_9_S))
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_9_V  0xF
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_9_S  1
/* WORLD_CONTROLLER_CORE_1_FROM_WORLD_9 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 9 .*/
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_9    (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_9_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_9_V  0x1
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_9_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_STATUSTABLE10_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x4A4)
/* WORLD_CONTROLLER_CORE_1_CURRENT_10 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 10 .*/
#define WORLD_CONTROLLER_CORE_1_CURRENT_10    (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_10_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_10_V  0x1
#define WORLD_CONTROLLER_CORE_1_CURRENT_10_S  5
/* WORLD_CONTROLLER_CORE_1_FROM_ENTRY_10 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 10.*/
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_10    0x0000000F
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_10_M  ((WORLD_CONTROLLER_CORE_1_FROM_ENTRY_10_V)<<(WORLD_CONTROLLER_CORE_1_FROM_ENTRY_10_S))
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_10_V  0xF
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_10_S  1
/* WORLD_CONTROLLER_CORE_1_FROM_WORLD_10 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 10 .*/
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_10    (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_10_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_10_V  0x1
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_10_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_STATUSTABLE11_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x4A8)
/* WORLD_CONTROLLER_CORE_1_CURRENT_11 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 11 .*/
#define WORLD_CONTROLLER_CORE_1_CURRENT_11    (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_11_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_11_V  0x1
#define WORLD_CONTROLLER_CORE_1_CURRENT_11_S  5
/* WORLD_CONTROLLER_CORE_1_FROM_ENTRY_11 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 11.*/
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_11    0x0000000F
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_11_M  ((WORLD_CONTROLLER_CORE_1_FROM_ENTRY_11_V)<<(WORLD_CONTROLLER_CORE_1_FROM_ENTRY_11_S))
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_11_V  0xF
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_11_S  1
/* WORLD_CONTROLLER_CORE_1_FROM_WORLD_11 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 11 .*/
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_11    (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_11_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_11_V  0x1
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_11_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_STATUSTABLE12_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x4AC)
/* WORLD_CONTROLLER_CORE_1_CURRENT_12 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 12 .*/
#define WORLD_CONTROLLER_CORE_1_CURRENT_12    (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_12_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_12_V  0x1
#define WORLD_CONTROLLER_CORE_1_CURRENT_12_S  5
/* WORLD_CONTROLLER_CORE_1_FROM_ENTRY_12 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 12.*/
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_12    0x0000000F
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_12_M  ((WORLD_CONTROLLER_CORE_1_FROM_ENTRY_12_V)<<(WORLD_CONTROLLER_CORE_1_FROM_ENTRY_12_S))
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_12_V  0xF
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_12_S  1
/* WORLD_CONTROLLER_CORE_1_FROM_WORLD_12 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 12 .*/
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_12    (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_12_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_12_V  0x1
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_12_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_STATUSTABLE13_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x4B0)
/* WORLD_CONTROLLER_CORE_1_CURRENT_13 : R/W ;bitpos:[5] ;default: 1'b0 ; */
/*description: This bit is used to confirm whether the current state is in entry 13 .*/
#define WORLD_CONTROLLER_CORE_1_CURRENT_13    (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_13_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_1_CURRENT_13_V  0x1
#define WORLD_CONTROLLER_CORE_1_CURRENT_13_S  5
/* WORLD_CONTROLLER_CORE_1_FROM_ENTRY_13 : R/W ;bitpos:[4:1] ;default: 4'h0 ; */
/*description: This filed is used to confirm in which entry before enter entry 13.*/
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_13    0x0000000F
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_13_M  ((WORLD_CONTROLLER_CORE_1_FROM_ENTRY_13_V)<<(WORLD_CONTROLLER_CORE_1_FROM_ENTRY_13_S))
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_13_V  0xF
#define WORLD_CONTROLLER_CORE_1_FROM_ENTRY_13_S  1
/* WORLD_CONTROLLER_CORE_1_FROM_WORLD_13 : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit is used to confirm world before enter entry 13 .*/
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_13    (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_13_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_13_V  0x1
#define WORLD_CONTROLLER_CORE_1_FROM_WORLD_13_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_STATUSTABLE_CURRENT_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x4FC)
/* WORLD_CONTROLLER_CORE_1_STATUSTABLE_CURRENT : R/W ;bitpos:[13:1] ;default: 13'b0 ; */
/*description: This field is used to quickly read and rewrite the current field of all STATUSTA
BLE registers.For example.*/
#define WORLD_CONTROLLER_CORE_1_STATUSTABLE_CURRENT    0x00001FFF
#define WORLD_CONTROLLER_CORE_1_STATUSTABLE_CURRENT_M  ((WORLD_CONTROLLER_CORE_1_STATUSTABLE_CURRENT_V)<<(WORLD_CONTROLLER_CORE_1_STATUSTABLE_CURRENT_S))
#define WORLD_CONTROLLER_CORE_1_STATUSTABLE_CURRENT_V  0x1FFF
#define WORLD_CONTROLLER_CORE_1_STATUSTABLE_CURRENT_S  1

#define WORLD_CONTROLLER_WCL_CORE_1_MESSAGE_PHASE_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x508)
/* WORLD_CONTROLLER_CORE_1_MESSAGE_ADDRESSPHASE : RO ;bitpos:[6] ;default: 1'b0 ; */
/*description: If this bit is 1.*/
#define WORLD_CONTROLLER_CORE_1_MESSAGE_ADDRESSPHASE    (BIT(6))
#define WORLD_CONTROLLER_CORE_1_MESSAGE_ADDRESSPHASE_M  (BIT(6))
#define WORLD_CONTROLLER_CORE_1_MESSAGE_ADDRESSPHASE_V  0x1
#define WORLD_CONTROLLER_CORE_1_MESSAGE_ADDRESSPHASE_S  6
/* WORLD_CONTROLLER_CORE_1_MESSAGE_DATAPHASE : RO ;bitpos:[5] ;default: 1'b0 ; */
/*description: If this bit is 1.*/
#define WORLD_CONTROLLER_CORE_1_MESSAGE_DATAPHASE    (BIT(5))
#define WORLD_CONTROLLER_CORE_1_MESSAGE_DATAPHASE_M  (BIT(5))
#define WORLD_CONTROLLER_CORE_1_MESSAGE_DATAPHASE_V  0x1
#define WORLD_CONTROLLER_CORE_1_MESSAGE_DATAPHASE_S  5
/* WORLD_CONTROLLER_CORE_1_MESSAGE_EXPECT : RO ;bitpos:[4:1] ;default: 4'b0 ; */
/*description: This field indicates the data to be written next time.*/
#define WORLD_CONTROLLER_CORE_1_MESSAGE_EXPECT    0x0000000F
#define WORLD_CONTROLLER_CORE_1_MESSAGE_EXPECT_M  ((WORLD_CONTROLLER_CORE_1_MESSAGE_EXPECT_V)<<(WORLD_CONTROLLER_CORE_1_MESSAGE_EXPECT_S))
#define WORLD_CONTROLLER_CORE_1_MESSAGE_EXPECT_V  0xF
#define WORLD_CONTROLLER_CORE_1_MESSAGE_EXPECT_S  1
/* WORLD_CONTROLLER_CORE_1_MESSAGE_MATCH : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit indicates whether the check is successful.*/
#define WORLD_CONTROLLER_CORE_1_MESSAGE_MATCH    (BIT(0))
#define WORLD_CONTROLLER_CORE_1_MESSAGE_MATCH_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_1_MESSAGE_MATCH_V  0x1
#define WORLD_CONTROLLER_CORE_1_MESSAGE_MATCH_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_WORLD_TRIGGER_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x540)
/* WORLD_CONTROLLER_CORE_1_WORLD_TRIGGER_ADDR : RW ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: This field is used to configure the entry address from WORLD0 to WORLD1.*/
#define WORLD_CONTROLLER_CORE_1_WORLD_TRIGGER_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_WORLD_TRIGGER_ADDR_M  ((WORLD_CONTROLLER_CORE_1_WORLD_TRIGGER_ADDR_V)<<(WORLD_CONTROLLER_CORE_1_WORLD_TRIGGER_ADDR_S))
#define WORLD_CONTROLLER_CORE_1_WORLD_TRIGGER_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_WORLD_TRIGGER_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_WORLD_PREPARE_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x544)
/* WORLD_CONTROLLER_CORE_1_WORLD_PREPARE : R/W ;bitpos:[1:0] ;default: 2'h0 ; */
/*description: This field to used to set world to enter.*/
#define WORLD_CONTROLLER_CORE_1_WORLD_PREPARE    0x00000003
#define WORLD_CONTROLLER_CORE_1_WORLD_PREPARE_M  ((WORLD_CONTROLLER_CORE_1_WORLD_PREPARE_V)<<(WORLD_CONTROLLER_CORE_1_WORLD_PREPARE_S))
#define WORLD_CONTROLLER_CORE_1_WORLD_PREPARE_V  0x3
#define WORLD_CONTROLLER_CORE_1_WORLD_PREPARE_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_WORLD_UPDATE_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x548)
/* WORLD_CONTROLLER_CORE_1_UPDATE : WO ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: This field is used to update configuration completed.*/
#define WORLD_CONTROLLER_CORE_1_UPDATE    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_UPDATE_M  ((WORLD_CONTROLLER_CORE_1_UPDATE_V)<<(WORLD_CONTROLLER_CORE_1_UPDATE_S))
#define WORLD_CONTROLLER_CORE_1_UPDATE_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_UPDATE_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_WORLD_CANCEL_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x54C)
/* WORLD_CONTROLLER_CORE_1_WORLD_CANCEL : WO ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: This field is used to cancel switch world configuration.*/
#define WORLD_CONTROLLER_CORE_1_WORLD_CANCEL    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_WORLD_CANCEL_M  ((WORLD_CONTROLLER_CORE_1_WORLD_CANCEL_V)<<(WORLD_CONTROLLER_CORE_1_WORLD_CANCEL_S))
#define WORLD_CONTROLLER_CORE_1_WORLD_CANCEL_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_WORLD_CANCEL_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_WORLD_IRAM0_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x550)
/* WORLD_CONTROLLER_CORE_1_WORLD_IRAM0 : R/W ;bitpos:[1:0] ;default: 2'h0 ; */
/*description: this field is used to read current world of Iram0 bus.*/
#define WORLD_CONTROLLER_CORE_1_WORLD_IRAM0    0x00000003
#define WORLD_CONTROLLER_CORE_1_WORLD_IRAM0_M  ((WORLD_CONTROLLER_CORE_1_WORLD_IRAM0_V)<<(WORLD_CONTROLLER_CORE_1_WORLD_IRAM0_S))
#define WORLD_CONTROLLER_CORE_1_WORLD_IRAM0_V  0x3
#define WORLD_CONTROLLER_CORE_1_WORLD_IRAM0_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_WORLD_DRAM0_PIF_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x554)
/* WORLD_CONTROLLER_CORE_1_WORLD_DRAM0_PIF : R/W ;bitpos:[1:0] ;default: 2'h0 ; */
/*description: this field is used to read current world of Dram0 bus and PIF bus.*/
#define WORLD_CONTROLLER_CORE_1_WORLD_DRAM0_PIF    0x00000003
#define WORLD_CONTROLLER_CORE_1_WORLD_DRAM0_PIF_M  ((WORLD_CONTROLLER_CORE_1_WORLD_DRAM0_PIF_V)<<(WORLD_CONTROLLER_CORE_1_WORLD_DRAM0_PIF_S))
#define WORLD_CONTROLLER_CORE_1_WORLD_DRAM0_PIF_V  0x3
#define WORLD_CONTROLLER_CORE_1_WORLD_DRAM0_PIF_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_WORLD_PHASE_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x558)
/* WORLD_CONTROLLER_CORE_1_WORLD_PHASE : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: This bit indicates whether is preparing to switch to WORLD1.*/
#define WORLD_CONTROLLER_CORE_1_WORLD_PHASE    (BIT(0))
#define WORLD_CONTROLLER_CORE_1_WORLD_PHASE_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_1_WORLD_PHASE_V  0x1
#define WORLD_CONTROLLER_CORE_1_WORLD_PHASE_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_NMI_MASK_ENABLE_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x580)
/* WORLD_CONTROLLER_CORE_1_NMI_MASK_ENABLE : WO ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: this field is used to set NMI mask.*/
#define WORLD_CONTROLLER_CORE_1_NMI_MASK_ENABLE    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_NMI_MASK_ENABLE_M  ((WORLD_CONTROLLER_CORE_1_NMI_MASK_ENABLE_V)<<(WORLD_CONTROLLER_CORE_1_NMI_MASK_ENABLE_S))
#define WORLD_CONTROLLER_CORE_1_NMI_MASK_ENABLE_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_NMI_MASK_ENABLE_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_NMI_MASK_TRIGGER_ADDR_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x584)
/* WORLD_CONTROLLER_CORE_1_NMI_MASK_TRIGGER_ADDR : R/W ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: this field to used to set trigger address.*/
#define WORLD_CONTROLLER_CORE_1_NMI_MASK_TRIGGER_ADDR    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_NMI_MASK_TRIGGER_ADDR_M  ((WORLD_CONTROLLER_CORE_1_NMI_MASK_TRIGGER_ADDR_V)<<(WORLD_CONTROLLER_CORE_1_NMI_MASK_TRIGGER_ADDR_S))
#define WORLD_CONTROLLER_CORE_1_NMI_MASK_TRIGGER_ADDR_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_NMI_MASK_TRIGGER_ADDR_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_NMI_MASK_DISABLE_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x588)
/* WORLD_CONTROLLER_CORE_1_NMI_MASK_DISABLE : WO ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: this field is used to disable NMI mask.*/
#define WORLD_CONTROLLER_CORE_1_NMI_MASK_DISABLE    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_NMI_MASK_DISABLE_M  ((WORLD_CONTROLLER_CORE_1_NMI_MASK_DISABLE_V)<<(WORLD_CONTROLLER_CORE_1_NMI_MASK_DISABLE_S))
#define WORLD_CONTROLLER_CORE_1_NMI_MASK_DISABLE_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_NMI_MASK_DISABLE_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_NMI_MASK_CANCLE_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x58C)
/* WORLD_CONTROLLER_CORE_1_NMI_MASK_CANCEL : WO ;bitpos:[31:0] ;default: 32'b0 ; */
/*description: this field is used to cancel NMI mask disable function..*/
#define WORLD_CONTROLLER_CORE_1_NMI_MASK_CANCEL    0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_NMI_MASK_CANCEL_M  ((WORLD_CONTROLLER_CORE_1_NMI_MASK_CANCEL_V)<<(WORLD_CONTROLLER_CORE_1_NMI_MASK_CANCEL_S))
#define WORLD_CONTROLLER_CORE_1_NMI_MASK_CANCEL_V  0xFFFFFFFF
#define WORLD_CONTROLLER_CORE_1_NMI_MASK_CANCEL_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_NMI_MASK_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x590)
/* WORLD_CONTROLLER_CORE_1_NMI_MASK : R/W ;bitpos:[0] ;default: 1'b0 ; */
/*description: this bit is used to mask NMI interrupt.*/
#define WORLD_CONTROLLER_CORE_1_NMI_MASK    (BIT(0))
#define WORLD_CONTROLLER_CORE_1_NMI_MASK_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_1_NMI_MASK_V  0x1
#define WORLD_CONTROLLER_CORE_1_NMI_MASK_S  0

#define WORLD_CONTROLLER_WCL_CORE_1_NMI_MASK_PHASE_REG          (DR_REG_WORLD_CONTROLLER_BASE + 0x594)
/* WORLD_CONTROLLER_CORE_1_NMI_MASK_PHASE : RO ;bitpos:[0] ;default: 1'b0 ; */
/*description: this bit is used to indicates whether the NMI interrupt is being masked.*/
#define WORLD_CONTROLLER_CORE_1_NMI_MASK_PHASE    (BIT(0))
#define WORLD_CONTROLLER_CORE_1_NMI_MASK_PHASE_M  (BIT(0))
#define WORLD_CONTROLLER_CORE_1_NMI_MASK_PHASE_V  0x1
#define WORLD_CONTROLLER_CORE_1_NMI_MASK_PHASE_S  0


#ifdef __cplusplus
}
#endif



#endif /*_SOC_WORLD_CONTROLLER_REG_H_ */
